/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodTree;

@BugPattern(summary="Providing Closeable resources makes their lifecycle unclear", severity=BugPattern.SeverityLevel.WARNING)
public class CloseableProvides
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Matcher<MethodTree> CLOSEABLE_PROVIDES_MATCHER = Matchers.allOf(InjectMatchers.hasProvidesAnnotation(), Matchers.methodReturns(Matchers.isSubtypeOf("java.io.Closeable")));

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!CLOSEABLE_PROVIDES_MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

