/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Constructors on abstract classes are never directly @Inject'ed, only the constructors of their subclasses can be @Inject'ed.", severity=BugPattern.SeverityLevel.WARNING)
public class InjectOnConstructorOfAbstractClass
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final MultiMatcher<MethodTree, AnnotationTree> INJECT_FINDER = Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.isType("javax.inject.Inject"), Matchers.isType("com.google.inject.Inject")));
    private static final Matcher<MethodTree> TO_MATCH = Matchers.allOf(Matchers.methodIsConstructor(), Matchers.enclosingClass(Matchers.hasModifier(Modifier.ABSTRACT)));

    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        MultiMatcher.MultiMatchResult<AnnotationTree> injectAnnotations;
        if (TO_MATCH.matches(methodTree, state) && (injectAnnotations = INJECT_FINDER.multiMatchResult(methodTree, state)).matches()) {
            AnnotationTree injectAnnotation = (AnnotationTree)injectAnnotations.matchingNodes().get(0);
            return this.describeMatch(injectAnnotation, (Fix)SuggestedFix.delete(injectAnnotation));
        }
        return Description.NO_MATCH;
    }
}

