/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Members shouldn't be annotated with @Inject if constructor is already annotated @Inject", severity=BugPattern.SeverityLevel.ERROR)
public class InjectOnMemberAndConstructor
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> HAS_CONSTRUCTORS_WITH_INJECT = Matchers.constructor(ChildMultiMatcher.MatchType.AT_LEAST_ONE, InjectMatchers.hasInjectAnnotation());
    private static final Matcher<VariableTree> INSTANCE_FIELD_WITH_INJECT = Matchers.allOf(Matchers.isField(), InjectMatchers.hasInjectAnnotation());

    @Override
    public final Description matchClass(ClassTree classTree, VisitorState state) {
        if (!HAS_CONSTRUCTORS_WITH_INJECT.matches(classTree, state)) {
            return Description.NO_MATCH;
        }
        List<MethodTree> ctors = ASTHelpers.getConstructors(classTree);
        ImmutableList ctorsWithInject = ctors.stream().filter(c -> InjectMatchers.hasInjectAnnotation().matches((MethodTree)c, state)).collect(ImmutableList.toImmutableList());
        if (ctorsWithInject.size() != 1) {
            return Description.NO_MATCH;
        }
        final HashSet variablesAssigned = new HashSet();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitAssignment(AssignmentTree tree, Void unused) {
                Symbol symbol = ASTHelpers.getSymbol(tree.getVariable());
                if (symbol != null && symbol.getKind() == ElementKind.FIELD && !symbol.isStatic()) {
                    variablesAssigned.add(symbol);
                }
                return (Void)super.visitAssignment(tree, null);
            }
        }.scan((Tree)Iterables.getOnlyElement(ctorsWithInject), null);
        SuggestedFix.Builder fix = SuggestedFix.builder();
        VariableTree variableTreeFirstMatch = null;
        for (Tree tree : classTree.getMembers()) {
            VariableTree variableTree;
            if (!(tree instanceof VariableTree) || !INSTANCE_FIELD_WITH_INJECT.matches(variableTree = (VariableTree)tree, state) || !variablesAssigned.contains(ASTHelpers.getSymbol(variableTree))) continue;
            variableTreeFirstMatch = variableTree;
            InjectOnMemberAndConstructor.removeInjectAnnotationFromVariable(variableTree, state).ifPresent(fix::merge);
        }
        if (variableTreeFirstMatch == null) {
            return Description.NO_MATCH;
        }
        if (fix.isEmpty()) {
            return this.describeMatch(variableTreeFirstMatch);
        }
        return this.describeMatch(variableTreeFirstMatch, (Fix)fix.build());
    }

    private static Optional<SuggestedFix> removeInjectAnnotationFromVariable(VariableTree variableTree, VisitorState state) {
        for (AnnotationTree annotationTree : variableTree.getModifiers().getAnnotations()) {
            if (!InjectMatchers.IS_APPLICATION_OF_AT_INJECT.matches(annotationTree, state)) continue;
            return Optional.of(SuggestedFix.replace(annotationTree, ""));
        }
        return Optional.empty();
    }
}

