/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

@BugPattern(name="InjectInvalidTargetingOnScopingAnnotation", summary="A scoping annotation's Target should include TYPE and METHOD.", severity=BugPattern.SeverityLevel.WARNING)
public class InvalidTargetingOnScopingAnnotation
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String TARGET_ANNOTATION = "java.lang.annotation.Target";
    private static final MultiMatcher<ClassTree, AnnotationTree> HAS_TARGET_ANNOTATION = Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.isType("java.lang.annotation.Target"));
    private static final Matcher<ClassTree> ANNOTATION_WITH_SCOPE_AND_TARGET = Matchers.allOf(Matchers.kindIs(Tree.Kind.ANNOTATION_TYPE), Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.ScopeAnnotation"), Matchers.hasAnnotation("javax.inject.Scope")));
    private static final ImmutableSet<ElementType> REQUIRED_ELEMENT_TYPES = Sets.immutableEnumSet((Enum)ElementType.TYPE, (Enum[])new ElementType[]{ElementType.METHOD});

    @Override
    public final Description matchClass(ClassTree classTree, VisitorState state) {
        MultiMatcher.MultiMatchResult<AnnotationTree> targetAnnotation;
        if (ANNOTATION_WITH_SCOPE_AND_TARGET.matches(classTree, state) && (targetAnnotation = HAS_TARGET_ANNOTATION.multiMatchResult(classTree, state)).matches()) {
            AnnotationTree targetTree = targetAnnotation.onlyMatchingNode();
            Target target = ASTHelpers.getAnnotation(classTree, Target.class);
            if (target != null && !Arrays.asList(target.value()).containsAll(REQUIRED_ELEMENT_TYPES)) {
                return this.describeMatch(targetTree, InvalidTargetingOnScopingAnnotation.replaceTargetAnnotation(target, targetTree));
            }
        }
        return Description.NO_MATCH;
    }

    private static Fix replaceTargetAnnotation(Target annotation, AnnotationTree targetAnnotationTree) {
        EnumSet<ElementType> types = EnumSet.copyOf(REQUIRED_ELEMENT_TYPES);
        types.addAll(Arrays.asList(annotation.value()));
        return InvalidTargetingOnScopingAnnotation.replaceTargetAnnotation(targetAnnotationTree, types);
    }

    static Fix replaceTargetAnnotation(AnnotationTree targetAnnotationTree, Set<ElementType> types) {
        SuggestedFix.Builder builder = SuggestedFix.builder().replace(targetAnnotationTree, "@Target({" + Joiner.on(", ").join(types) + "})");
        for (ElementType type : types) {
            builder.addStaticImport("java.lang.annotation.ElementType." + type);
        }
        return builder.build();
    }
}

