/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import java.util.List;

@BugPattern(summary="Scope annotations used as qualifier annotations don't have any effect. Move the scope annotation to the binding location or delete it.", severity=BugPattern.SeverityLevel.ERROR)
public class MisplacedScopeAnnotations
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final MultiMatcher<VariableTree, AnnotationTree> IS_SCOPE_ANNOTATION = Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, InjectMatchers.IS_SCOPING_ANNOTATION);
    private static final MultiMatcher<MethodTree, AnnotationTree> HAS_INJECT = Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, InjectMatchers.IS_APPLICATION_OF_AT_INJECT);
    private static final Matcher<MethodTree> HAS_PROVIDES = InjectMatchers.hasProvidesAnnotation();

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!HAS_INJECT.matches(tree, state) && !HAS_PROVIDES.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        ImmutableList<AnnotationTree> scopeAnnotations = tree.getParameters().stream().flatMap(variable -> IS_SCOPE_ANNOTATION.multiMatchResult((VariableTree)variable, state).matchingNodes().stream()).filter(annotation -> !InjectMatchers.IS_BINDING_ANNOTATION.matches((AnnotationTree)annotation, state)).collect(ImmutableList.toImmutableList());
        if (scopeAnnotations.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.deleteAll(scopeAnnotations);
    }

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        boolean hasInject = tree.getModifiers().getAnnotations().stream().anyMatch(annotation -> InjectMatchers.IS_APPLICATION_OF_AT_INJECT.matches((AnnotationTree)annotation, state));
        if (!hasInject) {
            return Description.NO_MATCH;
        }
        ImmutableList<AnnotationTree> scopeAnnotations = tree.getModifiers().getAnnotations().stream().filter(annotation -> InjectMatchers.IS_SCOPING_ANNOTATION.matches((AnnotationTree)annotation, state)).filter(annotation -> !InjectMatchers.IS_BINDING_ANNOTATION.matches((AnnotationTree)annotation, state)).collect(ImmutableList.toImmutableList());
        if (scopeAnnotations.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.deleteAll(scopeAnnotations);
    }

    private Description deleteAll(List<AnnotationTree> scopeAnnotations) {
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        scopeAnnotations.forEach(fixBuilder::delete);
        return this.describeMatch(scopeAnnotations.get(0), (Fix)fixBuilder.build());
    }
}

