/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ModifiersTree;
import java.util.List;

@BugPattern(name="InjectMoreThanOneQualifier", summary="Using more than one qualifier annotation on the same element is not allowed.", severity=BugPattern.SeverityLevel.ERROR)
public class MoreThanOneQualifier
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final Matcher<AnnotationTree> QUALIFIER_ANNOTATION_MATCHER = Matchers.anyOf(Matchers.symbolHasAnnotation("com.google.inject.BindingAnnotation"), Matchers.symbolHasAnnotation("javax.inject.Qualifier"));

    @Override
    public Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        int numberOfQualifiers = 0;
        if (QUALIFIER_ANNOTATION_MATCHER.matches(annotationTree, state)) {
            for (AnnotationTree annotationTree2 : MoreThanOneQualifier.getSiblingAnnotations(state)) {
                if (!QUALIFIER_ANNOTATION_MATCHER.matches(annotationTree2, state)) continue;
                ++numberOfQualifiers;
            }
        }
        if (numberOfQualifiers > 1) {
            return this.describeMatch(annotationTree, (Fix)SuggestedFix.delete(annotationTree));
        }
        return Description.NO_MATCH;
    }

    private static List<? extends AnnotationTree> getSiblingAnnotations(VisitorState state) {
        return ((ModifiersTree)state.getPath().getParentPath().getLeaf()).getAnnotations();
    }
}

