/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Annotations cannot be both Scope annotations and Qualifier annotations: this causes confusion when trying to use them.", severity=BugPattern.SeverityLevel.ERROR)
public class OverlappingQualifierAndScopeAnnotation
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> ANNOTATION_WITH_BOTH_TYPES = Matchers.allOf(Matchers.kindIs(Tree.Kind.ANNOTATION_TYPE), Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.BindingAnnotation"), Matchers.hasAnnotation("javax.inject.Qualifier")), Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.ScopeAnnotation"), Matchers.hasAnnotation("javax.inject.Scope")));

    @Override
    public final Description matchClass(ClassTree classTree, VisitorState state) {
        return ANNOTATION_WITH_BOTH_TYPES.matches(classTree, state) ? this.describeMatch(classTree) : Description.NO_MATCH;
    }
}

