/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inject.InvalidTargetingOnScopingAnnotation;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;

@BugPattern(summary="Injection frameworks currently don't understand Qualifiers in TYPE_PARAMETER or TYPE_USE contexts.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class QualifierWithTypeUse
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final MultiMatcher<ClassTree, AnnotationTree> HAS_TARGET_ANNOTATION = Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.isType("java.lang.annotation.Target"));
    private static final Matcher<ClassTree> IS_QUALIFIER_WITH_TARGET = Matchers.allOf(Matchers.kindIs(Tree.Kind.ANNOTATION_TYPE), Matchers.anyOf(Matchers.hasAnnotation("javax.inject.Qualifier"), Matchers.hasAnnotation("com.google.inject.BindingAnnotation")));
    private static final ImmutableSet<ElementType> FORBIDDEN_ELEMENT_TYPES = ImmutableSet.of(ElementType.TYPE_PARAMETER, ElementType.TYPE_USE);

    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        MultiMatcher.MultiMatchResult<AnnotationTree> targetAnnotation;
        if (IS_QUALIFIER_WITH_TARGET.matches(tree, state) && (targetAnnotation = HAS_TARGET_ANNOTATION.multiMatchResult(tree, state)).matches()) {
            AnnotationTree annotationTree = targetAnnotation.onlyMatchingNode();
            Target target = ASTHelpers.getAnnotation(tree, Target.class);
            if (QualifierWithTypeUse.hasTypeUseOrTypeParameter(target)) {
                return this.describeMatch(annotationTree, QualifierWithTypeUse.removeTypeUse(target, annotationTree));
            }
        }
        return Description.NO_MATCH;
    }

    private static boolean hasTypeUseOrTypeParameter(Target targetAnnotation) {
        return targetAnnotation != null && !Collections.disjoint(FORBIDDEN_ELEMENT_TYPES, Arrays.asList(targetAnnotation.value()));
    }

    private static Fix removeTypeUse(Target targetAnnotation, AnnotationTree tree) {
        EnumSet<ElementType> elements = EnumSet.copyOf(Arrays.asList(targetAnnotation.value()));
        elements.removeAll(FORBIDDEN_ELEMENT_TYPES);
        if (elements.isEmpty()) {
            return SuggestedFix.delete(tree);
        }
        return InvalidTargetingOnScopingAnnotation.replaceTargetAnnotation(tree, elements);
    }
}

