/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.dagger;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import org.checkerframework.checker.nullness.qual.Nullable;

@BugPattern(summary="AndroidInjection.inject() should always be invoked before calling super.lifecycleMethod()", severity=BugPattern.SeverityLevel.ERROR)
public final class AndroidInjectionBeforeSuper
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        for (MatchType matchType : MatchType.values()) {
            if (!matchType.methodMatcher.matches(tree, state)) continue;
            return tree.accept(new LifecycleMethodVisitor(matchType, state), null);
        }
        return Description.NO_MATCH;
    }

    private final class LifecycleMethodVisitor
    extends SimpleTreeVisitor<Description, Void> {
        private final MatchType matchType;
        private final VisitorState state;
        private boolean foundSuper = false;

        LifecycleMethodVisitor(MatchType matchType, VisitorState state) {
            this.matchType = matchType;
            this.state = state;
        }

        @Override
        public @Nullable Description visitMethodInvocation(MethodInvocationTree node, Void unused) {
            if (this.foundSuper && this.matchType.injectMethodMatcher.matches(node, this.state)) {
                return AndroidInjectionBeforeSuper.this.buildDescription(node).setMessage(String.format("AndroidInjection.inject() should always be invoked before calling super.%s()", this.matchType.lifecycleMethod)).build();
            }
            if (this.matchType.methodInvocationMatcher.matches(node, this.state)) {
                this.foundSuper = true;
            }
            return null;
        }

        @Override
        public Description visitMethod(MethodTree node, Void unused) {
            BlockTree methodBody = node.getBody();
            if (methodBody == null) {
                return Description.NO_MATCH;
            }
            return methodBody.getStatements().stream().map(tree -> tree.accept(this, null)).filter(Predicates.notNull()).findFirst().orElse(Description.NO_MATCH);
        }

        @Override
        public Description visitExpressionStatement(ExpressionStatementTree node, Void unused) {
            return node.getExpression().accept(this, null);
        }
    }

    private static enum MatchType {
        ACTIVITY("android.app.Activity", "onCreate", ImmutableList.of(Matchers.variableType(Matchers.isSameType("android.os.Bundle"))), "dagger.android.AndroidInjection"),
        FRAMEWORK_FRAGMENT("android.app.Fragment", "onAttach", ImmutableList.of(Matchers.variableType(Matchers.isSameType("android.content.Context"))), "dagger.android.AndroidInjection"),
        FRAMEWORK_FRAGMENT_PRE_API23("android.app.Fragment", "onAttach", ImmutableList.of(Matchers.variableType(Matchers.isSameType("android.app.Activity"))), "dagger.android.AndroidInjection"),
        SUPPORT_FRAGMENT("android.support.v4.app.Fragment", "onAttach", ImmutableList.of(Matchers.variableType(Matchers.isSameType("android.content.Context"))), "dagger.android.support.AndroidSupportInjection"),
        SUPPORT_FRAGMENT_PRE_API23("android.support.v4.app.Fragment", "onAttach", ImmutableList.of(Matchers.variableType(Matchers.isSameType("android.app.Activity"))), "dagger.android.support.AndroidSupportInjection"),
        SERVICE("android.app.Service", "onCreate", ImmutableList.of(), "dagger.android.AndroidInjection");

        private final String lifecycleMethod;
        private final Matcher<MethodTree> methodMatcher;
        private final Matcher<ExpressionTree> methodInvocationMatcher;
        private final Matcher<ExpressionTree> injectMethodMatcher;

        private MatchType(String componentType, String lifecycleMethod, ImmutableList<Matcher<VariableTree>> lifecycleMethodParameters, String staticMethodClass) {
            this.lifecycleMethod = lifecycleMethod;
            this.methodMatcher = Matchers.allOf(Matchers.methodIsNamed(lifecycleMethod), Matchers.methodHasParameters(lifecycleMethodParameters), Matchers.enclosingClass(Matchers.isSubtypeOf(componentType)));
            this.methodInvocationMatcher = Matchers.instanceMethod().onDescendantOf(componentType).named(lifecycleMethod);
            this.injectMethodMatcher = Matchers.staticMethod().onClass(staticMethodClass).named("inject").withParameters(componentType, new String[0]);
        }
    }
}

