/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.dagger;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="DaggerProvidesNull", summary="Dagger @Provides methods may not return null unless annotated with @Nullable", severity=BugPattern.SeverityLevel.ERROR)
public class ProvidesNull
extends BugChecker
implements BugChecker.ReturnTreeMatcher {
    @Override
    public Description matchReturn(ReturnTree returnTree, VisitorState state) {
        ExpressionTree returnExpression = returnTree.getExpression();
        if (returnExpression == null || returnExpression.getKind() != Tree.Kind.NULL_LITERAL) {
            return Description.NO_MATCH;
        }
        TreePath path = state.getPath();
        MethodTree enclosingMethod = null;
        while (true) {
            if (path == null || path.getLeaf() instanceof LambdaExpressionTree) {
                return Description.NO_MATCH;
            }
            if (path.getLeaf() instanceof MethodTree) break;
            path = path.getParentPath();
        }
        enclosingMethod = (MethodTree)path.getLeaf();
        Symbol.MethodSymbol enclosingMethodSym = ASTHelpers.getSymbol(enclosingMethod);
        if (!ASTHelpers.hasAnnotation((Symbol)enclosingMethodSym, "dagger.Provides", state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasDirectAnnotationWithSimpleName(enclosingMethodSym, "Nullable")) {
            return Description.NO_MATCH;
        }
        SuggestedFix addNullableFix = SuggestedFix.builder().prefixWith(enclosingMethod, "@Nullable\n").addImport("javax.annotation.Nullable").build();
        CatchTree enclosingCatch = ASTHelpers.findEnclosingNode(state.getPath(), CatchTree.class);
        if (enclosingCatch == null) {
            SuggestedFix throwRuntimeExceptionFix = SuggestedFix.replace(returnTree, "throw new RuntimeException();");
            return this.buildDescription(returnTree).addFix(addNullableFix).addFix(throwRuntimeExceptionFix).build();
        }
        String replacement = String.format("throw new RuntimeException(%s);", enclosingCatch.getParameter().getName());
        SuggestedFix throwRuntimeExceptionFix = SuggestedFix.replace(returnTree, replacement);
        return this.buildDescription(returnTree).addFix(throwRuntimeExceptionFix).addFix(addNullableFix).build();
    }
}

