/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.guice;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(summary="This method is not annotated with @Inject, but it overrides a method that is  annotated with @javax.inject.Inject. The method will not be Injected.", severity=BugPattern.SeverityLevel.ERROR)
public class OverridesJavaxInjectableMethod
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        if (InjectMatchers.hasInjectAnnotation().matches(methodTree, state)) {
            return Description.NO_MATCH;
        }
        boolean foundJavaxInject = false;
        for (Symbol.MethodSymbol superMethod : ASTHelpers.findSuperMethods(ASTHelpers.getSymbol(methodTree), state.getTypes())) {
            if (ASTHelpers.hasAnnotation((Symbol)superMethod, "com.google.inject.Inject", state)) {
                return Description.NO_MATCH;
            }
            foundJavaxInject |= ASTHelpers.hasAnnotation((Symbol)superMethod, "javax.inject.Inject", state);
        }
        if (foundJavaxInject) {
            return this.describeMatch(methodTree, (Fix)SuggestedFix.builder().addImport("javax.inject.Inject").prefixWith(methodTree, "@Inject\n").build());
        }
        return Description.NO_MATCH;
    }
}

