/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inlineme;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.InlineMeValidationDisabled;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.inlineme.InlinabilityResult;
import com.google.errorprone.bugpatterns.inlineme.InlineMeData;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

@BugPattern(name="InlineMeValidator", summary="Ensures that the @InlineMe annotation is used correctly.", suppressionAnnotations={InlineMeValidationDisabled.class}, documentSuppression=false, severity=BugPattern.SeverityLevel.ERROR)
public final class Validator
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    static final String CLEANUP_INLINE_ME_FLAG = "InlineMe:CleanupInlineMes";
    private final boolean cleanupInlineMes;
    private static final CharMatcher SEMICOLON = CharMatcher.is(';');

    public Validator(ErrorProneFlags flags) {
        this.cleanupInlineMes = flags.getBoolean(CLEANUP_INLINE_ME_FLAG).orElse(false);
    }

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(tree);
        if (this.cleanupInlineMes) {
            return Validator.shouldDelete(symbol, state) ? this.describeMatch(tree, (Fix)SuggestedFixes.replaceIncludingComments(state.getPath(), "", state)) : Description.NO_MATCH;
        }
        return InlineMeData.createFromSymbol(symbol).map(data -> this.match((InlineMeData)data, tree, state)).orElse(Description.NO_MATCH);
    }

    private static boolean shouldDelete(Symbol.MethodSymbol symbol, VisitorState state) {
        return ASTHelpers.hasDirectAnnotationWithSimpleName(symbol, "InlineMe") && !ASTHelpers.hasAnnotation((Symbol)symbol, "java.lang.Override", state) && ASTHelpers.findSuperMethods(symbol, state.getTypes()).isEmpty();
    }

    private Description match(InlineMeData existingAnnotation, MethodTree tree, VisitorState state) {
        InlinabilityResult result = InlinabilityResult.forMethod(tree, state);
        if (!result.isValidForValidator()) {
            return this.buildDescription(tree).setMessage(result.errorMessage()).addFix(SuggestedFix.delete(Validator.getInlineMeAnnotationTree(tree))).build();
        }
        InlineMeData inferredFromMethodBody = InlineMeData.buildExpectedInlineMeAnnotation(state, result.body());
        Set<MismatchedInlineMeComponents> mismatches = Validator.compatibleWithAnnotation(inferredFromMethodBody, existingAnnotation, state.context);
        if (mismatches.isEmpty()) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(Validator.renderInlineMeMismatch(inferredFromMethodBody, existingAnnotation, mismatches)).addFix(SuggestedFix.replace(Validator.getInlineMeAnnotationTree(tree), inferredFromMethodBody.buildAnnotation())).build();
    }

    private static AnnotationTree getInlineMeAnnotationTree(MethodTree tree) {
        return ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), "InlineMe");
    }

    private static String renderInlineMeMismatch(InlineMeData inferredFromMethodBody, InlineMeData existingAnnotation, Set<MismatchedInlineMeComponents> mismatches) {
        StringBuilder message = new StringBuilder("There is a mismatch between the implementation of the method and the replacement suggested in the annotation.");
        if (mismatches.contains((Object)MismatchedInlineMeComponents.REPLACEMENT_STRING)) {
            message.append(String.format("\nReplacement text: \n  InferredFromBody: %s\n  FromAnnotation: %s", inferredFromMethodBody.replacement(), existingAnnotation.replacement()));
        }
        if (mismatches.contains((Object)MismatchedInlineMeComponents.IMPORTS)) {
            message.append(String.format("\nImports: \n  InferredFromBody: %s\n  FromAnnotation: %s", inferredFromMethodBody.imports(), existingAnnotation.imports()));
        }
        if (mismatches.contains((Object)MismatchedInlineMeComponents.STATIC_IMPORTS)) {
            message.append(String.format("\nStatic imports: \n  InferredFromBody: %s\n  FromAnnotation: %s", inferredFromMethodBody.staticImports(), existingAnnotation.staticImports()));
        }
        return message.toString();
    }

    private static Set<MismatchedInlineMeComponents> compatibleWithAnnotation(InlineMeData inferredFromMethodBody, InlineMeData anno, Context context) {
        EnumSet<MismatchedInlineMeComponents> mismatches = EnumSet.noneOf(MismatchedInlineMeComponents.class);
        if (!Validator.parseAndCheckForTokenEquivalence(anno.replacement(), inferredFromMethodBody.replacement(), context)) {
            mismatches.add(MismatchedInlineMeComponents.REPLACEMENT_STRING);
        }
        if (!inferredFromMethodBody.imports().equals(anno.imports())) {
            mismatches.add(MismatchedInlineMeComponents.IMPORTS);
        }
        if (!inferredFromMethodBody.staticImports().equals(anno.staticImports())) {
            mismatches.add(MismatchedInlineMeComponents.STATIC_IMPORTS);
        }
        return mismatches;
    }

    private static boolean parseAndCheckForTokenEquivalence(String first, String second, Context context) {
        ImmutableList<ErrorProneToken> tokens1 = ErrorProneTokens.getTokens(SEMICOLON.trimTrailingFrom(first), context);
        ImmutableList<ErrorProneToken> tokens2 = ErrorProneTokens.getTokens(SEMICOLON.trimTrailingFrom(second), context);
        if (tokens1.size() != tokens2.size()) {
            return false;
        }
        for (int i = 0; i < tokens1.size(); ++i) {
            ErrorProneToken token1 = (ErrorProneToken)tokens1.get(i);
            ErrorProneToken token2 = (ErrorProneToken)tokens2.get(i);
            if (!token1.kind().equals(token2.kind())) {
                return false;
            }
            if (!Validator.mismatch(token1, token2, ErrorProneToken::hasName, ErrorProneToken::name) && !Validator.mismatch(token1, token2, ErrorProneToken::hasStringVal, ErrorProneToken::stringVal) && !Validator.mismatch(token1, token2, ErrorProneToken::hasRadix, ErrorProneToken::radix)) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean mismatch(ErrorProneToken first, ErrorProneToken second, Predicate<ErrorProneToken> guard, Function<ErrorProneToken, T> extractor) {
        return guard.test(first) && !extractor.apply(first).equals(extractor.apply(second));
    }

    private static enum MismatchedInlineMeComponents {
        REPLACEMENT_STRING,
        IMPORTS,
        STATIC_IMPORTS;

    }
}

