/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@BugPattern(summary="Javadoc links to exceptions in @throws without a @link tag (@throws Exception, not @throws {@link Exception}).", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"}, documentSuppression=false)
public final class InvalidThrowsLink
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Pattern THROWS_LINK = Pattern.compile("^@throws \\{@link ([^}]+)}");

    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            new ThrowsChecker(state).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    private final class ThrowsChecker
    extends DocTreePathScanner<Void, Void> {
        private final VisitorState state;

        private ThrowsChecker(VisitorState state) {
            this.state = state;
        }

        @Override
        public Void visitErroneous(ErroneousTree node, Void unused) {
            Matcher matcher = THROWS_LINK.matcher(node.getBody());
            Tokens.Comment comment = ((DCTree.DCDocComment)this.getCurrentPath().getDocComment()).comment;
            if (matcher.find()) {
                int beforeAt = comment.getSourcePos(((DCTree.DCErroneous)node).pos + matcher.start());
                int startOfCurly = comment.getSourcePos(((DCTree.DCErroneous)node).pos + matcher.end());
                SuggestedFix fix = SuggestedFix.replace(beforeAt, startOfCurly, "@throws " + matcher.group(1));
                this.state.reportMatch(InvalidThrowsLink.this.describeMatch(Utils.getDiagnosticPosition(beforeAt, this.getCurrentPath().getTreePath().getLeaf()), (Fix)fix));
            }
            return (Void)super.visitErroneous(node, null);
        }
    }
}

