/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.bugpatterns.javadoc.AutoValue_JavadocTag;
import java.util.Collection;
import java.util.stream.Stream;

@Immutable
@AutoValue
abstract class JavadocTag {
    static final ImmutableSet<JavadocTag> KNOWN_OTHER_TAGS = ImmutableSet.of(JavadocTag.blockTag("apiNote"), JavadocTag.blockTag("attr"), JavadocTag.blockTag("contact"), JavadocTag.blockTag("fails"), JavadocTag.blockTag("hide"), JavadocTag.blockTag("implNote"), new JavadocTag[]{JavadocTag.blockTag("implSpec"), JavadocTag.blockTag("removed"), JavadocTag.blockTag("required"), JavadocTag.blockTag("team")});
    private static final ImmutableSet<JavadocTag> COMMON_TAGS = ImmutableSet.of(JavadocTag.inlineTag("code"), JavadocTag.blockTag("deprecated"), JavadocTag.inlineTag("docRoot"), JavadocTag.inlineTag("link"), JavadocTag.inlineTag("linkplain"), JavadocTag.inlineTag("literal"), new JavadocTag[]{JavadocTag.blockTag("see"), JavadocTag.blockTag("since")});
    static final ImmutableSet<JavadocTag> VALID_CLASS_TAGS = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(COMMON_TAGS)).add(new JavadocTag[]{JavadocTag.blockTag("author"), JavadocTag.inlineTag("inheritDoc"), JavadocTag.blockTag("param"), JavadocTag.inlineTag("value"), JavadocTag.blockTag("version")})).build();
    static final ImmutableSet<JavadocTag> VALID_VARIABLE_TAGS = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(COMMON_TAGS)).add(new JavadocTag[]{JavadocTag.blockTag("serial"), JavadocTag.blockTag("serialData"), JavadocTag.blockTag("serialField"), JavadocTag.inlineTag("value")})).build();
    static final ImmutableSet<JavadocTag> VALID_METHOD_TAGS = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(COMMON_TAGS)).add(new JavadocTag[]{JavadocTag.blockTag("author"), JavadocTag.blockTag("exception"), JavadocTag.inlineTag("inheritDoc"), JavadocTag.blockTag("param"), JavadocTag.blockTag("return"), JavadocTag.blockTag("serial"), JavadocTag.blockTag("throws"), JavadocTag.blockTag("serialData"), JavadocTag.blockTag("serialField"), JavadocTag.inlineTag("value"), JavadocTag.blockTag("version")})).build();
    static final ImmutableSet<JavadocTag> ALL_INLINE_TAGS = Stream.of(VALID_CLASS_TAGS, VALID_VARIABLE_TAGS, VALID_METHOD_TAGS).flatMap(Collection::stream).filter(tag -> tag.type() == TagType.INLINE).collect(ImmutableSet.toImmutableSet());

    JavadocTag() {
    }

    abstract String name();

    abstract TagType type();

    static JavadocTag blockTag(String name) {
        return JavadocTag.of(name, TagType.BLOCK);
    }

    static JavadocTag inlineTag(String name) {
        return JavadocTag.of(name, TagType.INLINE);
    }

    private static JavadocTag of(String name, TagType type) {
        return new AutoValue_JavadocTag(name, type);
    }

    static enum TagType {
        BLOCK,
        INLINE;

    }
}

