/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;

@BugPattern(summary="URLs should not be used in @see tags; they are designed for Java elements which could be used with @link.", severity=BugPattern.SeverityLevel.WARNING)
public final class UrlInSee
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    @Override
    public Description matchClass(ClassTree classTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            new UrlInSeeChecker(state).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            new UrlInSeeChecker(state).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    @Override
    public Description matchVariable(VariableTree variableTree, VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            new UrlInSeeChecker(state).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    private final class UrlInSeeChecker
    extends DocTreePathScanner<Void, Void> {
        private final VisitorState state;

        private UrlInSeeChecker(VisitorState state) {
            this.state = state;
        }

        @Override
        public Void visitErroneous(ErroneousTree erroneousTree, Void unused) {
            if (erroneousTree.getBody().startsWith("@see http")) {
                this.state.reportMatch(UrlInSee.this.describeMatch(Utils.diagnosticPosition(this.getCurrentPath(), this.state), (Fix)Utils.replace(erroneousTree, erroneousTree.getBody().replaceFirst("@see", "See"), this.state)));
            }
            return (Void)super.visitErroneous(erroneousTree, unused);
        }
    }
}

