/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;

@BugPattern(summary="`T extends Object` is redundant in normal Java, and does not work to describe `T` as non-null across compilation boundaries when the Checker Framework unless you compile users against bytecode generated by the Checker Framework javac. (If you are building this code with the Checker Framework javac, then disable this check.)", severity=BugPattern.SeverityLevel.WARNING)
public final class ExtendsObject
extends BugChecker
implements BugChecker.TypeParameterTreeMatcher {
    private static final String NON_NULL = "org.checkerframework.checker.nullness.qual.NonNull";

    @Override
    public Description matchTypeParameter(TypeParameterTree tree, VisitorState state) {
        for (Tree tree2 : tree.getBounds()) {
            if (!state.getTypes().isSameType(ASTHelpers.getType(tree2), state.getSymtab().objectType) || tree2 instanceof AnnotatedTypeTree) continue;
            SuggestedFix.Builder fix = SuggestedFix.builder();
            String nonNull = SuggestedFixes.qualifyType(state, fix, NON_NULL);
            return this.describeMatch(tree2, (Fix)fix.prefixWith(tree2, String.format(" @%s ", nonNull)).build());
        }
        return Description.NO_MATCH;
    }
}

