/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.nullness.NullnessUtils;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.List;
import javax.lang.model.type.TypeKind;

@BugPattern(summary="Null is not permitted for this parameter.", severity=BugPattern.SeverityLevel.ERROR)
public final class NullArgumentForNonNullParameter
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final Supplier<Type> JAVA_OPTIONAL_TYPE = Suppliers.typeFromString("java.util.Optional");
    private static final Supplier<Type> GUAVA_OPTIONAL_TYPE = Suppliers.typeFromString("com.google.common.base.Optional");
    private static final Supplier<Name> OF_NAME = VisitorState.memoize(state -> state.getName("of"));
    private static final Supplier<Name> COM_GOOGLE_COMMON_PREFIX_NAME = VisitorState.memoize(state -> state.getName("com.google.common."));
    private final boolean beingConservative;

    public NullArgumentForNonNullParameter(ErrorProneFlags flags) {
        this.beingConservative = NullnessUtils.nullnessChecksShouldBeConservative(flags);
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.match(ASTHelpers.getSymbol(tree), tree.getArguments(), state);
    }

    @Override
    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return this.match(ASTHelpers.getSymbol(tree), tree.getArguments(), state);
    }

    private Description match(Symbol.MethodSymbol methodSymbol, List<? extends ExpressionTree> args, VisitorState state) {
        if (state.errorProneOptions().isTestOnlyTarget()) {
            return Description.NO_MATCH;
        }
        if (NullnessUtils.hasExtraParameterForEnclosingInstance(methodSymbol)) {
            return Description.NO_MATCH;
        }
        if (methodSymbol.isVarArgs()) {
            return Description.NO_MATCH;
        }
        Streams.forEachPair(args.stream(), methodSymbol.getParameters().stream(), (argTree, paramSymbol) -> {
            if (!NullnessUtils.hasDefinitelyNullBranch(argTree, ImmutableSet.of(), ImmutableSet.of(), state)) {
                return;
            }
            if (!this.argumentMustBeNonNull((Symbol.VarSymbol)paramSymbol, state)) {
                return;
            }
            state.reportMatch(this.describeMatch((Tree)argTree));
        });
        return Description.NO_MATCH;
    }

    private boolean argumentMustBeNonNull(Symbol.VarSymbol sym, VisitorState state) {
        if (((Type)sym.asType()).isPrimitive()) {
            return true;
        }
        if (sym.owner.name.equals(OF_NAME.get(state)) && (NullArgumentForNonNullParameter.isParameterOfMethodOnType(sym, JAVA_OPTIONAL_TYPE, state) || NullArgumentForNonNullParameter.isParameterOfMethodOnType(sym, GUAVA_OPTIONAL_TYPE, state))) {
            return true;
        }
        Nullness nullness = NullnessAnnotations.fromAnnotationsOn(sym).orElse(null);
        if (nullness == Nullness.NONNULL && !this.beingConservative) {
            return true;
        }
        if (nullness == Nullness.NULLABLE) {
            return false;
        }
        if (((Type)sym.asType()).getKind() == TypeKind.TYPEVAR) {
            return false;
        }
        return this.enclosingAnnotationDefaultsNonTypeVariablesToNonNull(sym, state);
    }

    private static boolean isParameterOfMethodOnType(Symbol.VarSymbol sym, Supplier<Type> typeSupplier, VisitorState state) {
        Type target = typeSupplier.get(state);
        return target != null && state.getTypes().isSameType(sym.enclClass().type, target);
    }

    private boolean enclosingAnnotationDefaultsNonTypeVariablesToNonNull(Symbol sym, VisitorState state) {
        while (sym != null) {
            if (ASTHelpers.hasAnnotation(sym, "com.google.protobuf.Internal$ProtoNonnullApi", state)) {
                return true;
            }
            if (ASTHelpers.hasAnnotation(sym, "org.jspecify.nullness.NullMarked", state) && (!this.beingConservative || sym.packge().fullname.startsWith(COM_GOOGLE_COMMON_PREFIX_NAME.get(state)))) {
                return true;
            }
            sym = sym.getEnclosingElement();
        }
        return false;
    }
}

