/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.nullness.AutoValue_NullnessUtils_NullCheck;
import com.google.errorprone.bugpatterns.nullness.AutoValue_NullnessUtils_NullableAnnotationToUse;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnnotations;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.Name;

class NullnessUtils {
    private static final Matcher<ExpressionTree> OPTIONAL_OR_NULL = Matchers.instanceMethod().onDescendantOf("com.google.common.base.Optional").named("orNull");
    private static final Matcher<ExpressionTree> OPTIONAL_OR_ELSE = Matchers.instanceMethod().onDescendantOf("java.util.Optional").named("orElse");
    private static Method getCasesMethod;
    private static Method getBodyMethod;

    private NullnessUtils() {
    }

    static boolean nullnessChecksShouldBeConservative(ErrorProneFlags flags) {
        return flags.getBoolean("Nullness:Conservative").orElse(true);
    }

    static boolean isInNullMarkedScope(Symbol sym, VisitorState state) {
        while (sym != null) {
            if (ASTHelpers.hasAnnotation(sym, "org.jspecify.nullness.NullMarked", state)) {
                return true;
            }
            sym = sym.getEnclosingElement();
        }
        return false;
    }

    static SuggestedFix fixByAddingNullableAnnotationToReturnType(VisitorState state, MethodTree method) {
        return NullnessUtils.fixByAddingNullableAnnotationToElementOrType(state, method, method.getReturnType(), "nullness:return");
    }

    static SuggestedFix fixByAddingNullableAnnotationToType(VisitorState state, VariableTree variable) {
        return NullnessUtils.fixByAddingNullableAnnotationToElementOrType(state, variable, variable.getType(), null);
    }

    private static SuggestedFix fixByAddingNullableAnnotationToElementOrType(VisitorState state, Tree elementTree, Tree typeTree, @Nullable String suppressionToRemove) {
        NullableAnnotationToUse nullableAnnotationToUse = NullnessUtils.pickNullableAnnotation(state);
        switch (NullnessUtils.applyOnlyIfAlreadyInScope(state)) {
            case TRUE: {
                if (nullableAnnotationToUse.isAlreadyInScope()) break;
                return SuggestedFix.emptyFix();
            }
            case IF_NOT: {
                if (!nullableAnnotationToUse.isAlreadyInScope()) break;
                return SuggestedFix.emptyFix();
            }
        }
        if (!nullableAnnotationToUse.isTypeUse()) {
            return nullableAnnotationToUse.fixPrefixingOnto(elementTree, state, suppressionToRemove);
        }
        return NullnessUtils.fixByAddingKnownTypeUseNullableAnnotation(state, typeTree, nullableAnnotationToUse, suppressionToRemove);
    }

    static SuggestedFix fixByAnnotatingTypeUseOnlyLocationWithNullableAnnotation(VisitorState state, Tree typeTree) {
        NullableAnnotationToUse nullableAnnotationToUse = NullnessUtils.pickNullableAnnotation(state);
        if (!nullableAnnotationToUse.isTypeUse()) {
            return SuggestedFix.emptyFix();
        }
        return NullnessUtils.fixByAddingKnownTypeUseNullableAnnotation(state, typeTree, nullableAnnotationToUse, null);
    }

    private static SuggestedFix fixByAddingKnownTypeUseNullableAnnotation(VisitorState state, Tree typeTree, NullableAnnotationToUse nullableAnnotationToUse, @Nullable String suppressionToRemove) {
        if (typeTree.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
            typeTree = ((ParameterizedTypeTree)typeTree).getType();
        }
        switch (typeTree.getKind()) {
            case ARRAY_TYPE: {
                Tree beforeBrackets = typeTree;
                while (beforeBrackets.getKind() == Tree.Kind.ARRAY_TYPE) {
                    beforeBrackets = ((ArrayTypeTree)beforeBrackets).getType();
                }
                return nullableAnnotationToUse.fixPostfixingOnto(beforeBrackets, state, suppressionToRemove);
            }
            case MEMBER_SELECT: {
                int lastDot = Lists.reverse(state.getOffsetTokensForNode(typeTree)).stream().filter(t -> t.kind() == Tokens.TokenKind.DOT).findFirst().get().pos();
                return nullableAnnotationToUse.fixPostfixingOnto(lastDot, state, suppressionToRemove);
            }
            case ANNOTATED_TYPE: {
                return nullableAnnotationToUse.fixPrefixingOnto(((AnnotatedTypeTree)typeTree).getAnnotations().get(0), state, suppressionToRemove);
            }
            case IDENTIFIER: {
                return nullableAnnotationToUse.fixPrefixingOnto(typeTree, state, suppressionToRemove);
            }
        }
        throw new AssertionError((Object)("unexpected kind for type tree: " + typeTree.getKind() + " for " + typeTree));
    }

    static boolean isAlreadyAnnotatedNullable(Symbol symbol) {
        return NullnessAnnotations.fromAnnotationsOn(symbol).orElse(null) == Nullness.NULLABLE;
    }

    static boolean hasExtraParameterForEnclosingInstance(Symbol.MethodSymbol symbol) {
        if (!symbol.isConstructor()) {
            return false;
        }
        Symbol.ClassSymbol constructedClass = ASTHelpers.enclosingClass(symbol);
        return ASTHelpers.enclosingClass(constructedClass) != null && !constructedClass.isStatic();
    }

    private static NullableAnnotationToUse pickNullableAnnotation(VisitorState state) {
        Symbol sym = FindIdentifiers.findIdent("Nullable", state, Kinds.KindSelector.VAL_TYP);
        ErrorProneFlags flags = state.errorProneOptions().getFlags();
        String defaultType = flags.get("Nullness:DefaultNullnessAnnotation").orElse(state.isAndroidCompatible() ? "androidx.annotation.Nullable" : "org.jspecify.nullness.Nullable");
        if (sym != null) {
            Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)sym;
            if (classSym.isAnnotationType()) {
                return NullableAnnotationToUse.annotationWithoutImporting("Nullable", NullnessUtils.isTypeUse(classSym.className()), true);
            }
            return NullableAnnotationToUse.annotationWithoutImporting(defaultType, NullnessUtils.isTypeUse(defaultType), false);
        }
        return NullableAnnotationToUse.annotationToBeImported(defaultType, NullnessUtils.isTypeUse(defaultType));
    }

    private static boolean isTypeUse(String className) {
        switch (className) {
            case "libcore.util.Nullable": 
            case "org.checkerframework.checker.nullness.compatqual.NullableType": 
            case "org.checkerframework.checker.nullness.qual.Nullable": 
            case "org.jspecify.nullness.Nullable": {
                return true;
            }
        }
        return false;
    }

    @Nullable
    static NullCheck getNullCheck(ExpressionTree tree) {
        ExpressionTree nullChecked;
        NullCheck.Polarity polarity;
        tree = ASTHelpers.stripParentheses(tree);
        switch (tree.getKind()) {
            case EQUAL_TO: {
                polarity = NullCheck.Polarity.IS_NULL;
                break;
            }
            case NOT_EQUAL_TO: {
                polarity = NullCheck.Polarity.IS_NOT_NULL;
                break;
            }
            default: {
                return null;
            }
        }
        BinaryTree equalityTree = (BinaryTree)tree;
        if (equalityTree.getRightOperand().getKind() == Tree.Kind.NULL_LITERAL) {
            nullChecked = equalityTree.getLeftOperand();
        } else if (equalityTree.getLeftOperand().getKind() == Tree.Kind.NULL_LITERAL) {
            nullChecked = equalityTree.getRightOperand();
        } else {
            return null;
        }
        Name name = nullChecked.getKind() == Tree.Kind.IDENTIFIER ? ((IdentifierTree)nullChecked).getName() : null;
        Symbol symbol = ASTHelpers.getSymbol(nullChecked);
        Symbol.VarSymbol varSymbol = symbol instanceof Symbol.VarSymbol ? (Symbol.VarSymbol)symbol : null;
        return new AutoValue_NullnessUtils_NullCheck(name, varSymbol, polarity);
    }

    static boolean hasDefinitelyNullBranch(ExpressionTree tree, final Set<Symbol.VarSymbol> definitelyNullVars, final ImmutableSet<Name> varsProvenNullByParentIf, final VisitorState stateForCompilationUnit) {
        return (Boolean)new SimpleTreeVisitor<Boolean, Void>(){

            @Override
            public Boolean visitAssignment(AssignmentTree tree, Void unused) {
                return (Boolean)this.visit(tree.getExpression(), unused);
            }

            @Override
            public Boolean visitConditionalExpression(ConditionalExpressionTree tree, Void unused) {
                return (Boolean)this.visit(tree.getTrueExpression(), unused) != false || (Boolean)this.visit(tree.getFalseExpression(), unused) != false || NullnessUtils.isTernaryXIfXIsNull(tree);
            }

            @Override
            public Boolean visitIdentifier(IdentifierTree tree, Void unused) {
                return (Boolean)super.visitIdentifier(tree, unused) != false || varsProvenNullByParentIf.contains(tree.getName());
            }

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                return (Boolean)super.visitMethodInvocation(tree, unused) != false || this.isOptionalOrNull(tree);
            }

            @Override
            public Boolean visitParenthesized(ParenthesizedTree tree, Void unused) {
                return (Boolean)this.visit(tree.getExpression(), unused);
            }

            @Override
            public Boolean visitTypeCast(TypeCastTree tree, Void unused) {
                return (Boolean)this.visit(tree.getExpression(), unused);
            }

            @Override
            protected Boolean defaultAction(Tree tree, Void unused) {
                return NullnessUtils.isVoid(ASTHelpers.getType(tree), stateForCompilationUnit) || definitelyNullVars.contains(ASTHelpers.getSymbol(tree)) || this.isSwitchExpressionWithDefinitelyNullBranch(tree);
            }

            boolean isOptionalOrNull(MethodInvocationTree tree) {
                return OPTIONAL_OR_NULL.matches(tree, stateForCompilationUnit) || OPTIONAL_OR_ELSE.matches(tree, stateForCompilationUnit) && tree.getArguments().get(0).getKind() == Tree.Kind.NULL_LITERAL;
            }

            boolean isSwitchExpressionWithDefinitelyNullBranch(Tree tree) {
                return tree.getKind().name().equals("SWITCH_EXPRESSION") && NullnessUtils.getCases(tree).stream().map(x$0 -> NullnessUtils.getBody(x$0)).anyMatch(t -> Objects.equals(this.visit((Tree)t, null), Boolean.TRUE));
            }
        }.visit(tree, null);
    }

    private static List<?> getCases(Tree switchExpressionTree) {
        try {
            if (getCasesMethod == null) {
                getCasesMethod = Class.forName("com.sun.source.tree.SwitchExpressionTree").getMethod("getCases", new Class[0]);
            }
            return (List)getCasesMethod.invoke((Object)switchExpressionTree, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static Tree getBody(Object caseTree) {
        try {
            if (getBodyMethod == null) {
                getBodyMethod = CaseTree.class.getMethod("getBody", new Class[0]);
            }
            return (Tree)getBodyMethod.invoke(caseTree, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static boolean isTernaryXIfXIsNull(ConditionalExpressionTree tree) {
        NullCheck nullCheck = NullnessUtils.getNullCheck(tree.getCondition());
        if (nullCheck == null) {
            return false;
        }
        ExpressionTree needsToBeKnownNull = nullCheck.nullCase(tree);
        return nullCheck.bareIdentifierMatches(needsToBeKnownNull);
    }

    static boolean isVoid(Type type, VisitorState state) {
        return type != null && state.getTypes().isSubtype(type, Suppliers.JAVA_LANG_VOID_TYPE.get(state));
    }

    static ImmutableSet<Name> varsProvenNullByParentIf(TreePath path) {
        Tree parent = path.getParentPath().getLeaf();
        if (!(parent instanceof BlockTree)) {
            return ImmutableSet.of();
        }
        if (((BlockTree)parent).getStatements().size() > 1) {
            return ImmutableSet.of();
        }
        Tree grandparent = path.getParentPath().getParentPath().getLeaf();
        if (!(grandparent instanceof IfTree)) {
            return ImmutableSet.of();
        }
        IfTree ifTree = (IfTree)grandparent;
        NullCheck nullCheck = NullnessUtils.getNullCheck(ifTree.getCondition());
        if (nullCheck == null) {
            return ImmutableSet.of();
        }
        if (parent != nullCheck.nullCase(ifTree)) {
            return ImmutableSet.of();
        }
        if (nullCheck.bareIdentifier() == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.of(nullCheck.bareIdentifier());
    }

    @Nullable
    static VariableTree findDeclaration(VisitorState state, Symbol sym) {
        JavacProcessingEnvironment javacEnv = JavacProcessingEnvironment.instance(state.context);
        TreePath declPath = Trees.instance(javacEnv).getPath(sym);
        if (declPath != null && declPath.getCompilationUnit() == state.getPath().getCompilationUnit() && declPath.getLeaf() instanceof VariableTree) {
            return (VariableTree)declPath.getLeaf();
        }
        return null;
    }

    private static OnlyIfInScope applyOnlyIfAlreadyInScope(VisitorState state) {
        return state.errorProneOptions().getFlags().getEnum("Nullness:OnlyIfAnnotationAlreadyInScope", OnlyIfInScope.class).orElse(OnlyIfInScope.FALSE);
    }

    private static boolean applyRemoveSuppressWarnings(VisitorState state) {
        return state.errorProneOptions().getFlags().getBoolean("Nullness:RemoveSuppressWarnings").orElse(false);
    }

    private static enum OnlyIfInScope {
        IF_NOT,
        FALSE,
        TRUE;

    }

    @AutoValue
    static abstract class NullCheck {
        NullCheck() {
        }

        @Nullable
        abstract Name bareIdentifier();

        @Nullable
        abstract Symbol.VarSymbol varSymbolButUsuallyPreferBareIdentifier();

        abstract Polarity polarity();

        boolean bareIdentifierMatches(ExpressionTree other) {
            return other.getKind() == Tree.Kind.IDENTIFIER && this.bareIdentifier() != null && this.bareIdentifier().equals(((IdentifierTree)other).getName());
        }

        ExpressionTree nullCase(ConditionalExpressionTree tree) {
            return this.polarity() == Polarity.IS_NULL ? tree.getTrueExpression() : tree.getFalseExpression();
        }

        StatementTree nullCase(IfTree tree) {
            return this.polarity() == Polarity.IS_NULL ? tree.getThenStatement() : tree.getElseStatement();
        }

        static enum Polarity {
            IS_NULL,
            IS_NOT_NULL;

        }
    }

    @AutoValue
    static abstract class NullableAnnotationToUse {
        NullableAnnotationToUse() {
        }

        static NullableAnnotationToUse annotationToBeImported(String qualifiedName, boolean isTypeUse) {
            return new AutoValue_NullnessUtils_NullableAnnotationToUse(qualifiedName, qualifiedName.replaceFirst(".*[.]", ""), isTypeUse, false);
        }

        static NullableAnnotationToUse annotationWithoutImporting(String name, boolean isTypeUse, boolean isAlreadyInScope) {
            return new AutoValue_NullnessUtils_NullableAnnotationToUse(null, name, isTypeUse, isAlreadyInScope);
        }

        final SuggestedFix fixPostfixingOnto(int position, VisitorState state, @Nullable String suppressionToRemove) {
            return this.prepareBuilder(state, suppressionToRemove).replace(position + 1, position + 1, " @" + this.use() + " ").build();
        }

        final SuggestedFix fixPostfixingOnto(Tree tree, VisitorState state, @Nullable String suppressionToRemove) {
            return this.prepareBuilder(state, suppressionToRemove).postfixWith(tree, " @" + this.use() + " ").build();
        }

        final SuggestedFix fixPrefixingOnto(Tree tree, VisitorState state, @Nullable String suppressionToRemove) {
            return this.prepareBuilder(state, suppressionToRemove).prefixWith(tree, "@" + this.use() + " ").build();
        }

        @Nullable
        abstract String importToAdd();

        abstract String use();

        abstract boolean isTypeUse();

        abstract boolean isAlreadyInScope();

        private SuggestedFix.Builder prepareBuilder(VisitorState state, @Nullable String suppressionToRemove) {
            SuggestedFix.Builder builder = SuggestedFix.builder();
            if (this.importToAdd() != null) {
                builder.addImport(this.importToAdd());
            }
            if (NullnessUtils.applyRemoveSuppressWarnings(state)) {
                SuggestedFixes.removeSuppressWarnings(builder, state, suppressionToRemove);
            }
            return builder;
        }
    }
}

