/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ImmutableAnalysis;
import com.google.errorprone.bugpatterns.threadsafety.ThreadSafety;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.Collections;
import java.util.Optional;

@BugPattern(name="ImmutableAnnotationChecker", altNames={"Immutable"}, summary="Annotations should always be immutable", severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"})
public class ImmutableAnnotationChecker
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public static final String ANNOTATED_ANNOTATION_MESSAGE = "annotations are immutable by default; annotating them with @com.google.errorprone.annotations.Immutable is unnecessary";
    private static final ImmutableSet<String> IGNORED_PROCESSORS = ImmutableSet.of("com.google.auto.value.processor.AutoAnnotationProcessor");
    private final WellKnownMutability wellKnownMutability;

    public ImmutableAnnotationChecker(ErrorProneFlags flags) {
        this.wellKnownMutability = WellKnownMutability.fromFlags(flags);
    }

    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        ThreadSafety.Violation info;
        Symbol.ClassSymbol symbol = ASTHelpers.getSymbol(tree);
        if (symbol.isAnnotationType() || !WellKnownMutability.isAnnotation(state, symbol.type)) {
            return Description.NO_MATCH;
        }
        if (!Collections.disjoint(ASTHelpers.getGeneratedBy(symbol, state), IGNORED_PROCESSORS)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Symbol)symbol, Immutable.class, state)) {
            AnnotationTree annotation = ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), "Immutable");
            if (annotation != null) {
                state.reportMatch(this.buildDescription(annotation).setMessage(ANNOTATED_ANNOTATION_MESSAGE).addFix(SuggestedFix.delete(annotation)).build());
            } else {
                state.reportMatch(this.buildDescription(tree).setMessage(ANNOTATED_ANNOTATION_MESSAGE).build());
            }
        }
        if (!(info = new ImmutableAnalysis(this, state, this.wellKnownMutability, ImmutableSet.of(Immutable.class.getName())).checkForImmutability(Optional.of(tree), ImmutableSet.of(), ASTHelpers.getType(tree), this::describeClass)).isPresent()) {
            return Description.NO_MATCH;
        }
        return this.describeClass(tree, info).build();
    }

    Description.Builder describeClass(Tree tree, ThreadSafety.Violation info) {
        String message = "annotations should be immutable: " + info.message();
        return this.buildDescription(tree).setMessage(message);
    }
}

