/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ImmutableChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.Optional;

@BugPattern(name="ImmutableRefactoring", summary="Refactors uses of the JSR 305 @Immutable to Error Prone's annotation", severity=BugPattern.SeverityLevel.SUGGESTION)
public class ImmutableRefactoring
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final ImmutableChecker immutableChecker = new ImmutableChecker(ImmutableSet.of(javax.annotation.concurrent.Immutable.class.getName(), Immutable.class.getName()));
        Optional<ImportTree> immutableImport = tree.getImports().stream().filter(i -> {
            Symbol s = ASTHelpers.getSymbol(i.getQualifiedIdentifier());
            return s != null && s.getQualifiedName().contentEquals(javax.annotation.concurrent.Immutable.class.getName());
        }).findFirst();
        if (!immutableImport.isPresent()) {
            return Description.NO_MATCH;
        }
        final boolean[] ok = new boolean[]{true};
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitClass(ClassTree node, Void unused) {
                if (immutableChecker.matchClass(node, this.createVisitorState().withPath(this.getCurrentPath())) != Description.NO_MATCH) {
                    ok[0] = false;
                }
                return (Void)super.visitClass(node, null);
            }

            private VisitorState createVisitorState() {
                return VisitorState.createConfiguredForCompilation(state.context, description -> {
                    ok2[0] = false;
                }, ImmutableMap.of(), state.errorProneOptions());
            }
        }.scan(state.getPath(), (Void)null);
        if (!ok[0]) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(immutableImport.get(), (Fix)SuggestedFix.builder().removeImport(javax.annotation.concurrent.Immutable.class.getName()).addImport(Immutable.class.getName()).build());
    }
}

