/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(name="ThreadPriorityCheck", summary="Relying on the thread scheduler is discouraged.", severity=BugPattern.SeverityLevel.WARNING)
public class ThreadPriorityCheck
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> THREAD_MATCHERS = Matchers.anyOf(Matchers.staticMethod().onClass("java.lang.Thread").named("yield"), Matchers.instanceMethod().onDescendantOf("java.lang.Thread").named("setPriority"));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return THREAD_MATCHERS.matches(tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

