/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.CanBeStaticAnalyzer;
import com.google.errorprone.bugpatterns.threadsafety.AnnotationInfo;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_ThreadSafety_Violation;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.ClassTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;
import org.pcollections.ConsPStack;

public final class ThreadSafety {
    private final VisitorState state;
    private final Purpose purpose;
    private final KnownTypes knownTypes;
    private final ImmutableSet<String> markerAnnotations;
    private final ImmutableSet<String> acceptedAnnotations;
    private final Class<? extends Annotation> containerOfAnnotation;
    @Nullable
    private final Class<? extends Annotation> suppressAnnotation;
    @Nullable
    private final Class<? extends Annotation> typeParameterAnnotation;
    private final Set<Symbol.TypeVariableSymbol> recursiveThreadSafeTypeParameter = new HashSet<Symbol.TypeVariableSymbol>();
    private static final Supplier<Name> CONTAINEROF = VisitorState.memoize(state -> state.getName("containerOf"));

    public static Builder builder() {
        return new Builder();
    }

    private ThreadSafety(VisitorState state, Purpose purpose, KnownTypes knownTypes, Set<String> markerAnnotations, Set<String> acceptedAnnotations, @Nullable Class<? extends Annotation> containerOfAnnotation, @Nullable Class<? extends Annotation> suppressAnnotation, @Nullable Class<? extends Annotation> typeParameterAnnotation) {
        this.state = Preconditions.checkNotNull(state);
        this.purpose = purpose;
        this.knownTypes = Preconditions.checkNotNull(knownTypes);
        this.markerAnnotations = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(markerAnnotations));
        this.acceptedAnnotations = ImmutableSet.copyOf((Collection)Preconditions.checkNotNull(acceptedAnnotations));
        this.containerOfAnnotation = containerOfAnnotation;
        this.suppressAnnotation = suppressAnnotation;
        this.typeParameterAnnotation = typeParameterAnnotation;
    }

    public Violation threadSafeInstantiation(Set<String> containerTypeParameters, AnnotationInfo annotation, Type type) {
        for (int i = 0; i < type.tsym.getTypeParameters().size(); ++i) {
            Violation info;
            Symbol.TypeVariableSymbol typaram = type.tsym.getTypeParameters().get(i);
            boolean immutableTypeParameter = this.hasThreadSafeTypeParameterAnnotation(typaram);
            if (!annotation.containerOf().contains(((Name)typaram.getSimpleName()).toString()) && !immutableTypeParameter) continue;
            if (type.getTypeArguments().isEmpty()) {
                return Violation.of(String.format("'%s' required instantiation of '%s' with type parameters, but was raw", this.getPrettyName(type.tsym), typaram));
            }
            Type tyarg = type.getTypeArguments().get(i);
            if (this.suppressAnnotation != null && tyarg.getAnnotationMirrors().stream().anyMatch(a -> ((Symbol.ClassSymbol)a.getAnnotationType().asElement()).flatName().contentEquals(this.suppressAnnotation.getName())) || !(info = this.isThreadSafeType(!immutableTypeParameter, containerTypeParameters, tyarg)).isPresent()) continue;
            return info.plus(String.format("'%s' was instantiated with %s type for '%s'", this.getPrettyName(type.tsym), this.purpose.mutableOrNonThreadSafe(), typaram.getSimpleName()));
        }
        return Violation.absent();
    }

    public Violation checkSuperInstantiation(Set<String> containerTypeParameters, AnnotationInfo annotation, Type type) {
        Violation info = this.threadSafeInstantiation(containerTypeParameters, annotation, type);
        if (info.isPresent()) {
            return info;
        }
        return Streams.zip(type.asElement().getTypeParameters().stream(), type.getTypeArguments().stream(), (typaram, argument) -> {
            if (this.containerOfSubtyping(containerTypeParameters, annotation, (Symbol.TypeVariableSymbol)typaram, (Type)argument)) {
                return Violation.of(String.format("'%s' is not a container of '%s'", annotation.typeName(), typaram));
            }
            return Violation.absent();
        }).filter(Violation::isPresent).findFirst().orElse(Violation.absent());
    }

    private boolean containerOfSubtyping(Set<String> containerTypeParameters, AnnotationInfo annotation, Symbol.TypeVariableSymbol typaram, Type tyargument) {
        if (!tyargument.hasTag(TypeTag.TYPEVAR)) {
            return false;
        }
        if (!containerTypeParameters.contains(((Name)tyargument.asElement().getSimpleName()).toString()) || this.isTypeParameterThreadSafe((Symbol.TypeVariableSymbol)tyargument.asElement(), containerTypeParameters)) {
            return false;
        }
        return !annotation.containerOf().contains(((Name)typaram.getSimpleName()).toString());
    }

    @Deprecated
    public Violation isThreadSafeType(Set<String> containerTypeParameters, Type type) {
        return this.isThreadSafeType(true, containerTypeParameters, type);
    }

    public Violation isThreadSafeType(boolean allowContainerTypeParameters, Set<String> containerTypeParameters, Type type) {
        return type.accept(new ThreadSafeTypeVisitor(allowContainerTypeParameters, containerTypeParameters), null);
    }

    public boolean hasThreadSafeTypeParameterAnnotation(Symbol.TypeVariableSymbol symbol) {
        return this.typeParameterAnnotation != null && symbol.getAnnotationMirrors().stream().anyMatch(t -> t.type.tsym.flatName().contentEquals(this.typeParameterAnnotation.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTypeParameterThreadSafe(Symbol.TypeVariableSymbol symbol, Set<String> containerTypeParameters) {
        if (!this.recursiveThreadSafeTypeParameter.add(symbol)) {
            return true;
        }
        try {
            for (Type bound : symbol.getBounds()) {
                if (this.isThreadSafeType(true, containerTypeParameters, bound).isPresent()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = this.hasThreadSafeTypeParameterAnnotation(symbol);
            return bl;
        }
        finally {
            this.recursiveThreadSafeTypeParameter.remove(symbol);
        }
    }

    public AnnotationInfo getMarkerOrAcceptedAnnotation(Symbol sym, VisitorState state) {
        String nameStr = sym.flatName().toString();
        AnnotationInfo known = this.knownTypes.getKnownSafeClasses().get(nameStr);
        if (known != null) {
            return known;
        }
        return this.getAnnotation(sym, ImmutableSet.copyOf(Sets.union(this.markerAnnotations, this.acceptedAnnotations)), state);
    }

    @Nullable
    public Type mutableEnclosingInstance(Optional<ClassTree> tree, Type.ClassType type) {
        if (tree.isPresent() && !CanBeStaticAnalyzer.referencesOuter(tree.get(), ASTHelpers.getSymbol(tree.get()), this.state)) {
            return null;
        }
        Type enclosing = type.getEnclosingType();
        while (!enclosing.getKind().equals((Object)TypeKind.NONE)) {
            if (this.getMarkerOrAcceptedAnnotation(enclosing.tsym, this.state) == null && this.isThreadSafeType(false, ImmutableSet.of(), enclosing).isPresent()) {
                return enclosing;
            }
            enclosing = enclosing.getEnclosingType();
        }
        return null;
    }

    public Set<String> threadSafeTypeParametersInScope(Symbol sym) {
        if (sym == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        Symbol s = sym;
        block4: while (s.owner != null) {
            switch (s.getKind()) {
                case INSTANCE_INIT: {
                    break;
                }
                case PACKAGE: {
                    break block4;
                }
                default: {
                    AnnotationInfo annotation = this.getMarkerOrAcceptedAnnotation(s, this.state);
                    if (annotation == null) break;
                    for (Symbol.TypeVariableSymbol typaram : s.getTypeParameters()) {
                        String name = ((Name)typaram.getSimpleName()).toString();
                        if (!annotation.containerOf().contains(name)) continue;
                        result.add(name);
                    }
                    if (s.isStatic()) break block4;
                }
            }
            s = s.owner;
        }
        return result.build();
    }

    @Nullable
    private AnnotationInfo getAnnotation(Symbol sym, ImmutableSet<String> annotationsToCheck, VisitorState state) {
        for (String annotation : annotationsToCheck) {
            AnnotationInfo info = this.getAnnotation(sym, state, annotation, this.containerOfAnnotation);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    @Nullable
    private AnnotationInfo getAnnotation(Symbol sym, VisitorState state, String annotation, @Nullable Class<? extends Annotation> elementAnnotation) {
        if (sym == null) {
            return null;
        }
        Optional<Attribute.Compound> attr = sym.getRawAttributes().stream().filter(a -> a.type.tsym.getQualifiedName().contentEquals(annotation)).findAny();
        if (attr.isPresent()) {
            ImmutableList<String> containerElements = ThreadSafety.containerOf(state, attr.get());
            if (elementAnnotation != null && containerElements.isEmpty()) {
                containerElements = sym.getTypeParameters().stream().filter(p -> p.getAnnotation(elementAnnotation) != null).map(p -> ((Name)p.getSimpleName()).toString()).collect(ImmutableList.toImmutableList());
            }
            return AnnotationInfo.create(sym.getQualifiedName().toString(), containerElements);
        }
        if (!(sym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        Type superClass = ((Symbol.ClassSymbol)sym).getSuperclass();
        AnnotationInfo superAnnotation = this.getInheritedAnnotation(superClass.asElement(), state);
        if (superAnnotation == null) {
            return null;
        }
        ImmutableList.Builder containerOf = ImmutableList.builder();
        for (int i = 0; i < superClass.getTypeArguments().size(); ++i) {
            Type arg = superClass.getTypeArguments().get(i);
            Symbol.TypeVariableSymbol formal = superClass.asElement().getTypeParameters().get(i);
            if (!arg.hasTag(TypeTag.TYPEVAR)) continue;
            Symbol.TypeSymbol argSym = arg.asElement();
            if (argSym.owner != sym || !superAnnotation.containerOf().contains(((Name)formal.getSimpleName()).toString())) continue;
            containerOf.add(((Name)argSym.getSimpleName()).toString());
        }
        return AnnotationInfo.create(superAnnotation.typeName(), containerOf.build());
    }

    public AnnotationInfo getInheritedAnnotation(Symbol sym, VisitorState state) {
        return this.getAnnotation(sym, this.markerAnnotations, state);
    }

    private static ImmutableList<String> containerOf(VisitorState state, Attribute.Compound attr) {
        Attribute m = attr.member(CONTAINEROF.get(state));
        if (m == null) {
            return ImmutableList.of();
        }
        return MoreAnnotations.asStrings(m).collect(ImmutableList.toImmutableList());
    }

    public String getPrettyName(Symbol sym) {
        if (!sym.getSimpleName().isEmpty()) {
            return sym.getSimpleName().toString();
        }
        if (sym.getKind() == ElementKind.ENUM) {
            return sym.owner.getSimpleName().toString();
        }
        Type superType = this.state.getTypes().supertype(sym.type);
        if (this.state.getTypes().isSameType(superType, this.state.getSymtab().objectType)) {
            superType = Iterables.getFirst(this.state.getTypes().interfaces(sym.type), superType);
        }
        return ((Name)superType.tsym.getSimpleName()).toString();
    }

    public Violation checkInstantiation(Collection<Symbol.TypeVariableSymbol> typeParameters, Collection<Type> typeArguments) {
        return Streams.zip(typeParameters.stream(), typeArguments.stream(), (sym, type) -> this.checkInstantiation((Symbol.TypeVariableSymbol)sym, (Collection<Type>)ImmutableList.of(type))).filter(Violation::isPresent).findFirst().orElse(Violation.absent());
    }

    public Violation checkInstantiation(Symbol.TypeVariableSymbol typeParameter, Collection<Type> instantiations) {
        if (!this.hasThreadSafeTypeParameterAnnotation(typeParameter)) {
            return Violation.absent();
        }
        for (Type instantiation : instantiations) {
            Violation info = this.isThreadSafeType(true, ImmutableSet.of(), instantiation);
            if (!info.isPresent()) continue;
            return info.plus(String.format("instantiation of '%s' is %s", typeParameter, this.purpose.mutableOrNotThreadSafe()));
        }
        return Violation.absent();
    }

    public Violation checkInvocation(Type methodType, Symbol symbol) {
        if (methodType == null) {
            return Violation.absent();
        }
        List<Symbol.TypeVariableSymbol> typeParameters = symbol.getTypeParameters();
        if (typeParameters.stream().noneMatch(this::hasThreadSafeTypeParameterAnnotation)) {
            return Violation.absent();
        }
        ImmutableListMultimap<Symbol.TypeVariableSymbol, Type> instantiation = ASTHelpers.getTypeSubstitution(methodType, symbol);
        for (Symbol.TypeVariableSymbol typeParameter : typeParameters) {
            Violation violation = this.checkInstantiation(typeParameter, (Collection<Type>)instantiation.get((Object)typeParameter));
            if (!violation.isPresent()) continue;
            return violation;
        }
        return Violation.absent();
    }

    private class ThreadSafeTypeVisitor
    extends Types.SimpleVisitor<Violation, Void> {
        private final boolean allowContainerTypeParameters;
        private final Set<String> containerTypeParameters;

        private ThreadSafeTypeVisitor(boolean allowContainerTypeParameters, Set<String> containerTypeParameters) {
            this.allowContainerTypeParameters = allowContainerTypeParameters;
            this.containerTypeParameters = !allowContainerTypeParameters ? ImmutableSet.of() : containerTypeParameters;
        }

        @Override
        public Violation visitWildcardType(Type.WildcardType type, Void s) {
            return ThreadSafety.this.state.getTypes().wildUpperBound(type).accept(this, null);
        }

        @Override
        public Violation visitArrayType(Type.ArrayType t, Void s) {
            return Violation.of(String.format("arrays are %s", ThreadSafety.this.purpose.mutableOrNotThreadSafe()));
        }

        @Override
        public Violation visitTypeVar(Type.TypeVar type, Void s) {
            Symbol.TypeVariableSymbol tyvar = (Symbol.TypeVariableSymbol)type.tsym;
            if (this.containerTypeParameters.contains(((Name)tyvar.getSimpleName()).toString())) {
                return Violation.absent();
            }
            if (ThreadSafety.this.isTypeParameterThreadSafe(tyvar, this.containerTypeParameters)) {
                return Violation.absent();
            }
            String message = !this.allowContainerTypeParameters ? String.format("'%s' is not annotated @ImmutableTypeParameter", tyvar.getSimpleName()) : (!this.containerTypeParameters.isEmpty() ? String.format("'%s' is a %s type variable (not in '%s')", tyvar.getSimpleName(), ThreadSafety.this.purpose.mutableOrNonThreadSafe(), Joiner.on(", ").join(this.containerTypeParameters)) : String.format("'%s' is a %s type variable", tyvar.getSimpleName(), ThreadSafety.this.purpose.mutableOrNonThreadSafe()));
            return Violation.of(message);
        }

        @Override
        public Violation visitType(Type type, Void s) {
            switch (type.tsym.getKind()) {
                case ANNOTATION_TYPE: {
                    return Violation.absent();
                }
                case ENUM: {
                    return Violation.absent();
                }
                case INTERFACE: 
                case CLASS: {
                    break;
                }
                default: {
                    if (!type.tsym.getKind().name().equals("RECORD")) {
                        throw new AssertionError((Object)String.format("Unexpected type kind %s", new Object[]{type.tsym.getKind()}));
                    }
                    break;
                }
            }
            if (WellKnownMutability.isAnnotation(ThreadSafety.this.state, type)) {
                return Violation.absent();
            }
            AnnotationInfo annotation = ThreadSafety.this.getMarkerOrAcceptedAnnotation(type.tsym, ThreadSafety.this.state);
            if (annotation != null) {
                return ThreadSafety.this.threadSafeInstantiation(this.containerTypeParameters, annotation, type);
            }
            String nameStr = type.tsym.flatName().toString();
            if (ThreadSafety.this.knownTypes.getKnownUnsafeClasses().contains(nameStr)) {
                return Violation.of(String.format("'%s' is %s", type.tsym.getSimpleName(), ThreadSafety.this.purpose.mutableOrNotThreadSafe()));
            }
            if (WellKnownMutability.isProto2MessageClass(ThreadSafety.this.state, type)) {
                if (WellKnownMutability.isProto2MutableMessageClass(ThreadSafety.this.state, type)) {
                    return Violation.of(String.format("'%s' is a mutable proto message", type.tsym.getSimpleName()));
                }
                return Violation.absent();
            }
            return Violation.of(String.format("the declaration of type '%s' is not annotated with %s", type, Streams.concat(ThreadSafety.this.markerAnnotations.stream(), ThreadSafety.this.acceptedAnnotations.stream()).map(a -> "@" + a).collect(Collectors.joining(" or "))));
        }
    }

    @AutoValue
    public static abstract class Violation {
        public static Violation create(ConsPStack<String> path) {
            return new AutoValue_ThreadSafety_Violation(path);
        }

        public boolean isPresent() {
            return !this.path().isEmpty();
        }

        public String message() {
            return Joiner.on(", ").join(this.path());
        }

        public abstract ConsPStack<String> path();

        public Violation plus(String edge) {
            return Violation.create((ConsPStack<String>)this.path().plus((Object)edge));
        }

        public static Violation of(String reason) {
            return Violation.create(ConsPStack.singleton(reason));
        }

        public static Violation absent() {
            return Violation.create(ConsPStack.empty());
        }
    }

    public static interface KnownTypes {
        public Map<String, AnnotationInfo> getKnownSafeClasses();

        public Set<String> getKnownUnsafeClasses();
    }

    public static class Builder {
        private Purpose purpose = Purpose.FOR_IMMUTABLE_CHECKER;
        private KnownTypes knownTypes;
        private ImmutableSet<String> markerAnnotations;
        private ImmutableSet<String> acceptedAnnotations = ImmutableSet.of();
        @Nullable
        private Class<? extends Annotation> containerOfAnnotation;
        @Nullable
        private Class<? extends Annotation> suppressAnnotation;
        @Nullable
        private Class<? extends Annotation> typeParameterAnnotation;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder setPurpose(Purpose purpose) {
            this.purpose = purpose;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder knownTypes(KnownTypes knownTypes) {
            this.knownTypes = knownTypes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder markerAnnotations(Set<String> markerAnnotations) {
            return this.markerAnnotations(ImmutableSet.copyOf(markerAnnotations));
        }

        @CanIgnoreReturnValue
        public Builder markerAnnotations(ImmutableSet<String> markerAnnotations) {
            Preconditions.checkNotNull(markerAnnotations);
            this.markerAnnotations = markerAnnotations;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder acceptedAnnotations(Set<String> acceptedAnnotations) {
            return this.acceptedAnnotations(ImmutableSet.copyOf(acceptedAnnotations));
        }

        @CanIgnoreReturnValue
        public Builder acceptedAnnotations(ImmutableSet<String> acceptedAnnotations) {
            Preconditions.checkNotNull(acceptedAnnotations);
            this.acceptedAnnotations = acceptedAnnotations;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder containerOfAnnotation(Class<? extends Annotation> containerOfAnnotation) {
            Preconditions.checkNotNull(containerOfAnnotation);
            this.containerOfAnnotation = containerOfAnnotation;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder suppressAnnotation(Class<? extends Annotation> suppressAnnotation) {
            Preconditions.checkNotNull(suppressAnnotation);
            this.suppressAnnotation = suppressAnnotation;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder typeParameterAnnotation(Class<? extends Annotation> typeParameterAnnotation) {
            Preconditions.checkNotNull(typeParameterAnnotation);
            Preconditions.checkArgument(Arrays.stream(typeParameterAnnotation.getAnnotation(Target.class).value()).anyMatch(ElementType.TYPE_PARAMETER::equals), "%s must be applicable to type parameters", typeParameterAnnotation);
            this.typeParameterAnnotation = typeParameterAnnotation;
            return this;
        }

        public ThreadSafety build(VisitorState state) {
            Preconditions.checkNotNull(this.knownTypes);
            Preconditions.checkNotNull(this.markerAnnotations);
            return new ThreadSafety(state, this.purpose, this.knownTypes, this.markerAnnotations, this.acceptedAnnotations, this.containerOfAnnotation, this.suppressAnnotation, this.typeParameterAnnotation);
        }
    }

    public static enum Purpose {
        FOR_IMMUTABLE_CHECKER{

            @Override
            String mutableOrNonThreadSafe() {
                return "mutable";
            }

            @Override
            String mutableOrNotThreadSafe() {
                return "mutable";
            }
        }
        ,
        FOR_THREAD_SAFE_CHECKER{

            @Override
            String mutableOrNonThreadSafe() {
                return "non-thread-safe";
            }

            @Override
            String mutableOrNotThreadSafe() {
                return "not thread-safe";
            }
        };


        abstract String mutableOrNonThreadSafe();

        abstract String mutableOrNotThreadSafe();
    }
}

