/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.time.NearbyCallers;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="duration.getNano() only accesses the underlying nanosecond adjustment from the whole second.", explanation="If you call duration.getNano(), you must also call duration.getSeconds() in 'nearby' code. If you are trying to convert this duration to nanoseconds, you probably meant to use duration.toNanos() instead.", severity=BugPattern.SeverityLevel.WARNING)
public final class JavaDurationGetSecondsGetNano
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> GET_SECONDS = MethodMatchers.instanceMethod().onExactClass("java.time.Duration").named("getSeconds");
    private static final Matcher<ExpressionTree> GET_NANO = Matchers.allOf(MethodMatchers.instanceMethod().onExactClass("java.time.Duration").named("getNano"), Matchers.not(Matchers.packageStartsWith("java.")));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (GET_NANO.matches(tree, state) && !NearbyCallers.containsCallToSameReceiverNearby(tree, GET_SECONDS, state, false)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

