/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.time.NearbyCallers;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="instant.getNano() only accesses the underlying nanosecond adjustment from the whole second.", explanation="If you call instant.getNano(), you must also call instant.getEpochSecond() in 'nearby' code. If you are trying to convert this instant to nanoseconds, you probably meant to use Instants.toEpochNanos(instant) instead.", severity=BugPattern.SeverityLevel.WARNING)
public final class JavaInstantGetSecondsGetNano
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> GET_EPOCH_SECOND = MethodMatchers.instanceMethod().onExactClass("java.time.Instant").named("getEpochSecond");
    private static final Matcher<ExpressionTree> GET_NANO = Matchers.allOf(MethodMatchers.instanceMethod().onExactClass("java.time.Instant").named("getNano"), Matchers.not(Matchers.packageStartsWith("java.")));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (GET_NANO.matches(tree, state) && !NearbyCallers.containsCallToSameReceiverNearby(tree, GET_EPOCH_SECOND, state, false)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

