/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.time.NearbyCallers;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="localTime.getNano() only accesses the nanos-of-second field. It's rare to only use getNano() without a nearby getSecond() call.", severity=BugPattern.SeverityLevel.WARNING)
public final class JavaLocalTimeGetNano
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> GET_SECOND = MethodMatchers.instanceMethod().onExactClass("java.time.LocalTime").named("getSecond");
    private static final Matcher<ExpressionTree> GET_NANO = Matchers.allOf(MethodMatchers.instanceMethod().onExactClass("java.time.LocalTime").named("getNano"), Matchers.not(Matchers.packageStartsWith("java.")));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (GET_NANO.matches(tree, state) && !NearbyCallers.containsCallToSameReceiverNearby(tree, GET_SECOND, state, false)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

