/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import java.util.ArrayList;

@BugPattern(summary="Use of JodaTime's type.plus(long) or type.minus(long) is not allowed (where <type> = {Duration,Instant,DateTime,DateMidnight}). Please use type.plus(Duration.millis(long)) or type.minus(Duration.millis(long)) instead.", explanation="JodaTime's type.plus(long) and type.minus(long) methods are often a source of bugs because the units of the parameters are ambiguous. Please use type.plus(Duration.millis(long)) or type.minus(Duration.millis(long)) instead.", severity=BugPattern.SeverityLevel.WARNING)
public final class JodaPlusMinusLong
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableSet<String> TYPES = ImmutableSet.of("DateMidnight", "DateTime", "Duration", "Instant");
    private static final ImmutableSet<String> METHODS = ImmutableSet.of("plus", "minus");
    private static final Matcher<ExpressionTree> MATCHER = Matchers.allOf(JodaPlusMinusLong.buildMatcher(), Matchers.not(Matchers.packageStartsWith("org.joda.time")));
    private static final Matcher<ExpressionTree> DURATION_GET_MILLIS_MATCHER = MethodMatchers.instanceMethod().onDescendantOf("org.joda.time.ReadableDuration").named("getMillis");

    private static Matcher<ExpressionTree> buildMatcher() {
        ArrayList<MethodMatchers.ParameterMatcher> matchers = new ArrayList<MethodMatchers.ParameterMatcher>();
        for (String type : TYPES) {
            for (String method : METHODS) {
                matchers.add(Matchers.instanceMethod().onExactClass("org.joda.time." + type).named(method).withParameters("long", new String[0]));
            }
        }
        return Matchers.anyOf(matchers);
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder builder = SuggestedFix.builder();
        ExpressionTree firstArgumentTree = tree.getArguments().get(0);
        Object firstArgumentReplacement = DURATION_GET_MILLIS_MATCHER.matches(firstArgumentTree, state) ? state.getSourceForNode(ASTHelpers.getReceiver(firstArgumentTree)) : SuggestedFixes.qualifyType(state, builder, "org.joda.time.Duration") + ".millis(" + state.getSourceForNode(firstArgumentTree) + ")";
        builder.replace(firstArgumentTree, (String)firstArgumentReplacement);
        return this.describeMatch(tree, (Fix)builder.build());
    }
}

