/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="LocalDate.plus() and minus() does not work with Durations. LocalDate represents civil time (years/months/days), so java.time.Period is the appropriate thing to add or subtract instead.", severity=BugPattern.SeverityLevel.ERROR)
public final class LocalDateTemporalAmount
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> MATCHER = Matchers.allOf(MethodMatchers.instanceMethod().onExactClass("java.time.LocalDate").namedAnyOf("plus", "minus").withParameters("java.time.temporal.TemporalAmount", new String[0]), Matchers.argument(0, Matchers.isSameType("java.time.Duration")), Matchers.not(Matchers.packageStartsWith("java.")));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return MATCHER.matches(tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

