/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Period.from(Period) returns itself; from(Duration) throws a runtime exception.", explanation="Period.from(TemporalAmount) will always throw a DateTimeException when passed a Duration and return itself when passed a Period.", severity=BugPattern.SeverityLevel.ERROR)
public final class PeriodFrom
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> PERIOD_FROM = Matchers.staticMethod().onClass("java.time.Period").named("from");
    private static final Matcher<Tree> DURATION = Matchers.isSameType("java.time.Duration");
    private static final Matcher<Tree> PERIOD = Matchers.isSameType("java.time.Period");

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (PERIOD_FROM.matches(tree, state)) {
            ExpressionTree arg0 = tree.getArguments().get(0);
            if (DURATION.matches(arg0, state)) {
                return this.describeMatch(tree);
            }
            if (PERIOD.matches(arg0, state)) {
                return this.describeMatch(tree, (Fix)SuggestedFix.replace(tree, state.getSourceForNode(arg0)));
            }
        }
        return Description.NO_MATCH;
    }
}

