/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="When adding or subtracting from a Period, Duration is incompatible.", explanation="Period.(plus|minus)(TemporalAmount) will always throw a DateTimeException when passed a Duration.", severity=BugPattern.SeverityLevel.ERROR)
public final class PeriodTimeMath
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private final Matcher<MethodInvocationTree> matcherToCheck;
    private static final Matcher<ExpressionTree> PERIOD_MATH = Matchers.instanceMethod().onExactClass("java.time.Period").namedAnyOf("plus", "minus");
    private static final Matcher<ExpressionTree> DURATION = Matchers.isSameType("java.time.Duration");
    private static final Matcher<ExpressionTree> PERIOD = Matchers.isSameType("java.time.Period");

    public PeriodTimeMath(ErrorProneFlags flags) {
        boolean requireStrictCompatibility = flags.getBoolean("PeriodTimeMath:RequireStaticPeriodArgument").orElse(false);
        this.matcherToCheck = Matchers.allOf(PERIOD_MATH, Matchers.argument(0, requireStrictCompatibility ? Matchers.not(PERIOD) : DURATION));
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.matcherToCheck.matches(tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

