/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="Use ZoneOffset.UTC instead of ZoneId.of(\"Z\").", explanation="Avoid the magic constant (ZoneId.of(\"Z\")) in favor of a more descriptive API:  ZoneOffset.UTC", severity=BugPattern.SeverityLevel.ERROR)
public final class ZoneIdOfZ
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String ZONE_OFFSET = "java.time.ZoneOffset";
    private static final Matcher<ExpressionTree> ZONE_ID_OF = Matchers.allOf(MethodMatchers.staticMethod().onClass("java.time.ZoneId").named("of"), Matchers.not(Matchers.anyOf(Matchers.packageStartsWith("java."), Matchers.packageStartsWith("tck.java."))));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        String zone;
        if (ZONE_ID_OF.matches(tree, state) && (zone = ASTHelpers.constValue(tree.getArguments().get(0), String.class)) != null && zone.equals("Z")) {
            SuggestedFix.Builder fix = SuggestedFix.builder().addImport(ZONE_OFFSET);
            fix.replace(tree, String.format("%s.UTC", SuggestedFixes.qualifyType(state, fix, ZONE_OFFSET)));
            return this.describeMatch(tree, (Fix)fix.build());
        }
        return Description.NO_MATCH;
    }
}

