/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import java.util.Set;

public class CompoundAssignment
implements Matcher<CompoundAssignmentTree> {
    private static final ImmutableSet<Tree.Kind> COMPOUND_ASSIGNMENT_OPERATORS = ImmutableSet.of(Tree.Kind.AND_ASSIGNMENT, Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT, new Tree.Kind[]{Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT});
    private final Set<Tree.Kind> operators;
    private final Matcher<ExpressionTree> receiverMatcher;
    private final Matcher<ExpressionTree> expressionMatcher;

    public CompoundAssignment(Set<Tree.Kind> operators, Matcher<ExpressionTree> receiverMatcher, Matcher<ExpressionTree> expressionMatcher) {
        this.operators = CompoundAssignment.validateOperators(operators);
        if (receiverMatcher == null) {
            throw new NullPointerException("CompoundAssignment receiver matcher is null");
        }
        if (expressionMatcher == null) {
            throw new NullPointerException("CompoundAssignment expression matcher is null");
        }
        this.receiverMatcher = receiverMatcher;
        this.expressionMatcher = expressionMatcher;
    }

    @Override
    public boolean matches(CompoundAssignmentTree compoundAssignmentTree, VisitorState state) {
        if (!this.operators.contains((Object)compoundAssignmentTree.getKind())) {
            return false;
        }
        return this.receiverMatcher.matches(compoundAssignmentTree.getVariable(), state) && this.expressionMatcher.matches(compoundAssignmentTree.getExpression(), state);
    }

    private static Set<Tree.Kind> validateOperators(Set<Tree.Kind> kinds) {
        for (Tree.Kind kind : kinds) {
            if (COMPOUND_ASSIGNMENT_OPERATORS.contains((Object)kind)) continue;
            throw new IllegalArgumentException(kind.name() + " is not a compound-assignment operator.");
        }
        return kinds;
    }
}

