/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.fixes.Fix;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;

public class Description {
    public static final Description NO_MATCH = new Description(null, "<no match>", "<no match>", "<no match>", ImmutableList.of(), BugPattern.SeverityLevel.SUGGESTION);
    public final JCDiagnostic.DiagnosticPosition position;
    public final String checkName;
    private final String rawMessage;
    @Nullable
    private final String linkUrl;
    public final ImmutableList<Fix> fixes;
    public final BugPattern.SeverityLevel severity;

    public String getMessage() {
        return String.format("[%s] %s", this.checkName, this.getMessageWithoutCheckName());
    }

    @Nullable
    public String getLink() {
        return this.linkUrl;
    }

    public String getRawMessage() {
        return this.rawMessage;
    }

    public String getMessageWithoutCheckName() {
        return this.linkUrl != null ? String.format("%s\n%s", this.rawMessage, Description.linkTextForDiagnostic(this.linkUrl)) : String.format("%s", this.rawMessage);
    }

    private Description(JCDiagnostic.DiagnosticPosition position, String checkName, String rawMessage, @Nullable String linkUrl, List<Fix> fixes, BugPattern.SeverityLevel severity) {
        this.position = position;
        this.checkName = checkName;
        this.rawMessage = rawMessage;
        this.linkUrl = linkUrl;
        this.fixes = ImmutableList.copyOf(fixes);
        this.severity = severity;
    }

    @CheckReturnValue
    public Description applySeverityOverride(BugPattern.SeverityLevel severity) {
        return new Description(this.position, this.checkName, this.rawMessage, this.linkUrl, this.fixes, severity);
    }

    @Nullable
    private static String linkTextForDiagnostic(String linkUrl) {
        return Strings.isNullOrEmpty(linkUrl) ? null : "  (see " + linkUrl + ")";
    }

    public static Builder builder(Tree node, String name, @Nullable String link, BugPattern.SeverityLevel severity, String message) {
        return new Builder((JCDiagnostic.DiagnosticPosition)((Object)node), name, link, severity, message);
    }

    public static Builder builder(JCDiagnostic.DiagnosticPosition position, String name, @Nullable String link, BugPattern.SeverityLevel severity, String message) {
        return new Builder(position, name, link, severity, message);
    }

    public static Builder builder(JCTree tree, String name, @Nullable String link, BugPattern.SeverityLevel severity, String message) {
        return new Builder(tree, name, link, severity, message);
    }

    public static class Builder {
        private final JCDiagnostic.DiagnosticPosition position;
        private final String name;
        private String linkUrl;
        private final BugPattern.SeverityLevel severity;
        private final ImmutableList.Builder<Fix> fixListBuilder = ImmutableList.builder();
        private String rawMessage;

        private Builder(JCDiagnostic.DiagnosticPosition position, String name, @Nullable String linkUrl, BugPattern.SeverityLevel severity, String rawMessage) {
            this.position = Preconditions.checkNotNull(position);
            this.name = Preconditions.checkNotNull(name);
            this.linkUrl = linkUrl;
            this.severity = Preconditions.checkNotNull(severity);
            this.rawMessage = Preconditions.checkNotNull(rawMessage);
        }

        @CanIgnoreReturnValue
        public Builder addFix(Fix fix) {
            Preconditions.checkNotNull(fix, "fix must not be null");
            if (!fix.isEmpty()) {
                this.fixListBuilder.add((Object)fix);
            }
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addFix(Optional<? extends Fix> fix) {
            Preconditions.checkNotNull(fix, "fix must not be null");
            fix.ifPresent(this::addFix);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllFixes(List<? extends Fix> fixes) {
            Preconditions.checkNotNull(fixes, "fixes must not be null");
            for (Fix fix : fixes) {
                this.addFix(fix);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMessage(String message) {
            Preconditions.checkNotNull(message, "message must not be null");
            this.rawMessage = message;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLinkUrl(String linkUrl) {
            Preconditions.checkNotNull(linkUrl, "linkUrl must not be null");
            this.linkUrl = linkUrl;
            return this;
        }

        public Description build() {
            return new Description(this.position, this.name, this.rawMessage, this.linkUrl, (List<Fix>)((Object)this.fixListBuilder.build()), this.severity);
        }
    }
}

