/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers.method;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.method.BaseMethodMatcher;
import com.google.errorprone.matchers.method.MatchState;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;

final class MethodMatcherImpl
implements MethodMatchers.InstanceMethodMatcher,
MethodMatchers.StaticMethodMatcher,
MethodMatchers.AnyMethodMatcher,
MethodMatchers.MethodClassMatcher,
MethodMatchers.MethodSignatureMatcher,
MethodMatchers.MethodNameMatcher,
MethodMatchers.ConstructorMatcher,
MethodMatchers.ConstructorClassMatcher,
MethodMatchers.ParameterMatcher {
    static final MethodMatchers.AnyMethodMatcher ANY_METHOD = new MethodMatcherImpl(BaseMethodMatcher.METHOD, ImmutableList.of((m, s) -> true));
    static final MethodMatchers.ConstructorMatcher CONSTRUCTOR = new MethodMatcherImpl(BaseMethodMatcher.CONSTRUCTOR, ImmutableList.of((m, s) -> true));
    static final MethodMatchers.StaticMethodMatcher STATIC_METHOD = new MethodMatcherImpl(BaseMethodMatcher.METHOD, ImmutableList.of((m, s) -> m.sym().isStatic()));
    static final MethodMatchers.InstanceMethodMatcher INSTANCE_METHOD = new MethodMatcherImpl(BaseMethodMatcher.METHOD, ImmutableList.of((m, s) -> !m.sym().isStatic()));
    private final BaseMethodMatcher baseMatcher;
    private final ImmutableList<Constraint> constraints;

    private MethodMatcherImpl(BaseMethodMatcher baseMatcher, ImmutableList<Constraint> matchers) {
        this.baseMatcher = baseMatcher;
        this.constraints = matchers;
    }

    private MethodMatcherImpl append(Constraint c) {
        return new MethodMatcherImpl(this.baseMatcher, (ImmutableList<Constraint>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.constraints)).add(c)).build());
    }

    @Override
    public boolean matches(ExpressionTree tree, VisitorState state) {
        MatchState method = this.baseMatcher.match(tree);
        if (method == null) {
            return false;
        }
        for (Constraint constraint : this.constraints) {
            if (constraint.matches(method, state)) continue;
            return false;
        }
        return true;
    }

    @Override
    public MethodMatchers.MethodClassMatcher onClass(TypePredicate predicate) {
        return this.append((m, s) -> predicate.apply(m.ownerType(), s));
    }

    @Override
    public MethodMatchers.MethodClassMatcher onClass(String className) {
        TypePredicate pred = TypePredicates.isExactType(className);
        return this.append((m, s) -> pred.apply(m.ownerType(), s));
    }

    @Override
    public MethodMatchers.MethodClassMatcher onClass(Supplier<Type> classType) {
        return this.onClass(TypePredicates.isExactType(classType));
    }

    @Override
    public MethodMatchers.MethodClassMatcher onClassAny(Iterable<String> classNames) {
        TypePredicate pred = TypePredicates.isExactTypeAny(classNames);
        return this.append((m, s) -> pred.apply(m.ownerType(), s));
    }

    @Override
    public MethodMatchers.MethodClassMatcher onClassAny(String ... classNames) {
        return this.onClassAny(ImmutableList.copyOf(classNames));
    }

    @Override
    public MethodMatchers.MethodClassMatcher onExactClass(String className) {
        return this.onClass(className);
    }

    @Override
    public MethodMatchers.MethodClassMatcher onExactClass(Supplier<Type> classType) {
        return this.onClass(classType);
    }

    @Override
    public MethodMatchers.MethodClassMatcher onExactClassAny(Iterable<String> classTypes) {
        return this.onClassAny(classTypes);
    }

    @Override
    public MethodMatchers.MethodClassMatcher onExactClassAny(String ... classTypes) {
        return this.onClassAny(classTypes);
    }

    @Override
    public MethodMatchers.MethodClassMatcher onDescendantOf(String className) {
        TypePredicate pred = TypePredicates.isDescendantOf(className);
        return this.append((m, s) -> pred.apply(m.ownerType(), s));
    }

    @Override
    public MethodMatchers.MethodClassMatcher onDescendantOf(Supplier<Type> classType) {
        return this.onClass(TypePredicates.isDescendantOf(classType));
    }

    @Override
    public MethodMatchers.MethodClassMatcher onDescendantOfAny(String ... classTypes) {
        return this.onDescendantOfAny(ImmutableList.copyOf(classTypes));
    }

    @Override
    public MethodMatchers.MethodClassMatcher onDescendantOfAny(Iterable<String> classTypes) {
        TypePredicate pred = TypePredicates.isDescendantOfAny(classTypes);
        return this.append((m, s) -> pred.apply(m.ownerType(), s));
    }

    @Override
    public MethodMatchers.MethodClassMatcher anyClass() {
        return this;
    }

    @Override
    public MethodMatchers.MethodNameMatcher named(String name) {
        Preconditions.checkArgument(!name.contains("(") && !name.contains(")"), "method name (%s) cannot contain parentheses; use \"foo\" instead of \"foo()\"", (Object)name);
        return this.append((m, s) -> ((Name)m.sym().getSimpleName()).contentEquals(name));
    }

    @Override
    public MethodMatchers.MethodNameMatcher namedAnyOf(String ... names) {
        return this.namedAnyOf(ImmutableSet.copyOf(names));
    }

    @Override
    public MethodMatchers.MethodNameMatcher namedAnyOf(Iterable<String> names) {
        ImmutableSet<String> expected = ImmutableSet.copyOf(names);
        return this.append((m, s) -> expected.contains(((Name)m.sym().getSimpleName()).toString()));
    }

    @Override
    public MethodMatchers.MethodNameMatcher withAnyName() {
        return this;
    }

    private MethodMatchers.MethodNameMatcher stringConstraint(Predicate<String> constraint) {
        return this.append((m, s) -> constraint.test(((Name)m.sym().getSimpleName()).toString()));
    }

    @Override
    public MethodMatchers.MethodNameMatcher withNameMatching(Pattern pattern) {
        return this.stringConstraint(s -> pattern.matcher((CharSequence)s).matches());
    }

    @Override
    public MethodMatchers.MethodSignatureMatcher withSignature(String signature) {
        return this.append((m, s) -> ((Name)m.sym().getSimpleName()).contentEquals(signature) || m.sym().toString().equals(signature));
    }

    @Override
    public MethodMatchers.ParameterMatcher withNoParameters() {
        return this.withParameters(ImmutableList.of());
    }

    @Override
    public MethodMatchers.ParameterMatcher withParameters(String first, String ... rest) {
        return this.withParameters(Lists.asList(first, rest));
    }

    @Override
    public MethodMatchers.ParameterMatcher withParameters(Iterable<String> expected) {
        return this.withParametersOfType(Suppliers.fromStrings(expected));
    }

    @Override
    public MethodMatchers.ParameterMatcher withParametersOfType(Iterable<Supplier<Type>> expected) {
        return this.append((method, state) -> {
            List<Type> actual = method.paramTypes();
            if (actual.size() != Iterables.size(expected)) {
                return false;
            }
            Iterator<Type> ax = actual.iterator();
            Iterator bx = expected.iterator();
            while (ax.hasNext()) {
                if (ASTHelpers.isSameType(ax.next(), (Type)((Supplier)bx.next()).get(state), state)) continue;
                return false;
            }
            return true;
        });
    }

    @Override
    public MethodMatchers.ConstructorClassMatcher forClass(TypePredicate predicate) {
        return this.append((m, s) -> predicate.apply(m.ownerType(), s));
    }

    @Override
    public MethodMatchers.ConstructorClassMatcher forClass(String className) {
        return this.append((m, s) -> m.ownerType().asElement().getQualifiedName().contentEquals(className));
    }

    @Override
    public MethodMatchers.ConstructorClassMatcher forClass(Supplier<Type> classType) {
        return this.forClass(TypePredicates.isExactType(classType));
    }

    private static interface Constraint {
        public boolean matches(MatchState var1, VisitorState var2);
    }
}

