/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.errorprone.CodeTransformer;
import com.google.errorprone.SubContext;
import com.google.errorprone.VisitorState;
import com.google.errorprone.refaster.BlockTemplate;
import com.google.errorprone.refaster.ExpressionTemplate;
import com.google.errorprone.refaster.PlaceholderMethod;
import com.google.errorprone.refaster.RefasterRule;
import com.google.errorprone.refaster.Template;
import com.google.errorprone.refaster.UBlank;
import com.google.errorprone.refaster.UStatement;
import com.google.errorprone.refaster.UTemplater;
import com.google.errorprone.refaster.UType;
import com.google.errorprone.refaster.UTypeVar;
import com.google.errorprone.refaster.UVariableDecl;
import com.google.errorprone.refaster.annotation.AfterTemplate;
import com.google.errorprone.refaster.annotation.AllowCodeBetweenLines;
import com.google.errorprone.refaster.annotation.AlsoNegation;
import com.google.errorprone.refaster.annotation.BeforeTemplate;
import com.google.errorprone.refaster.annotation.Placeholder;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;

public final class RefasterRuleBuilderScanner
extends SimpleTreeVisitor<Void, Void> {
    private static final Logger logger = Logger.getLogger(RefasterRuleBuilderScanner.class.toString());
    static final Context.Key<Map<Symbol.MethodSymbol, PlaceholderMethod>> PLACEHOLDER_METHODS_KEY = new Context.Key();
    private final Context context;
    private final Map<Symbol.MethodSymbol, PlaceholderMethod> placeholderMethods;
    private final List<Template<?>> beforeTemplates;
    private final List<Template<?>> afterTemplates;

    private RefasterRuleBuilderScanner(Context context) {
        this.context = new SubContext(context);
        if (context.get(PLACEHOLDER_METHODS_KEY) == null) {
            this.placeholderMethods = new HashMap<Symbol.MethodSymbol, PlaceholderMethod>();
            context.put(PLACEHOLDER_METHODS_KEY, this.placeholderMethods);
        } else {
            this.placeholderMethods = context.get(PLACEHOLDER_METHODS_KEY);
        }
        this.beforeTemplates = new ArrayList();
        this.afterTemplates = new ArrayList();
    }

    public static Collection<? extends CodeTransformer> extractRules(ClassTree tree, Context context) {
        Symbol.ClassSymbol sym = ASTHelpers.getSymbol(tree);
        RefasterRuleBuilderScanner scanner = new RefasterRuleBuilderScanner(context);
        ImmutableList<MethodTree> methods = new Ordering<MethodTree>(){

            @Override
            public int compare(MethodTree l, MethodTree r) {
                return Boolean.compare(l.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT), r.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT));
            }
        }.reverse().immutableSortedCopy(Iterables.filter(tree.getMembers(), MethodTree.class));
        scanner.visit(methods, null);
        UTemplater templater = new UTemplater(context);
        List<UType> types = templater.templateTypes(sym.type.getTypeArguments());
        return scanner.createMatchers(Iterables.filter(types, UTypeVar.class), sym.getQualifiedName().toString(), UTemplater.annotationMap(sym));
    }

    @Override
    public Void visitMethod(MethodTree tree, Void v) {
        try {
            VisitorState state = new VisitorState(this.context);
            logger.log(Level.FINE, "Discovered method with name {0}", tree.getName());
            if (ASTHelpers.hasAnnotation((Tree)tree, Placeholder.class, state)) {
                Preconditions.checkArgument(tree.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT), "@Placeholder methods are expected to be abstract");
                UTemplater templater = new UTemplater(this.context);
                ImmutableMap.Builder<UVariableDecl, ImmutableClassToInstanceMap<Annotation>> params = ImmutableMap.builder();
                for (VariableTree variableTree : tree.getParameters()) {
                    params.put(templater.visitVariable(variableTree, null), UTemplater.annotationMap(ASTHelpers.getSymbol(variableTree)));
                }
                Symbol.MethodSymbol sym = ASTHelpers.getSymbol(tree);
                this.placeholderMethods.put(sym, PlaceholderMethod.create(tree.getName(), templater.template(sym.getReturnType()), params.buildOrThrow(), UTemplater.annotationMap(sym)));
            } else if (ASTHelpers.hasAnnotation((Tree)tree, BeforeTemplate.class, state)) {
                Preconditions.checkState(this.afterTemplates.isEmpty(), "BeforeTemplate must come before AfterTemplate");
                Template<?> template = UTemplater.createTemplate(this.context, tree);
                this.beforeTemplates.add(template);
                if (template instanceof BlockTemplate) {
                    this.context.put(UTemplater.REQUIRE_BLOCK_KEY, Boolean.valueOf(true));
                }
            } else if (ASTHelpers.hasAnnotation((Tree)tree, AfterTemplate.class, state)) {
                this.afterTemplates.add(UTemplater.createTemplate(this.context, tree));
            } else if (tree.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT)) {
                throw new IllegalArgumentException("Placeholder methods must have @Placeholder, but abstract method does not: " + tree);
            }
            return null;
        }
        catch (RuntimeException t) {
            throw new RuntimeException("Error analysing: " + tree.getName(), t);
        }
    }

    private ImmutableList<? extends CodeTransformer> createMatchers(Iterable<UTypeVar> typeVars, String qualifiedTemplateClass, ImmutableClassToInstanceMap<Annotation> annotationMap) {
        if (this.beforeTemplates.isEmpty() && this.afterTemplates.isEmpty()) {
            return ImmutableList.of();
        }
        if (annotationMap.containsKey(AllowCodeBetweenLines.class)) {
            int i;
            ArrayList<UBlank> blanks = new ArrayList<UBlank>();
            for (i = 0; i < this.beforeTemplates.size(); ++i) {
                if (this.beforeTemplates.get(i) instanceof ExpressionTemplate) {
                    throw new IllegalArgumentException("@AllowCodeBetweenLines may not be specified for expression templates.");
                }
                BlockTemplate before = (BlockTemplate)this.beforeTemplates.get(i);
                ArrayList<UStatement> stmtsWithBlanks = new ArrayList<UStatement>();
                for (UStatement stmt : before.templateStatements()) {
                    if (!stmtsWithBlanks.isEmpty()) {
                        UBlank blank = UBlank.create();
                        blanks.add(blank);
                        stmtsWithBlanks.add(blank);
                    }
                    stmtsWithBlanks.add(stmt);
                }
                this.beforeTemplates.set(i, before.withStatements(stmtsWithBlanks));
            }
            for (i = 0; i < this.afterTemplates.size(); ++i) {
                BlockTemplate afterBlock = (BlockTemplate)this.afterTemplates.get(i);
                this.afterTemplates.set(i, afterBlock.withStatements(Iterables.concat(blanks, afterBlock.templateStatements())));
            }
        }
        RefasterRule<?, ?> rule = RefasterRule.create(qualifiedTemplateClass, typeVars, this.beforeTemplates, this.afterTemplates, annotationMap);
        ArrayList<ExpressionTemplate> negatedAfterTemplates = new ArrayList<ExpressionTemplate>();
        for (Template<?> afterTemplate : this.afterTemplates) {
            if (!afterTemplate.annotations().containsKey(AlsoNegation.class)) continue;
            negatedAfterTemplates.add(((ExpressionTemplate)afterTemplate).negation());
        }
        if (!negatedAfterTemplates.isEmpty()) {
            ArrayList<ExpressionTemplate> negatedBeforeTemplates = new ArrayList<ExpressionTemplate>();
            for (Template template : this.beforeTemplates) {
                negatedBeforeTemplates.add(((ExpressionTemplate)template).negation());
            }
            RefasterRule<?, ?> negation = RefasterRule.create(qualifiedTemplateClass, typeVars, negatedBeforeTemplates, negatedAfterTemplates, annotationMap);
            return ImmutableList.of(rule, negation);
        }
        return ImmutableList.of(rule);
    }
}

