/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.SuppressionInfo;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Suppressible;
import com.google.errorprone.refaster.RefasterRule;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.util.Set;

final class RefasterSuppressionHelper {
    static boolean suppressed(RefasterRule<?, ?> rule, Tree tree, Context context) {
        VisitorState state = VisitorState.createForUtilityPurposes(context);
        Symbol sym = ASTHelpers.getDeclaredSymbol(tree);
        if (sym == null) {
            return false;
        }
        return SuppressionInfo.EMPTY.withExtendedSuppressions(sym, state, ImmutableSet.of()).suppressedState(new RefasterSuppressible(rule), false, state).equals((Object)SuppressionInfo.SuppressedState.SUPPRESSED);
    }

    private RefasterSuppressionHelper() {
    }

    private static class RefasterSuppressible
    implements Suppressible {
        private final RefasterRule<?, ?> rule;

        RefasterSuppressible(RefasterRule<?, ?> rule) {
            this.rule = rule;
        }

        @Override
        public Set<String> allNames() {
            return ImmutableSet.of(this.canonicalName());
        }

        @Override
        public String canonicalName() {
            return this.rule.simpleTemplateName();
        }

        @Override
        public boolean supportsSuppressWarnings() {
            return true;
        }

        @Override
        public Set<Class<? extends Annotation>> customSuppressionAnnotations() {
            return ImmutableSet.of();
        }

        @Override
        public boolean suppressedByAnyOf(Set<Name> annotations, VisitorState s) {
            return false;
        }
    }
}

