/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.suppliers;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.VisitorState;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.Objects;

public final class Suppliers {
    public static final Supplier<Type> JAVA_LANG_VOID_TYPE = Suppliers.typeFromClass(Void.class);
    public static final Supplier<Type> VOID_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().voidType;
        }
    };
    public static final Supplier<Type> JAVA_LANG_BOOLEAN_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getTypeFromString("java.lang.Boolean");
        }
    };
    public static final Supplier<Type> JAVA_LANG_INTEGER_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getTypeFromString("java.lang.Integer");
        }
    };
    public static final Supplier<Type> JAVA_LANG_LONG_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getTypeFromString("java.lang.Long");
        }
    };
    public static final Supplier<Type> STRING_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().stringType;
        }
    };
    public static final Supplier<Type> BOOLEAN_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().booleanType;
        }
    };
    public static final Supplier<Type> BYTE_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().byteType;
        }
    };
    public static final Supplier<Type> INT_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().intType;
        }
    };
    public static final Supplier<Type> LONG_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().longType;
        }
    };
    public static final Supplier<Type> DOUBLE_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().doubleType;
        }
    };
    public static final Supplier<Type> CHAR_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().charType;
        }
    };
    public static final Supplier<Type> OBJECT_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().objectType;
        }
    };
    public static final Supplier<Type> EXCEPTION_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().exceptionType;
        }
    };
    public static final Supplier<Type> THROWABLE_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().throwableType;
        }
    };
    public static final Supplier<Type> ANNOTATION_TYPE = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return state.getSymtab().annotationType;
        }
    };
    public static final Supplier<Type> ENCLOSING_CLASS = new Supplier<Type>(){

        @Override
        public Type get(VisitorState state) {
            return ASTHelpers.getType((ClassTree)state.findEnclosing(ClassTree.class));
        }
    };

    public static Supplier<Type> genericTypeOf(final Supplier<ExpressionTree> expressionSupplier, final int n) {
        return new Supplier<Type>(){

            @Override
            public Type get(VisitorState state) {
                JCTree.JCExpression jcExpression = (JCTree.JCExpression)expressionSupplier.get(state);
                if (jcExpression.type.getTypeArguments().size() <= n) {
                    return state.getSymtab().objectType;
                }
                return jcExpression.type.getTypeArguments().get(n);
            }
        };
    }

    public static Supplier<Type> genericTypeOfType(final Supplier<Type> typeSupplier, final int n) {
        return new Supplier<Type>(){

            @Override
            public Type get(VisitorState state) {
                Type type = (Type)typeSupplier.get(state);
                if (type.getTypeArguments().size() <= n) {
                    return state.getSymtab().objectType;
                }
                return type.getTypeArguments().get(n);
            }
        };
    }

    public static Supplier<Type> receiverType() {
        return new Supplier<Type>(){

            @Override
            public Type get(VisitorState state) {
                MethodInvocationTree methodInvocation = (MethodInvocationTree)state.getPath().getLeaf();
                return ASTHelpers.getReceiverType(methodInvocation.getMethodSelect());
            }
        };
    }

    public static Supplier<ExpressionTree> receiverInstance() {
        return new Supplier<ExpressionTree>(){

            @Override
            public ExpressionTree get(VisitorState state) {
                MethodInvocationTree method = (MethodInvocationTree)state.getPath().getLeaf();
                return ((JCTree.JCFieldAccess)method.getMethodSelect()).getExpression();
            }
        };
    }

    public static Supplier<Type> typeFromString(String typeString) {
        Objects.requireNonNull(typeString);
        return VisitorState.memoize(state -> state.getTypeFromString(typeString));
    }

    public static Supplier<Type> typeFromClass(Class<?> inputClass) {
        return Suppliers.typeFromString(inputClass.getName());
    }

    public static <T> Supplier<T> identitySupplier(final T toSupply) {
        return new Supplier<T>(){

            @Override
            public T get(VisitorState state) {
                return toSupply;
            }
        };
    }

    public static Supplier<Type> arrayOf(final Supplier<Type> elementType) {
        return new Supplier<Type>(){

            @Override
            public Type get(VisitorState state) {
                return new Type.ArrayType((Type)elementType.get(state), state.getSymtab().arraysType.tsym);
            }
        };
    }

    public static ImmutableList<Supplier<Type>> fromStrings(Iterable<String> types) {
        return ImmutableList.copyOf(Iterables.transform(types, new Function<String, Supplier<Type>>(){

            @Override
            public Supplier<Type> apply(String input) {
                return Suppliers.typeFromString(input);
            }
        }));
    }

    private Suppliers() {
    }
}

