/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2021, The Linux Foundation. All rights reserved.
 * Copyright (c) 2022-2023, Qualcomm Innovation Center, Inc. All rights reserved.
 */

#ifndef _GEN7_REG_H
#define _GEN7_REG_H

/* GEN7 interrupt bits */
#define GEN7_INT_GPUIDLE                0
#define GEN7_INT_AHBERROR               1
#define GEN7_INT_CPIPCINT0              4
#define GEN7_INT_CPIPCINT1              5
#define GEN7_INT_ATBASYNCFIFOOVERFLOW   6
#define GEN7_INT_GPCERROR               7
#define GEN7_INT_SWINTERRUPT            8
#define GEN7_INT_HWERROR                9
#define GEN7_INT_CCU_CLEAN_DEPTH_TS     10
#define GEN7_INT_CCU_CLEAN_COLOR_TS     11
#define GEN7_INT_CCU_RESOLVE_CLEAN_TS   12
#define GEN7_INT_PM4CPINTERRUPT         15
#define GEN7_INT_PM4CPINTERRUPTLPAC     16
#define GEN7_INT_RB_DONE_TS             17
#define GEN7_INT_CACHE_CLEAN_TS         20
#define GEN7_INT_CACHE_CLEAN_TS_LPAC    21
#define GEN7_INT_ATBBUSOVERFLOW         22
#define GEN7_INT_HANGDETECTINTERRUPT    23
#define GEN7_INT_OUTOFBOUNDACCESS       24
#define GEN7_INT_UCHETRAPINTERRUPT      25
#define GEN7_INT_DEBUGBUSINTERRUPT0     26
#define GEN7_INT_DEBUGBUSINTERRUPT1     27
#define GEN7_INT_TSBWRITEERROR          28
#define GEN7_INT_ISDBCPUIRQ             30
#define GEN7_INT_ISDBUNDERDEBUG         31

/* CP registers */
#define GEN7_CP_RB_BASE                  0x800
#define GEN7_CP_RB_BASE_HI               0x801
#define GEN7_CP_RB_CNTL                  0x802
#define GEN7_CP_RB_RPTR_ADDR_LO          0x804
#define GEN7_CP_RB_RPTR_ADDR_HI          0x805
#define GEN7_CP_RB_RPTR                  0x806
#define GEN7_CP_RB_WPTR                  0x807
#define GEN7_CP_SQE_CNTL                 0x808
#define GEN7_CP_CP2GMU_STATUS            0x812
#define GEN7_CP_HW_FAULT                 0x821
#define GEN7_CP_INTERRUPT_STATUS         0x823
#define GEN7_CP_PROTECT_STATUS           0x824
#define GEN7_CP_STATUS_1                 0x825
#define GEN7_CP_SQE_INSTR_BASE_LO        0x830
#define GEN7_CP_SQE_INSTR_BASE_HI        0x831
#define GEN7_CP_MISC_CNTL                0x840
#define GEN7_CP_CHICKEN_DBG              0x841
#define GEN7_CP_DBG_ECO_CNTL             0x843
#define GEN7_CP_APRIV_CNTL               0x844
#define GEN7_CP_PROTECT_CNTL             0x84f
#define GEN7_CP_PROTECT_REG              0x850
#define GEN7_CP_CONTEXT_SWITCH_CNTL      0x8a0
#define GEN7_CP_CONTEXT_SWITCH_SMMU_INFO_LO 0x8a1
#define GEN7_CP_CONTEXT_SWITCH_SMMU_INFO_HI 0x8a2
#define GEN7_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR_LO 0x8a3
#define GEN7_CP_CONTEXT_SWITCH_PRIV_NON_SECURE_RESTORE_ADDR_HI 0x8a4
#define GEN7_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR_LO     0x8a5
#define GEN7_CP_CONTEXT_SWITCH_PRIV_SECURE_RESTORE_ADDR_HI     0x8a6
#define GEN7_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR_LO        0x8a7
#define GEN7_CP_CONTEXT_SWITCH_NON_PRIV_RESTORE_ADDR_HI        0x8a8
#define GEN7_CP_CONTEXT_SWITCH_LEVEL_STATUS                    0x8ab
#define GEN7_CP_PERFCTR_CP_SEL_0         0x8d0
#define GEN7_CP_PERFCTR_CP_SEL_1         0x8d1
#define GEN7_CP_PERFCTR_CP_SEL_2         0x8d2
#define GEN7_CP_PERFCTR_CP_SEL_3         0x8d3
#define GEN7_CP_PERFCTR_CP_SEL_4         0x8d4
#define GEN7_CP_PERFCTR_CP_SEL_5         0x8d5
#define GEN7_CP_PERFCTR_CP_SEL_6         0x8d6
#define GEN7_CP_PERFCTR_CP_SEL_7         0x8d7
#define GEN7_CP_PERFCTR_CP_SEL_8         0x8d8
#define GEN7_CP_PERFCTR_CP_SEL_9         0x8d9
#define GEN7_CP_PERFCTR_CP_SEL_10        0x8da
#define GEN7_CP_PERFCTR_CP_SEL_11        0x8db
#define GEN7_CP_PERFCTR_CP_SEL_12        0x8dc
#define GEN7_CP_PERFCTR_CP_SEL_13        0x8dd
#define GEN7_CP_BV_PERFCTR_CP_SEL_0      0x8e0
#define GEN7_CP_BV_PERFCTR_CP_SEL_1      0x8e1
#define GEN7_CP_BV_PERFCTR_CP_SEL_2      0x8e2
#define GEN7_CP_BV_PERFCTR_CP_SEL_3      0x8e3
#define GEN7_CP_BV_PERFCTR_CP_SEL_4      0x8e4
#define GEN7_CP_BV_PERFCTR_CP_SEL_5      0x8e5
#define GEN7_CP_BV_PERFCTR_CP_SEL_6      0x8e6
#define GEN7_CP_CRASH_SCRIPT_BASE_LO     0x900
#define GEN7_CP_CRASH_SCRIPT_BASE_HI     0x901
#define GEN7_CP_CRASH_DUMP_CNTL          0x902
#define GEN7_CP_CRASH_DUMP_STATUS        0x903
#define GEN7_CP_SQE_STAT_ADDR            0x908
#define GEN7_CP_SQE_STAT_DATA            0x909
#define GEN7_CP_DRAW_STATE_ADDR          0x90a
#define GEN7_CP_DRAW_STATE_DATA          0x90b
#define GEN7_CP_ROQ_DBG_ADDR             0x90c
#define GEN7_CP_ROQ_DBG_DATA             0x90d
#define GEN7_CP_MEM_POOL_DBG_ADDR        0x90e
#define GEN7_CP_MEM_POOL_DBG_DATA        0x90f
#define GEN7_CP_SQE_UCODE_DBG_ADDR       0x910
#define GEN7_CP_SQE_UCODE_DBG_DATA       0x911
#define GEN7_CP_IB1_BASE                 0x928
#define GEN7_CP_IB1_BASE_HI              0x929
#define GEN7_CP_IB1_REM_SIZE             0x92a
#define GEN7_CP_IB2_BASE                 0x92b
#define GEN7_CP_IB2_BASE_HI              0x92c
#define GEN7_CP_IB2_REM_SIZE             0x92d
#define GEN7_CP_ALWAYS_ON_COUNTER_LO     0x980
#define GEN7_CP_ALWAYS_ON_COUNTER_HI     0x981
#define GEN7_CP_ALWAYS_ON_CONTEXT_LO     0x982
#define GEN7_CP_ALWAYS_ON_CONTEXT_HI     0x983
#define GEN7_CP_AHB_CNTL                 0x98d
#define GEN7_CP_RL_ERROR_DETAILS_0       0x9b4
#define GEN7_CP_RL_ERROR_DETAILS_1       0x9cf
#define GEN7_CP_APERTURE_CNTL_HOST       0xa00
#define GEN7_CP_APERTURE_CNTL_CD         0xa03
#define GEN7_CP_BV_PROTECT_STATUS        0xa61
#define GEN7_CP_BV_HW_FAULT              0xa64
#define GEN7_CP_BV_DRAW_STATE_ADDR       0xa81
#define GEN7_CP_BV_DRAW_STATE_DATA       0xa82
#define GEN7_CP_BV_ROQ_DBG_ADDR          0xa83
#define GEN7_CP_BV_ROQ_DBG_DATA          0xa84
#define GEN7_CP_BV_SQE_UCODE_DBG_ADDR    0xa85
#define GEN7_CP_BV_SQE_UCODE_DBG_DATA    0xa86
#define GEN7_CP_BV_SQE_STAT_ADDR         0xa87
#define GEN7_CP_BV_SQE_STAT_DATA         0xa88
#define GEN7_CP_BV_RB_RPTR_ADDR_LO       0xa98
#define GEN7_CP_BV_RB_RPTR_ADDR_HI       0xa99
#define GEN7_CP_RESOURCE_TBL_DBG_ADDR    0xa9a
#define GEN7_CP_RESOURCE_TBL_DBG_DATA    0xa9b
#define GEN7_CP_BV_MEM_POOL_DBG_ADDR     0xa96
#define GEN7_CP_BV_MEM_POOL_DBG_DATA     0xa97
#define GEN7_CP_BV_APRIV_CNTL            0xad0
#define GEN7_CP_BV_CHICKEN_DBG           0xada

/* LPAC registers */
#define GEN7_CP_LPAC_RB_BASE             0xb00
#define GEN7_CP_LPAC_RB_BASE_HI          0xb01
#define GEN7_CP_LPAC_RB_RPTR             0xb06
#define GEN7_CP_LPAC_RB_WPTR             0xb07
#define GEN7_CP_LPAC_PROTECT_CNTL        0xb09
#define GEN7_CP_LPAC_DRAW_STATE_ADDR     0xb0a
#define GEN7_CP_LPAC_DRAW_STATE_DATA     0xb0b
#define GEN7_CP_LPAC_ROQ_DBG_ADDR        0xb0c
#define GEN7_CP_LPAC_IB1_BASE            0xb0d
#define GEN7_CP_LPAC_IB1_BASE_HI         0xb0e
#define GEN7_CP_LPAC_IB1_REM_SIZE        0xb0f
#define GEN7_CP_LPAC_IB2_BASE            0xb10
#define GEN7_CP_LPAC_IB2_BASE_HI         0xb11
#define GEN7_CP_LPAC_IB2_REM_SIZE        0xb12
#define GEN7_CP_SQE_AC_UCODE_DBG_ADDR    0xb27
#define GEN7_CP_SQE_AC_UCODE_DBG_DATA    0xb28
#define GEN7_CP_SQE_AC_STAT_ADDR         0xb29
#define GEN7_CP_SQE_AC_STAT_DATA         0xb2a
#define GEN7_CP_LPAC_CHICKEN_DBG         0xb30
#define GEN7_CP_LPAC_APRIV_CNTL          0xb31
#define GEN7_CP_LPAC_ROQ_DBG_DATA        0xb35
#define GEN7_CP_LPAC_FIFO_DBG_DATA       0xb36
#define GEN7_CP_LPAC_FIFO_DBG_ADDR       0xb40
#define GEN7_LPAC_RBBM_STATUS            0x5fe

/* RBBM registers */
#define GEN7_RBBM_INT_0_STATUS                   0x201
#define GEN7_RBBM_STATUS                         0x210
#define GEN7_RBBM_STATUS3                        0x213
#define GEN7_RBBM_PERFCTR_CP_0_LO                0x300
#define GEN7_RBBM_PERFCTR_CP_0_HI                0x301
#define GEN7_RBBM_PERFCTR_CP_1_LO                0x302
#define GEN7_RBBM_PERFCTR_CP_1_HI                0x303
#define GEN7_RBBM_PERFCTR_CP_2_LO                0x304
#define GEN7_RBBM_PERFCTR_CP_2_HI                0x305
#define GEN7_RBBM_PERFCTR_CP_3_LO                0x306
#define GEN7_RBBM_PERFCTR_CP_3_HI                0x307
#define GEN7_RBBM_PERFCTR_CP_4_LO                0x308
#define GEN7_RBBM_PERFCTR_CP_4_HI                0x309
#define GEN7_RBBM_PERFCTR_CP_5_LO                0x30a
#define GEN7_RBBM_PERFCTR_CP_5_HI                0x30b
#define GEN7_RBBM_PERFCTR_CP_6_LO                0x30c
#define GEN7_RBBM_PERFCTR_CP_6_HI                0x30d
#define GEN7_RBBM_PERFCTR_CP_7_LO                0x30e
#define GEN7_RBBM_PERFCTR_CP_7_HI                0x30f
#define GEN7_RBBM_PERFCTR_CP_8_LO                0x310
#define GEN7_RBBM_PERFCTR_CP_8_HI                0x311
#define GEN7_RBBM_PERFCTR_CP_9_LO                0x312
#define GEN7_RBBM_PERFCTR_CP_9_HI                0x313
#define GEN7_RBBM_PERFCTR_CP_10_LO               0x314
#define GEN7_RBBM_PERFCTR_CP_10_HI               0x315
#define GEN7_RBBM_PERFCTR_CP_11_LO               0x316
#define GEN7_RBBM_PERFCTR_CP_11_HI               0x317
#define GEN7_RBBM_PERFCTR_CP_12_LO               0x318
#define GEN7_RBBM_PERFCTR_CP_12_HI               0x319
#define GEN7_RBBM_PERFCTR_CP_13_LO               0x31a
#define GEN7_RBBM_PERFCTR_CP_13_HI               0x31b
#define GEN7_RBBM_PERFCTR_RBBM_0_LO              0x31c
#define GEN7_RBBM_PERFCTR_RBBM_0_HI              0x31d
#define GEN7_RBBM_PERFCTR_RBBM_1_LO              0x31e
#define GEN7_RBBM_PERFCTR_RBBM_1_HI              0x31f
#define GEN7_RBBM_PERFCTR_RBBM_2_LO              0x320
#define GEN7_RBBM_PERFCTR_RBBM_2_HI              0x321
#define GEN7_RBBM_PERFCTR_RBBM_3_LO              0x322
#define GEN7_RBBM_PERFCTR_RBBM_3_HI              0x323
#define GEN7_RBBM_PERFCTR_PC_0_LO                0x324
#define GEN7_RBBM_PERFCTR_PC_0_HI                0x325
#define GEN7_RBBM_PERFCTR_PC_1_LO                0x326
#define GEN7_RBBM_PERFCTR_PC_1_HI                0x327
#define GEN7_RBBM_PERFCTR_PC_2_LO                0x328
#define GEN7_RBBM_PERFCTR_PC_2_HI                0x329
#define GEN7_RBBM_PERFCTR_PC_3_LO                0x32a
#define GEN7_RBBM_PERFCTR_PC_3_HI                0x32b
#define GEN7_RBBM_PERFCTR_PC_4_LO                0x32c
#define GEN7_RBBM_PERFCTR_PC_4_HI                0x32d
#define GEN7_RBBM_PERFCTR_PC_5_LO                0x32e
#define GEN7_RBBM_PERFCTR_PC_5_HI                0x32f
#define GEN7_RBBM_PERFCTR_PC_6_LO                0x330
#define GEN7_RBBM_PERFCTR_PC_6_HI                0x331
#define GEN7_RBBM_PERFCTR_PC_7_LO                0x332
#define GEN7_RBBM_PERFCTR_PC_7_HI                0x333
#define GEN7_RBBM_PERFCTR_VFD_0_LO               0x334
#define GEN7_RBBM_PERFCTR_VFD_0_HI               0x335
#define GEN7_RBBM_PERFCTR_VFD_1_LO               0x336
#define GEN7_RBBM_PERFCTR_VFD_1_HI               0x337
#define GEN7_RBBM_PERFCTR_VFD_2_LO               0x338
#define GEN7_RBBM_PERFCTR_VFD_2_HI               0x339
#define GEN7_RBBM_PERFCTR_VFD_3_LO               0x33a
#define GEN7_RBBM_PERFCTR_VFD_3_HI               0x33b
#define GEN7_RBBM_PERFCTR_VFD_4_LO               0x33c
#define GEN7_RBBM_PERFCTR_VFD_4_HI               0x33d
#define GEN7_RBBM_PERFCTR_VFD_5_LO               0x33e
#define GEN7_RBBM_PERFCTR_VFD_5_HI               0x33f
#define GEN7_RBBM_PERFCTR_VFD_6_LO               0x340
#define GEN7_RBBM_PERFCTR_VFD_6_HI               0x341
#define GEN7_RBBM_PERFCTR_VFD_7_LO               0x342
#define GEN7_RBBM_PERFCTR_VFD_7_HI               0x343
#define GEN7_RBBM_PERFCTR_HLSQ_0_LO              0x344
#define GEN7_RBBM_PERFCTR_HLSQ_0_HI              0x345
#define GEN7_RBBM_PERFCTR_HLSQ_1_LO              0x346
#define GEN7_RBBM_PERFCTR_HLSQ_1_HI              0x347
#define GEN7_RBBM_PERFCTR_HLSQ_2_LO              0x348
#define GEN7_RBBM_PERFCTR_HLSQ_2_HI              0x349
#define GEN7_RBBM_PERFCTR_HLSQ_3_LO              0x34a
#define GEN7_RBBM_PERFCTR_HLSQ_3_HI              0x34b
#define GEN7_RBBM_PERFCTR_HLSQ_4_LO              0x34c
#define GEN7_RBBM_PERFCTR_HLSQ_4_HI              0x34d
#define GEN7_RBBM_PERFCTR_HLSQ_5_LO              0x34e
#define GEN7_RBBM_PERFCTR_HLSQ_5_HI              0x34f
#define GEN7_RBBM_PERFCTR_VPC_0_LO               0x350
#define GEN7_RBBM_PERFCTR_VPC_0_HI               0x351
#define GEN7_RBBM_PERFCTR_VPC_1_LO               0x352
#define GEN7_RBBM_PERFCTR_VPC_1_HI               0x353
#define GEN7_RBBM_PERFCTR_VPC_2_LO               0x354
#define GEN7_RBBM_PERFCTR_VPC_2_HI               0x355
#define GEN7_RBBM_PERFCTR_VPC_3_LO               0x356
#define GEN7_RBBM_PERFCTR_VPC_3_HI               0x357
#define GEN7_RBBM_PERFCTR_VPC_4_LO               0x358
#define GEN7_RBBM_PERFCTR_VPC_4_HI               0x359
#define GEN7_RBBM_PERFCTR_VPC_5_LO               0x35a
#define GEN7_RBBM_PERFCTR_VPC_5_HI               0x35b
#define GEN7_RBBM_PERFCTR_CCU_0_LO               0x35c
#define GEN7_RBBM_PERFCTR_CCU_0_HI               0x35d
#define GEN7_RBBM_PERFCTR_CCU_1_LO               0x35e
#define GEN7_RBBM_PERFCTR_CCU_1_HI               0x35f
#define GEN7_RBBM_PERFCTR_CCU_2_LO               0x360
#define GEN7_RBBM_PERFCTR_CCU_2_HI               0x361
#define GEN7_RBBM_PERFCTR_CCU_3_LO               0x362
#define GEN7_RBBM_PERFCTR_CCU_3_HI               0x363
#define GEN7_RBBM_PERFCTR_CCU_4_LO               0x364
#define GEN7_RBBM_PERFCTR_CCU_4_HI               0x365
#define GEN7_RBBM_PERFCTR_TSE_0_LO               0x366
#define GEN7_RBBM_PERFCTR_TSE_0_HI               0x367
#define GEN7_RBBM_PERFCTR_TSE_1_LO               0x368
#define GEN7_RBBM_PERFCTR_TSE_1_HI               0x369
#define GEN7_RBBM_PERFCTR_TSE_2_LO               0x36a
#define GEN7_RBBM_PERFCTR_TSE_2_HI               0x36b
#define GEN7_RBBM_PERFCTR_TSE_3_LO               0x36c
#define GEN7_RBBM_PERFCTR_TSE_3_HI               0x36d
#define GEN7_RBBM_PERFCTR_RAS_0_LO               0x36e
#define GEN7_RBBM_PERFCTR_RAS_0_HI               0x36f
#define GEN7_RBBM_PERFCTR_RAS_1_LO               0x370
#define GEN7_RBBM_PERFCTR_RAS_1_HI               0x371
#define GEN7_RBBM_PERFCTR_RAS_2_LO               0x372
#define GEN7_RBBM_PERFCTR_RAS_2_HI               0x373
#define GEN7_RBBM_PERFCTR_RAS_3_LO               0x374
#define GEN7_RBBM_PERFCTR_RAS_3_HI               0x375
#define GEN7_RBBM_PERFCTR_UCHE_0_LO              0x376
#define GEN7_RBBM_PERFCTR_UCHE_0_HI              0x377
#define GEN7_RBBM_PERFCTR_UCHE_1_LO              0x378
#define GEN7_RBBM_PERFCTR_UCHE_1_HI              0x379
#define GEN7_RBBM_PERFCTR_UCHE_2_LO              0x37a
#define GEN7_RBBM_PERFCTR_UCHE_2_HI              0x37b
#define GEN7_RBBM_PERFCTR_UCHE_3_LO              0x37c
#define GEN7_RBBM_PERFCTR_UCHE_3_HI              0x37d
#define GEN7_RBBM_PERFCTR_UCHE_4_LO              0x37e
#define GEN7_RBBM_PERFCTR_UCHE_4_HI              0x37f
#define GEN7_RBBM_PERFCTR_UCHE_5_LO              0x380
#define GEN7_RBBM_PERFCTR_UCHE_5_HI              0x381
#define GEN7_RBBM_PERFCTR_UCHE_6_LO              0x382
#define GEN7_RBBM_PERFCTR_UCHE_6_HI              0x383
#define GEN7_RBBM_PERFCTR_UCHE_7_LO              0x384
#define GEN7_RBBM_PERFCTR_UCHE_7_HI              0x385
#define GEN7_RBBM_PERFCTR_UCHE_8_LO              0x386
#define GEN7_RBBM_PERFCTR_UCHE_8_HI              0x387
#define GEN7_RBBM_PERFCTR_UCHE_9_LO              0x388
#define GEN7_RBBM_PERFCTR_UCHE_9_HI              0x389
#define GEN7_RBBM_PERFCTR_UCHE_10_LO             0x38a
#define GEN7_RBBM_PERFCTR_UCHE_10_HI             0x38b
#define GEN7_RBBM_PERFCTR_UCHE_11_LO             0x38c
#define GEN7_RBBM_PERFCTR_UCHE_11_HI             0x38d
#define GEN7_RBBM_PERFCTR_TP_0_LO                0x38e
#define GEN7_RBBM_PERFCTR_TP_0_HI                0x38f
#define GEN7_RBBM_PERFCTR_TP_1_LO                0x390
#define GEN7_RBBM_PERFCTR_TP_1_HI                0x391
#define GEN7_RBBM_PERFCTR_TP_2_LO                0x392
#define GEN7_RBBM_PERFCTR_TP_2_HI                0x393
#define GEN7_RBBM_PERFCTR_TP_3_LO                0x394
#define GEN7_RBBM_PERFCTR_TP_3_HI                0x395
#define GEN7_RBBM_PERFCTR_TP_4_LO                0x396
#define GEN7_RBBM_PERFCTR_TP_4_HI                0x397
#define GEN7_RBBM_PERFCTR_TP_5_LO                0x398
#define GEN7_RBBM_PERFCTR_TP_5_HI                0x399
#define GEN7_RBBM_PERFCTR_TP_6_LO                0x39a
#define GEN7_RBBM_PERFCTR_TP_6_HI                0x39b
#define GEN7_RBBM_PERFCTR_TP_7_LO                0x39c
#define GEN7_RBBM_PERFCTR_TP_7_HI                0x39d
#define GEN7_RBBM_PERFCTR_TP_8_LO                0x39e
#define GEN7_RBBM_PERFCTR_TP_8_HI                0x39f
#define GEN7_RBBM_PERFCTR_TP_9_LO                0x3a0
#define GEN7_RBBM_PERFCTR_TP_9_HI                0x3a1
#define GEN7_RBBM_PERFCTR_TP_10_LO               0x3a2
#define GEN7_RBBM_PERFCTR_TP_10_HI               0x3a3
#define GEN7_RBBM_PERFCTR_TP_11_LO               0x3a4
#define GEN7_RBBM_PERFCTR_TP_11_HI               0x3a5
#define GEN7_RBBM_PERFCTR_SP_0_LO                0x3a6
#define GEN7_RBBM_PERFCTR_SP_0_HI                0x3a7
#define GEN7_RBBM_PERFCTR_SP_1_LO                0x3a8
#define GEN7_RBBM_PERFCTR_SP_1_HI                0x3a9
#define GEN7_RBBM_PERFCTR_SP_2_LO                0x3aa
#define GEN7_RBBM_PERFCTR_SP_2_HI                0x3ab
#define GEN7_RBBM_PERFCTR_SP_3_LO                0x3ac
#define GEN7_RBBM_PERFCTR_SP_3_HI                0x3ad
#define GEN7_RBBM_PERFCTR_SP_4_LO                0x3ae
#define GEN7_RBBM_PERFCTR_SP_4_HI                0x3af
#define GEN7_RBBM_PERFCTR_SP_5_LO                0x3b0
#define GEN7_RBBM_PERFCTR_SP_5_HI                0x3b1
#define GEN7_RBBM_PERFCTR_SP_6_LO                0x3b2
#define GEN7_RBBM_PERFCTR_SP_6_HI                0x3b3
#define GEN7_RBBM_PERFCTR_SP_7_LO                0x3b4
#define GEN7_RBBM_PERFCTR_SP_7_HI                0x3b5
#define GEN7_RBBM_PERFCTR_SP_8_LO                0x3b6
#define GEN7_RBBM_PERFCTR_SP_8_HI                0x3b7
#define GEN7_RBBM_PERFCTR_SP_9_LO                0x3b8
#define GEN7_RBBM_PERFCTR_SP_9_HI                0x3b9
#define GEN7_RBBM_PERFCTR_SP_10_LO               0x3ba
#define GEN7_RBBM_PERFCTR_SP_10_HI               0x3bb
#define GEN7_RBBM_PERFCTR_SP_11_LO               0x3bc
#define GEN7_RBBM_PERFCTR_SP_11_HI               0x3bd
#define GEN7_RBBM_PERFCTR_SP_12_LO               0x3be
#define GEN7_RBBM_PERFCTR_SP_12_HI               0x3bf
#define GEN7_RBBM_PERFCTR_SP_13_LO               0x3c0
#define GEN7_RBBM_PERFCTR_SP_13_HI               0x3c1
#define GEN7_RBBM_PERFCTR_SP_14_LO               0x3c2
#define GEN7_RBBM_PERFCTR_SP_14_HI               0x3c3
#define GEN7_RBBM_PERFCTR_SP_15_LO               0x3c4
#define GEN7_RBBM_PERFCTR_SP_15_HI               0x3c5
#define GEN7_RBBM_PERFCTR_SP_16_LO               0x3c6
#define GEN7_RBBM_PERFCTR_SP_16_HI               0x3c7
#define GEN7_RBBM_PERFCTR_SP_17_LO               0x3c8
#define GEN7_RBBM_PERFCTR_SP_17_HI               0x3c9
#define GEN7_RBBM_PERFCTR_SP_18_LO               0x3ca
#define GEN7_RBBM_PERFCTR_SP_18_HI               0x3cb
#define GEN7_RBBM_PERFCTR_SP_19_LO               0x3cc
#define GEN7_RBBM_PERFCTR_SP_19_HI               0x3cd
#define GEN7_RBBM_PERFCTR_SP_20_LO               0x3ce
#define GEN7_RBBM_PERFCTR_SP_20_HI               0x3cf
#define GEN7_RBBM_PERFCTR_SP_21_LO               0x3d0
#define GEN7_RBBM_PERFCTR_SP_21_HI               0x3d1
#define GEN7_RBBM_PERFCTR_SP_22_LO               0x3d2
#define GEN7_RBBM_PERFCTR_SP_22_HI               0x3d3
#define GEN7_RBBM_PERFCTR_SP_23_LO               0x3d4
#define GEN7_RBBM_PERFCTR_SP_23_HI               0x3d5
#define GEN7_RBBM_PERFCTR_RB_0_LO                0x3d6
#define GEN7_RBBM_PERFCTR_RB_0_HI                0x3d7
#define GEN7_RBBM_PERFCTR_RB_1_LO                0x3d8
#define GEN7_RBBM_PERFCTR_RB_1_HI                0x3d9
#define GEN7_RBBM_PERFCTR_RB_2_LO                0x3da
#define GEN7_RBBM_PERFCTR_RB_2_HI                0x3db
#define GEN7_RBBM_PERFCTR_RB_3_LO                0x3dc
#define GEN7_RBBM_PERFCTR_RB_3_HI                0x3dd
#define GEN7_RBBM_PERFCTR_RB_4_LO                0x3de
#define GEN7_RBBM_PERFCTR_RB_4_HI                0x3df
#define GEN7_RBBM_PERFCTR_RB_5_LO                0x3e0
#define GEN7_RBBM_PERFCTR_RB_5_HI                0x3e1
#define GEN7_RBBM_PERFCTR_RB_6_LO                0x3e2
#define GEN7_RBBM_PERFCTR_RB_6_HI                0x3e3
#define GEN7_RBBM_PERFCTR_RB_7_LO                0x3e4
#define GEN7_RBBM_PERFCTR_RB_7_HI                0x3e5
#define GEN7_RBBM_PERFCTR_VSC_0_LO               0x3e6
#define GEN7_RBBM_PERFCTR_VSC_0_HI               0x3e7
#define GEN7_RBBM_PERFCTR_VSC_1_LO               0x3e8
#define GEN7_RBBM_PERFCTR_VSC_1_HI               0x3e9
#define GEN7_RBBM_PERFCTR_LRZ_0_LO               0x3ea
#define GEN7_RBBM_PERFCTR_LRZ_0_HI               0x3eb
#define GEN7_RBBM_PERFCTR_LRZ_1_LO               0x3ec
#define GEN7_RBBM_PERFCTR_LRZ_1_HI               0x3ed
#define GEN7_RBBM_PERFCTR_LRZ_2_LO               0x3ee
#define GEN7_RBBM_PERFCTR_LRZ_2_HI               0x3ef
#define GEN7_RBBM_PERFCTR_LRZ_3_LO               0x3f0
#define GEN7_RBBM_PERFCTR_LRZ_3_HI               0x3f1
#define GEN7_RBBM_PERFCTR_CMP_0_LO               0x3f2
#define GEN7_RBBM_PERFCTR_CMP_0_HI               0x3f3
#define GEN7_RBBM_PERFCTR_CMP_1_LO               0x3f4
#define GEN7_RBBM_PERFCTR_CMP_1_HI               0x3f5
#define GEN7_RBBM_PERFCTR_CMP_2_LO               0x3f6
#define GEN7_RBBM_PERFCTR_CMP_2_HI               0x3f7
#define GEN7_RBBM_PERFCTR_CMP_3_LO               0x3f8
#define GEN7_RBBM_PERFCTR_CMP_3_HI               0x3f9
#define GEN7_RBBM_PERFCTR_UFC_0_LO               0x3fa
#define GEN7_RBBM_PERFCTR_UFC_0_HI               0x3fb
#define GEN7_RBBM_PERFCTR_UFC_1_LO               0x3fc
#define GEN7_RBBM_PERFCTR_UFC_1_HI               0x3fd
#define GEN7_RBBM_PERFCTR_UFC_2_LO               0x3fe
#define GEN7_RBBM_PERFCTR_UFC_2_HI               0x3ff
#define GEN7_RBBM_PERFCTR_UFC_3_LO               0x400
#define GEN7_RBBM_PERFCTR_UFC_3_HI               0x401
#define GEN7_RBBM_PERFCTR2_HLSQ_0_LO             0x410
#define GEN7_RBBM_PERFCTR2_HLSQ_0_HI             0x411
#define GEN7_RBBM_PERFCTR2_HLSQ_1_LO             0x412
#define GEN7_RBBM_PERFCTR2_HLSQ_1_HI             0x413
#define GEN7_RBBM_PERFCTR2_HLSQ_2_LO             0x414
#define GEN7_RBBM_PERFCTR2_HLSQ_2_HI             0x415
#define GEN7_RBBM_PERFCTR2_HLSQ_3_LO             0x416
#define GEN7_RBBM_PERFCTR2_HLSQ_3_HI             0x417
#define GEN7_RBBM_PERFCTR2_HLSQ_4_LO             0x418
#define GEN7_RBBM_PERFCTR2_HLSQ_4_HI             0x419
#define GEN7_RBBM_PERFCTR2_HLSQ_5_LO             0x41a
#define GEN7_RBBM_PERFCTR2_HLSQ_5_HI             0x41b
#define GEN7_RBBM_PERFCTR2_CP_0_LO               0x41c
#define GEN7_RBBM_PERFCTR2_CP_0_HI               0x41d
#define GEN7_RBBM_PERFCTR2_CP_1_LO               0x41e
#define GEN7_RBBM_PERFCTR2_CP_1_HI               0x41f
#define GEN7_RBBM_PERFCTR2_CP_2_LO               0x420
#define GEN7_RBBM_PERFCTR2_CP_2_HI               0x421
#define GEN7_RBBM_PERFCTR2_CP_3_LO               0x422
#define GEN7_RBBM_PERFCTR2_CP_3_HI               0x423
#define GEN7_RBBM_PERFCTR2_CP_4_LO               0x424
#define GEN7_RBBM_PERFCTR2_CP_4_HI               0x425
#define GEN7_RBBM_PERFCTR2_CP_5_LO               0x426
#define GEN7_RBBM_PERFCTR2_CP_5_HI               0x427
#define GEN7_RBBM_PERFCTR2_CP_6_LO               0x428
#define GEN7_RBBM_PERFCTR2_CP_6_HI               0x429
#define GEN7_RBBM_PERFCTR2_SP_0_LO               0x42a
#define GEN7_RBBM_PERFCTR2_SP_0_HI               0x42b
#define GEN7_RBBM_PERFCTR2_SP_1_LO               0x42c
#define GEN7_RBBM_PERFCTR2_SP_1_HI               0x42d
#define GEN7_RBBM_PERFCTR2_SP_2_LO               0x42e
#define GEN7_RBBM_PERFCTR2_SP_2_HI               0x42f
#define GEN7_RBBM_PERFCTR2_SP_3_LO               0x430
#define GEN7_RBBM_PERFCTR2_SP_3_HI               0x431
#define GEN7_RBBM_PERFCTR2_SP_4_LO               0x432
#define GEN7_RBBM_PERFCTR2_SP_4_HI               0x433
#define GEN7_RBBM_PERFCTR2_SP_5_LO               0x434
#define GEN7_RBBM_PERFCTR2_SP_5_HI               0x435
#define GEN7_RBBM_PERFCTR2_SP_6_LO               0x436
#define GEN7_RBBM_PERFCTR2_SP_6_HI               0x437
#define GEN7_RBBM_PERFCTR2_SP_7_LO               0x438
#define GEN7_RBBM_PERFCTR2_SP_7_HI               0x439
#define GEN7_RBBM_PERFCTR2_SP_8_LO               0x43a
#define GEN7_RBBM_PERFCTR2_SP_8_HI               0x43b
#define GEN7_RBBM_PERFCTR2_SP_9_LO               0x43c
#define GEN7_RBBM_PERFCTR2_SP_9_HI               0x43d
#define GEN7_RBBM_PERFCTR2_SP_10_LO              0x43e
#define GEN7_RBBM_PERFCTR2_SP_10_HI              0x43f
#define GEN7_RBBM_PERFCTR2_SP_11_LO              0x440
#define GEN7_RBBM_PERFCTR2_SP_11_HI              0x441
#define GEN7_RBBM_PERFCTR2_TP_0_LO               0x442
#define GEN7_RBBM_PERFCTR2_TP_0_HI               0x443
#define GEN7_RBBM_PERFCTR2_TP_1_LO               0x444
#define GEN7_RBBM_PERFCTR2_TP_1_HI               0x445
#define GEN7_RBBM_PERFCTR2_TP_2_LO               0x446
#define GEN7_RBBM_PERFCTR2_TP_2_HI               0x447
#define GEN7_RBBM_PERFCTR2_TP_3_LO               0x448
#define GEN7_RBBM_PERFCTR2_TP_3_HI               0x449
#define GEN7_RBBM_PERFCTR2_TP_4_LO               0x44a
#define GEN7_RBBM_PERFCTR2_TP_4_HI               0x44b
#define GEN7_RBBM_PERFCTR2_TP_5_LO               0x44c
#define GEN7_RBBM_PERFCTR2_TP_5_HI               0x44d
#define GEN7_RBBM_PERFCTR2_UFC_0_LO              0x44e
#define GEN7_RBBM_PERFCTR2_UFC_0_HI              0x44f
#define GEN7_RBBM_PERFCTR2_UFC_1_LO              0x450
#define GEN7_RBBM_PERFCTR2_UFC_1_HI              0x451
#define GEN7_RBBM_PERFCTR_BV_PC_0_LO             0x460
#define GEN7_RBBM_PERFCTR_BV_PC_0_HI             0x461
#define GEN7_RBBM_PERFCTR_BV_PC_1_LO             0x462
#define GEN7_RBBM_PERFCTR_BV_PC_1_HI             0x463
#define GEN7_RBBM_PERFCTR_BV_PC_2_LO             0x464
#define GEN7_RBBM_PERFCTR_BV_PC_2_HI             0x465
#define GEN7_RBBM_PERFCTR_BV_PC_3_LO             0x466
#define GEN7_RBBM_PERFCTR_BV_PC_3_HI             0x467
#define GEN7_RBBM_PERFCTR_BV_PC_4_LO             0x468
#define GEN7_RBBM_PERFCTR_BV_PC_4_HI             0x469
#define GEN7_RBBM_PERFCTR_BV_PC_5_LO             0x46a
#define GEN7_RBBM_PERFCTR_BV_PC_5_HI             0x46b
#define GEN7_RBBM_PERFCTR_BV_PC_6_LO             0x46c
#define GEN7_RBBM_PERFCTR_BV_PC_6_HI             0x46d
#define GEN7_RBBM_PERFCTR_BV_PC_7_LO             0x46e
#define GEN7_RBBM_PERFCTR_BV_PC_7_HI             0x46f
#define GEN7_RBBM_PERFCTR_BV_VFD_0_LO            0x470
#define GEN7_RBBM_PERFCTR_BV_VFD_0_HI            0x471
#define GEN7_RBBM_PERFCTR_BV_VFD_1_LO            0x472
#define GEN7_RBBM_PERFCTR_BV_VFD_1_HI            0x473
#define GEN7_RBBM_PERFCTR_BV_VFD_2_LO            0x474
#define GEN7_RBBM_PERFCTR_BV_VFD_2_HI            0x475
#define GEN7_RBBM_PERFCTR_BV_VFD_3_LO            0x476
#define GEN7_RBBM_PERFCTR_BV_VFD_3_HI            0x477
#define GEN7_RBBM_PERFCTR_BV_VFD_4_LO            0x478
#define GEN7_RBBM_PERFCTR_BV_VFD_4_HI            0x479
#define GEN7_RBBM_PERFCTR_BV_VFD_5_LO            0x47a
#define GEN7_RBBM_PERFCTR_BV_VFD_5_HI            0x47b
#define GEN7_RBBM_PERFCTR_BV_VFD_6_LO            0x47c
#define GEN7_RBBM_PERFCTR_BV_VFD_6_HI            0x47d
#define GEN7_RBBM_PERFCTR_BV_VFD_7_LO            0x47e
#define GEN7_RBBM_PERFCTR_BV_VFD_7_HI            0x47f
#define GEN7_RBBM_PERFCTR_BV_VPC_0_LO            0x480
#define GEN7_RBBM_PERFCTR_BV_VPC_0_HI            0x481
#define GEN7_RBBM_PERFCTR_BV_VPC_1_LO            0x482
#define GEN7_RBBM_PERFCTR_BV_VPC_1_HI            0x483
#define GEN7_RBBM_PERFCTR_BV_VPC_2_LO            0x484
#define GEN7_RBBM_PERFCTR_BV_VPC_2_HI            0x485
#define GEN7_RBBM_PERFCTR_BV_VPC_3_LO            0x486
#define GEN7_RBBM_PERFCTR_BV_VPC_3_HI            0x487
#define GEN7_RBBM_PERFCTR_BV_VPC_4_LO            0x488
#define GEN7_RBBM_PERFCTR_BV_VPC_4_HI            0x489
#define GEN7_RBBM_PERFCTR_BV_VPC_5_LO            0x48a
#define GEN7_RBBM_PERFCTR_BV_VPC_5_HI            0x48b
#define GEN7_RBBM_PERFCTR_BV_TSE_0_LO            0x48c
#define GEN7_RBBM_PERFCTR_BV_TSE_0_HI            0x48d
#define GEN7_RBBM_PERFCTR_BV_TSE_1_LO            0x48e
#define GEN7_RBBM_PERFCTR_BV_TSE_1_HI            0x48f
#define GEN7_RBBM_PERFCTR_BV_TSE_2_LO            0x490
#define GEN7_RBBM_PERFCTR_BV_TSE_2_HI            0x491
#define GEN7_RBBM_PERFCTR_BV_TSE_3_LO            0x492
#define GEN7_RBBM_PERFCTR_BV_TSE_3_HI            0x493
#define GEN7_RBBM_PERFCTR_BV_RAS_0_LO            0x494
#define GEN7_RBBM_PERFCTR_BV_RAS_0_HI            0x495
#define GEN7_RBBM_PERFCTR_BV_RAS_1_LO            0x496
#define GEN7_RBBM_PERFCTR_BV_RAS_1_HI            0x497
#define GEN7_RBBM_PERFCTR_BV_RAS_2_LO            0x498
#define GEN7_RBBM_PERFCTR_BV_RAS_2_HI            0x499
#define GEN7_RBBM_PERFCTR_BV_RAS_3_LO            0x49a
#define GEN7_RBBM_PERFCTR_BV_RAS_3_HI            0x49b
#define GEN7_RBBM_PERFCTR_BV_LRZ_0_LO            0x49c
#define GEN7_RBBM_PERFCTR_BV_LRZ_0_HI            0x49d
#define GEN7_RBBM_PERFCTR_BV_LRZ_1_LO            0x49e
#define GEN7_RBBM_PERFCTR_BV_LRZ_1_HI            0x49f
#define GEN7_RBBM_PERFCTR_BV_LRZ_2_LO            0x4a0
#define GEN7_RBBM_PERFCTR_BV_LRZ_2_HI            0x4a1
#define GEN7_RBBM_PERFCTR_BV_LRZ_3_LO            0x4a2
#define GEN7_RBBM_PERFCTR_BV_LRZ_3_HI            0x4a3

#define GEN7_RBBM_PERFCTR_CNTL                   0x500
#define GEN7_RBBM_PERFCTR_RBBM_SEL_0             0x507
#define GEN7_RBBM_PERFCTR_RBBM_SEL_1             0x508
#define GEN7_RBBM_PERFCTR_RBBM_SEL_2             0x509
#define GEN7_RBBM_PERFCTR_RBBM_SEL_3             0x50a
#define GEN7_RBBM_PERFCTR_GPU_BUSY_MASKED        0x50b
#define GEN7_RBBM_PERFCTR_SRAM_INIT_CMD          0x50e
#define GEN7_RBBM_PERFCTR_SRAM_INIT_STATUS       0x50f

#define GEN7_RBBM_ISDB_CNT                       0x533
#define GEN7_RBBM_NC_MODE_CNTL                   0x534
#define GEN7_RBBM_SNAPSHOT_STATUS                0x535

#define GEN7_RBBM_PERFCTR_UCHE_12_LO             0x584
#define GEN7_RBBM_PERFCTR_UCHE_12_HI             0x585
#define GEN7_RBBM_PERFCTR_UCHE_13_LO             0x586
#define GEN7_RBBM_PERFCTR_UCHE_13_HI             0x587
#define GEN7_RBBM_PERFCTR_UCHE_14_LO             0x588
#define GEN7_RBBM_PERFCTR_UCHE_14_HI             0x589
#define GEN7_RBBM_PERFCTR_UCHE_15_LO             0x58a
#define GEN7_RBBM_PERFCTR_UCHE_15_HI             0x58b
#define GEN7_RBBM_PERFCTR_UCHE_16_LO             0x58c
#define GEN7_RBBM_PERFCTR_UCHE_16_HI             0x58d
#define GEN7_RBBM_PERFCTR_UCHE_17_LO             0x58e
#define GEN7_RBBM_PERFCTR_UCHE_17_HI             0x58f
#define GEN7_RBBM_PERFCTR_UCHE_18_LO             0x590
#define GEN7_RBBM_PERFCTR_UCHE_18_HI             0x591
#define GEN7_RBBM_PERFCTR_UCHE_19_LO             0x592
#define GEN7_RBBM_PERFCTR_UCHE_19_HI             0x593
#define GEN7_RBBM_PERFCTR_UCHE_20_LO             0x594
#define GEN7_RBBM_PERFCTR_UCHE_20_HI             0x595
#define GEN7_RBBM_PERFCTR_UCHE_21_LO             0x596
#define GEN7_RBBM_PERFCTR_UCHE_21_HI             0x597
#define GEN7_RBBM_PERFCTR_UCHE_22_LO             0x598
#define GEN7_RBBM_PERFCTR_UCHE_22_HI             0x599
#define GEN7_RBBM_PERFCTR_UCHE_23_LO             0x59a
#define GEN7_RBBM_PERFCTR_UCHE_23_HI             0x59b

#define GEN7_RBBM_SECVID_TRUST_CNTL              0xf400
#define GEN7_RBBM_SECVID_TSB_TRUSTED_BASE_LO     0xf800
#define GEN7_RBBM_SECVID_TSB_TRUSTED_BASE_HI     0xf801
#define GEN7_RBBM_SECVID_TSB_TRUSTED_SIZE        0xf802
#define GEN7_RBBM_SECVID_TSB_CNTL                0xf803
#define GEN7_RBBM_SECVID_TSB_STATUS_LO           0xfc00
#define GEN7_RBBM_SECVID_TSB_STATUS_HI           0xfc01

#define GEN7_RBBM_GBIF_CLIENT_QOS_CNTL   0x00011
#define GEN7_RBBM_GBIF_HALT              0x00016
#define GEN7_RBBM_GBIF_HALT_ACK          0x00017
#define GEN7_RBBM_INTERFACE_HANG_INT_CNTL 0x0001f
#define GEN7_RBBM_INT_CLEAR_CMD          0x00037
#define GEN7_RBBM_INT_0_MASK             0x00038
#define GEN7_RBBM_INT_2_MASK             0x0003a
#define GEN7_RBBM_SP_HYST_CNT            0x00042
#define GEN7_RBBM_SW_RESET_CMD           0x00043
#define GEN7_RBBM_RAC_THRESHOLD_CNT      0x00044
#define GEN7_RBBM_CLOCK_CNTL             0x000ae
#define GEN7_RBBM_CLOCK_CNTL_SP0         0x000b0
#define GEN7_RBBM_CLOCK_CNTL2_SP0        0x000b4
#define GEN7_RBBM_CLOCK_DELAY_SP0        0x000b8
#define GEN7_RBBM_CLOCK_HYST_SP0         0x000bc
#define GEN7_RBBM_CLOCK_CNTL_TP0         0x000c0
#define GEN7_RBBM_CLOCK_CNTL2_TP0        0x000c4
#define GEN7_RBBM_CLOCK_CNTL3_TP0        0x000c8
#define GEN7_RBBM_CLOCK_CNTL4_TP0        0x000cc
#define GEN7_RBBM_CLOCK_DELAY_TP0        0x000d0
#define GEN7_RBBM_CLOCK_DELAY2_TP0       0x000d4
#define GEN7_RBBM_CLOCK_DELAY3_TP0       0x000d8
#define GEN7_RBBM_CLOCK_DELAY4_TP0       0x000dc
#define GEN7_RBBM_CLOCK_HYST_TP0         0x000e0
#define GEN7_RBBM_CLOCK_HYST2_TP0        0x000e4
#define GEN7_RBBM_CLOCK_HYST3_TP0        0x000e8
#define GEN7_RBBM_CLOCK_HYST4_TP0        0x000ec
#define GEN7_RBBM_CLOCK_CNTL_RB0         0x000f0
#define GEN7_RBBM_CLOCK_CNTL2_RB0        0x000f4
#define GEN7_RBBM_CLOCK_CNTL_CCU0        0x000f8
#define GEN7_RBBM_CLOCK_HYST_RB_CCU0     0x00100
#define GEN7_RBBM_CLOCK_CNTL_RAC         0x00104
#define GEN7_RBBM_CLOCK_CNTL2_RAC        0x00105
#define GEN7_RBBM_CLOCK_DELAY_RAC        0x00106
#define GEN7_RBBM_CLOCK_HYST_RAC         0x00107
#define GEN7_RBBM_CLOCK_CNTL_TSE_RAS_RBBM 0x00108
#define GEN7_RBBM_CLOCK_DELAY_TSE_RAS_RBBM 0x00109
#define GEN7_RBBM_CLOCK_HYST_TSE_RAS_RBBM 0x0010a
#define GEN7_RBBM_CLOCK_CNTL_UCHE        0x0010b
#define GEN7_RBBM_CLOCK_CNTL2_UCHE       0x0010c
#define GEN7_RBBM_CLOCK_DELAY_UCHE       0x0010f
#define GEN7_RBBM_CLOCK_HYST_UCHE        0x00110
#define GEN7_RBBM_CLOCK_MODE_VFD         0x00111
#define GEN7_RBBM_CLOCK_DELAY_VFD        0x00112
#define GEN7_RBBM_CLOCK_HYST_VFD         0x00113
#define GEN7_RBBM_CLOCK_MODE_GPC         0x00114
#define GEN7_RBBM_CLOCK_DELAY_GPC        0x00115
#define GEN7_RBBM_CLOCK_HYST_GPC         0x00116
#define GEN7_RBBM_CLOCK_DELAY_HLSQ_2     0x00117
#define GEN7_RBBM_CLOCK_CNTL_GMU_GX      0x00118
#define GEN7_RBBM_CLOCK_DELAY_GMU_GX     0x00119
#define GEN7_RBBM_CLOCK_HYST_GMU_GX      0x0011a
#define GEN7_RBBM_CLOCK_MODE_HLSQ        0x0011b
#define GEN7_RBBM_CLOCK_DELAY_HLSQ       0x0011c
#define GEN7_RBBM_CLOCK_HYST_HLSQ        0x0011d
#define GEN7_RBBM_CLOCK_HYST2_VFD        0x0012f
#define GEN7_RBBM_CLOCK_MODE_CP          0x00260
#define GEN7_RBBM_CLOCK_MODE_BV_LRZ      0x00284
#define GEN7_RBBM_CLOCK_MODE_BV_GRAS     0x00285
#define GEN7_RBBM_CLOCK_MODE2_GRAS       0x00286
#define GEN7_RBBM_CLOCK_MODE_BV_VFD      0x00287
#define GEN7_RBBM_CLOCK_MODE_BV_GPC      0x00288

/* DBGC_CFG registers */
#define GEN7_DBGC_CFG_DBGBUS_SEL_A                  0x600
#define GEN7_DBGC_CFG_DBGBUS_SEL_B                  0x601
#define GEN7_DBGC_CFG_DBGBUS_SEL_C                  0x602
#define GEN7_DBGC_CFG_DBGBUS_SEL_D                  0x603
#define GEN7_DBGC_CFG_DBGBUS_CNTLT                  0x604
#define GEN7_DBGC_CFG_DBGBUS_CNTLM                  0x605
#define GEN7_DBGC_CFG_DBGBUS_OPL                    0x606
#define GEN7_DBGC_CFG_DBGBUS_OPE                    0x607
#define GEN7_DBGC_CFG_DBGBUS_IVTL_0                 0x608
#define GEN7_DBGC_CFG_DBGBUS_IVTL_1                 0x609
#define GEN7_DBGC_CFG_DBGBUS_IVTL_2                 0x60a
#define GEN7_DBGC_CFG_DBGBUS_IVTL_3                 0x60b
#define GEN7_DBGC_CFG_DBGBUS_MASKL_0                0x60c
#define GEN7_DBGC_CFG_DBGBUS_MASKL_1                0x60d
#define GEN7_DBGC_CFG_DBGBUS_MASKL_2                0x60e
#define GEN7_DBGC_CFG_DBGBUS_MASKL_3                0x60f
#define GEN7_DBGC_CFG_DBGBUS_BYTEL_0                0x610
#define GEN7_DBGC_CFG_DBGBUS_BYTEL_1                0x611
#define GEN7_DBGC_CFG_DBGBUS_IVTE_0                 0x612
#define GEN7_DBGC_CFG_DBGBUS_IVTE_1                 0x613
#define GEN7_DBGC_CFG_DBGBUS_IVTE_2                 0x614
#define GEN7_DBGC_CFG_DBGBUS_IVTE_3                 0x615
#define GEN7_DBGC_CFG_DBGBUS_MASKE_0                0x616
#define GEN7_DBGC_CFG_DBGBUS_MASKE_1                0x617
#define GEN7_DBGC_CFG_DBGBUS_MASKE_2                0x618
#define GEN7_DBGC_CFG_DBGBUS_MASKE_3                0x619
#define GEN7_DBGC_CFG_DBGBUS_NIBBLEE                0x61a
#define GEN7_DBGC_CFG_DBGBUS_PTRC0                  0x61b
#define GEN7_DBGC_CFG_DBGBUS_PTRC1                  0x61c
#define GEN7_DBGC_CFG_DBGBUS_LOADREG                0x61d
#define GEN7_DBGC_CFG_DBGBUS_IDX                    0x61e
#define GEN7_DBGC_CFG_DBGBUS_CLRC                   0x61f
#define GEN7_DBGC_CFG_DBGBUS_LOADIVT                0x620
#define GEN7_DBGC_VBIF_DBG_CNTL                     0x621
#define GEN7_DBGC_DBG_LO_HI_GPIO                    0x622
#define GEN7_DBGC_EXT_TRACE_BUS_CNTL                0x623
#define GEN7_DBGC_READ_AHB_THROUGH_DBG              0x624
#define GEN7_DBGC_CFG_DBGBUS_OVER                   0x626
#define GEN7_DBGC_CFG_DBGBUS_TRACE_BUF1             0x62f
#define GEN7_DBGC_CFG_DBGBUS_TRACE_BUF2             0x630
#define GEN7_DBGC_EVT_CFG                           0x640
#define GEN7_DBGC_EVT_INTF_SEL_0                    0x641
#define GEN7_DBGC_EVT_INTF_SEL_1                    0x642
#define GEN7_DBGC_PERF_ATB_CFG                      0x643
#define GEN7_DBGC_PERF_ATB_COUNTER_SEL_0            0x644
#define GEN7_DBGC_PERF_ATB_COUNTER_SEL_1            0x645
#define GEN7_DBGC_PERF_ATB_COUNTER_SEL_2            0x646
#define GEN7_DBGC_PERF_ATB_COUNTER_SEL_3            0x647
#define GEN7_DBGC_PERF_ATB_TRIG_INTF_SEL_0          0x648
#define GEN7_DBGC_PERF_ATB_TRIG_INTF_SEL_1          0x649
#define GEN7_DBGC_PERF_ATB_DRAIN_CMD                0x64a
#define GEN7_DBGC_ECO_CNTL                          0x650
#define GEN7_DBGC_AHB_DBG_CNTL                      0x651

/* VSC registers */
#define GEN7_VSC_PERFCTR_VSC_SEL_0          0xcd8
#define GEN7_VSC_PERFCTR_VSC_SEL_1          0xcd9

/* GRAS registers */
#define GEN7_GRAS_NC_MODE_CNTL              0x8602
#define GEN7_GRAS_PERFCTR_TSE_SEL_0         0x8610
#define GEN7_GRAS_PERFCTR_TSE_SEL_1         0x8611
#define GEN7_GRAS_PERFCTR_TSE_SEL_2         0x8612
#define GEN7_GRAS_PERFCTR_TSE_SEL_3         0x8613
#define GEN7_GRAS_PERFCTR_RAS_SEL_0         0x8614
#define GEN7_GRAS_PERFCTR_RAS_SEL_1         0x8615
#define GEN7_GRAS_PERFCTR_RAS_SEL_2         0x8616
#define GEN7_GRAS_PERFCTR_RAS_SEL_3         0x8617
#define GEN7_GRAS_PERFCTR_LRZ_SEL_0         0x8618
#define GEN7_GRAS_PERFCTR_LRZ_SEL_1         0x8619
#define GEN7_GRAS_PERFCTR_LRZ_SEL_2         0x861a
#define GEN7_GRAS_PERFCTR_LRZ_SEL_3         0x861b

/* RB registers */
#define GEN7_RB_NC_MODE_CNTL                0x8e08
#define GEN7_RB_PERFCTR_RB_SEL_0            0x8e10
#define GEN7_RB_PERFCTR_RB_SEL_1            0x8e11
#define GEN7_RB_PERFCTR_RB_SEL_2            0x8e12
#define GEN7_RB_PERFCTR_RB_SEL_3            0x8e13
#define GEN7_RB_PERFCTR_RB_SEL_4            0x8e14
#define GEN7_RB_PERFCTR_RB_SEL_5            0x8e15
#define GEN7_RB_PERFCTR_RB_SEL_6            0x8e16
#define GEN7_RB_PERFCTR_RB_SEL_7            0x8e17
#define GEN7_RB_PERFCTR_CCU_SEL_0           0x8e18
#define GEN7_RB_PERFCTR_CCU_SEL_1           0x8e19
#define GEN7_RB_PERFCTR_CCU_SEL_2           0x8e1a
#define GEN7_RB_PERFCTR_CCU_SEL_3           0x8e1b
#define GEN7_RB_PERFCTR_CCU_SEL_4           0x8e1c
#define GEN7_RB_CMP_DBG_ECO_CNTL            0x8e28
#define GEN7_RB_PERFCTR_CMP_SEL_0           0x8e2c
#define GEN7_RB_PERFCTR_CMP_SEL_1           0x8e2d
#define GEN7_RB_PERFCTR_CMP_SEL_2           0x8e2e
#define GEN7_RB_PERFCTR_CMP_SEL_3           0x8e2f
#define GEN7_RB_PERFCTR_UFC_SEL_0           0x8e30
#define GEN7_RB_PERFCTR_UFC_SEL_1           0x8e31
#define GEN7_RB_PERFCTR_UFC_SEL_2           0x8e32
#define GEN7_RB_PERFCTR_UFC_SEL_3           0x8e33
#define GEN7_RB_PERFCTR_UFC_SEL_4           0x8e34
#define GEN7_RB_PERFCTR_UFC_SEL_5           0x8e35
#define GEN7_RB_RB_SUB_BLOCK_SEL_CNTL_HOST  0x8e3b
#define GEN7_RB_RB_SUB_BLOCK_SEL_CNTL_CD    0x8e3d
#define GEN7_RB_CONTEXT_SWITCH_GMEM_SAVE_RESTORE 0x8e50

/* PC registers */
#define GEN7_PC_PERFCTR_PC_SEL_0            0x9e42
#define GEN7_PC_PERFCTR_PC_SEL_1            0x9e43
#define GEN7_PC_PERFCTR_PC_SEL_2            0x9e44
#define GEN7_PC_PERFCTR_PC_SEL_3            0x9e45
#define GEN7_PC_PERFCTR_PC_SEL_4            0x9e46
#define GEN7_PC_PERFCTR_PC_SEL_5            0x9e47
#define GEN7_PC_PERFCTR_PC_SEL_6            0x9e48
#define GEN7_PC_PERFCTR_PC_SEL_7            0x9e49
#define GEN7_PC_PERFCTR_PC_SEL_8            0x9e4a
#define GEN7_PC_PERFCTR_PC_SEL_9            0x9e4b
#define GEN7_PC_PERFCTR_PC_SEL_10           0x9e4c
#define GEN7_PC_PERFCTR_PC_SEL_11           0x9e4d
#define GEN7_PC_PERFCTR_PC_SEL_12           0x9e4e
#define GEN7_PC_PERFCTR_PC_SEL_13           0x9e4f
#define GEN7_PC_PERFCTR_PC_SEL_14           0x9e50
#define GEN7_PC_PERFCTR_PC_SEL_15           0x9e51

/* VFD registers */
#define GEN7_VFD_PERFCTR_VFD_SEL_0          0xa610
#define GEN7_VFD_PERFCTR_VFD_SEL_1          0xa611
#define GEN7_VFD_PERFCTR_VFD_SEL_2          0xa612
#define GEN7_VFD_PERFCTR_VFD_SEL_3          0xa613
#define GEN7_VFD_PERFCTR_VFD_SEL_4          0xa614
#define GEN7_VFD_PERFCTR_VFD_SEL_5          0xa615
#define GEN7_VFD_PERFCTR_VFD_SEL_6          0xa616
#define GEN7_VFD_PERFCTR_VFD_SEL_7          0xa617
#define GEN7_VFD_PERFCTR_VFD_SEL_8          0xa618
#define GEN7_VFD_PERFCTR_VFD_SEL_9          0xa619
#define GEN7_VFD_PERFCTR_VFD_SEL_10         0xa61a
#define GEN7_VFD_PERFCTR_VFD_SEL_11         0xa61b
#define GEN7_VFD_PERFCTR_VFD_SEL_12         0xa61c
#define GEN7_VFD_PERFCTR_VFD_SEL_13         0xa61d
#define GEN7_VFD_PERFCTR_VFD_SEL_14         0xa61e
#define GEN7_VFD_PERFCTR_VFD_SEL_15         0xa61f

/* SP registers */
#define GEN7_SP_READ_SEL                    0xae6d
#define GEN7_SP_DBG_CNTL                    0xae71
#define GEN7_SP_AHB_READ_APERTURE           0xc000

/* VPC registers */
#define GEN7_VPC_PERFCTR_VPC_SEL_0          0x960b
#define GEN7_VPC_PERFCTR_VPC_SEL_1          0x960c
#define GEN7_VPC_PERFCTR_VPC_SEL_2          0x960c
#define GEN7_VPC_PERFCTR_VPC_SEL_3          0x960e
#define GEN7_VPC_PERFCTR_VPC_SEL_4          0x960f
#define GEN7_VPC_PERFCTR_VPC_SEL_5          0x9610
#define GEN7_VPC_PERFCTR_VPC_SEL_6          0x9611
#define GEN7_VPC_PERFCTR_VPC_SEL_7          0x9612
#define GEN7_VPC_PERFCTR_VPC_SEL_8          0x9613
#define GEN7_VPC_PERFCTR_VPC_SEL_9          0x9614
#define GEN7_VPC_PERFCTR_VPC_SEL_10         0x9615
#define GEN7_VPC_PERFCTR_VPC_SEL_11         0x9616

/* UCHE registers */
#define GEN7_UCHE_MODE_CNTL                 0xe01
#define GEN7_UCHE_WRITE_THRU_BASE_LO        0xe07
#define GEN7_UCHE_WRITE_THRU_BASE_HI        0xe08
#define GEN7_UCHE_TRAP_BASE_LO              0xe09
#define GEN7_UCHE_TRAP_BASE_HI              0xe0a
#define GEN7_UCHE_GMEM_RANGE_MIN_LO         0xe0b
#define GEN7_UCHE_GMEM_RANGE_MIN_HI         0xe0c
#define GEN7_UCHE_GMEM_RANGE_MAX_LO         0xe0d
#define GEN7_UCHE_GMEM_RANGE_MAX_HI         0xe0e
#define GEN7_UCHE_CACHE_WAYS                0xe17
#define GEN7_UCHE_CLIENT_PF                 0xe19
#define GEN7_UCHE_PERFCTR_UCHE_SEL_0        0xe1c
#define GEN7_UCHE_PERFCTR_UCHE_SEL_1        0xe1d
#define GEN7_UCHE_PERFCTR_UCHE_SEL_2        0xe1e
#define GEN7_UCHE_PERFCTR_UCHE_SEL_3        0xe1f
#define GEN7_UCHE_PERFCTR_UCHE_SEL_4        0xe20
#define GEN7_UCHE_PERFCTR_UCHE_SEL_5        0xe21
#define GEN7_UCHE_PERFCTR_UCHE_SEL_6        0xe22
#define GEN7_UCHE_PERFCTR_UCHE_SEL_7        0xe23
#define GEN7_UCHE_PERFCTR_UCHE_SEL_8        0xe24
#define GEN7_UCHE_PERFCTR_UCHE_SEL_9        0xe25
#define GEN7_UCHE_PERFCTR_UCHE_SEL_10       0xe26
#define GEN7_UCHE_PERFCTR_UCHE_SEL_11       0xe27
#define GEN7_UCHE_GBIF_GX_CONFIG            0xe3a
#define GEN7_UCHE_CMDQ_CONFIG               0xe3c
#define GEN7_UCHE_PERFCTR_UCHE_SEL_12       0xe40
#define GEN7_UCHE_PERFCTR_UCHE_SEL_13       0xe41
#define GEN7_UCHE_PERFCTR_UCHE_SEL_14       0xe42
#define GEN7_UCHE_PERFCTR_UCHE_SEL_15       0xe43
#define GEN7_UCHE_PERFCTR_UCHE_SEL_16       0xe44
#define GEN7_UCHE_PERFCTR_UCHE_SEL_17       0xe45
#define GEN7_UCHE_PERFCTR_UCHE_SEL_18       0xe46
#define GEN7_UCHE_PERFCTR_UCHE_SEL_19       0xe47
#define GEN7_UCHE_PERFCTR_UCHE_SEL_20       0xe48
#define GEN7_UCHE_PERFCTR_UCHE_SEL_21       0xe49
#define GEN7_UCHE_PERFCTR_UCHE_SEL_22       0xe4a
#define GEN7_UCHE_PERFCTR_UCHE_SEL_23       0xe4b

/* SP registers */
#define GEN7_SP_NC_MODE_CNTL                0xae02
#define GEN7_SP_PERFCTR_HLSQ_SEL_0          0xae60
#define GEN7_SP_PERFCTR_HLSQ_SEL_1          0xae61
#define GEN7_SP_PERFCTR_HLSQ_SEL_2          0xae62
#define GEN7_SP_PERFCTR_HLSQ_SEL_3          0xae63
#define GEN7_SP_PERFCTR_HLSQ_SEL_4          0xae64
#define GEN7_SP_PERFCTR_HLSQ_SEL_5          0xae65
#define GEN7_SP_PERFCTR_SP_SEL_0            0xae80
#define GEN7_SP_PERFCTR_SP_SEL_1            0xae81
#define GEN7_SP_PERFCTR_SP_SEL_2            0xae82
#define GEN7_SP_PERFCTR_SP_SEL_3            0xae83
#define GEN7_SP_PERFCTR_SP_SEL_4            0xae84
#define GEN7_SP_PERFCTR_SP_SEL_5            0xae85
#define GEN7_SP_PERFCTR_SP_SEL_6            0xae86
#define GEN7_SP_PERFCTR_SP_SEL_7            0xae87
#define GEN7_SP_PERFCTR_SP_SEL_8            0xae88
#define GEN7_SP_PERFCTR_SP_SEL_9            0xae89
#define GEN7_SP_PERFCTR_SP_SEL_10           0xae8a
#define GEN7_SP_PERFCTR_SP_SEL_11           0xae8b
#define GEN7_SP_PERFCTR_SP_SEL_12           0xae8c
#define GEN7_SP_PERFCTR_SP_SEL_13           0xae8d
#define GEN7_SP_PERFCTR_SP_SEL_14           0xae8e
#define GEN7_SP_PERFCTR_SP_SEL_15           0xae8f
#define GEN7_SP_PERFCTR_SP_SEL_16           0xae90
#define GEN7_SP_PERFCTR_SP_SEL_17           0xae91
#define GEN7_SP_PERFCTR_SP_SEL_18           0xae92
#define GEN7_SP_PERFCTR_SP_SEL_19           0xae93
#define GEN7_SP_PERFCTR_SP_SEL_20           0xae94
#define GEN7_SP_PERFCTR_SP_SEL_21           0xae95
#define GEN7_SP_PERFCTR_SP_SEL_22           0xae96
#define GEN7_SP_PERFCTR_SP_SEL_23           0xae97
#define GEN7_SP_PERFCTR_SP_SEL_24           0xae98
#define GEN7_SP_PERFCTR_SP_SEL_25           0xae99
#define GEN7_SP_PERFCTR_SP_SEL_26           0xae9a
#define GEN7_SP_PERFCTR_SP_SEL_27           0xae9b
#define GEN7_SP_PERFCTR_SP_SEL_28           0xae9c
#define GEN7_SP_PERFCTR_SP_SEL_29           0xae9d
#define GEN7_SP_PERFCTR_SP_SEL_30           0xae9e
#define GEN7_SP_PERFCTR_SP_SEL_31           0xae9f
#define GEN7_SP_PERFCTR_SP_SEL_32           0xaea0
#define GEN7_SP_PERFCTR_SP_SEL_33           0xaea1
#define GEN7_SP_PERFCTR_SP_SEL_34           0xaea2
#define GEN7_SP_PERFCTR_SP_SEL_35           0xaea3

/* TP registers */
#define GEN7_TPL1_NC_MODE_CNTL              0xb604
#define GEN7_TPL1_PERFCTR_TP_SEL_0          0xb610
#define GEN7_TPL1_PERFCTR_TP_SEL_1          0xb611
#define GEN7_TPL1_PERFCTR_TP_SEL_2          0xb612
#define GEN7_TPL1_PERFCTR_TP_SEL_3          0xb613
#define GEN7_TPL1_PERFCTR_TP_SEL_4          0xb614
#define GEN7_TPL1_PERFCTR_TP_SEL_5          0xb615
#define GEN7_TPL1_PERFCTR_TP_SEL_6          0xb616
#define GEN7_TPL1_PERFCTR_TP_SEL_7          0xb617
#define GEN7_TPL1_PERFCTR_TP_SEL_8          0xb618
#define GEN7_TPL1_PERFCTR_TP_SEL_9          0xb619
#define GEN7_TPL1_PERFCTR_TP_SEL_10         0xb61a
#define GEN7_TPL1_PERFCTR_TP_SEL_11         0xb61b
#define GEN7_TPL1_PERFCTR_TP_SEL_12         0xb61c
#define GEN7_TPL1_PERFCTR_TP_SEL_13         0xb61d
#define GEN7_TPL1_PERFCTR_TP_SEL_14         0xb61e
#define GEN7_TPL1_PERFCTR_TP_SEL_15         0xb61f
#define GEN7_TPL1_PERFCTR_TP_SEL_16         0xb620
#define GEN7_TPL1_PERFCTR_TP_SEL_17         0xb621

/* VBIF registers */
#define GEN7_VBIF_XIN_HALT_CTRL1                0x3081
#define GEN7_VBIF_TEST_BUS_OUT_CTRL             0x3084
#define GEN7_VBIF_TEST_BUS1_CTRL0               0x3085
#define GEN7_VBIF_TEST_BUS1_CTRL1               0x3086
#define GEN7_VBIF_TEST_BUS2_CTRL0               0x3087
#define GEN7_VBIF_TEST_BUS2_CTRL1               0x3088
#define GEN7_VBIF_TEST_BUS_OUT                  0x308c
#define GEN7_VBIF_PERF_CNT_SEL0                 0x30d0
#define GEN7_VBIF_PERF_CNT_SEL1                 0x30d1
#define GEN7_VBIF_PERF_CNT_SEL2                 0x30d2
#define GEN7_VBIF_PERF_CNT_SEL3                 0x30d3
#define GEN7_VBIF_PERF_CNT_LOW0                 0x30d8
#define GEN7_VBIF_PERF_CNT_LOW1                 0x30d9
#define GEN7_VBIF_PERF_CNT_LOW2                 0x30da
#define GEN7_VBIF_PERF_CNT_LOW3                 0x30db
#define GEN7_VBIF_PERF_CNT_HIGH0                0x30e0
#define GEN7_VBIF_PERF_CNT_HIGH1                0x30e1
#define GEN7_VBIF_PERF_CNT_HIGH2                0x30e2
#define GEN7_VBIF_PERF_CNT_HIGH3                0x30e3
#define GEN7_VBIF_PERF_PWR_CNT_EN0              0x3100
#define GEN7_VBIF_PERF_PWR_CNT_EN1              0x3101
#define GEN7_VBIF_PERF_PWR_CNT_EN2              0x3102
#define GEN7_VBIF_PERF_PWR_CNT_LOW0             0x3110
#define GEN7_VBIF_PERF_PWR_CNT_LOW1             0x3111
#define GEN7_VBIF_PERF_PWR_CNT_LOW2             0x3112
#define GEN7_VBIF_PERF_PWR_CNT_HIGH0            0x3118
#define GEN7_VBIF_PERF_PWR_CNT_HIGH1            0x3119
#define GEN7_VBIF_PERF_PWR_CNT_HIGH2            0x311a

/* GBIF countables */
#define GBIF_AXI0_READ_DATA_TOTAL_BEATS    34
#define GBIF_AXI1_READ_DATA_TOTAL_BEATS    35
#define GBIF_AXI0_WRITE_DATA_TOTAL_BEATS   46
#define GBIF_AXI1_WRITE_DATA_TOTAL_BEATS   47

/* GBIF registers */
#define GEN7_GBIF_SCACHE_CNTL0            0x3c01
#define GEN7_GBIF_SCACHE_CNTL1            0x3c02
#define GEN7_GBIF_QSB_SIDE0               0x3c03
#define GEN7_GBIF_QSB_SIDE1               0x3c04
#define GEN7_GBIF_QSB_SIDE2               0x3c05
#define GEN7_GBIF_QSB_SIDE3               0x3c06
#define GEN7_GBIF_HALT                    0x3c45
#define GEN7_GBIF_HALT_ACK                0x3c46

#define GEN7_GBIF_CLIENT_HALT_MASK        BIT(0)
#define GEN7_GBIF_ARB_HALT_MASK           BIT(1)
#define GEN7_GBIF_GX_HALT_MASK            BIT(0)

#define GEN7_GBIF_PERF_PWR_CNT_EN         0x3cc0
#define GEN7_GBIF_PERF_PWR_CNT_CLR        0x3cc1
#define GEN7_GBIF_PERF_CNT_SEL            0x3cc2
#define GEN7_GBIF_PERF_PWR_CNT_SEL        0x3cc3
#define GEN7_GBIF_PERF_CNT_LOW0           0x3cc4
#define GEN7_GBIF_PERF_CNT_LOW1           0x3cc5
#define GEN7_GBIF_PERF_CNT_LOW2           0x3cc6
#define GEN7_GBIF_PERF_CNT_LOW3           0x3cc7
#define GEN7_GBIF_PERF_CNT_HIGH0          0x3cc8
#define GEN7_GBIF_PERF_CNT_HIGH1          0x3cc9
#define GEN7_GBIF_PERF_CNT_HIGH2          0x3cca
#define GEN7_GBIF_PERF_CNT_HIGH3          0x3ccb
#define GEN7_GBIF_PWR_CNT_LOW0            0x3ccc
#define GEN7_GBIF_PWR_CNT_LOW1            0x3ccd
#define GEN7_GBIF_PWR_CNT_LOW2            0x3cce
#define GEN7_GBIF_PWR_CNT_HIGH0           0x3ccf
#define GEN7_GBIF_PWR_CNT_HIGH1           0x3cd0
#define GEN7_GBIF_PWR_CNT_HIGH2           0x3cd1


/* CX_DBGC_CFG registers */
#define GEN7_CX_DBGC_CFG_DBGBUS_SEL_A                   0x18400
#define GEN7_CX_DBGC_CFG_DBGBUS_SEL_B                   0x18401
#define GEN7_CX_DBGC_CFG_DBGBUS_SEL_C                   0x18402
#define GEN7_CX_DBGC_CFG_DBGBUS_SEL_D                   0x18403
#define GEN7_CX_DBGC_CFG_DBGBUS_CNTLT                   0x18404
#define GEN7_CX_DBGC_CFG_DBGBUS_CNTLM                   0x18405
#define GEN7_CX_DBGC_CFG_DBGBUS_OPL                     0x18406
#define GEN7_CX_DBGC_CFG_DBGBUS_OPE                     0x18407
#define GEN7_CX_DBGC_CFG_DBGBUS_IVTL_0                  0x18408
#define GEN7_CX_DBGC_CFG_DBGBUS_IVTL_1                  0x18409
#define GEN7_CX_DBGC_CFG_DBGBUS_IVTL_2                  0x1840a
#define GEN7_CX_DBGC_CFG_DBGBUS_IVTL_3                  0x1840b
#define GEN7_CX_DBGC_CFG_DBGBUS_MASKL_0                 0x1840c
#define GEN7_CX_DBGC_CFG_DBGBUS_MASKL_1                 0x1840d
#define GEN7_CX_DBGC_CFG_DBGBUS_MASKL_2                 0x1840e
#define GEN7_CX_DBGC_CFG_DBGBUS_MASKL_3                 0x1840f
#define GEN7_CX_DBGC_CFG_DBGBUS_BYTEL_0                 0x18410
#define GEN7_CX_DBGC_CFG_DBGBUS_BYTEL_1                 0x18411
#define GEN7_CX_DBGC_CFG_DBGBUS_IVTE_0                  0x18412
#define GEN7_CX_DBGC_CFG_DBGBUS_IVTE_1                  0x18413
#define GEN7_CX_DBGC_CFG_DBGBUS_IVTE_2                  0x18414
#define GEN7_CX_DBGC_CFG_DBGBUS_IVTE_3                  0x18415
#define GEN7_CX_DBGC_CFG_DBGBUS_MASKE_0                 0x18416
#define GEN7_CX_DBGC_CFG_DBGBUS_MASKE_1                 0x18417
#define GEN7_CX_DBGC_CFG_DBGBUS_MASKE_2                 0x18418
#define GEN7_CX_DBGC_CFG_DBGBUS_MASKE_3                 0x18419
#define GEN7_CX_DBGC_CFG_DBGBUS_NIBBLEE                 0x1841a
#define GEN7_CX_DBGC_CFG_DBGBUS_PTRC0                   0x1841b
#define GEN7_CX_DBGC_CFG_DBGBUS_PTRC1                   0x1841c
#define GEN7_CX_DBGC_CFG_DBGBUS_LOADREG                 0x1841d
#define GEN7_CX_DBGC_CFG_DBGBUS_IDX                     0x1841e
#define GEN7_CX_DBGC_CFG_DBGBUS_CLRC                    0x1841f
#define GEN7_CX_DBGC_CFG_DBGBUS_LOADIVT                 0x18420
#define GEN7_CX_DBGC_VBIF_DBG_CNTL                      0x18421
#define GEN7_CX_DBGC_DBG_LO_HI_GPIO                     0x18422
#define GEN7_CX_DBGC_EXT_TRACE_BUS_CNTL                 0x18423
#define GEN7_CX_DBGC_READ_AHB_THROUGH_DBG               0x18424
#define GEN7_CX_DBGC_CFG_DBGBUS_OVER                    0x18426
#define GEN7_CX_DBGC_CFG_DBGBUS_TRACE_BUF1              0x1842f
#define GEN7_CX_DBGC_CFG_DBGBUS_TRACE_BUF2              0x18430
#define GEN7_CX_DBGC_EVT_CFG                            0x18440
#define GEN7_CX_DBGC_EVT_INTF_SEL_0                     0x18441
#define GEN7_CX_DBGC_EVT_INTF_SEL_1                     0x18442
#define GEN7_CX_DBGC_PERF_ATB_CFG                       0x18443
#define GEN7_CX_DBGC_PERF_ATB_COUNTER_SEL_0             0x18444
#define GEN7_CX_DBGC_PERF_ATB_COUNTER_SEL_1             0x18445
#define GEN7_CX_DBGC_PERF_ATB_COUNTER_SEL_2             0x18446
#define GEN7_CX_DBGC_PERF_ATB_COUNTER_SEL_3             0x18447
#define GEN7_CX_DBGC_PERF_ATB_TRIG_INTF_SEL_0           0x18448
#define GEN7_CX_DBGC_PERF_ATB_TRIG_INTF_SEL_1           0x18449
#define GEN7_CX_DBGC_PERF_ATB_DRAIN_CMD                 0x1844a
#define GEN7_CX_DBGC_ECO_CNTL                           0x18450
#define GEN7_CX_DBGC_AHB_DBG_CNTL                       0x18451
#define GEN7_CX_DBGC_TCM_DBG_ADDR                       0x18580
#define GEN7_CX_DBGC_TCM_DBG_DATA                       0x18581

/* GMU control registers */
#define GEN7_GMU_CM3_ITCM_START			0x1b400
#define GEN7_GMU_CM3_DTCM_START			0x1c400
#define GEN7_GMU_NMI_CONTROL_STATUS		0x1cbf0
#define GEN7_GMU_BOOT_SLUMBER_OPTION		0x1cbf8
#define GEN7_GMU_GX_VOTE_IDX			0x1cbf9
#define GEN7_GMU_MX_VOTE_IDX			0x1cbfa
#define GEN7_GMU_DCVS_ACK_OPTION		0x1cbfc
#define GEN7_GMU_DCVS_PERF_SETTING		0x1cbfd
#define GEN7_GMU_DCVS_BW_SETTING		0x1cbfe
#define GEN7_GMU_DCVS_RETURN			0x1cbff
#define GEN7_GMU_ICACHE_CONFIG			0x1f400
#define GEN7_GMU_DCACHE_CONFIG			0x1f401
#define GEN7_GMU_SYS_BUS_CONFIG			0x1f40f
#define GEN7_GMU_CX_MRC_GBIF_QOS_CTRL		0x1f50b
#define GEN7_GMU_CM3_SYSRESET			0x1f800
#define GEN7_GMU_CM3_BOOT_CONFIG		0x1f801
#define GEN7_GMU_CX_GMU_WFI_CONFIG		0x1f802
#define GEN7_GMU_CX_GMU_WDOG_CTRL		0x1f813
#define GEN7_GMU_CM3_FW_BUSY			0x1f81a
#define GEN7_GMU_CM3_FW_INIT_RESULT		0x1f81c
#define GEN7_GMU_CM3_CFG			0x1f82d
#define GEN7_GMU_CX_GMU_POWER_COUNTER_ENABLE	0x1f840
#define GEN7_GMU_CX_GMU_POWER_COUNTER_SELECT_0	0x1f841
#define GEN7_GMU_CX_GMU_POWER_COUNTER_SELECT_1	0x1f842
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_0_L	0x1f844
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_0_H	0x1f845
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_1_L	0x1f846
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_1_H	0x1f847
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_2_L	0x1f848
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_2_H	0x1f849
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_3_L	0x1f84a
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_3_H	0x1f84b
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_4_L	0x1f84c
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_4_H	0x1f84d
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_5_L	0x1f84e
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_5_H	0x1f84f
#define GEN7_GMU_CX_GMU_POWER_COUNTER_GMUCLK_0_L	0x1f850
#define GEN7_GMU_CX_GMU_POWER_COUNTER_GMUCLK_0_H	0x1f851
#define GEN7_GMU_CX_GMU_POWER_COUNTER_GMUCLK_1_L	0x1f852
#define GEN7_GMU_CX_GMU_POWER_COUNTER_GMUCLK_1_H	0x1f853
#define GEN7_GMU_CX_GMU_POWER_COUNTER_SELECT_2	0x1f860
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_6_L	0x1f870
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_6_H	0x1f871
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_7_L	0x1f872
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_7_H	0x1f873
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_8_L	0x1f874
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_8_H	0x1f875
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_9_L	0x1f876
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_9_H	0x1f877
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_10_L	0x1f878
#define GEN7_GMU_CX_GMU_POWER_COUNTER_XOCLK_10_H	0x1f879
#define GEN7_GMU_CX_GMU_POWER_COUNTER_SELECT_3	0x1f87f
#define GEN7_GMU_CX_GMU_ALWAYS_ON_COUNTER_L	0x1f888
#define GEN7_GMU_CX_GMU_ALWAYS_ON_COUNTER_H	0x1f889
#define GEN7_GMU_PWR_COL_INTER_FRAME_CTRL	0x1f8c0
#define GEN7_GMU_PWR_COL_INTER_FRAME_HYST	0x1f8c1
#define GEN7_GMU_GFX_PWR_CLK_STATUS		0x1f8d0
#define GEN7_GMU_CX_GMU_PERF_COUNTER_ENABLE	0x1f8a0
#define GEN7_GMU_CX_GMU_PERF_COUNTER_SELECT_0	0x1f8a1
#define GEN7_GMU_CX_GMU_PERF_COUNTER_SELECT_1	0x1f8a2
#define GEN7_GMU_CX_GMU_PERF_COUNTER_0_L	0x1f8a4
#define GEN7_GMU_CX_GMU_PERF_COUNTER_0_H	0x1f8a5
#define GEN7_GMU_CX_GMU_PERF_COUNTER_1_L	0x1f8a6
#define GEN7_GMU_CX_GMU_PERF_COUNTER_1_H	0x1f8a7
#define GEN7_GMU_CX_GMU_PERF_COUNTER_2_L	0x1f8a8
#define GEN7_GMU_CX_GMU_PERF_COUNTER_2_H	0x1f8a9
#define GEN7_GMU_CX_GMU_PERF_COUNTER_3_L	0x1f8aa
#define GEN7_GMU_CX_GMU_PERF_COUNTER_3_H	0x1f8ab
#define GEN7_GMU_CX_GMU_PERF_COUNTER_4_L	0x1f8ac
#define GEN7_GMU_CX_GMU_PERF_COUNTER_4_H	0x1f8ad
#define GEN7_GMU_CX_GMU_PERF_COUNTER_5_L	0x1f8ae
#define GEN7_GMU_CX_GMU_PERF_COUNTER_5_H	0x1f8af
#define GEN7_GPU_GMU_CX_GMU_RPMH_POWER_STATE	0x1f8ec
#define GEN7_GMU_BOOT_KMD_LM_HANDSHAKE		0x1f9f0

/* HFI registers*/
#define GEN7_GMU_ALWAYS_ON_COUNTER_L		0x1f888
#define GEN7_GMU_ALWAYS_ON_COUNTER_H		0x1f889
#define GEN7_GMU_GMU_PWR_COL_KEEPALIVE		0x1f8c3
#define GEN7_GMU_PWR_COL_PREEMPT_KEEPALIVE	0x1f8c4
#define GEN7_GMU_HFI_CTRL_STATUS		0x1f980
#define GEN7_GMU_HFI_QTBL_INFO			0x1f984
#define GEN7_GMU_HFI_QTBL_ADDR			0x1f985
#define GEN7_GMU_HFI_CTRL_INIT			0x1f986
#define GEN7_GMU_GMU2HOST_INTR_SET		0x1f990
#define GEN7_GMU_GMU2HOST_INTR_CLR		0x1f991
#define GEN7_GMU_GMU2HOST_INTR_INFO		0x1f992
#define GEN7_GMU_GMU2HOST_INTR_MASK		0x1f993
#define GEN7_GMU_HOST2GMU_INTR_SET		0x1f994
#define GEN7_GMU_HOST2GMU_INTR_CLR		0x1f995
#define GEN7_GMU_HOST2GMU_INTR_RAW_INFO		0x1f996
#define GEN7_GMU_HOST2GMU_INTR_EN_0		0x1f997
#define GEN7_GMU_HOST2GMU_INTR_EN_1		0x1f998
#define GEN7_GMU_HOST2GMU_INTR_EN_2		0x1f999
#define GEN7_GMU_HOST2GMU_INTR_EN_3		0x1f99a
#define GEN7_GMU_HOST2GMU_INTR_INFO_0		0x1f99b
#define GEN7_GMU_HOST2GMU_INTR_INFO_1		0x1f99c
#define GEN7_GMU_HOST2GMU_INTR_INFO_2		0x1f99d
#define GEN7_GMU_HOST2GMU_INTR_INFO_3		0x1f99e
#define GEN7_GMU_GENERAL_0			0x1f9c5
#define GEN7_GMU_GENERAL_1			0x1f9c6
#define GEN7_GMU_GENERAL_6			0x1f9cb
#define GEN7_GMU_GENERAL_7			0x1f9cc
#define GEN7_GMU_GENERAL_8			0x1f9cd
#define GEN7_GMU_GENERAL_9			0x1f9ce
#define GEN7_GMU_GENERAL_10			0x1f9cf

/* FAL10 veto register */
#define GEN7_GPU_GMU_CX_GMU_CX_FAL_INTF		0x1f8f0
#define GEN7_GPU_GMU_CX_GMU_CX_FALNEXT_INTF	0x1f8f1

#define GEN7_GMU_AO_INTERRUPT_EN		0x23b03
#define GEN7_GMU_AO_HOST_INTERRUPT_CLR		0x23b04
#define GEN7_GMU_AO_HOST_INTERRUPT_STATUS	0x23b05
#define GEN7_GMU_AO_HOST_INTERRUPT_MASK		0x23b06
#define GEN7_GPU_GMU_AO_GMU_CGC_MODE_CNTL	0x23b09
#define GEN7_GPU_GMU_AO_GMU_CGC_DELAY_CNTL	0x23b0a
#define GEN7_GPU_GMU_AO_GMU_CGC_HYST_CNTL	0x23b0b
#define GEN7_GPU_GMU_AO_GPU_CX_BUSY_STATUS	0x23b0c
#define GEN7_GPU_GMU_AO_GPU_CX_BUSY_STATUS2	0x23b0d
#define GEN7_GPU_GMU_AO_GPU_CX_BUSY_MASK	0x23b0e
#define GEN7_GMU_AO_AHB_FENCE_CTRL		0x23b10
#define GEN7_GMU_AHB_FENCE_STATUS		0x23b13
#define GEN7_GMU_AHB_FENCE_STATUS_CLR		0x23b14
#define GEN7_GMU_RBBM_INT_UNMASKED_STATUS	0x23b15
#define GEN7_GMU_AO_SPARE_CNTL			0x23b16
#define GEN7_GPU_GMU_AO_GPU_LPAC_BUSY_STATUS	0x23b30

/* GMU RSC control registers */
#define GEN7_GMU_RSCC_CONTROL_REQ		0x23b07
#define GEN7_GMU_RSCC_CONTROL_ACK		0x23b08

/* FENCE control registers */
#define GEN7_GMU_AHB_FENCE_RANGE_0		0x23b11

/* GPUCC registers */
#define GEN7_GPU_CC_GX_DOMAIN_MISC3		0x26541
#define GEN7_GPU_CC_CX_GDSCR			0x26442

/* GPU RSC sequencer registers */
#define GEN7_GPU_RSCC_RSC_STATUS0_DRV0			0x00004
#define GEN7_RSCC_PDC_SEQ_START_ADDR			0x00008
#define GEN7_RSCC_PDC_MATCH_VALUE_LO			0x00009
#define GEN7_RSCC_PDC_MATCH_VALUE_HI			0x0000a
#define GEN7_RSCC_PDC_SLAVE_ID_DRV0			0x0000b
#define GEN7_RSCC_HIDDEN_TCS_CMD0_ADDR			0x0000d
#define GEN7_RSCC_HIDDEN_TCS_CMD0_DATA			0x0000e
#define GEN7_RSCC_TIMESTAMP_UNIT0_TIMESTAMP_L_DRV0	0x00082
#define GEN7_RSCC_TIMESTAMP_UNIT0_TIMESTAMP_H_DRV0	0x00083
#define GEN7_RSCC_TIMESTAMP_UNIT1_EN_DRV0		0x00089
#define GEN7_RSCC_TIMESTAMP_UNIT1_OUTPUT_DRV0		0x0008c
#define GEN7_RSCC_OVERRIDE_START_ADDR			0x00100
#define GEN7_RSCC_SEQ_BUSY_DRV0				0x00101
#define GEN7_RSCC_SEQ_MEM_0_DRV0			0x00180
#define GEN7_RSCC_TCS0_DRV0_STATUS			0x00346
#define GEN7_RSCC_TCS1_DRV0_STATUS			0x003ee
#define GEN7_RSCC_TCS2_DRV0_STATUS			0x00496
#define GEN7_RSCC_TCS3_DRV0_STATUS			0x0053e
#define GEN7_RSCC_TCS4_DRV0_STATUS          0x005e6
#define GEN7_RSCC_TCS5_DRV0_STATUS          0x0068e
#define GEN7_RSCC_TCS6_DRV0_STATUS          0x00736
#define GEN7_RSCC_TCS7_DRV0_STATUS          0x007de
#define GEN7_RSCC_TCS8_DRV0_STATUS          0x00886
#define GEN7_RSCC_TCS9_DRV0_STATUS          0x0092e

/* Device-specific RSCC registers */
#define GEN7_6_0_RSCC_SEQ_MEM_0_DRV0			0x00154
#define GEN7_6_0_RSCC_TCS0_DRV0_STATUS			0x0034a
#define GEN7_6_0_RSCC_TCS1_DRV0_STATUS			0x003f2
#define GEN7_6_0_RSCC_TCS2_DRV0_STATUS			0x0049a
#define GEN7_6_0_RSCC_TCS3_DRV0_STATUS			0x00542
#define GEN7_6_0_RSCC_TCS4_DRV0_STATUS			0x005EA
#define GEN7_6_0_RSCC_TCS5_DRV0_STATUS			0x00692
#define GEN7_6_0_RSCC_TCS6_DRV0_STATUS			0x0073A
#define GEN7_6_0_RSCC_TCS7_DRV0_STATUS			0x007E2
#define GEN7_6_0_RSCC_TCS8_DRV0_STATUS			0x0088A
#define GEN7_6_0_RSCC_TCS9_DRV0_STATUS			0x00932

/* GPU PDC sequencer registers in AOSS.RPMh domain */
#define GEN7_PDC_GPU_ENABLE_PDC				0x1140
#define GEN7_PDC_GPU_SEQ_START_ADDR			0x1148

#define GEN7_SMMU_BASE				0x28000

/* GPU CX_MISC registers */
#define GEN7_GPU_CX_MISC_TCM_RET_CNTL		0x39

#endif /* _GEN7_REG_H */
