/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2022 Qualcomm Innovation Center, Inc. All rights reserved.
 */

#pragma once
// AUTOGENERATED FILE: DO NOT EDIT

#include <linux/types.h>
#include <soc/qcom/smci_object.h>

#define HDCP1_PROVISION 0
#define HDCP1_VERIFY 1
#define HDCP1_SET_ENCRYPTION 2
#define HDCP1_SET_ENCRYPTION_V2 3
#define HDCP1_SET_KEY 4
#define HDCP1_SET_KEY_V2 5
#define HDCP1_SET_MODE 6

static inline int32_t hdcp1_release(struct smci_object self)
{
	return smci_object_invoke(self, SMCI_OBJECT_OP_RELEASE, 0, 0);
}

static inline int32_t hdcp1_retain(struct smci_object self)
{
	return smci_object_invoke(self, SMCI_OBJECT_OP_RETAIN, 0, 0);
}

static inline int32_t hdcp1_provision(struct smci_object self, uint32_t keyFormat_val,
		   const void *key_ptr, size_t key_len,
		   const void *dps_ptr, size_t dps_len)
{
	union smci_object_arg a[3] = {{{0, 0}}};

	a[0].b = (struct smci_object_buf) {&keyFormat_val, sizeof(uint32_t)};
	a[1].bi = (struct smci_object_buf_in) {key_ptr, key_len * 1};
	a[2].bi = (struct smci_object_buf_in) {dps_ptr, dps_len * 1};

	return smci_object_invoke(self, HDCP1_PROVISION, a,
		 SMCI_OBJECT_COUNTS_PACK(3, 0, 0, 0));
}

static inline int32_t hdcp1_verify(struct smci_object self, uint32_t deviceType_val)
{
	union smci_object_arg a[1] = {{{0, 0}}};

	a[0].b = (struct smci_object_buf) {&deviceType_val, sizeof(uint32_t)};

	return smci_object_invoke(self, HDCP1_VERIFY, a,
		 SMCI_OBJECT_COUNTS_PACK(1, 0, 0, 0));
}

static inline int32_t hdcp1_set_encryption(struct smci_object self, uint32_t enable_val)
{
	union smci_object_arg a[1] = {{{0, 0}}};

	a[0].b = (struct smci_object_buf) {&enable_val, sizeof(uint32_t)};

	return smci_object_invoke(self, HDCP1_SET_ENCRYPTION, a,
		 SMCI_OBJECT_COUNTS_PACK(1, 0, 0, 0));
}

static inline int32_t hdcp1_set_encryption_v2(struct smci_object self, uint32_t enable_val,
		   uint32_t deviceType_val)
{
	union smci_object_arg a[1] = {{{0, 0}}};
	struct {
		uint32_t m_enable;
		uint32_t m_deviceType;
	} i;

	a[0].b = (struct smci_object_buf) {&i, 8};
	i.m_enable = enable_val;
	i.m_deviceType = deviceType_val;

	return smci_object_invoke(self, HDCP1_SET_ENCRYPTION_V2, a,
		 SMCI_OBJECT_COUNTS_PACK(1, 0, 0, 0));
}

static inline int32_t hdcp1_set_key(struct smci_object self, void *ksv_ptr, size_t ksv_len,
		 size_t *ksv_lenout)
{
	union smci_object_arg a[1] = {{{0, 0}}};
	int32_t result = 0;

	a[0].b = (struct smci_object_buf) {ksv_ptr, ksv_len * 1};

	result = smci_object_invoke(self, HDCP1_SET_KEY, a,
		   SMCI_OBJECT_COUNTS_PACK(0, 1, 0, 0));

	*ksv_lenout = a[0].b.size / 1;

	return result;
}

static inline int32_t hdcp1_set_key_v2(struct smci_object self, void *ksv_ptr,
		size_t ksv_len, size_t *ksv_lenout,
		uint32_t deviceType_val)
{
	union smci_object_arg a[2] = {{{0, 0}}};
	int32_t result = 0;

	a[1].b = (struct smci_object_buf) {ksv_ptr, ksv_len * 1};
	a[0].b = (struct smci_object_buf) {&deviceType_val, sizeof(uint32_t)};

	result = smci_object_invoke(self, HDCP1_SET_KEY_V2, a,
		   SMCI_OBJECT_COUNTS_PACK(1, 1, 0, 0));

	*ksv_lenout = a[1].b.size / 1;

	return result;
}

static inline int32_t hdcp1_set_mode(struct smci_object self, int32_t mode_val)
{
	union smci_object_arg a[1] = {{{0, 0}}};

	a[0].b = (struct smci_object_buf) {&mode_val, sizeof(int32_t)};

	return smci_object_invoke(self, HDCP1_SET_MODE, a,
		 SMCI_OBJECT_COUNTS_PACK(1, 0, 0, 0));
}
