/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2022 Qualcomm Innovation Center, Inc. All rights reserved.
 */

#pragma once
// AUTOGENERATED FILE: DO NOT EDIT

#include <linux/types.h>
#include <soc/qcom/smci_object.h>

#define HDCP2P2_PROVISION_KEY 0
#define HDCP2P2_VERIFY_KEY 1
#define HDCP2P2_TX_INIT 2
#define HDCP2P2_TX_DEINIT 3
#define HDCP2P2_RCVD_MSG 4
#define HDCP2P2_SEND_TIMEOUT 5
#define HDCP2P2_SET_HW_KEY 6
#define HDCP2P2_QUERY_STREAM_TYPE 7
#define HDCP2P2_INIT 8
#define HDCP2P2_DEINIT 9
#define HDCP2P2_VERSION 10
#define HDCP2P2_SESSION_INIT 11
#define HDCP2P2_SESSION_DEINIT 12
#define HDCP2P2_START_AUTH 13
#define HDCP2P2_SESSION_OPEN_STREAM 14
#define HDCP2P2_SESSION_CLOSE_STREAM 15
#define HDCP2P2_FORCE_ENCRYPTION 16
#define HDCP2P2_DELETE_PAIRING_INFO 17

static inline int32_t hdcp2p2_release(struct smci_object self)
{
	return smci_object_invoke(self, SMCI_OBJECT_OP_RELEASE, 0, 0);
}

static inline int32_t hdcp2p2_retain(struct smci_object self)
{
	return smci_object_invoke(self, SMCI_OBJECT_OP_RETAIN, 0, 0);
}

static inline int32_t hdcp2p2_provision_key(struct smci_object self, const void *key_ptr,
		 size_t key_len,
		 const void *dps_ptr,
		 size_t dps_len)
{
	union smci_object_arg a[2] = {{{0, 0}}};

	a[0].bi = (struct smci_object_buf_in) {key_ptr, key_len * 1};
	a[1].bi = (struct smci_object_buf_in) {dps_ptr, dps_len * 1};

	return smci_object_invoke(self, HDCP2P2_PROVISION_KEY, a,
		 SMCI_OBJECT_COUNTS_PACK(2, 0, 0, 0));
}

static inline int32_t hdcp2p2_verify_key(struct smci_object self)
{
	return smci_object_invoke(self, HDCP2P2_VERIFY_KEY, 0, 0);
}

static inline int32_t hdcp2p2_tx_init(struct smci_object self, uint32_t sessionid_val,
		   uint32_t *ctxhandle_ptr)
{
	union smci_object_arg a[2] = {{{0, 0}}};

	a[0].b = (struct smci_object_buf) {&sessionid_val, sizeof(uint32_t)};
	a[1].b = (struct smci_object_buf) {ctxhandle_ptr, sizeof(uint32_t)};

	return smci_object_invoke(self, HDCP2P2_TX_INIT, a,
						 SMCI_OBJECT_COUNTS_PACK(1, 1, 0, 0));
}

static inline int32_t hdcp2p2_tx_deinit(struct smci_object self, uint32_t ctxhandle_val)
{
	union smci_object_arg a[1] = {{{0, 0}}};

	a[0].b = (struct smci_object_buf) {&ctxhandle_val, sizeof(uint32_t)};

	return smci_object_invoke(self, HDCP2P2_TX_DEINIT, a,
		 SMCI_OBJECT_COUNTS_PACK(1, 0, 0, 0));
}

static inline int32_t hdcp2p2_rcvd_msg(
	struct smci_object self, const void *reqMsg_ptr, size_t reqMsg_len,
	uint32_t ctxhandle_val, void *resMsg_ptr, size_t resMsg_len,
	size_t *resMsg_lenout, uint32_t *timeout_ptr, uint32_t *flag_ptr)
{
	union smci_object_arg a[4] = {{{0, 0}}};
	int32_t result = 0;
	struct {
		uint32_t m_timeout;
		uint32_t m_flag;
	} o;

	a[2].b = (struct smci_object_buf) {&o, 8};
	a[0].bi = (struct smci_object_buf_in) {reqMsg_ptr, reqMsg_len * 1};
	a[1].b = (struct smci_object_buf) {&ctxhandle_val, sizeof(uint32_t)};
	a[3].b = (struct smci_object_buf) {resMsg_ptr, resMsg_len * 1};

	result = smci_object_invoke(self, HDCP2P2_RCVD_MSG, a,
		   SMCI_OBJECT_COUNTS_PACK(2, 2, 0, 0));

	*resMsg_lenout = a[3].b.size / 1;
	*timeout_ptr = o.m_timeout;
	*flag_ptr = o.m_flag;

	return result;
}

static inline int32_t hdcp2p2_send_timeout(struct smci_object self, uint32_t ctxhandle_val,
		void *resMsg_ptr, size_t resMsg_len,
		size_t *resMsg_lenout,
		uint32_t *timeout_ptr)
{
	union smci_object_arg a[3] = {{{0, 0}}};
	int32_t result = 0;

	a[0].b = (struct smci_object_buf) {&ctxhandle_val, sizeof(uint32_t)};
	a[1].b = (struct smci_object_buf) {resMsg_ptr, resMsg_len * 1};
	a[2].b = (struct smci_object_buf) {timeout_ptr, sizeof(uint32_t)};

	result = smci_object_invoke(self, HDCP2P2_SEND_TIMEOUT, a,
		   SMCI_OBJECT_COUNTS_PACK(1, 2, 0, 0));

	*resMsg_lenout = a[1].b.size / 1;

	return result;
}

static inline int32_t hdcp2p2_set_hw_key(struct smci_object self, uint32_t ctxhandle_val)
{
	union smci_object_arg a[1] = {{{0, 0}}};

	a[0].b = (struct smci_object_buf) {&ctxhandle_val, sizeof(uint32_t)};

	return smci_object_invoke(self, HDCP2P2_SET_HW_KEY, a,
		 SMCI_OBJECT_COUNTS_PACK(1, 0, 0, 0));
}

static inline int32_t hdcp2p2_query_stream_type(
	struct smci_object self, uint32_t ctxhandle_val, void *resMsg_ptr, size_t resMsg_len,
	size_t *resMsg_lenout, uint32_t *timeout_ptr)
{
	union smci_object_arg a[3] = {{{0, 0}}};
	int32_t result = 0;

	a[0].b = (struct smci_object_buf) {&ctxhandle_val, sizeof(uint32_t)};
	a[1].b = (struct smci_object_buf) {resMsg_ptr, resMsg_len * 1};
	a[2].b = (struct smci_object_buf) {timeout_ptr, sizeof(uint32_t)};

	result = smci_object_invoke(self, HDCP2P2_QUERY_STREAM_TYPE, a,
		   SMCI_OBJECT_COUNTS_PACK(1, 2, 0, 0));

	*resMsg_lenout = a[1].b.size / 1;

	return result;
}

static inline int32_t hdcp2p2_init(struct smci_object self, uint32_t clientVersion_val,
		uint32_t *appversion_ptr)
{
	union smci_object_arg a[2] = {{{0, 0}}};

	a[0].b = (struct smci_object_buf) {&clientVersion_val, sizeof(uint32_t)};
	a[1].b = (struct smci_object_buf) {appversion_ptr, sizeof(uint32_t)};

	return smci_object_invoke(self, HDCP2P2_INIT, a,
						 SMCI_OBJECT_COUNTS_PACK(1, 1, 0, 0));
}

static inline int32_t hdcp2p2_deinit(struct smci_object self)
{
	return smci_object_invoke(self, HDCP2P2_DEINIT, 0, 0);
}

static inline int32_t hdcp2p2_version(struct smci_object self, uint32_t *appversion_ptr)
{
	union smci_object_arg a[1] = {{{0, 0}}};

	a[0].b = (struct smci_object_buf) {appversion_ptr, sizeof(uint32_t)};

	return smci_object_invoke(self, HDCP2P2_VERSION, a,
		 SMCI_OBJECT_COUNTS_PACK(0, 1, 0, 0));
}

static inline int32_t hdcp2p2_session_init(struct smci_object self, uint32_t deviceId_val,
		uint32_t *sessionId_ptr)
{
	union smci_object_arg a[2] = {{{0, 0}}};

	a[0].b = (struct smci_object_buf) {&deviceId_val, sizeof(uint32_t)};
	a[1].b = (struct smci_object_buf) {sessionId_ptr, sizeof(uint32_t)};

	return smci_object_invoke(self, HDCP2P2_SESSION_INIT, a,
		 SMCI_OBJECT_COUNTS_PACK(1, 1, 0, 0));
}

static inline int32_t hdcp2p2_session_deinit(struct smci_object self,
		  uint32_t sessionId_val)
{
	union smci_object_arg a[1] = {{{0, 0}}};

	a[0].b = (struct smci_object_buf) {&sessionId_val, sizeof(uint32_t)};

	return smci_object_invoke(self, HDCP2P2_SESSION_DEINIT, a,
		SMCI_OBJECT_COUNTS_PACK(1, 0, 0, 0));
}

static inline int32_t hdcp2p2_start_auth(struct smci_object self, uint32_t ctxhandle_val,
		  void *resMsg_ptr, size_t resMsg_len,
		  size_t *resMsg_lenout,
		  uint32_t *timeout_ptr,
		  uint32_t *flag_ptr,
		  uint32_t *tzctxhandle_ptr)
{
	union smci_object_arg a[3] = {{{0, 0}}};
	int32_t result = 0;
	struct {
		uint32_t m_timeout;
		uint32_t m_flag;
		uint32_t m_tzctxhandle;
	} o;

	a[1].b = (struct smci_object_buf) {&o, 12};
	a[0].b = (struct smci_object_buf) {&ctxhandle_val, sizeof(uint32_t)};
	a[2].b = (struct smci_object_buf) {resMsg_ptr, resMsg_len * 1};

	result = smci_object_invoke(self, HDCP2P2_START_AUTH, a,
		   SMCI_OBJECT_COUNTS_PACK(1, 2, 0, 0));

	*resMsg_lenout = a[2].b.size / 1;
	*timeout_ptr = o.m_timeout;
	*flag_ptr = o.m_flag;
	*tzctxhandle_ptr = o.m_tzctxhandle;

	return result;
}

static inline int32_t hdcp2p2_session_open_stream(struct smci_object self,
		   uint32_t sessionid_val,
		   uint32_t vcpayloadid_val,
		   uint32_t stream_number_val,
		   uint32_t streamMediaType_val,
		   uint32_t *resStreamId_ptr)
{
	union smci_object_arg a[2] = {{{0, 0}}};
	struct {
		uint32_t m_sessionid;
		uint32_t m_vcpayloadid;
		uint32_t m_stream_number;
		uint32_t m_streamMediaType;
	} i;

	a[0].b = (struct smci_object_buf) {&i, 16};
	i.m_sessionid = sessionid_val;
	i.m_vcpayloadid = vcpayloadid_val;
	i.m_stream_number = stream_number_val;
	i.m_streamMediaType = streamMediaType_val;
	a[1].b = (struct smci_object_buf) {resStreamId_ptr, sizeof(uint32_t)};

	return smci_object_invoke(self, HDCP2P2_SESSION_OPEN_STREAM, a,
		 SMCI_OBJECT_COUNTS_PACK(1, 1, 0, 0));
}

static inline int32_t hdcp2p2_session_close_stream(struct smci_object self,
		uint32_t sessionid_val,
		uint32_t streamId_val)
{
	union smci_object_arg a[1] = {{{0, 0}}};
	struct {
		uint32_t m_sessionid;
		uint32_t m_streamId;
	} i;

	a[0].b = (struct smci_object_buf) {&i, 8};
	i.m_sessionid = sessionid_val;
	i.m_streamId = streamId_val;

	return smci_object_invoke(self, HDCP2P2_SESSION_CLOSE_STREAM, a,
		 SMCI_OBJECT_COUNTS_PACK(1, 0, 0, 0));
}

static inline int32_t hdcp2p2_force_encryption(struct smci_object self,
		uint32_t ctxhandle_val,
		uint32_t enable_val)
{
	union smci_object_arg a[1] = {{{0, 0}}};
	struct {
		uint32_t m_ctxhandle;
		uint32_t m_enable;
	} i;

	a[0].b = (struct smci_object_buf) {&i, 8};
	i.m_ctxhandle = ctxhandle_val;
	i.m_enable = enable_val;

	return smci_object_invoke(self, HDCP2P2_FORCE_ENCRYPTION, a,
		 SMCI_OBJECT_COUNTS_PACK(1, 0, 0, 0));
}

static inline int32_t hdcp2p2_delete_pairing_info(struct smci_object self)
{
	return smci_object_invoke(self, HDCP2P2_DELETE_PAIRING_INFO, 0, 0);
}
