/*----------------------------------------------------------------------------*/
// (C) 2021 FCNT LIMITED
/*----------------------------------------------------------------------------*/
// SPDX-License-Identifier: GPL-2.0
//==============================================================================
// include file
//==============================================================================

#include <linux/init.h>
#include <linux/module.h>
#include <linux/workqueue.h>
#include <linux/soc/qcom/smem.h>
#include <linux/nonvolatile_common.h>

//==============================================================================
// define
//==============================================================================
#define APNV_MDM_MASTER_CLEAR_I		(41070)
#define FDR_MONITOR_DELAY			(3*HZ)
#define FDR_MONITOR_RETRY_NUM		(10)

//==============================================================================
// static valuable
//==============================================================================
static struct delayed_work			modem_fdr_monitor;
static unsigned char				mcflg_modem;
static bool							nvget_flag = false;
static unsigned long				retry_num = 0;
static bool							is_recovery = false;

//==============================================================================
// functions
//==============================================================================
static int __init custom_get_androidboot_mode(char *str)
{
	if (!strcmp(str, "recoverymenu")) {
		is_recovery = true;
	} else if (!strcmp(str, "fotamode")) {
		is_recovery = true;
	} else if (!strcmp(str, "osupdatemode")) {
		is_recovery = true;
	} else if (!strcmp(str, "masterclear")) {
		is_recovery = true;
	}
	return 0;
}
early_param("androidboot.mode", custom_get_androidboot_mode);

static void custom_fdrflag_monitor(struct work_struct *work)
{
	uint32_t* flag_p;
	int result, retry = 1;

	do {
		if (work == NULL) {
			break;
		}

		if (!nvget_flag) {
			result = get_nonvolatile((uint8_t*)&mcflg_modem, APNV_MDM_MASTER_CLEAR_I, sizeof(mcflg_modem));
			if (result < 0) {
				printk(KERN_ERR "[FDR monitor] Error get_nonvolatile.\n");
				break;
			}
			nvget_flag = true;
		}
		if (mcflg_modem == 0) {
			retry = 0;
			break;
		}

		flag_p = smem_alloc_vendor0(SMEM_OEM_V0_007);
		if (!flag_p) {
			printk(KERN_ERR "[FDR monitor] Error smem_alloc_vendor0.\n");
			break;
		}

		if (*flag_p == 0) {
			printk(KERN_INFO "[FDR monitor] FDR complete \n");
			mcflg_modem = 0;
			result = set_nonvolatile((uint8_t*)&mcflg_modem, APNV_MDM_MASTER_CLEAR_I, sizeof(mcflg_modem));
			retry = 0;
		} else {
			printk(KERN_INFO "[FDR monitor] FDR non completion %d \n", (unsigned int)*flag_p);
		}
	} while(0);

	if (retry) {
		if (retry_num < FDR_MONITOR_RETRY_NUM) {
			schedule_delayed_work(&modem_fdr_monitor, FDR_MONITOR_DELAY);
			retry_num++;
		}
	}

	return;
}
static int __init custom_fdr_monitor_init(void)
{
	if (!is_recovery) {
		INIT_DELAYED_WORK(&modem_fdr_monitor, custom_fdrflag_monitor);
		schedule_delayed_work(&modem_fdr_monitor, FDR_MONITOR_DELAY);
	}

	return 0;
}

static void __exit custom_fdr_monitor_exit(void)
{
	cancel_delayed_work_sync(&modem_fdr_monitor);
}

module_init(custom_fdr_monitor_init);
module_exit(custom_fdr_monitor_exit);

MODULE_LICENSE("GPL v2");
