/* SPDX-License-Identifier: GPL-2.0-only */
/* Copyright (c) 2015, 2018, 2020 The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __MSM_JPEGDMA_REGS_H__
#define __MSM_JPEGDMA_REGS_H__

#define MSM_JPEGDMA_HW_REVISION                  0x00
#define MSM_JPEGDMA_HW_CAPABILITY                0x04
#define MSM_JPEGDMA_HW_CAPABILITY_NUM_PIPES_BMSK 0x06
#define MSM_JPEGDMA_HW_CAPABILITY_NUM_PIPES_SHFT 0x01

#define MSM_JPEGDMA_IRQ_MASK_ADDR         0x0C
#define MSM_JPEGDMA_IRQ_MASK_SESSION_DONE (1 << 0)
#define MSM_JPEGDMA_IRQ_MASK_RD_BUF_DONE  (1 << 1)
#define MSM_JPEGDMA_IRQ_MASK_WR_BUF_DONE  (1 << 5)
#define MSM_JPEGDMA_IRQ_MASK_AXI_HALT     (1 << 9)
#define MSM_JPEGDMA_IRQ_MASK_RST_DONE     (1 << 10)

#define MSM_JPEGDMA_IRQ_STATUS              0x10
#define MSM_JPEGDMA_IRQ_STATUS_SESSION_DONE (1 << 0)
#define MSM_JPEGDMA_IRQ_STATUS_RD_BUF_DONE  (1 << 1)
#define MSM_JPEGDMA_IRQ_STATUS_WR_BUF_DONE  (1 << 5)
#define MSM_JPEGDMA_IRQ_STATUS_AXI_HALT     (1 << 9)
#define MSM_JPEGDMA_IRQ_STATUS_RST_DONE     (1 << 10)

#define MSM_JPEGDMA_IRQ_CLEAR_ADDR 0x14
#define MSM_JPEGDMA_IRQ_CLEAR_BMSK 0xFFFFFFFF

#define MSM_JPEGDMA_CORE_CFG_ADDR  0x18
#define MSM_JPEGDMA_CMD_ADDR       0x1C

#define MSM_JPEGDMA_CORE_CFG_TEST_BUS_ENABLE_SHFT  19
#define MSM_JPEGDMA_CORE_CFG_BRIDGE_ENABLE_SHFT    6
#define MSM_JPEGDMA_CORE_CFG_SCALE_1_ENABLE_SHFT   5
#define MSM_JPEGDMA_CORE_CFG_SCALE_0_ENABLE_SHFT   4

#define MSM_JPEGDMA_CORE_CFG_WE_1_ENABLE_SHFT 0x03
#define MSM_JPEGDMA_CORE_CFG_WE_0_ENABLE_SHFT 0x02
#define MSM_JPEGDMA_CORE_CFG_FE_1_ENABLE_SHFT 0x01
#define MSM_JPEGDMA_CORE_CFG_FE_0_ENABLE_SHFT 0x00

#define MSM_JPEGDMA_FE_0_CFG_ADDR                0x2C
#define MSM_JPEGDMA_FE_1_CFG_ADDR                0x70
#define MSM_JPEGDMA_FE_CFG_MAL_BOUNDARY_SHFT     25
#define MSM_JPEGDMA_FE_CFG_MAL_EN_SHFT           21
#define MSM_JPEGDMA_FE_CFG_PLN_BLOCK_TYPE_CBCR   0x03
#define MSM_JPEGDMA_FE_CFG_PLN_BLOCK_TYPE_CR     0x02
#define MSM_JPEGDMA_FE_CFG_PLN_BLOCK_TYPE_CB     0x01
#define MSM_JPEGDMA_FE_CFG_PLN_BLOCK_TYPE_Y      0x00
#define MSM_JPEGDMA_FE_CFG_PLN_BLOCK_TYPE_SHFT   19
#define MSM_JPEGDMA_FE_CFG_BLOCK_WIDTH_SHFT      0x04
#define MSM_JPEGDMA_FE_CFG_BURST_LENGTH_MAX_SHFT 0x00

#define MSM_JPEGDMA_FE_RD_0_PNTR_ADDR               0x34
#define MSM_JPEGDMA_FE_RD_1_PNTR_ADDR               0x78
#define MSM_JPEGDMA_FE_RD_BUFFER_SIZE_0_ADDR        0x44
#define MSM_JPEGDMA_FE_RD_BUFFER_SIZE_1_ADDR        0x88
#define MSM_JPEGDMA_FE_RD_BUFFER_SIZE_HEIGHT_SHFT   16
#define MSM_JPEGDMA_FE_RD_0_STRIDE_ADDR             0x48
#define MSM_JPEGDMA_FE_RD_1_STRIDE_ADDR             0x8C
#define MSM_JPEGDMA_FE_RD_0_HINIT_ADDR              0x4C
#define MSM_JPEGDMA_FE_RD_1_HINIT_ADDR              0x90
#define MSM_JPEGDMA_FE_RD_0_HINIT_INT_ADDR          0x50
#define MSM_JPEGDMA_FE_RD_1_HINIT_INT_ADDR          0x94
#define MSM_JPEGDMA_FE_RD_0_VINIT_INT_ADDR          0x58
#define MSM_JPEGDMA_FE_RD_1_VINIT_INT_ADDR          0x9C

#define MSM_JPEGDMA_WE_CFG_ADDR                          0xB8
#define MSM_JPEGDMA_WE_CFG_MAL_BOUNDARY_SHFT             0x08
#define MSM_JPEGDMA_WE_CFG_MAL_EN_SHFT                   0x07
#define MSM_JPEGDMA_WE_CFG_BURST_LENGTH_MAX_SHFT         0x00
#define MSM_JPEGDMA_WE_PLN_0_WR_PNTR_ADDR                0xBC
#define MSM_JPEGDMA_WE_PLN_1_WR_PNTR_ADDR                0xEC
#define MSM_JPEGDMA_WE_PLN_WR_BUFFER_SIZE_0_ADDR         0xC4
#define MSM_JPEGDMA_WE_PLN_WR_BUFFER_SIZE_1_ADDR         0xF4
#define MSM_JPEGDMA_WE_PLN_WR_BUFFER_SIZE_HEIGHT_SHFT    16
#define MSM_JPEGDMA_WE_PLN_0_WR_STRIDE_ADDR              0xC8
#define MSM_JPEGDMA_WE_PLN_1_WR_STRIDE_ADDR              0xF8
#define MSM_JPEGDMA_WE_PLN_0_WR_CFG_0_ADDR               0xCC
#define MSM_JPEGDMA_WE_PLN_1_WR_CFG_0_ADDR               0xFC
#define MSM_JPEGDMA_WE_PLN_WR_CFG_0_BLOCKS_PER_ROW_SHFT  16
#define MSM_JPEGDMA_WE_PLN_0_WR_CFG_1_ADDR               0xD0
#define MSM_JPEGDMA_WE_PLN_1_WR_CFG_1_ADDR               0x100
#define MSM_JPEGDMA_WE_PLN_WR_CFG_1_LAST_H_STEP_SHFT     16
#define MSM_JPEGDMA_WE_PLN_0_WR_CFG_2_ADDR               0xD4
#define MSM_JPEGDMA_WE_PLN_1_WR_CFG_2_ADDR               0x104
#define MSM_JPEGDMA_WE_PLN_WR_CFG_2_LAST_V_STEP_SHFT     16
#define MSM_JPEGDMA_WE_PLN_0_WR_CFG_3_ADDR               0xD8
#define MSM_JPEGDMA_WE_PLN_1_WR_CFG_3_ADDR               0x108

#define MSM_JPEGDMA_PP_0_SCALE_PHASEV_STEP_ADDR       0x19C
#define MSM_JPEGDMA_PP_1_SCALE_PHASEV_STEP_ADDR       0x1BC
#define MSM_JPEGDMA_PP_0_SCALE_PHASEH_STEP_ADDR       0x194
#define MSM_JPEGDMA_PP_1_SCALE_PHASEH_STEP_ADDR       0x1B4
#define MSM_JPEGDMA_PP_0_SCALE_CFG_ADDR               0x188
#define MSM_JPEGDMA_PP_1_SCALE_CFG_ADDR               0x1A8
#define MSM_JPEGDMA_PP_SCALE_CFG_VSCALE_ENABLE_SHFT   0x05
#define MSM_JPEGDMA_PP_SCALE_CFG_HSCALE_ENABLE_SHFT   0x04

#define MSM_JPEGDMA_S0_MMU_PF_ADDR_MIN                0x190
#define MSM_JPEGDMA_S0_MMU_PF_ADDR_MAX                0x198
#define MSM_JPEGDMA_S1_MMU_PF_ADDR_MIN                0x1A4
#define MSM_JPEGDMA_S1_MMU_PF_ADDR_MAX                0x1AC

#define MSM_JPEGDMA_CMD_CLEAR_READ_PLN_QUEUES         0x030
#define MSM_JPEGDMA_CMD_CLEAR_WRITE_PLN_QUEUES        0x300

#define MSM_HW_JPEGDMA_RESET                          0x08
#define MSM_HW_JPEGDMA_RESET_DEFAULT                  0x32083

#define MSM_JPEGDMA_RESET_CMD_BMSK                    0xFFFFFFFF

#endif /* __MSM_JPEG_DMA_REGS_H__ */
