/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2019, The Linux Foundation. All rights reserved.
 */
#if !defined(_GSI_HWIO_H_)
#define _GSI_HWIO_H_
/*
 *
 * HWIO register definitions to follow:
 *
 */
#define GSI_REG_BASE (IPA_0_IPA_WRAPPER_BASE + 0x00004000)
#define GSI_REG_BASE_PHYS (IPA_0_IPA_WRAPPER_BASE_PHYS + 0x00004000)
#define GSI_REG_BASE_OFFS 0x00004000
#define HWIO_GSI_CFG_ADDR (GSI_REG_BASE + 0x00000000)
#define HWIO_GSI_CFG_PHYS (GSI_REG_BASE_PHYS + 0x00000000)
#define HWIO_GSI_CFG_OFFS (GSI_REG_BASE_OFFS + 0x00000000)
#define HWIO_GSI_CFG_RMSK 0xf3f
#define HWIO_GSI_CFG_ATTR 0x3
#define HWIO_GSI_CFG_IN in_dword_masked(HWIO_GSI_CFG_ADDR, \
					HWIO_GSI_CFG_RMSK)
#define HWIO_GSI_CFG_INM(m) in_dword_masked(HWIO_GSI_CFG_ADDR, m)
#define HWIO_GSI_CFG_OUT(v) out_dword(HWIO_GSI_CFG_ADDR, v)
#define HWIO_GSI_CFG_OUTM(m, v) out_dword_masked_ns(HWIO_GSI_CFG_ADDR, \
						    m, \
						    v, \
						    HWIO_GSI_CFG_IN)
#define HWIO_GSI_CFG_SLEEP_CLK_DIV_BMSK 0xf00
#define HWIO_GSI_CFG_SLEEP_CLK_DIV_SHFT 0x8
#define HWIO_GSI_CFG_BP_MTRIX_DISABLE_BMSK 0x20
#define HWIO_GSI_CFG_BP_MTRIX_DISABLE_SHFT 0x5
#define HWIO_GSI_CFG_GSI_PWR_CLPS_BMSK 0x10
#define HWIO_GSI_CFG_GSI_PWR_CLPS_SHFT 0x4
#define HWIO_GSI_CFG_UC_IS_MCS_BMSK 0x8
#define HWIO_GSI_CFG_UC_IS_MCS_SHFT 0x3
#define HWIO_GSI_CFG_DOUBLE_MCS_CLK_FREQ_BMSK 0x4
#define HWIO_GSI_CFG_DOUBLE_MCS_CLK_FREQ_SHFT 0x2
#define HWIO_GSI_CFG_MCS_ENABLE_BMSK 0x2
#define HWIO_GSI_CFG_MCS_ENABLE_SHFT 0x1
#define HWIO_GSI_CFG_GSI_ENABLE_BMSK 0x1
#define HWIO_GSI_CFG_GSI_ENABLE_SHFT 0x0
#define HWIO_GSI_MANAGER_MCS_CODE_VER_ADDR (GSI_REG_BASE + 0x00000008)
#define HWIO_GSI_MANAGER_MCS_CODE_VER_PHYS (GSI_REG_BASE_PHYS + 0x00000008)
#define HWIO_GSI_MANAGER_MCS_CODE_VER_OFFS (GSI_REG_BASE_OFFS + 0x00000008)
#define HWIO_GSI_ZEROS_ADDR (GSI_REG_BASE + 0x00000010)
#define HWIO_GSI_ZEROS_PHYS (GSI_REG_BASE_PHYS + 0x00000010)
#define HWIO_GSI_ZEROS_OFFS (GSI_REG_BASE_OFFS + 0x00000010)
#define HWIO_GSI_PERIPH_BASE_ADDR_LSB_ADDR (GSI_REG_BASE + 0x00000018)
#define HWIO_GSI_PERIPH_BASE_ADDR_LSB_PHYS (GSI_REG_BASE_PHYS + 0x00000018)
#define HWIO_GSI_PERIPH_BASE_ADDR_LSB_OFFS (GSI_REG_BASE_OFFS + 0x00000018)
#define HWIO_GSI_PERIPH_BASE_ADDR_MSB_ADDR (GSI_REG_BASE + 0x0000001c)
#define HWIO_GSI_PERIPH_BASE_ADDR_MSB_PHYS (GSI_REG_BASE_PHYS + 0x0000001c)
#define HWIO_GSI_PERIPH_BASE_ADDR_MSB_OFFS (GSI_REG_BASE_OFFS + 0x0000001c)
#define HWIO_GSI_PERIPH_PENDING_ADDR (GSI_REG_BASE + 0x00000020)
#define HWIO_GSI_PERIPH_PENDING_PHYS (GSI_REG_BASE_PHYS + 0x00000020)
#define HWIO_GSI_PERIPH_PENDING_OFFS (GSI_REG_BASE_OFFS + 0x00000020)
#define HWIO_GSI_MOQA_CFG_ADDR (GSI_REG_BASE + 0x00000030)
#define HWIO_GSI_MOQA_CFG_PHYS (GSI_REG_BASE_PHYS + 0x00000030)
#define HWIO_GSI_MOQA_CFG_OFFS (GSI_REG_BASE_OFFS + 0x00000030)
#define HWIO_GSI_REE_CFG_ADDR (GSI_REG_BASE + 0x00000038)
#define HWIO_GSI_REE_CFG_PHYS (GSI_REG_BASE_PHYS + 0x00000038)
#define HWIO_GSI_REE_CFG_OFFS (GSI_REG_BASE_OFFS + 0x00000038)
#define HWIO_GSI_REE_CFG_RMSK 0xff03
#define HWIO_GSI_REE_CFG_ATTR 0x3
#define HWIO_GSI_REE_CFG_IN in_dword_masked(HWIO_GSI_REE_CFG_ADDR, \
					    HWIO_GSI_REE_CFG_RMSK)
#define HWIO_GSI_REE_CFG_INM(m) in_dword_masked(HWIO_GSI_REE_CFG_ADDR, m)
#define HWIO_GSI_REE_CFG_OUT(v) out_dword(HWIO_GSI_REE_CFG_ADDR, v)
#define HWIO_GSI_REE_CFG_OUTM(m, v) out_dword_masked_ns( \
		HWIO_GSI_REE_CFG_ADDR, \
		m, \
		v, \
		HWIO_GSI_REE_CFG_IN)
#define HWIO_GSI_REE_CFG_MAX_BURST_SIZE_BMSK 0xff00
#define HWIO_GSI_REE_CFG_MAX_BURST_SIZE_SHFT 0x8
#define HWIO_GSI_REE_CFG_CHANNEL_EMPTY_INT_ENABLE_BMSK 0x2
#define HWIO_GSI_REE_CFG_CHANNEL_EMPTY_INT_ENABLE_SHFT 0x1
#define HWIO_GSI_REE_CFG_MOVE_TO_ESC_CLR_MODE_TRSH_BMSK 0x1
#define HWIO_GSI_REE_CFG_MOVE_TO_ESC_CLR_MODE_TRSH_SHFT 0x0
#define HWIO_GSI_CGC_CTRL_ADDR (GSI_REG_BASE + 0x00000060)
#define HWIO_GSI_CGC_CTRL_PHYS (GSI_REG_BASE_PHYS + 0x00000060)
#define HWIO_GSI_CGC_CTRL_OFFS (GSI_REG_BASE_OFFS + 0x00000060)
#define HWIO_GSI_MSI_CACHEATTR_ADDR (GSI_REG_BASE + 0x00000080)
#define HWIO_GSI_MSI_CACHEATTR_PHYS (GSI_REG_BASE_PHYS + 0x00000080)
#define HWIO_GSI_MSI_CACHEATTR_OFFS (GSI_REG_BASE_OFFS + 0x00000080)
#define HWIO_GSI_EVENT_CACHEATTR_ADDR (GSI_REG_BASE + 0x00000084)
#define HWIO_GSI_EVENT_CACHEATTR_PHYS (GSI_REG_BASE_PHYS + 0x00000084)
#define HWIO_GSI_EVENT_CACHEATTR_OFFS (GSI_REG_BASE_OFFS + 0x00000084)
#define HWIO_GSI_DATA_CACHEATTR_ADDR (GSI_REG_BASE + 0x00000088)
#define HWIO_GSI_DATA_CACHEATTR_PHYS (GSI_REG_BASE_PHYS + 0x00000088)
#define HWIO_GSI_DATA_CACHEATTR_OFFS (GSI_REG_BASE_OFFS + 0x00000088)
#define HWIO_GSI_TRE_CACHEATTR_ADDR (GSI_REG_BASE + 0x00000090)
#define HWIO_GSI_TRE_CACHEATTR_PHYS (GSI_REG_BASE_PHYS + 0x00000090)
#define HWIO_GSI_TRE_CACHEATTR_OFFS (GSI_REG_BASE_OFFS + 0x00000090)
#define HWIO_IC_DISABLE_CHNL_BCK_PRS_LSB_ADDR (GSI_REG_BASE + 0x000000a0)
#define HWIO_IC_DISABLE_CHNL_BCK_PRS_LSB_PHYS (GSI_REG_BASE_PHYS + \
					       0x000000a0)
#define HWIO_IC_DISABLE_CHNL_BCK_PRS_LSB_OFFS (GSI_REG_BASE_OFFS + \
					       0x000000a0)
#define HWIO_IC_DISABLE_CHNL_BCK_PRS_MSB_ADDR (GSI_REG_BASE + 0x000000a4)
#define HWIO_IC_DISABLE_CHNL_BCK_PRS_MSB_PHYS (GSI_REG_BASE_PHYS + \
					       0x000000a4)
#define HWIO_IC_DISABLE_CHNL_BCK_PRS_MSB_OFFS (GSI_REG_BASE_OFFS + \
					       0x000000a4)
#define HWIO_IC_GEN_EVNT_BCK_PRS_LSB_ADDR (GSI_REG_BASE + 0x000000a8)
#define HWIO_IC_GEN_EVNT_BCK_PRS_LSB_PHYS (GSI_REG_BASE_PHYS + 0x000000a8)
#define HWIO_IC_GEN_EVNT_BCK_PRS_LSB_OFFS (GSI_REG_BASE_OFFS + 0x000000a8)
#define HWIO_IC_GEN_EVNT_BCK_PRS_MSB_ADDR (GSI_REG_BASE + 0x000000ac)
#define HWIO_IC_GEN_EVNT_BCK_PRS_MSB_PHYS (GSI_REG_BASE_PHYS + 0x000000ac)
#define HWIO_IC_GEN_EVNT_BCK_PRS_MSB_OFFS (GSI_REG_BASE_OFFS + 0x000000ac)
#define HWIO_IC_GEN_INT_BCK_PRS_LSB_ADDR (GSI_REG_BASE + 0x000000b0)
#define HWIO_IC_GEN_INT_BCK_PRS_LSB_PHYS (GSI_REG_BASE_PHYS + 0x000000b0)
#define HWIO_IC_GEN_INT_BCK_PRS_LSB_OFFS (GSI_REG_BASE_OFFS + 0x000000b0)
#define HWIO_IC_GEN_INT_BCK_PRS_MSB_ADDR (GSI_REG_BASE + 0x000000b4)
#define HWIO_IC_GEN_INT_BCK_PRS_MSB_PHYS (GSI_REG_BASE_PHYS + 0x000000b4)
#define HWIO_IC_GEN_INT_BCK_PRS_MSB_OFFS (GSI_REG_BASE_OFFS + 0x000000b4)
#define HWIO_IC_STOP_INT_MOD_BCK_PRS_LSB_ADDR (GSI_REG_BASE + 0x000000b8)
#define HWIO_IC_STOP_INT_MOD_BCK_PRS_LSB_PHYS (GSI_REG_BASE_PHYS + \
					       0x000000b8)
#define HWIO_IC_STOP_INT_MOD_BCK_PRS_LSB_OFFS (GSI_REG_BASE_OFFS + \
					       0x000000b8)
#define HWIO_IC_STOP_INT_MOD_BCK_PRS_MSB_ADDR (GSI_REG_BASE + 0x000000bc)
#define HWIO_IC_STOP_INT_MOD_BCK_PRS_MSB_PHYS (GSI_REG_BASE_PHYS + \
					       0x000000bc)
#define HWIO_IC_STOP_INT_MOD_BCK_PRS_MSB_OFFS (GSI_REG_BASE_OFFS + \
					       0x000000bc)
#define HWIO_IC_PROCESS_DESC_BCK_PRS_LSB_ADDR (GSI_REG_BASE + 0x000000c0)
#define HWIO_IC_PROCESS_DESC_BCK_PRS_LSB_PHYS (GSI_REG_BASE_PHYS + \
					       0x000000c0)
#define HWIO_IC_PROCESS_DESC_BCK_PRS_LSB_OFFS (GSI_REG_BASE_OFFS + \
					       0x000000c0)
#define HWIO_IC_PROCESS_DESC_BCK_PRS_MSB_ADDR (GSI_REG_BASE + 0x000000c4)
#define HWIO_IC_PROCESS_DESC_BCK_PRS_MSB_PHYS (GSI_REG_BASE_PHYS + \
					       0x000000c4)
#define HWIO_IC_PROCESS_DESC_BCK_PRS_MSB_OFFS (GSI_REG_BASE_OFFS + \
					       0x000000c4)
#define HWIO_IC_TLV_STOP_BCK_PRS_LSB_ADDR (GSI_REG_BASE + 0x000000c8)
#define HWIO_IC_TLV_STOP_BCK_PRS_LSB_PHYS (GSI_REG_BASE_PHYS + 0x000000c8)
#define HWIO_IC_TLV_STOP_BCK_PRS_LSB_OFFS (GSI_REG_BASE_OFFS + 0x000000c8)
#define HWIO_IC_TLV_STOP_BCK_PRS_MSB_ADDR (GSI_REG_BASE + 0x000000cc)
#define HWIO_IC_TLV_STOP_BCK_PRS_MSB_PHYS (GSI_REG_BASE_PHYS + 0x000000cc)
#define HWIO_IC_TLV_STOP_BCK_PRS_MSB_OFFS (GSI_REG_BASE_OFFS + 0x000000cc)
#define HWIO_IC_TLV_RESET_BCK_PRS_LSB_ADDR (GSI_REG_BASE + 0x000000d0)
#define HWIO_IC_TLV_RESET_BCK_PRS_LSB_PHYS (GSI_REG_BASE_PHYS + 0x000000d0)
#define HWIO_IC_TLV_RESET_BCK_PRS_LSB_OFFS (GSI_REG_BASE_OFFS + 0x000000d0)
#define HWIO_IC_TLV_RESET_BCK_PRS_MSB_ADDR (GSI_REG_BASE + 0x000000d4)
#define HWIO_IC_TLV_RESET_BCK_PRS_MSB_PHYS (GSI_REG_BASE_PHYS + 0x000000d4)
#define HWIO_IC_TLV_RESET_BCK_PRS_MSB_OFFS (GSI_REG_BASE_OFFS + 0x000000d4)
#define HWIO_IC_RGSTR_TIMER_BCK_PRS_LSB_ADDR (GSI_REG_BASE + 0x000000d8)
#define HWIO_IC_RGSTR_TIMER_BCK_PRS_LSB_PHYS (GSI_REG_BASE_PHYS + \
					      0x000000d8)
#define HWIO_IC_RGSTR_TIMER_BCK_PRS_LSB_OFFS (GSI_REG_BASE_OFFS + \
					      0x000000d8)
#define HWIO_IC_RGSTR_TIMER_BCK_PRS_MSB_ADDR (GSI_REG_BASE + 0x000000dc)
#define HWIO_IC_RGSTR_TIMER_BCK_PRS_MSB_PHYS (GSI_REG_BASE_PHYS + \
					      0x000000dc)
#define HWIO_IC_RGSTR_TIMER_BCK_PRS_MSB_OFFS (GSI_REG_BASE_OFFS + \
					      0x000000dc)
#define HWIO_IC_READ_BCK_PRS_LSB_ADDR (GSI_REG_BASE + 0x000000e0)
#define HWIO_IC_READ_BCK_PRS_LSB_PHYS (GSI_REG_BASE_PHYS + 0x000000e0)
#define HWIO_IC_READ_BCK_PRS_LSB_OFFS (GSI_REG_BASE_OFFS + 0x000000e0)
#define HWIO_IC_READ_BCK_PRS_MSB_ADDR (GSI_REG_BASE + 0x000000e4)
#define HWIO_IC_READ_BCK_PRS_MSB_PHYS (GSI_REG_BASE_PHYS + 0x000000e4)
#define HWIO_IC_READ_BCK_PRS_MSB_OFFS (GSI_REG_BASE_OFFS + 0x000000e4)
#define HWIO_IC_WRITE_BCK_PRS_LSB_ADDR (GSI_REG_BASE + 0x000000e8)
#define HWIO_IC_WRITE_BCK_PRS_LSB_PHYS (GSI_REG_BASE_PHYS + 0x000000e8)
#define HWIO_IC_WRITE_BCK_PRS_LSB_OFFS (GSI_REG_BASE_OFFS + 0x000000e8)
#define HWIO_IC_WRITE_BCK_PRS_MSB_ADDR (GSI_REG_BASE + 0x000000ec)
#define HWIO_IC_WRITE_BCK_PRS_MSB_PHYS (GSI_REG_BASE_PHYS + 0x000000ec)
#define HWIO_IC_WRITE_BCK_PRS_MSB_OFFS (GSI_REG_BASE_OFFS + 0x000000ec)
#define HWIO_IC_UCONTROLLER_GPR_BCK_PRS_LSB_ADDR (GSI_REG_BASE + \
						  0x000000f0)
#define HWIO_IC_UCONTROLLER_GPR_BCK_PRS_LSB_PHYS (GSI_REG_BASE_PHYS + \
						  0x000000f0)
#define HWIO_IC_UCONTROLLER_GPR_BCK_PRS_LSB_OFFS (GSI_REG_BASE_OFFS + \
						  0x000000f0)
#define HWIO_IC_UCONTROLLER_GPR_BCK_PRS_MSB_ADDR (GSI_REG_BASE + \
						  0x000000f4)
#define HWIO_IC_UCONTROLLER_GPR_BCK_PRS_MSB_PHYS (GSI_REG_BASE_PHYS + \
						  0x000000f4)
#define HWIO_IC_UCONTROLLER_GPR_BCK_PRS_MSB_OFFS (GSI_REG_BASE_OFFS + \
						  0x000000f4)
#define HWIO_IC_INT_WEIGHT_REE_ADDR (GSI_REG_BASE + 0x00000100)
#define HWIO_IC_INT_WEIGHT_REE_PHYS (GSI_REG_BASE_PHYS + 0x00000100)
#define HWIO_IC_INT_WEIGHT_REE_OFFS (GSI_REG_BASE_OFFS + 0x00000100)
#define HWIO_IC_INT_WEIGHT_EVT_ENG_ADDR (GSI_REG_BASE + 0x00000104)
#define HWIO_IC_INT_WEIGHT_EVT_ENG_PHYS (GSI_REG_BASE_PHYS + 0x00000104)
#define HWIO_IC_INT_WEIGHT_EVT_ENG_OFFS (GSI_REG_BASE_OFFS + 0x00000104)
#define HWIO_IC_INT_WEIGHT_INT_ENG_ADDR (GSI_REG_BASE + 0x00000108)
#define HWIO_IC_INT_WEIGHT_INT_ENG_PHYS (GSI_REG_BASE_PHYS + 0x00000108)
#define HWIO_IC_INT_WEIGHT_INT_ENG_OFFS (GSI_REG_BASE_OFFS + 0x00000108)
#define HWIO_IC_INT_WEIGHT_CSR_ADDR (GSI_REG_BASE + 0x0000010c)
#define HWIO_IC_INT_WEIGHT_CSR_PHYS (GSI_REG_BASE_PHYS + 0x0000010c)
#define HWIO_IC_INT_WEIGHT_CSR_OFFS (GSI_REG_BASE_OFFS + 0x0000010c)
#define HWIO_IC_INT_WEIGHT_TLV_ENG_ADDR (GSI_REG_BASE + 0x00000110)
#define HWIO_IC_INT_WEIGHT_TLV_ENG_PHYS (GSI_REG_BASE_PHYS + 0x00000110)
#define HWIO_IC_INT_WEIGHT_TLV_ENG_OFFS (GSI_REG_BASE_OFFS + 0x00000110)
#define HWIO_IC_INT_WEIGHT_TIMER_ENG_ADDR (GSI_REG_BASE + 0x00000114)
#define HWIO_IC_INT_WEIGHT_TIMER_ENG_PHYS (GSI_REG_BASE_PHYS + 0x00000114)
#define HWIO_IC_INT_WEIGHT_TIMER_ENG_OFFS (GSI_REG_BASE_OFFS + 0x00000114)
#define HWIO_IC_INT_WEIGHT_DB_ENG_ADDR (GSI_REG_BASE + 0x00000118)
#define HWIO_IC_INT_WEIGHT_DB_ENG_PHYS (GSI_REG_BASE_PHYS + 0x00000118)
#define HWIO_IC_INT_WEIGHT_DB_ENG_OFFS (GSI_REG_BASE_OFFS + 0x00000118)
#define HWIO_IC_INT_WEIGHT_RD_WR_ENG_ADDR (GSI_REG_BASE + 0x0000011c)
#define HWIO_IC_INT_WEIGHT_RD_WR_ENG_PHYS (GSI_REG_BASE_PHYS + 0x0000011c)
#define HWIO_IC_INT_WEIGHT_RD_WR_ENG_OFFS (GSI_REG_BASE_OFFS + 0x0000011c)
#define HWIO_IC_INT_WEIGHT_UCONTROLLER_ENG_ADDR (GSI_REG_BASE + 0x00000120)
#define HWIO_IC_INT_WEIGHT_UCONTROLLER_ENG_PHYS (GSI_REG_BASE_PHYS + \
						 0x00000120)
#define HWIO_IC_INT_WEIGHT_UCONTROLLER_ENG_OFFS (GSI_REG_BASE_OFFS + \
						 0x00000120)
#define HWIO_IC_INT_WEIGHT_SDMA_ADDR (GSI_REG_BASE + 0x00000124)
#define HWIO_IC_INT_WEIGHT_SDMA_PHYS (GSI_REG_BASE_PHYS + 0x00000124)
#define HWIO_IC_INT_WEIGHT_SDMA_OFFS (GSI_REG_BASE_OFFS + 0x00000124)
#define HWIO_GSI_SDMA_CFG_ADDR (GSI_REG_BASE + 0x0000003c)
#define HWIO_GSI_SDMA_CFG_PHYS (GSI_REG_BASE_PHYS + 0x0000003c)
#define HWIO_GSI_SDMA_CFG_OFFS (GSI_REG_BASE_OFFS + 0x0000003c)
#define HWIO_GSI_SDMA_CACHEATTR_ADDR (GSI_REG_BASE + 0x00000094)
#define HWIO_GSI_SDMA_CACHEATTR_PHYS (GSI_REG_BASE_PHYS + 0x00000094)
#define HWIO_GSI_SDMA_CACHEATTR_OFFS (GSI_REG_BASE_OFFS + 0x00000094)
#define HWIO_GSI_SDMA_SG_IOVEC_LSB_n_ADDR(n) (GSI_REG_BASE + 0x00000140 + \
					      0x8 * (n))
#define HWIO_GSI_SDMA_SG_IOVEC_LSB_n_PHYS(n) (GSI_REG_BASE_PHYS + \
					      0x00000140 + 0x8 * (n))
#define HWIO_GSI_SDMA_SG_IOVEC_LSB_n_OFFS(n) (GSI_REG_BASE_OFFS + \
					      0x00000140 + 0x8 * (n))
#define HWIO_GSI_SDMA_SG_IOVEC_MSB_n_ADDR(n) (GSI_REG_BASE + 0x00000144 + \
					      0x8 * (n))
#define HWIO_GSI_SDMA_SG_IOVEC_MSB_n_PHYS(n) (GSI_REG_BASE_PHYS + \
					      0x00000144 + 0x8 * (n))
#define HWIO_GSI_SDMA_SG_IOVEC_MSB_n_OFFS(n) (GSI_REG_BASE_OFFS + \
					      0x00000144 + 0x8 * (n))
#define HWIO_GSI_MANAGER_EE_QOS_n_ADDR(n) (GSI_REG_BASE + 0x00000300 + \
					   0x4 * (n))
#define HWIO_GSI_MANAGER_EE_QOS_n_PHYS(n) (GSI_REG_BASE_PHYS + \
					   0x00000300 + 0x4 * (n))
#define HWIO_GSI_MANAGER_EE_QOS_n_OFFS(n) (GSI_REG_BASE_OFFS + \
					   0x00000300 + 0x4 * (n))
#define HWIO_GSI_SHRAM_PTR_CH_CNTXT_BASE_ADDR_ADDR (GSI_REG_BASE + \
						    0x00000200)
#define HWIO_GSI_SHRAM_PTR_CH_CNTXT_BASE_ADDR_PHYS (GSI_REG_BASE_PHYS +	\
						    0x00000200)
#define HWIO_GSI_SHRAM_PTR_CH_CNTXT_BASE_ADDR_OFFS (GSI_REG_BASE_OFFS +	\
						    0x00000200)
#define HWIO_GSI_SHRAM_PTR_EV_CNTXT_BASE_ADDR_ADDR (GSI_REG_BASE + \
						    0x00000204)
#define HWIO_GSI_SHRAM_PTR_EV_CNTXT_BASE_ADDR_PHYS (GSI_REG_BASE_PHYS +	\
						    0x00000204)
#define HWIO_GSI_SHRAM_PTR_EV_CNTXT_BASE_ADDR_OFFS (GSI_REG_BASE_OFFS +	\
						    0x00000204)
#define HWIO_GSI_SHRAM_PTR_RE_STORAGE_BASE_ADDR_ADDR (GSI_REG_BASE + \
						      0x00000208)
#define HWIO_GSI_SHRAM_PTR_RE_STORAGE_BASE_ADDR_PHYS (GSI_REG_BASE_PHYS + \
						      0x00000208)
#define HWIO_GSI_SHRAM_PTR_RE_STORAGE_BASE_ADDR_OFFS (GSI_REG_BASE_OFFS + \
						      0x00000208)
#define HWIO_GSI_SHRAM_PTR_RE_ESC_BUF_BASE_ADDR_ADDR (GSI_REG_BASE + \
						      0x0000020c)
#define HWIO_GSI_SHRAM_PTR_RE_ESC_BUF_BASE_ADDR_PHYS (GSI_REG_BASE_PHYS + \
						      0x0000020c)
#define HWIO_GSI_SHRAM_PTR_RE_ESC_BUF_BASE_ADDR_OFFS (GSI_REG_BASE_OFFS + \
						      0x0000020c)
#define HWIO_GSI_SHRAM_PTR_EE_SCRACH_BASE_ADDR_ADDR (GSI_REG_BASE + \
						     0x00000240)
#define HWIO_GSI_SHRAM_PTR_EE_SCRACH_BASE_ADDR_PHYS (GSI_REG_BASE_PHYS + \
						     0x00000240)
#define HWIO_GSI_SHRAM_PTR_EE_SCRACH_BASE_ADDR_OFFS (GSI_REG_BASE_OFFS + \
						     0x00000240)
#define HWIO_GSI_SHRAM_PTR_FUNC_STACK_BASE_ADDR_ADDR (GSI_REG_BASE + \
						      0x00000244)
#define HWIO_GSI_SHRAM_PTR_FUNC_STACK_BASE_ADDR_PHYS (GSI_REG_BASE_PHYS + \
						      0x00000244)
#define HWIO_GSI_SHRAM_PTR_FUNC_STACK_BASE_ADDR_OFFS (GSI_REG_BASE_OFFS + \
						      0x00000244)
#define HWIO_GSI_SHRAM_PTR_MCS_SCRATCH_BASE_ADDR_ADDR (GSI_REG_BASE + \
						       0x00000248)
#define HWIO_GSI_SHRAM_PTR_MCS_SCRATCH_BASE_ADDR_PHYS (GSI_REG_BASE_PHYS + \
						       0x00000248)
#define HWIO_GSI_SHRAM_PTR_MCS_SCRATCH_BASE_ADDR_OFFS (GSI_REG_BASE_OFFS + \
						       0x00000248)
#define HWIO_GSI_SHRAM_PTR_MCS_SCRATCH1_BASE_ADDR_ADDR (GSI_REG_BASE + \
							0x0000024c)
#define HWIO_GSI_SHRAM_PTR_MCS_SCRATCH1_BASE_ADDR_PHYS (GSI_REG_BASE_PHYS \
							+ 0x0000024c)
#define HWIO_GSI_SHRAM_PTR_MCS_SCRATCH1_BASE_ADDR_OFFS (GSI_REG_BASE_OFFS \
							+ 0x0000024c)
#define HWIO_GSI_SHRAM_PTR_MCS_SCRATCH2_BASE_ADDR_ADDR (GSI_REG_BASE + \
							0x00000250)
#define HWIO_GSI_SHRAM_PTR_MCS_SCRATCH2_BASE_ADDR_PHYS (GSI_REG_BASE_PHYS \
							+ 0x00000250)
#define HWIO_GSI_SHRAM_PTR_MCS_SCRATCH2_BASE_ADDR_OFFS (GSI_REG_BASE_OFFS \
							+ 0x00000250)
#define HWIO_GSI_SHRAM_PTR_CH_VP_TRANS_TABLE_BASE_ADDR_ADDR (GSI_REG_BASE \
							     + 0x00000254)
#define HWIO_GSI_SHRAM_PTR_CH_VP_TRANS_TABLE_BASE_ADDR_PHYS ( \
		GSI_REG_BASE_PHYS + 0x00000254)
#define HWIO_GSI_SHRAM_PTR_CH_VP_TRANS_TABLE_BASE_ADDR_OFFS ( \
		GSI_REG_BASE_OFFS + 0x00000254)
#define HWIO_GSI_SHRAM_PTR_EV_VP_TRANS_TABLE_BASE_ADDR_ADDR (GSI_REG_BASE \
							     + 0x00000258)
#define HWIO_GSI_SHRAM_PTR_EV_VP_TRANS_TABLE_BASE_ADDR_PHYS ( \
		GSI_REG_BASE_PHYS + 0x00000258)
#define HWIO_GSI_SHRAM_PTR_EV_VP_TRANS_TABLE_BASE_ADDR_OFFS ( \
		GSI_REG_BASE_OFFS + 0x00000258)
#define HWIO_GSI_SHRAM_PTR_USER_INFO_DATA_BASE_ADDR_ADDR (GSI_REG_BASE + \
							  0x0000025c)
#define HWIO_GSI_SHRAM_PTR_USER_INFO_DATA_BASE_ADDR_PHYS ( \
		GSI_REG_BASE_PHYS + 0x0000025c)
#define HWIO_GSI_SHRAM_PTR_USER_INFO_DATA_BASE_ADDR_OFFS ( \
		GSI_REG_BASE_OFFS + 0x0000025c)
#define HWIO_GSI_SHRAM_PTR_EE_CMD_FIFO_BASE_ADDR_ADDR (GSI_REG_BASE + \
						       0x00000260)
#define HWIO_GSI_SHRAM_PTR_EE_CMD_FIFO_BASE_ADDR_PHYS (GSI_REG_BASE_PHYS + \
						       0x00000260)
#define HWIO_GSI_SHRAM_PTR_EE_CMD_FIFO_BASE_ADDR_OFFS (GSI_REG_BASE_OFFS + \
						       0x00000260)
#define HWIO_GSI_SHRAM_PTR_CH_CMD_FIFO_BASE_ADDR_ADDR (GSI_REG_BASE + \
						       0x00000264)
#define HWIO_GSI_SHRAM_PTR_CH_CMD_FIFO_BASE_ADDR_PHYS (GSI_REG_BASE_PHYS + \
						       0x00000264)
#define HWIO_GSI_SHRAM_PTR_CH_CMD_FIFO_BASE_ADDR_OFFS (GSI_REG_BASE_OFFS + \
						       0x00000264)
#define HWIO_GSI_IRAM_PTR_CH_CMD_ADDR (GSI_REG_BASE + 0x00000400)
#define HWIO_GSI_IRAM_PTR_CH_CMD_PHYS (GSI_REG_BASE_PHYS + 0x00000400)
#define HWIO_GSI_IRAM_PTR_CH_CMD_OFFS (GSI_REG_BASE_OFFS + 0x00000400)
#define HWIO_GSI_IRAM_PTR_EE_GENERIC_CMD_ADDR (GSI_REG_BASE + 0x00000404)
#define HWIO_GSI_IRAM_PTR_EE_GENERIC_CMD_PHYS (GSI_REG_BASE_PHYS + \
					       0x00000404)
#define HWIO_GSI_IRAM_PTR_EE_GENERIC_CMD_OFFS (GSI_REG_BASE_OFFS + \
					       0x00000404)
#define HWIO_GSI_IRAM_PTR_TLV_CH_NOT_FULL_ADDR (GSI_REG_BASE + 0x00000408)
#define HWIO_GSI_IRAM_PTR_TLV_CH_NOT_FULL_PHYS (GSI_REG_BASE_PHYS + \
						0x00000408)
#define HWIO_GSI_IRAM_PTR_TLV_CH_NOT_FULL_OFFS (GSI_REG_BASE_OFFS + \
						0x00000408)
#define HWIO_GSI_IRAM_PTR_CH_DB_ADDR (GSI_REG_BASE + 0x00000418)
#define HWIO_GSI_IRAM_PTR_CH_DB_PHYS (GSI_REG_BASE_PHYS + 0x00000418)
#define HWIO_GSI_IRAM_PTR_CH_DB_OFFS (GSI_REG_BASE_OFFS + 0x00000418)
#define HWIO_GSI_IRAM_PTR_EV_DB_ADDR (GSI_REG_BASE + 0x0000041c)
#define HWIO_GSI_IRAM_PTR_EV_DB_PHYS (GSI_REG_BASE_PHYS + 0x0000041c)
#define HWIO_GSI_IRAM_PTR_EV_DB_OFFS (GSI_REG_BASE_OFFS + 0x0000041c)
#define HWIO_GSI_IRAM_PTR_NEW_RE_ADDR (GSI_REG_BASE + 0x00000420)
#define HWIO_GSI_IRAM_PTR_NEW_RE_PHYS (GSI_REG_BASE_PHYS + 0x00000420)
#define HWIO_GSI_IRAM_PTR_NEW_RE_OFFS (GSI_REG_BASE_OFFS + 0x00000420)
#define HWIO_GSI_IRAM_PTR_CH_DIS_COMP_ADDR (GSI_REG_BASE + 0x00000424)
#define HWIO_GSI_IRAM_PTR_CH_DIS_COMP_PHYS (GSI_REG_BASE_PHYS + 0x00000424)
#define HWIO_GSI_IRAM_PTR_CH_DIS_COMP_OFFS (GSI_REG_BASE_OFFS + 0x00000424)
#define HWIO_GSI_IRAM_PTR_CH_EMPTY_ADDR (GSI_REG_BASE + 0x00000428)
#define HWIO_GSI_IRAM_PTR_CH_EMPTY_PHYS (GSI_REG_BASE_PHYS + 0x00000428)
#define HWIO_GSI_IRAM_PTR_CH_EMPTY_OFFS (GSI_REG_BASE_OFFS + 0x00000428)
#define HWIO_GSI_IRAM_PTR_EVENT_GEN_COMP_ADDR (GSI_REG_BASE + 0x0000042c)
#define HWIO_GSI_IRAM_PTR_EVENT_GEN_COMP_PHYS (GSI_REG_BASE_PHYS + \
					       0x0000042c)
#define HWIO_GSI_IRAM_PTR_EVENT_GEN_COMP_OFFS (GSI_REG_BASE_OFFS + \
					       0x0000042c)
#define HWIO_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_0_ADDR (GSI_REG_BASE + \
						   0x00000430)
#define HWIO_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_0_PHYS (GSI_REG_BASE_PHYS + \
						   0x00000430)
#define HWIO_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_0_OFFS (GSI_REG_BASE_OFFS + \
						   0x00000430)
#define HWIO_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_2_ADDR (GSI_REG_BASE + \
						   0x00000434)
#define HWIO_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_2_PHYS (GSI_REG_BASE_PHYS + \
						   0x00000434)
#define HWIO_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_2_OFFS (GSI_REG_BASE_OFFS + \
						   0x00000434)
#define HWIO_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_1_ADDR (GSI_REG_BASE + \
						   0x00000438)
#define HWIO_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_1_PHYS (GSI_REG_BASE_PHYS + \
						   0x00000438)
#define HWIO_GSI_IRAM_PTR_PERIPH_IF_TLV_IN_1_OFFS (GSI_REG_BASE_OFFS + \
						   0x00000438)
#define HWIO_GSI_IRAM_PTR_TIMER_EXPIRED_ADDR (GSI_REG_BASE + 0x0000043c)
#define HWIO_GSI_IRAM_PTR_TIMER_EXPIRED_PHYS (GSI_REG_BASE_PHYS + \
					      0x0000043c)
#define HWIO_GSI_IRAM_PTR_TIMER_EXPIRED_OFFS (GSI_REG_BASE_OFFS + \
					      0x0000043c)
#define HWIO_GSI_IRAM_PTR_WRITE_ENG_COMP_ADDR (GSI_REG_BASE + 0x00000440)
#define HWIO_GSI_IRAM_PTR_WRITE_ENG_COMP_PHYS (GSI_REG_BASE_PHYS + \
					       0x00000440)
#define HWIO_GSI_IRAM_PTR_WRITE_ENG_COMP_OFFS (GSI_REG_BASE_OFFS + \
					       0x00000440)
#define HWIO_GSI_IRAM_PTR_READ_ENG_COMP_ADDR (GSI_REG_BASE + 0x00000444)
#define HWIO_GSI_IRAM_PTR_READ_ENG_COMP_PHYS (GSI_REG_BASE_PHYS + \
					      0x00000444)
#define HWIO_GSI_IRAM_PTR_READ_ENG_COMP_OFFS (GSI_REG_BASE_OFFS + \
					      0x00000444)
#define HWIO_GSI_IRAM_PTR_UC_GP_INT_ADDR (GSI_REG_BASE + 0x00000448)
#define HWIO_GSI_IRAM_PTR_UC_GP_INT_PHYS (GSI_REG_BASE_PHYS + 0x00000448)
#define HWIO_GSI_IRAM_PTR_UC_GP_INT_OFFS (GSI_REG_BASE_OFFS + 0x00000448)
#define HWIO_GSI_IRAM_PTR_INT_MOD_STOPPED_ADDR (GSI_REG_BASE + 0x0000044c)
#define HWIO_GSI_IRAM_PTR_INT_MOD_STOPPED_PHYS (GSI_REG_BASE_PHYS + \
						0x0000044c)
#define HWIO_GSI_IRAM_PTR_INT_MOD_STOPPED_OFFS (GSI_REG_BASE_OFFS + \
						0x0000044c)
#define HWIO_GSI_IRAM_PTR_SDMA_INT_n_ADDR(n) (GSI_REG_BASE + 0x00000450 + \
					      0x4 * (n))
#define HWIO_GSI_IRAM_PTR_SDMA_INT_n_PHYS(n) (GSI_REG_BASE_PHYS + \
					      0x00000450 + 0x4 * (n))
#define HWIO_GSI_IRAM_PTR_SDMA_INT_n_OFFS(n) (GSI_REG_BASE_OFFS + \
					      0x00000450 + 0x4 * (n))
#define HWIO_GSI_INST_RAM_n_ADDR(n) (GSI_REG_BASE + 0x0001b000 + 0x4 * (n))
#define HWIO_GSI_INST_RAM_n_PHYS(n) (GSI_REG_BASE_PHYS + 0x0001b000 + \
				     0x4 * (n))
#define HWIO_GSI_INST_RAM_n_OFFS(n) (GSI_REG_BASE_OFFS + 0x0001b000 + \
				     0x4 * (n))
#define HWIO_GSI_SHRAM_n_ADDR(n) (GSI_REG_BASE + 0x00002000 + 0x4 * (n))
#define HWIO_GSI_SHRAM_n_PHYS(n) (GSI_REG_BASE_PHYS + 0x00002000 + 0x4 * \
				  (n))
#define HWIO_GSI_SHRAM_n_OFFS(n) (GSI_REG_BASE_OFFS + 0x00002000 + 0x4 * \
				  (n))
#define HWIO_GSI_SHRAM_n_RMSK 0xffffffff
#define HWIO_GSI_SHRAM_n_MAXn 1343
#define HWIO_GSI_SHRAM_n_ATTR 0x3
#define HWIO_GSI_SHRAM_n_INI(n) in_dword_masked(HWIO_GSI_SHRAM_n_ADDR( \
							n), \
						HWIO_GSI_SHRAM_n_RMSK)
#define HWIO_GSI_SHRAM_n_INMI(n, mask) in_dword_masked(	\
		HWIO_GSI_SHRAM_n_ADDR(n), \
		mask)
#define HWIO_GSI_SHRAM_n_OUTI(n, val) out_dword(HWIO_GSI_SHRAM_n_ADDR( \
							n), val)
#define HWIO_GSI_SHRAM_n_OUTMI(n, mask, val) out_dword_masked_ns( \
		HWIO_GSI_SHRAM_n_ADDR(n), \
		mask, \
		val, \
		HWIO_GSI_SHRAM_n_INI(n))
#define HWIO_GSI_SHRAM_n_SHRAM_BMSK 0xffffffff
#define HWIO_GSI_SHRAM_n_SHRAM_SHFT 0x0
#define HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_ADDR(n, k) (GSI_REG_BASE + \
						    0x00003800 + 0x80 *	\
						    (n) + 0x4 * (k))
#define HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_PHYS(n, k) (GSI_REG_BASE_PHYS +	\
						    0x00003800 + 0x80 *	\
						    (n) + 0x4 * (k))
#define HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_OFFS(n, k) (GSI_REG_BASE_OFFS +	\
						    0x00003800 + 0x80 *	\
						    (n) + 0x4 * (k))
#define HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_RMSK 0x3f
#define HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_MAXn 2
#define HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_MAXk 22
#define HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_ATTR 0x3
#define HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_INI2(n, k) in_dword_masked( \
		HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_ADDR(n, k), \
		HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_RMSK)
#define HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_INMI2(n, k, mask) in_dword_masked( \
		HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_ADDR(n, k), \
		mask)
#define HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_OUTI2(n, k, val) out_dword( \
		HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_ADDR(n, k), \
		val)
#define HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_OUTMI2(n, k, mask, \
					       val) out_dword_masked_ns( \
		HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_ADDR(n,	\
						     k), \
		mask, \
		val, \
		HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_INI2(n, k))
#define HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_VALID_BMSK 0x20
#define HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_VALID_SHFT 0x5
#define HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_PHY_CH_BMSK 0x1f
#define HWIO_GSI_MAP_EE_n_CH_k_VP_TABLE_PHY_CH_SHFT 0x0
#define HWIO_GSI_TEST_BUS_SEL_ADDR (GSI_REG_BASE + 0x00001000)
#define HWIO_GSI_TEST_BUS_SEL_PHYS (GSI_REG_BASE_PHYS + 0x00001000)
#define HWIO_GSI_TEST_BUS_SEL_OFFS (GSI_REG_BASE_OFFS + 0x00001000)
#define HWIO_GSI_TEST_BUS_SEL_RMSK 0xf00ff
#define HWIO_GSI_TEST_BUS_SEL_ATTR 0x3
#define HWIO_GSI_TEST_BUS_SEL_IN in_dword_masked( \
		HWIO_GSI_TEST_BUS_SEL_ADDR, \
		HWIO_GSI_TEST_BUS_SEL_RMSK)
#define HWIO_GSI_TEST_BUS_SEL_INM(m) in_dword_masked( \
		HWIO_GSI_TEST_BUS_SEL_ADDR, \
		m)
#define HWIO_GSI_TEST_BUS_SEL_OUT(v) out_dword(HWIO_GSI_TEST_BUS_SEL_ADDR, \
					       v)
#define HWIO_GSI_TEST_BUS_SEL_OUTM(m, v) out_dword_masked_ns( \
		HWIO_GSI_TEST_BUS_SEL_ADDR, \
		m, \
		v, \
		HWIO_GSI_TEST_BUS_SEL_IN)
#define HWIO_GSI_TEST_BUS_SEL_GSI_HW_EVENTS_SEL_BMSK 0xf0000
#define HWIO_GSI_TEST_BUS_SEL_GSI_HW_EVENTS_SEL_SHFT 0x10
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_BMSK 0xff
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_SHFT 0x0
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_ZEROS_FVAL 0x0
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_MCS_0_FVAL 0x1
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_MCS_1_FVAL 0x2
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_MCS_2_FVAL 0x3
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_MCS_3_FVAL 0x4
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_MCS_4_FVAL 0x5
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_DB_ENG_FVAL 0x9
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_REE_0_FVAL 0xb
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_REE_1_FVAL 0xc
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_REE_2_FVAL 0xd
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_REE_3_FVAL 0xe
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_REE_4_FVAL 0xf
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_REE_5_FVAL 0x10
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_REE_6_FVAL 0x11
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_REE_7_FVAL 0x12
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_EVE_0_FVAL 0x13
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_EVE_1_FVAL 0x14
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_EVE_2_FVAL 0x15
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_EVE_3_FVAL 0x16
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_EVE_4_FVAL 0x17
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_EVE_5_FVAL 0x18
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_IE_0_FVAL 0x1b
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_IE_1_FVAL 0x1c
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_IE_2_FVAL 0x1d
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_IC_0_FVAL 0x1f
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_IC_1_FVAL 0x20
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_IC_2_FVAL 0x21
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_IC_3_FVAL 0x22
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_IC_4_FVAL 0x23
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_MOQA_0_FVAL 0x27
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_MOQA_1_FVAL 0x28
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_MOQA_2_FVAL 0x29
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_MOQA_3_FVAL 0x2a
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_TMR_0_FVAL 0x2b
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_TMR_1_FVAL 0x2c
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_TMR_2_FVAL 0x2d
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_TMR_3_FVAL 0x2e
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_RD_WR_0_FVAL 0x33
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_RD_WR_1_FVAL 0x34
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_RD_WR_2_FVAL 0x35
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_RD_WR_3_FVAL 0x36
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_CSR_FVAL 0x3a
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_SDMA_0_FVAL 0x3c
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_SMDA_1_FVAL 0x3d
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_CSR_1_FVAL 0x3e
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_CSR_2_FVAL 0x3f
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_MCS_5_FVAL 0x40
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_IC_5_FVAL 0x41
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_CSR_3_FVAL 0x42
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_TLV_0_FVAL 0x43
#define HWIO_GSI_TEST_BUS_SEL_GSI_TESTBUS_SEL_REE_8_FVAL 0x44
#define HWIO_GSI_TEST_BUS_REG_ADDR (GSI_REG_BASE + 0x00001008)
#define HWIO_GSI_TEST_BUS_REG_PHYS (GSI_REG_BASE_PHYS + 0x00001008)
#define HWIO_GSI_TEST_BUS_REG_OFFS (GSI_REG_BASE_OFFS + 0x00001008)
#define HWIO_GSI_TEST_BUS_REG_RMSK 0xffffffff
#define HWIO_GSI_TEST_BUS_REG_ATTR 0x1
#define HWIO_GSI_TEST_BUS_REG_IN in_dword_masked( \
		HWIO_GSI_TEST_BUS_REG_ADDR, \
		HWIO_GSI_TEST_BUS_REG_RMSK)
#define HWIO_GSI_TEST_BUS_REG_INM(m) in_dword_masked( \
		HWIO_GSI_TEST_BUS_REG_ADDR, \
		m)
#define HWIO_GSI_TEST_BUS_REG_GSI_TESTBUS_REG_BMSK 0xffffffff
#define HWIO_GSI_TEST_BUS_REG_GSI_TESTBUS_REG_SHFT 0x0
#define HWIO_GSI_DEBUG_BUSY_REG_ADDR (GSI_REG_BASE + 0x00001010)
#define HWIO_GSI_DEBUG_BUSY_REG_PHYS (GSI_REG_BASE_PHYS + 0x00001010)
#define HWIO_GSI_DEBUG_BUSY_REG_OFFS (GSI_REG_BASE_OFFS + 0x00001010)
#define HWIO_GSI_DEBUG_EVENT_PENDING_ADDR (GSI_REG_BASE + 0x00001014)
#define HWIO_GSI_DEBUG_EVENT_PENDING_PHYS (GSI_REG_BASE_PHYS + 0x00001014)
#define HWIO_GSI_DEBUG_EVENT_PENDING_OFFS (GSI_REG_BASE_OFFS + 0x00001014)
#define HWIO_GSI_DEBUG_TIMER_PENDING_ADDR (GSI_REG_BASE + 0x00001018)
#define HWIO_GSI_DEBUG_TIMER_PENDING_PHYS (GSI_REG_BASE_PHYS + 0x00001018)
#define HWIO_GSI_DEBUG_TIMER_PENDING_OFFS (GSI_REG_BASE_OFFS + 0x00001018)
#define HWIO_GSI_DEBUG_RD_WR_PENDING_ADDR (GSI_REG_BASE + 0x0000101c)
#define HWIO_GSI_DEBUG_RD_WR_PENDING_PHYS (GSI_REG_BASE_PHYS + 0x0000101c)
#define HWIO_GSI_DEBUG_RD_WR_PENDING_OFFS (GSI_REG_BASE_OFFS + 0x0000101c)
#define HWIO_GSI_DEBUG_COUNTER_CFGn_ADDR(n) (GSI_REG_BASE + 0x00001200 + \
					     0x4 * (n))
#define HWIO_GSI_DEBUG_COUNTER_CFGn_PHYS(n) (GSI_REG_BASE_PHYS + \
					     0x00001200 + 0x4 * (n))
#define HWIO_GSI_DEBUG_COUNTER_CFGn_OFFS(n) (GSI_REG_BASE_OFFS + \
					     0x00001200 + 0x4 * (n))
#define HWIO_GSI_DEBUG_COUNTERn_ADDR(n) (GSI_REG_BASE + 0x00001240 + 0x4 * \
					 (n))
#define HWIO_GSI_DEBUG_COUNTERn_PHYS(n) (GSI_REG_BASE_PHYS + 0x00001240 + \
					 0x4 * (n))
#define HWIO_GSI_DEBUG_COUNTERn_OFFS(n) (GSI_REG_BASE_OFFS + 0x00001240 + \
					 0x4 * (n))
#define HWIO_GSI_DEBUG_COUNTERn_RMSK 0xffff
#define HWIO_GSI_DEBUG_COUNTERn_MAXn 7
#define HWIO_GSI_DEBUG_COUNTERn_ATTR 0x1
#define HWIO_GSI_DEBUG_COUNTERn_INI(n) in_dword_masked(	\
		HWIO_GSI_DEBUG_COUNTERn_ADDR(n), \
		HWIO_GSI_DEBUG_COUNTERn_RMSK)
#define HWIO_GSI_DEBUG_COUNTERn_INMI(n, mask) in_dword_masked( \
		HWIO_GSI_DEBUG_COUNTERn_ADDR(n), \
		mask)
#define HWIO_GSI_DEBUG_COUNTERn_COUNTER_VALUE_BMSK 0xffff
#define HWIO_GSI_DEBUG_COUNTERn_COUNTER_VALUE_SHFT 0x0
#define HWIO_GSI_DEBUG_PC_FROM_SW_ADDR (GSI_REG_BASE + 0x00001040)
#define HWIO_GSI_DEBUG_PC_FROM_SW_PHYS (GSI_REG_BASE_PHYS + 0x00001040)
#define HWIO_GSI_DEBUG_PC_FROM_SW_OFFS (GSI_REG_BASE_OFFS + 0x00001040)
#define HWIO_GSI_DEBUG_SW_STALL_ADDR (GSI_REG_BASE + 0x00001044)
#define HWIO_GSI_DEBUG_SW_STALL_PHYS (GSI_REG_BASE_PHYS + 0x00001044)
#define HWIO_GSI_DEBUG_SW_STALL_OFFS (GSI_REG_BASE_OFFS + 0x00001044)
#define HWIO_GSI_DEBUG_PC_FOR_DEBUG_ADDR (GSI_REG_BASE + 0x00001048)
#define HWIO_GSI_DEBUG_PC_FOR_DEBUG_PHYS (GSI_REG_BASE_PHYS + 0x00001048)
#define HWIO_GSI_DEBUG_PC_FOR_DEBUG_OFFS (GSI_REG_BASE_OFFS + 0x00001048)
#define HWIO_GSI_DEBUG_QSB_LOG_SEL_ADDR (GSI_REG_BASE + 0x00001050)
#define HWIO_GSI_DEBUG_QSB_LOG_SEL_PHYS (GSI_REG_BASE_PHYS + 0x00001050)
#define HWIO_GSI_DEBUG_QSB_LOG_SEL_OFFS (GSI_REG_BASE_OFFS + 0x00001050)
#define HWIO_GSI_DEBUG_QSB_LOG_CLR_ADDR (GSI_REG_BASE + 0x00001058)
#define HWIO_GSI_DEBUG_QSB_LOG_CLR_PHYS (GSI_REG_BASE_PHYS + 0x00001058)
#define HWIO_GSI_DEBUG_QSB_LOG_CLR_OFFS (GSI_REG_BASE_OFFS + 0x00001058)
#define HWIO_GSI_DEBUG_QSB_LOG_ERR_TRNS_ID_ADDR (GSI_REG_BASE + 0x00001060)
#define HWIO_GSI_DEBUG_QSB_LOG_ERR_TRNS_ID_PHYS (GSI_REG_BASE_PHYS + \
						 0x00001060)
#define HWIO_GSI_DEBUG_QSB_LOG_ERR_TRNS_ID_OFFS (GSI_REG_BASE_OFFS + \
						 0x00001060)
#define HWIO_GSI_DEBUG_QSB_LOG_0_ADDR (GSI_REG_BASE + 0x00001064)
#define HWIO_GSI_DEBUG_QSB_LOG_0_PHYS (GSI_REG_BASE_PHYS + 0x00001064)
#define HWIO_GSI_DEBUG_QSB_LOG_0_OFFS (GSI_REG_BASE_OFFS + 0x00001064)
#define HWIO_GSI_DEBUG_QSB_LOG_1_ADDR (GSI_REG_BASE + 0x00001068)
#define HWIO_GSI_DEBUG_QSB_LOG_1_PHYS (GSI_REG_BASE_PHYS + 0x00001068)
#define HWIO_GSI_DEBUG_QSB_LOG_1_OFFS (GSI_REG_BASE_OFFS + 0x00001068)
#define HWIO_GSI_DEBUG_QSB_LOG_2_ADDR (GSI_REG_BASE + 0x0000106c)
#define HWIO_GSI_DEBUG_QSB_LOG_2_PHYS (GSI_REG_BASE_PHYS + 0x0000106c)
#define HWIO_GSI_DEBUG_QSB_LOG_2_OFFS (GSI_REG_BASE_OFFS + 0x0000106c)
#define HWIO_GSI_DEBUG_QSB_LOG_LAST_MISC_IDn_ADDR(n) (GSI_REG_BASE + \
						      0x00001070 + 0x4 * \
						      (n))
#define HWIO_GSI_DEBUG_QSB_LOG_LAST_MISC_IDn_PHYS(n) (GSI_REG_BASE_PHYS + \
						      0x00001070 + 0x4 * \
						      (n))
#define HWIO_GSI_DEBUG_QSB_LOG_LAST_MISC_IDn_OFFS(n) (GSI_REG_BASE_OFFS + \
						      0x00001070 + 0x4 * \
						      (n))
#define HWIO_GSI_DEBUG_SW_RF_n_WRITE_ADDR(n) (GSI_REG_BASE + 0x00001080 + \
					      0x4 * (n))
#define HWIO_GSI_DEBUG_SW_RF_n_WRITE_PHYS(n) (GSI_REG_BASE_PHYS + \
					      0x00001080 + 0x4 * (n))
#define HWIO_GSI_DEBUG_SW_RF_n_WRITE_OFFS(n) (GSI_REG_BASE_OFFS + \
					      0x00001080 + 0x4 * (n))
#define HWIO_GSI_DEBUG_SW_RF_n_READ_ADDR(n) (GSI_REG_BASE + 0x00001100 + \
					     0x4 * (n))
#define HWIO_GSI_DEBUG_SW_RF_n_READ_PHYS(n) (GSI_REG_BASE_PHYS + \
					     0x00001100 + 0x4 * (n))
#define HWIO_GSI_DEBUG_SW_RF_n_READ_OFFS(n) (GSI_REG_BASE_OFFS + \
					     0x00001100 + 0x4 * (n))
#define HWIO_GSI_DEBUG_SW_RF_n_READ_RMSK 0xffffffff
#define HWIO_GSI_DEBUG_SW_RF_n_READ_MAXn 31
#define HWIO_GSI_DEBUG_SW_RF_n_READ_ATTR 0x1
#define HWIO_GSI_DEBUG_SW_RF_n_READ_INI(n) in_dword_masked( \
		HWIO_GSI_DEBUG_SW_RF_n_READ_ADDR(n), \
		HWIO_GSI_DEBUG_SW_RF_n_READ_RMSK)
#define HWIO_GSI_DEBUG_SW_RF_n_READ_INMI(n, mask) in_dword_masked( \
		HWIO_GSI_DEBUG_SW_RF_n_READ_ADDR(n), \
		mask)
#define HWIO_GSI_DEBUG_SW_RF_n_READ_RF_REG_BMSK 0xffffffff
#define HWIO_GSI_DEBUG_SW_RF_n_READ_RF_REG_SHFT 0x0
#define HWIO_GSI_DEBUG_EE_n_CH_k_VP_TABLE_ADDR(n, k) (GSI_REG_BASE + \
						      0x00001400 + 0x80 * \
						      (n) + 0x4 * (k))
#define HWIO_GSI_DEBUG_EE_n_CH_k_VP_TABLE_PHYS(n, k) (GSI_REG_BASE_PHYS + \
						      0x00001400 + 0x80 * \
						      (n) + 0x4 * (k))
#define HWIO_GSI_DEBUG_EE_n_CH_k_VP_TABLE_OFFS(n, k) (GSI_REG_BASE_OFFS + \
						      0x00001400 + 0x80 * \
						      (n) + 0x4 * (k))
#define HWIO_GSI_DEBUG_EE_n_EV_k_VP_TABLE_ADDR(n, k) (GSI_REG_BASE + \
						      0x00001600 + 0x80 * \
						      (n) + 0x4 * (k))
#define HWIO_GSI_DEBUG_EE_n_EV_k_VP_TABLE_PHYS(n, k) (GSI_REG_BASE_PHYS + \
						      0x00001600 + 0x80 * \
						      (n) + 0x4 * (k))
#define HWIO_GSI_DEBUG_EE_n_EV_k_VP_TABLE_OFFS(n, k) (GSI_REG_BASE_OFFS + \
						      0x00001600 + 0x80 * \
						      (n) + 0x4 * (k))
#define HWIO_GSI_DEBUG_EE_n_EV_k_VP_TABLE_RMSK 0x3f
#define HWIO_GSI_DEBUG_EE_n_EV_k_VP_TABLE_MAXn 3
#define HWIO_GSI_DEBUG_EE_n_EV_k_VP_TABLE_MAXk 19
#define HWIO_GSI_DEBUG_EE_n_EV_k_VP_TABLE_ATTR 0x1
#define HWIO_GSI_DEBUG_EE_n_EV_k_VP_TABLE_INI2(n, k) in_dword_masked( \
		HWIO_GSI_DEBUG_EE_n_EV_k_VP_TABLE_ADDR(n, k), \
		HWIO_GSI_DEBUG_EE_n_EV_k_VP_TABLE_RMSK)
#define HWIO_GSI_DEBUG_EE_n_EV_k_VP_TABLE_INMI2(n, k, \
						mask) in_dword_masked( \
		HWIO_GSI_DEBUG_EE_n_EV_k_VP_TABLE_ADDR(n, \
						       k), \
		mask)
#define HWIO_GSI_DEBUG_EE_n_EV_k_VP_TABLE_VALID_BMSK 0x20
#define HWIO_GSI_DEBUG_EE_n_EV_k_VP_TABLE_VALID_SHFT 0x5
#define HWIO_GSI_DEBUG_EE_n_EV_k_VP_TABLE_PHY_EV_CH_BMSK 0x1f
#define HWIO_GSI_DEBUG_EE_n_EV_k_VP_TABLE_PHY_EV_CH_SHFT 0x0
#define HWIO_GSI_DEBUG_SDMA_TRANS_DB_n_ADDR(n) (GSI_REG_BASE + \
						0x00001800 + 0x4 * (n))
#define HWIO_GSI_DEBUG_SDMA_TRANS_DB_n_PHYS(n) (GSI_REG_BASE_PHYS + \
						0x00001800 + 0x4 * (n))
#define HWIO_GSI_DEBUG_SDMA_TRANS_DB_n_OFFS(n) (GSI_REG_BASE_OFFS + \
						0x00001800 + 0x4 * (n))
#define HWIO_GSI_UC_SRC_IRQ_ADDR (GSI_REG_BASE + 0x00000500)
#define HWIO_GSI_UC_SRC_IRQ_PHYS (GSI_REG_BASE_PHYS + 0x00000500)
#define HWIO_GSI_UC_SRC_IRQ_OFFS (GSI_REG_BASE_OFFS + 0x00000500)
#define HWIO_GSI_UC_SRC_IRQ_MSK_ADDR (GSI_REG_BASE + 0x00000504)
#define HWIO_GSI_UC_SRC_IRQ_MSK_PHYS (GSI_REG_BASE_PHYS + 0x00000504)
#define HWIO_GSI_UC_SRC_IRQ_MSK_OFFS (GSI_REG_BASE_OFFS + 0x00000504)
#define HWIO_GSI_UC_SRC_IRQ_CLR_ADDR (GSI_REG_BASE + 0x00000508)
#define HWIO_GSI_UC_SRC_IRQ_CLR_PHYS (GSI_REG_BASE_PHYS + 0x00000508)
#define HWIO_GSI_UC_SRC_IRQ_CLR_OFFS (GSI_REG_BASE_OFFS + 0x00000508)
#define HWIO_GSI_ACC_ARGS_n_ADDR(n) (GSI_REG_BASE + 0x0000050c + 0x4 * (n))
#define HWIO_GSI_ACC_ARGS_n_PHYS(n) (GSI_REG_BASE_PHYS + 0x0000050c + \
				     0x4 * (n))
#define HWIO_GSI_ACC_ARGS_n_OFFS(n) (GSI_REG_BASE_OFFS + 0x0000050c + \
				     0x4 * (n))
#define HWIO_GSI_ACC_ROUTINE_ADDR (GSI_REG_BASE + 0x00000524)
#define HWIO_GSI_ACC_ROUTINE_PHYS (GSI_REG_BASE_PHYS + 0x00000524)
#define HWIO_GSI_ACC_ROUTINE_OFFS (GSI_REG_BASE_OFFS + 0x00000524)
#define HWIO_GSI_ACC_GO_ADDR (GSI_REG_BASE + 0x00000528)
#define HWIO_GSI_ACC_GO_PHYS (GSI_REG_BASE_PHYS + 0x00000528)
#define HWIO_GSI_ACC_GO_OFFS (GSI_REG_BASE_OFFS + 0x00000528)
#define HWIO_GSI_ACC_2_UC_MCS_STTS_ADDR (GSI_REG_BASE + 0x0000052c)
#define HWIO_GSI_ACC_2_UC_MCS_STTS_PHYS (GSI_REG_BASE_PHYS + 0x0000052c)
#define HWIO_GSI_ACC_2_UC_MCS_STTS_OFFS (GSI_REG_BASE_OFFS + 0x0000052c)
#define HWIO_GSI_ACC_2_UC_MCS_RET_VAL_LSB_ADDR (GSI_REG_BASE + 0x00000530)
#define HWIO_GSI_ACC_2_UC_MCS_RET_VAL_LSB_PHYS (GSI_REG_BASE_PHYS + \
						0x00000530)
#define HWIO_GSI_ACC_2_UC_MCS_RET_VAL_LSB_OFFS (GSI_REG_BASE_OFFS + \
						0x00000530)
#define HWIO_GSI_ACC_2_UC_MCS_RET_VAL_MSB_ADDR (GSI_REG_BASE + 0x00000534)
#define HWIO_GSI_ACC_2_UC_MCS_RET_VAL_MSB_PHYS (GSI_REG_BASE_PHYS + \
						0x00000534)
#define HWIO_GSI_ACC_2_UC_MCS_RET_VAL_MSB_OFFS (GSI_REG_BASE_OFFS + \
						0x00000534)
#define HWIO_GSI_IC_2_UC_MCS_VLD_ADDR (GSI_REG_BASE + 0x00000538)
#define HWIO_GSI_IC_2_UC_MCS_VLD_PHYS (GSI_REG_BASE_PHYS + 0x00000538)
#define HWIO_GSI_IC_2_UC_MCS_VLD_OFFS (GSI_REG_BASE_OFFS + 0x00000538)
#define HWIO_GSI_IC_2_UC_MCS_PC_ADDR (GSI_REG_BASE + 0x0000053c)
#define HWIO_GSI_IC_2_UC_MCS_PC_PHYS (GSI_REG_BASE_PHYS + 0x0000053c)
#define HWIO_GSI_IC_2_UC_MCS_PC_OFFS (GSI_REG_BASE_OFFS + 0x0000053c)
#define HWIO_GSI_IC_2_UC_MCS_ARGS_n_ADDR(n) (GSI_REG_BASE + 0x00000540 + \
					     0x4 * (n))
#define HWIO_GSI_IC_2_UC_MCS_ARGS_n_PHYS(n) (GSI_REG_BASE_PHYS + \
					     0x00000540 + 0x4 * (n))
#define HWIO_GSI_IC_2_UC_MCS_ARGS_n_OFFS(n) (GSI_REG_BASE_OFFS + \
					     0x00000540 + 0x4 * (n))
#define HWIO_GSI_UC_TLV_IN_VLD_ADDR (GSI_REG_BASE + 0x00000558)
#define HWIO_GSI_UC_TLV_IN_VLD_PHYS (GSI_REG_BASE_PHYS + 0x00000558)
#define HWIO_GSI_UC_TLV_IN_VLD_OFFS (GSI_REG_BASE_OFFS + 0x00000558)
#define HWIO_GSI_UC_TLV_IN_ROUTINE_ADDR (GSI_REG_BASE + 0x0000055c)
#define HWIO_GSI_UC_TLV_IN_ROUTINE_PHYS (GSI_REG_BASE_PHYS + 0x0000055c)
#define HWIO_GSI_UC_TLV_IN_ROUTINE_OFFS (GSI_REG_BASE_OFFS + 0x0000055c)
#define HWIO_GSI_UC_TLV_IN_ARGS_n_ADDR(n) (GSI_REG_BASE + 0x00000560 + \
					   0x4 * (n))
#define HWIO_GSI_UC_TLV_IN_ARGS_n_PHYS(n) (GSI_REG_BASE_PHYS + \
					   0x00000560 + 0x4 * (n))
#define HWIO_GSI_UC_TLV_IN_ARGS_n_OFFS(n) (GSI_REG_BASE_OFFS + \
					   0x00000560 + 0x4 * (n))
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_ADDR(n, k) (GSI_REG_BASE + 0x0000f000 + \
					       0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					       0x0000f000 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					       0x0000f000 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_RMSK 0xfff7ffff
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_MAXn 2
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_MAXk 22
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_ATTR 0x3
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_CNTXT_0_ADDR(n, k), \
		HWIO_EE_n_GSI_CH_k_CNTXT_0_RMSK)
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_CNTXT_0_ADDR(n, k), \
		mask)
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_GSI_CH_k_CNTXT_0_ADDR(n, k), \
		val)
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_OUTMI2(n, k, mask, \
					  val) out_dword_masked_ns( \
		HWIO_EE_n_GSI_CH_k_CNTXT_0_ADDR(n, \
						k), \
		mask, \
		val, \
		HWIO_EE_n_GSI_CH_k_CNTXT_0_INI2(n, k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_ELEMENT_SIZE_BMSK 0xff000000
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_ELEMENT_SIZE_SHFT 0x18
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHSTATE_BMSK 0xf00000
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHSTATE_SHFT 0x14
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHSTATE_NOT_ALLOCATED_FVAL 0x0
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHSTATE_ALLOCATED_FVAL 0x1
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHSTATE_STARTED_FVAL 0x2
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHSTATE_STOPPED_FVAL 0x3
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHSTATE_STOP_IN_PROC_FVAL 0x4
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHSTATE_ERROR_FVAL 0xf
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_ERINDEX_BMSK 0x7c000
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_ERINDEX_SHFT 0xe
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_PROTOCOL_MSB_BMSK 0x2000
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_PROTOCOL_MSB_SHFT 0xd
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHID_BMSK 0x1f00
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHID_SHFT 0x8
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_EE_BMSK 0xf0
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_EE_SHFT 0x4
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_DIR_BMSK 0x8
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_DIR_SHFT 0x3
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_DIR_INBOUND_FVAL 0x0
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_DIR_OUTBOUND_FVAL 0x1
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_PROTOCOL_BMSK 0x7
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_PROTOCOL_SHFT 0x0
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_PROTOCOL_MHI_FVAL 0x0
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_PROTOCOL_XHCI_FVAL 0x1
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_PROTOCOL_GPI_FVAL 0x2
#define HWIO_EE_n_GSI_CH_k_CNTXT_0_CHTYPE_PROTOCOL_XDCI_FVAL 0x3
#define HWIO_EE_n_GSI_CH_k_CNTXT_1_ADDR(n, k) (GSI_REG_BASE + 0x0000f004 + \
					       0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_1_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					       0x0000f004 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_1_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					       0x0000f004 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_1_RMSK 0xffff
#define HWIO_EE_n_GSI_CH_k_CNTXT_1_MAXn 2
#define HWIO_EE_n_GSI_CH_k_CNTXT_1_MAXk 22
#define HWIO_EE_n_GSI_CH_k_CNTXT_1_ATTR 0x3
#define HWIO_EE_n_GSI_CH_k_CNTXT_1_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_CNTXT_1_ADDR(n, k), \
		HWIO_EE_n_GSI_CH_k_CNTXT_1_RMSK)
#define HWIO_EE_n_GSI_CH_k_CNTXT_1_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_CNTXT_1_ADDR(n, k), \
		mask)
#define HWIO_EE_n_GSI_CH_k_CNTXT_1_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_GSI_CH_k_CNTXT_1_ADDR(n, k), \
		val)
#define HWIO_EE_n_GSI_CH_k_CNTXT_1_OUTMI2(n, k, mask, \
					  val) out_dword_masked_ns( \
		HWIO_EE_n_GSI_CH_k_CNTXT_1_ADDR(n, \
						k), \
		mask, \
		val, \
		HWIO_EE_n_GSI_CH_k_CNTXT_1_INI2(n, k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_1_R_LENGTH_BMSK 0xffff
#define HWIO_EE_n_GSI_CH_k_CNTXT_1_R_LENGTH_SHFT 0x0
#define HWIO_EE_n_GSI_CH_k_CNTXT_2_ADDR(n, k) (GSI_REG_BASE + 0x0000f008 + \
					       0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_2_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					       0x0000f008 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_2_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					       0x0000f008 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_2_RMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_CNTXT_2_MAXn 2
#define HWIO_EE_n_GSI_CH_k_CNTXT_2_MAXk 22
#define HWIO_EE_n_GSI_CH_k_CNTXT_2_ATTR 0x3
#define HWIO_EE_n_GSI_CH_k_CNTXT_2_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_CNTXT_2_ADDR(n, k), \
		HWIO_EE_n_GSI_CH_k_CNTXT_2_RMSK)
#define HWIO_EE_n_GSI_CH_k_CNTXT_2_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_CNTXT_2_ADDR(n, k), \
		mask)
#define HWIO_EE_n_GSI_CH_k_CNTXT_2_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_GSI_CH_k_CNTXT_2_ADDR(n, k), \
		val)
#define HWIO_EE_n_GSI_CH_k_CNTXT_2_OUTMI2(n, k, mask, \
					  val) out_dword_masked_ns( \
		HWIO_EE_n_GSI_CH_k_CNTXT_2_ADDR(n, \
						k), \
		mask, \
		val, \
		HWIO_EE_n_GSI_CH_k_CNTXT_2_INI2(n, k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_2_R_BASE_ADDR_LSBS_BMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_CNTXT_2_R_BASE_ADDR_LSBS_SHFT 0x0
#define HWIO_EE_n_GSI_CH_k_CNTXT_3_ADDR(n, k) (GSI_REG_BASE + 0x0000f00c + \
					       0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_3_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					       0x0000f00c + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_3_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					       0x0000f00c + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_3_RMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_CNTXT_3_MAXn 2
#define HWIO_EE_n_GSI_CH_k_CNTXT_3_MAXk 22
#define HWIO_EE_n_GSI_CH_k_CNTXT_3_ATTR 0x3
#define HWIO_EE_n_GSI_CH_k_CNTXT_3_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_CNTXT_3_ADDR(n, k), \
		HWIO_EE_n_GSI_CH_k_CNTXT_3_RMSK)
#define HWIO_EE_n_GSI_CH_k_CNTXT_3_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_CNTXT_3_ADDR(n, k), \
		mask)
#define HWIO_EE_n_GSI_CH_k_CNTXT_3_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_GSI_CH_k_CNTXT_3_ADDR(n, k), \
		val)
#define HWIO_EE_n_GSI_CH_k_CNTXT_3_OUTMI2(n, k, mask, \
					  val) out_dword_masked_ns( \
		HWIO_EE_n_GSI_CH_k_CNTXT_3_ADDR(n, \
						k), \
		mask, \
		val, \
		HWIO_EE_n_GSI_CH_k_CNTXT_3_INI2(n, k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_3_R_BASE_ADDR_MSBS_BMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_CNTXT_3_R_BASE_ADDR_MSBS_SHFT 0x0
#define HWIO_EE_n_GSI_CH_k_CNTXT_4_ADDR(n, k) (GSI_REG_BASE + 0x0000f010 + \
					       0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_4_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					       0x0000f010 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_4_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					       0x0000f010 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_4_RMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_CNTXT_4_MAXn 2
#define HWIO_EE_n_GSI_CH_k_CNTXT_4_MAXk 22
#define HWIO_EE_n_GSI_CH_k_CNTXT_4_ATTR 0x3
#define HWIO_EE_n_GSI_CH_k_CNTXT_4_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_CNTXT_4_ADDR(n, k), \
		HWIO_EE_n_GSI_CH_k_CNTXT_4_RMSK)
#define HWIO_EE_n_GSI_CH_k_CNTXT_4_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_CNTXT_4_ADDR(n, k), \
		mask)
#define HWIO_EE_n_GSI_CH_k_CNTXT_4_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_GSI_CH_k_CNTXT_4_ADDR(n, k), \
		val)
#define HWIO_EE_n_GSI_CH_k_CNTXT_4_OUTMI2(n, k, mask, \
					  val) out_dword_masked_ns( \
		HWIO_EE_n_GSI_CH_k_CNTXT_4_ADDR(n, \
						k), \
		mask, \
		val, \
		HWIO_EE_n_GSI_CH_k_CNTXT_4_INI2(n, k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_4_READ_PTR_LSB_BMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_CNTXT_4_READ_PTR_LSB_SHFT 0x0
#define HWIO_EE_n_GSI_CH_k_CNTXT_5_ADDR(n, k) (GSI_REG_BASE + 0x0000f014 + \
					       0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_5_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					       0x0000f014 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_5_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					       0x0000f014 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_5_RMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_CNTXT_5_MAXn 2
#define HWIO_EE_n_GSI_CH_k_CNTXT_5_MAXk 22
#define HWIO_EE_n_GSI_CH_k_CNTXT_5_ATTR 0x1
#define HWIO_EE_n_GSI_CH_k_CNTXT_5_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_CNTXT_5_ADDR(n, k), \
		HWIO_EE_n_GSI_CH_k_CNTXT_5_RMSK)
#define HWIO_EE_n_GSI_CH_k_CNTXT_5_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_CNTXT_5_ADDR(n, k), \
		mask)
#define HWIO_EE_n_GSI_CH_k_CNTXT_5_READ_PTR_MSB_BMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_CNTXT_5_READ_PTR_MSB_SHFT 0x0
#define HWIO_EE_n_GSI_CH_k_CNTXT_6_ADDR(n, k) (GSI_REG_BASE + 0x0000f018 + \
					       0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_6_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					       0x0000f018 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_6_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					       0x0000f018 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_6_RMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_CNTXT_6_MAXn 2
#define HWIO_EE_n_GSI_CH_k_CNTXT_6_MAXk 22
#define HWIO_EE_n_GSI_CH_k_CNTXT_6_ATTR 0x1
#define HWIO_EE_n_GSI_CH_k_CNTXT_6_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_CNTXT_6_ADDR(n, k), \
		HWIO_EE_n_GSI_CH_k_CNTXT_6_RMSK)
#define HWIO_EE_n_GSI_CH_k_CNTXT_6_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_CNTXT_6_ADDR(n, k), \
		mask)
#define HWIO_EE_n_GSI_CH_k_CNTXT_6_WRITE_PTR_LSB_BMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_CNTXT_6_WRITE_PTR_LSB_SHFT 0x0
#define HWIO_EE_n_GSI_CH_k_CNTXT_7_ADDR(n, k) (GSI_REG_BASE + 0x0000f01c + \
					       0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_7_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					       0x0000f01c + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_7_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					       0x0000f01c + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_CNTXT_7_RMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_CNTXT_7_MAXn 2
#define HWIO_EE_n_GSI_CH_k_CNTXT_7_MAXk 22
#define HWIO_EE_n_GSI_CH_k_CNTXT_7_ATTR 0x1
#define HWIO_EE_n_GSI_CH_k_CNTXT_7_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_CNTXT_7_ADDR(n, k), \
		HWIO_EE_n_GSI_CH_k_CNTXT_7_RMSK)
#define HWIO_EE_n_GSI_CH_k_CNTXT_7_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_CNTXT_7_ADDR(n, k), \
		mask)
#define HWIO_EE_n_GSI_CH_k_CNTXT_7_WRITE_PTR_MSB_BMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_CNTXT_7_WRITE_PTR_MSB_SHFT 0x0
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_ADDR(n, k) (GSI_REG_BASE +	\
							 0x0000f054 + \
							 0x4000 * (n) +	\
							 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_PHYS(n, \
						  k) (GSI_REG_BASE_PHYS + \
						      0x0000f054 + \
						      0x4000 * (n) + \
						      0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_OFFS(n, \
						  k) (GSI_REG_BASE_OFFS + \
						      0x0000f054 + \
						      0x4000 * (n) + \
						      0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_RMSK 0xffff
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_MAXn 2
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_MAXk 22
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_ATTR 0x3
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_ADDR(n, k), \
		HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_RMSK)
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_INMI2(n, k, \
						   mask) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_ADDR(n, \
							  k), \
		mask)
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_ADDR(n, k), \
		val)
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_OUTMI2(n, k, mask,	\
						    val) \
	out_dword_masked_ns(HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_ADDR( \
				    n, \
				    k), mask, val, \
			    HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_INI2(n, k))
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_READ_PTR_BMSK 0xffff
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_READ_PTR_READ_PTR_SHFT 0x0
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_ADDR(n, k) (GSI_REG_BASE + \
							  0x0000f058 + \
							  0x4000 * (n) + \
							  0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_PHYS(n, \
						   k) (GSI_REG_BASE_PHYS + \
						       0x0000f058 + \
						       0x4000 * (n) + \
						       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_OFFS(n, \
						   k) (GSI_REG_BASE_OFFS + \
						       0x0000f058 + \
						       0x4000 * (n) + \
						       0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_RMSK 0xffff
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_MAXn 2
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_MAXk 22
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_ATTR 0x3
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_ADDR(n, k), \
		HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_RMSK)
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_INMI2(n, k, \
						    mask) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_ADDR(n, \
							   k), \
		mask)
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_ADDR(n, k), \
		val)
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_OUTMI2(n, k, mask, \
						     val) \
	out_dword_masked_ns(HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_ADDR(	\
				    n, \
				    k), mask, val, \
			    HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_INI2(n, \
								       k))
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_RE_INTR_DB_BMSK 0xffff
#define HWIO_EE_n_GSI_CH_k_RE_FETCH_WRITE_PTR_RE_INTR_DB_SHFT 0x0
#define HWIO_EE_n_GSI_CH_k_QOS_ADDR(n, k) (GSI_REG_BASE + 0x0000f05c + \
					   0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_QOS_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					   0x0000f05c + 0x4000 * (n) + \
					   0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_QOS_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					   0x0000f05c + 0x4000 * (n) + \
					   0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_QOS_RMSK 0xff3f0f
#define HWIO_EE_n_GSI_CH_k_QOS_MAXn 2
#define HWIO_EE_n_GSI_CH_k_QOS_MAXk 22
#define HWIO_EE_n_GSI_CH_k_QOS_ATTR 0x3
#define HWIO_EE_n_GSI_CH_k_QOS_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_QOS_ADDR(n, k), \
		HWIO_EE_n_GSI_CH_k_QOS_RMSK)
#define HWIO_EE_n_GSI_CH_k_QOS_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_QOS_ADDR(n, k), \
		mask)
#define HWIO_EE_n_GSI_CH_k_QOS_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_GSI_CH_k_QOS_ADDR(n, k), \
		val)
#define HWIO_EE_n_GSI_CH_k_QOS_OUTMI2(n, k, mask, val) out_dword_masked_ns( \
		HWIO_EE_n_GSI_CH_k_QOS_ADDR(n, k), \
		mask, \
		val, \
		HWIO_EE_n_GSI_CH_k_QOS_INI2(n, k))
#define HWIO_EE_n_GSI_CH_k_QOS_EMPTY_LVL_THRSHOLD_BMSK 0xff0000
#define HWIO_EE_n_GSI_CH_k_QOS_EMPTY_LVL_THRSHOLD_SHFT 0x10
#define HWIO_EE_n_GSI_CH_k_QOS_PREFETCH_MODE_BMSK 0x3c00
#define HWIO_EE_n_GSI_CH_k_QOS_PREFETCH_MODE_SHFT 0xa
#define HWIO_EE_n_GSI_CH_k_QOS_PREFETCH_MODE_USE_PREFETCH_BUFS_FVAL 0x0
#define HWIO_EE_n_GSI_CH_k_QOS_PREFETCH_MODE_ESCAPE_BUF_ONLY_FVAL 0x1
#define HWIO_EE_n_GSI_CH_k_QOS_PREFETCH_MODE_SMART_PRE_FETCH_FVAL 0x2
#define HWIO_EE_n_GSI_CH_k_QOS_PREFETCH_MODE_FREE_PRE_FETCH_FVAL 0x3
#define HWIO_EE_n_GSI_CH_k_QOS_USE_DB_ENG_BMSK 0x200
#define HWIO_EE_n_GSI_CH_k_QOS_USE_DB_ENG_SHFT 0x9
#define HWIO_EE_n_GSI_CH_k_QOS_MAX_PREFETCH_BMSK 0x100
#define HWIO_EE_n_GSI_CH_k_QOS_MAX_PREFETCH_SHFT 0x8
#define HWIO_EE_n_GSI_CH_k_QOS_MAX_PREFETCH_ONE_PREFETCH_SEG_FVAL 0x0
#define HWIO_EE_n_GSI_CH_k_QOS_MAX_PREFETCH_TWO_PREFETCH_SEG_FVAL 0x1
#define HWIO_EE_n_GSI_CH_k_QOS_WRR_WEIGHT_BMSK 0xf
#define HWIO_EE_n_GSI_CH_k_QOS_WRR_WEIGHT_SHFT 0x0
#define HWIO_EE_n_GSI_CH_k_SCRATCH_0_ADDR(n, k) (GSI_REG_BASE +	\
						 0x0000f060 + 0x4000 * \
						 (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_SCRATCH_0_PHYS(n, k) (GSI_REG_BASE_PHYS + \
						 0x0000f060 + 0x4000 * \
						 (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_SCRATCH_0_OFFS(n, k) (GSI_REG_BASE_OFFS + \
						 0x0000f060 + 0x4000 * \
						 (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_SCRATCH_0_RMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_SCRATCH_0_MAXn 2
#define HWIO_EE_n_GSI_CH_k_SCRATCH_0_MAXk 22
#define HWIO_EE_n_GSI_CH_k_SCRATCH_0_ATTR 0x3
#define HWIO_EE_n_GSI_CH_k_SCRATCH_0_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_SCRATCH_0_ADDR(n, k), \
		HWIO_EE_n_GSI_CH_k_SCRATCH_0_RMSK)
#define HWIO_EE_n_GSI_CH_k_SCRATCH_0_INMI2(n, k, mask) in_dword_masked(	\
		HWIO_EE_n_GSI_CH_k_SCRATCH_0_ADDR(n, k), \
		mask)
#define HWIO_EE_n_GSI_CH_k_SCRATCH_0_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_GSI_CH_k_SCRATCH_0_ADDR(n, k), \
		val)
#define HWIO_EE_n_GSI_CH_k_SCRATCH_0_OUTMI2(n, k, mask,	\
					    val) out_dword_masked_ns( \
		HWIO_EE_n_GSI_CH_k_SCRATCH_0_ADDR(n, \
						  k), \
		mask, \
		val, \
		HWIO_EE_n_GSI_CH_k_SCRATCH_0_INI2(n, k))
#define HWIO_EE_n_GSI_CH_k_SCRATCH_0_SCRATCH_BMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_SCRATCH_0_SCRATCH_SHFT 0x0
#define HWIO_EE_n_GSI_CH_k_SCRATCH_1_ADDR(n, k) (GSI_REG_BASE +	\
						 0x0000f064 + 0x4000 * \
						 (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_SCRATCH_1_PHYS(n, k) (GSI_REG_BASE_PHYS + \
						 0x0000f064 + 0x4000 * \
						 (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_SCRATCH_1_OFFS(n, k) (GSI_REG_BASE_OFFS + \
						 0x0000f064 + 0x4000 * \
						 (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_SCRATCH_1_RMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_SCRATCH_1_MAXn 2
#define HWIO_EE_n_GSI_CH_k_SCRATCH_1_MAXk 22
#define HWIO_EE_n_GSI_CH_k_SCRATCH_1_ATTR 0x3
#define HWIO_EE_n_GSI_CH_k_SCRATCH_1_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_SCRATCH_1_ADDR(n, k), \
		HWIO_EE_n_GSI_CH_k_SCRATCH_1_RMSK)
#define HWIO_EE_n_GSI_CH_k_SCRATCH_1_INMI2(n, k, mask) in_dword_masked(	\
		HWIO_EE_n_GSI_CH_k_SCRATCH_1_ADDR(n, k), \
		mask)
#define HWIO_EE_n_GSI_CH_k_SCRATCH_1_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_GSI_CH_k_SCRATCH_1_ADDR(n, k), \
		val)
#define HWIO_EE_n_GSI_CH_k_SCRATCH_1_OUTMI2(n, k, mask,	\
					    val) out_dword_masked_ns( \
		HWIO_EE_n_GSI_CH_k_SCRATCH_1_ADDR(n, \
						  k), \
		mask, \
		val, \
		HWIO_EE_n_GSI_CH_k_SCRATCH_1_INI2(n, k))
#define HWIO_EE_n_GSI_CH_k_SCRATCH_1_SCRATCH_BMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_SCRATCH_1_SCRATCH_SHFT 0x0
#define HWIO_EE_n_GSI_CH_k_SCRATCH_2_ADDR(n, k) (GSI_REG_BASE +	\
						 0x0000f068 + 0x4000 * \
						 (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_SCRATCH_2_PHYS(n, k) (GSI_REG_BASE_PHYS + \
						 0x0000f068 + 0x4000 * \
						 (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_SCRATCH_2_OFFS(n, k) (GSI_REG_BASE_OFFS + \
						 0x0000f068 + 0x4000 * \
						 (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_SCRATCH_2_RMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_SCRATCH_2_MAXn 2
#define HWIO_EE_n_GSI_CH_k_SCRATCH_2_MAXk 22
#define HWIO_EE_n_GSI_CH_k_SCRATCH_2_ATTR 0x3
#define HWIO_EE_n_GSI_CH_k_SCRATCH_2_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_SCRATCH_2_ADDR(n, k), \
		HWIO_EE_n_GSI_CH_k_SCRATCH_2_RMSK)
#define HWIO_EE_n_GSI_CH_k_SCRATCH_2_INMI2(n, k, mask) in_dword_masked(	\
		HWIO_EE_n_GSI_CH_k_SCRATCH_2_ADDR(n, k), \
		mask)
#define HWIO_EE_n_GSI_CH_k_SCRATCH_2_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_GSI_CH_k_SCRATCH_2_ADDR(n, k), \
		val)
#define HWIO_EE_n_GSI_CH_k_SCRATCH_2_OUTMI2(n, k, mask,	\
					    val) out_dword_masked_ns( \
		HWIO_EE_n_GSI_CH_k_SCRATCH_2_ADDR(n, \
						  k), \
		mask, \
		val, \
		HWIO_EE_n_GSI_CH_k_SCRATCH_2_INI2(n, k))
#define HWIO_EE_n_GSI_CH_k_SCRATCH_2_SCRATCH_BMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_SCRATCH_2_SCRATCH_SHFT 0x0
#define HWIO_EE_n_GSI_CH_k_SCRATCH_3_ADDR(n, k) (GSI_REG_BASE +	\
						 0x0000f06c + 0x4000 * \
						 (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_SCRATCH_3_PHYS(n, k) (GSI_REG_BASE_PHYS + \
						 0x0000f06c + 0x4000 * \
						 (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_SCRATCH_3_OFFS(n, k) (GSI_REG_BASE_OFFS + \
						 0x0000f06c + 0x4000 * \
						 (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_SCRATCH_3_RMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_SCRATCH_3_MAXn 2
#define HWIO_EE_n_GSI_CH_k_SCRATCH_3_MAXk 22
#define HWIO_EE_n_GSI_CH_k_SCRATCH_3_ATTR 0x3
#define HWIO_EE_n_GSI_CH_k_SCRATCH_3_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_GSI_CH_k_SCRATCH_3_ADDR(n, k), \
		HWIO_EE_n_GSI_CH_k_SCRATCH_3_RMSK)
#define HWIO_EE_n_GSI_CH_k_SCRATCH_3_INMI2(n, k, mask) in_dword_masked(	\
		HWIO_EE_n_GSI_CH_k_SCRATCH_3_ADDR(n, k), \
		mask)
#define HWIO_EE_n_GSI_CH_k_SCRATCH_3_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_GSI_CH_k_SCRATCH_3_ADDR(n, k), \
		val)
#define HWIO_EE_n_GSI_CH_k_SCRATCH_3_OUTMI2(n, k, mask,	\
					    val) out_dword_masked_ns( \
		HWIO_EE_n_GSI_CH_k_SCRATCH_3_ADDR(n, \
						  k), \
		mask, \
		val, \
		HWIO_EE_n_GSI_CH_k_SCRATCH_3_INI2(n, k))
#define HWIO_EE_n_GSI_CH_k_SCRATCH_3_SCRATCH_BMSK 0xffffffff
#define HWIO_EE_n_GSI_CH_k_SCRATCH_3_SCRATCH_SHFT 0x0
#define HWIO_EE_n_GSI_CH_k_DB_ENG_WRITE_PTR_ADDR(n, k) (GSI_REG_BASE + \
							0x0000f070 + \
							0x4000 * (n) + \
							0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_DB_ENG_WRITE_PTR_PHYS(n, \
						 k) (GSI_REG_BASE_PHYS + \
						     0x0000f070 + 0x4000 * \
						     (n) + 0x80 * (k))
#define HWIO_EE_n_GSI_CH_k_DB_ENG_WRITE_PTR_OFFS(n, \
						 k) (GSI_REG_BASE_OFFS + \
						     0x0000f070 + 0x4000 * \
						     (n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_0_ADDR(n, k) (GSI_REG_BASE + 0x00010000 + \
					      0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_0_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					      0x00010000 + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_0_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					      0x00010000 + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_0_RMSK 0xfff1ffff
#define HWIO_EE_n_EV_CH_k_CNTXT_0_MAXn 2
#define HWIO_EE_n_EV_CH_k_CNTXT_0_MAXk 19
#define HWIO_EE_n_EV_CH_k_CNTXT_0_ATTR 0x3
#define HWIO_EE_n_EV_CH_k_CNTXT_0_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_0_ADDR(n, k), \
		HWIO_EE_n_EV_CH_k_CNTXT_0_RMSK)
#define HWIO_EE_n_EV_CH_k_CNTXT_0_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_0_ADDR(n, k), \
		mask)
#define HWIO_EE_n_EV_CH_k_CNTXT_0_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_EV_CH_k_CNTXT_0_ADDR(n, k), \
		val)
#define HWIO_EE_n_EV_CH_k_CNTXT_0_OUTMI2(n, k, mask, \
					 val) out_dword_masked_ns( \
		HWIO_EE_n_EV_CH_k_CNTXT_0_ADDR(n, \
					       k), \
		mask, \
		val, \
		HWIO_EE_n_EV_CH_k_CNTXT_0_INI2(n, k))
#define HWIO_EE_n_EV_CH_k_CNTXT_0_ELEMENT_SIZE_BMSK 0xff000000
#define HWIO_EE_n_EV_CH_k_CNTXT_0_ELEMENT_SIZE_SHFT 0x18
#define HWIO_EE_n_EV_CH_k_CNTXT_0_CHSTATE_BMSK 0xf00000
#define HWIO_EE_n_EV_CH_k_CNTXT_0_CHSTATE_SHFT 0x14
#define HWIO_EE_n_EV_CH_k_CNTXT_0_CHSTATE_NOT_ALLOCATED_FVAL 0x0
#define HWIO_EE_n_EV_CH_k_CNTXT_0_CHSTATE_ALLOCATED_FVAL 0x1
#define HWIO_EE_n_EV_CH_k_CNTXT_0_INTYPE_BMSK 0x10000
#define HWIO_EE_n_EV_CH_k_CNTXT_0_INTYPE_SHFT 0x10
#define HWIO_EE_n_EV_CH_k_CNTXT_0_INTYPE_MSI_FVAL 0x0
#define HWIO_EE_n_EV_CH_k_CNTXT_0_INTYPE_IRQ_FVAL 0x1
#define HWIO_EE_n_EV_CH_k_CNTXT_0_EVCHID_BMSK 0xff00
#define HWIO_EE_n_EV_CH_k_CNTXT_0_EVCHID_SHFT 0x8
#define HWIO_EE_n_EV_CH_k_CNTXT_0_EE_BMSK 0xf0
#define HWIO_EE_n_EV_CH_k_CNTXT_0_EE_SHFT 0x4
#define HWIO_EE_n_EV_CH_k_CNTXT_0_CHTYPE_BMSK 0xf
#define HWIO_EE_n_EV_CH_k_CNTXT_0_CHTYPE_SHFT 0x0
#define HWIO_EE_n_EV_CH_k_CNTXT_0_CHTYPE_MHI_EV_FVAL 0x0
#define HWIO_EE_n_EV_CH_k_CNTXT_0_CHTYPE_XHCI_EV_FVAL 0x1
#define HWIO_EE_n_EV_CH_k_CNTXT_0_CHTYPE_GPI_EV_FVAL 0x2
#define HWIO_EE_n_EV_CH_k_CNTXT_0_CHTYPE_XDCI_FVAL 0x3
#define HWIO_EE_n_EV_CH_k_CNTXT_1_ADDR(n, k) (GSI_REG_BASE + 0x00010004 + \
					      0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_1_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					      0x00010004 + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_1_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					      0x00010004 + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_1_RMSK 0xffff
#define HWIO_EE_n_EV_CH_k_CNTXT_1_MAXn 2
#define HWIO_EE_n_EV_CH_k_CNTXT_1_MAXk 19
#define HWIO_EE_n_EV_CH_k_CNTXT_1_ATTR 0x3
#define HWIO_EE_n_EV_CH_k_CNTXT_1_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_1_ADDR(n, k), \
		HWIO_EE_n_EV_CH_k_CNTXT_1_RMSK)
#define HWIO_EE_n_EV_CH_k_CNTXT_1_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_1_ADDR(n, k), \
		mask)
#define HWIO_EE_n_EV_CH_k_CNTXT_1_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_EV_CH_k_CNTXT_1_ADDR(n, k), \
		val)
#define HWIO_EE_n_EV_CH_k_CNTXT_1_OUTMI2(n, k, mask, \
					 val) out_dword_masked_ns( \
		HWIO_EE_n_EV_CH_k_CNTXT_1_ADDR(n, \
					       k), \
		mask, \
		val, \
		HWIO_EE_n_EV_CH_k_CNTXT_1_INI2(n, k))
#define HWIO_EE_n_EV_CH_k_CNTXT_1_R_LENGTH_BMSK 0xffff
#define HWIO_EE_n_EV_CH_k_CNTXT_1_R_LENGTH_SHFT 0x0
#define HWIO_EE_n_EV_CH_k_CNTXT_2_ADDR(n, k) (GSI_REG_BASE + 0x00010008 + \
					      0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_2_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					      0x00010008 + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_2_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					      0x00010008 + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_2_RMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_2_MAXn 2
#define HWIO_EE_n_EV_CH_k_CNTXT_2_MAXk 19
#define HWIO_EE_n_EV_CH_k_CNTXT_2_ATTR 0x3
#define HWIO_EE_n_EV_CH_k_CNTXT_2_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_2_ADDR(n, k), \
		HWIO_EE_n_EV_CH_k_CNTXT_2_RMSK)
#define HWIO_EE_n_EV_CH_k_CNTXT_2_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_2_ADDR(n, k), \
		mask)
#define HWIO_EE_n_EV_CH_k_CNTXT_2_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_EV_CH_k_CNTXT_2_ADDR(n, k), \
		val)
#define HWIO_EE_n_EV_CH_k_CNTXT_2_OUTMI2(n, k, mask, \
					 val) out_dword_masked_ns( \
		HWIO_EE_n_EV_CH_k_CNTXT_2_ADDR(n, \
					       k), \
		mask, \
		val, \
		HWIO_EE_n_EV_CH_k_CNTXT_2_INI2(n, k))
#define HWIO_EE_n_EV_CH_k_CNTXT_2_R_BASE_ADDR_LSBS_BMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_2_R_BASE_ADDR_LSBS_SHFT 0x0
#define HWIO_EE_n_EV_CH_k_CNTXT_3_ADDR(n, k) (GSI_REG_BASE + 0x0001000c + \
					      0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_3_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					      0x0001000c + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_3_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					      0x0001000c + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_3_RMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_3_MAXn 2
#define HWIO_EE_n_EV_CH_k_CNTXT_3_MAXk 19
#define HWIO_EE_n_EV_CH_k_CNTXT_3_ATTR 0x3
#define HWIO_EE_n_EV_CH_k_CNTXT_3_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_3_ADDR(n, k), \
		HWIO_EE_n_EV_CH_k_CNTXT_3_RMSK)
#define HWIO_EE_n_EV_CH_k_CNTXT_3_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_3_ADDR(n, k), \
		mask)
#define HWIO_EE_n_EV_CH_k_CNTXT_3_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_EV_CH_k_CNTXT_3_ADDR(n, k), \
		val)
#define HWIO_EE_n_EV_CH_k_CNTXT_3_OUTMI2(n, k, mask, \
					 val) out_dword_masked_ns( \
		HWIO_EE_n_EV_CH_k_CNTXT_3_ADDR(n, \
					       k), \
		mask, \
		val, \
		HWIO_EE_n_EV_CH_k_CNTXT_3_INI2(n, k))
#define HWIO_EE_n_EV_CH_k_CNTXT_3_R_BASE_ADDR_MSBS_BMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_3_R_BASE_ADDR_MSBS_SHFT 0x0
#define HWIO_EE_n_EV_CH_k_CNTXT_4_ADDR(n, k) (GSI_REG_BASE + 0x00010010 + \
					      0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_4_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					      0x00010010 + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_4_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					      0x00010010 + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_4_RMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_4_MAXn 2
#define HWIO_EE_n_EV_CH_k_CNTXT_4_MAXk 19
#define HWIO_EE_n_EV_CH_k_CNTXT_4_ATTR 0x3
#define HWIO_EE_n_EV_CH_k_CNTXT_4_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_4_ADDR(n, k), \
		HWIO_EE_n_EV_CH_k_CNTXT_4_RMSK)
#define HWIO_EE_n_EV_CH_k_CNTXT_4_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_4_ADDR(n, k), \
		mask)
#define HWIO_EE_n_EV_CH_k_CNTXT_4_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_EV_CH_k_CNTXT_4_ADDR(n, k), \
		val)
#define HWIO_EE_n_EV_CH_k_CNTXT_4_OUTMI2(n, k, mask, \
					 val) out_dword_masked_ns( \
		HWIO_EE_n_EV_CH_k_CNTXT_4_ADDR(n, \
					       k), \
		mask, \
		val, \
		HWIO_EE_n_EV_CH_k_CNTXT_4_INI2(n, k))
#define HWIO_EE_n_EV_CH_k_CNTXT_4_READ_PTR_LSB_BMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_4_READ_PTR_LSB_SHFT 0x0
#define HWIO_EE_n_EV_CH_k_CNTXT_5_ADDR(n, k) (GSI_REG_BASE + 0x00010014 + \
					      0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_5_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					      0x00010014 + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_5_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					      0x00010014 + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_5_RMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_5_MAXn 2
#define HWIO_EE_n_EV_CH_k_CNTXT_5_MAXk 19
#define HWIO_EE_n_EV_CH_k_CNTXT_5_ATTR 0x1
#define HWIO_EE_n_EV_CH_k_CNTXT_5_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_5_ADDR(n, k), \
		HWIO_EE_n_EV_CH_k_CNTXT_5_RMSK)
#define HWIO_EE_n_EV_CH_k_CNTXT_5_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_5_ADDR(n, k), \
		mask)
#define HWIO_EE_n_EV_CH_k_CNTXT_5_READ_PTR_MSB_BMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_5_READ_PTR_MSB_SHFT 0x0
#define HWIO_EE_n_EV_CH_k_CNTXT_6_ADDR(n, k) (GSI_REG_BASE + 0x00010018 + \
					      0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_6_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					      0x00010018 + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_6_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					      0x00010018 + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_6_RMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_6_MAXn 2
#define HWIO_EE_n_EV_CH_k_CNTXT_6_MAXk 19
#define HWIO_EE_n_EV_CH_k_CNTXT_6_ATTR 0x1
#define HWIO_EE_n_EV_CH_k_CNTXT_6_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_6_ADDR(n, k), \
		HWIO_EE_n_EV_CH_k_CNTXT_6_RMSK)
#define HWIO_EE_n_EV_CH_k_CNTXT_6_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_6_ADDR(n, k), \
		mask)
#define HWIO_EE_n_EV_CH_k_CNTXT_6_WRITE_PTR_LSB_BMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_6_WRITE_PTR_LSB_SHFT 0x0
#define HWIO_EE_n_EV_CH_k_CNTXT_7_ADDR(n, k) (GSI_REG_BASE + 0x0001001c + \
					      0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_7_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					      0x0001001c + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_7_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					      0x0001001c + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_7_RMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_7_MAXn 2
#define HWIO_EE_n_EV_CH_k_CNTXT_7_MAXk 19
#define HWIO_EE_n_EV_CH_k_CNTXT_7_ATTR 0x1
#define HWIO_EE_n_EV_CH_k_CNTXT_7_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_7_ADDR(n, k), \
		HWIO_EE_n_EV_CH_k_CNTXT_7_RMSK)
#define HWIO_EE_n_EV_CH_k_CNTXT_7_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_7_ADDR(n, k), \
		mask)
#define HWIO_EE_n_EV_CH_k_CNTXT_7_WRITE_PTR_MSB_BMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_7_WRITE_PTR_MSB_SHFT 0x0
#define HWIO_EE_n_EV_CH_k_CNTXT_8_ADDR(n, k) (GSI_REG_BASE + 0x00010020 + \
					      0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_8_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					      0x00010020 + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_8_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					      0x00010020 + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_8_RMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_8_MAXn 2
#define HWIO_EE_n_EV_CH_k_CNTXT_8_MAXk 19
#define HWIO_EE_n_EV_CH_k_CNTXT_8_ATTR 0x3
#define HWIO_EE_n_EV_CH_k_CNTXT_8_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_8_ADDR(n, k), \
		HWIO_EE_n_EV_CH_k_CNTXT_8_RMSK)
#define HWIO_EE_n_EV_CH_k_CNTXT_8_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_8_ADDR(n, k), \
		mask)
#define HWIO_EE_n_EV_CH_k_CNTXT_8_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_EV_CH_k_CNTXT_8_ADDR(n, k), \
		val)
#define HWIO_EE_n_EV_CH_k_CNTXT_8_OUTMI2(n, k, mask, \
					 val) out_dword_masked_ns( \
		HWIO_EE_n_EV_CH_k_CNTXT_8_ADDR(n, \
					       k), \
		mask, \
		val, \
		HWIO_EE_n_EV_CH_k_CNTXT_8_INI2(n, k))
#define HWIO_EE_n_EV_CH_k_CNTXT_8_INT_MOD_CNT_BMSK 0xff000000
#define HWIO_EE_n_EV_CH_k_CNTXT_8_INT_MOD_CNT_SHFT 0x18
#define HWIO_EE_n_EV_CH_k_CNTXT_8_INT_MODC_BMSK 0xff0000
#define HWIO_EE_n_EV_CH_k_CNTXT_8_INT_MODC_SHFT 0x10
#define HWIO_EE_n_EV_CH_k_CNTXT_8_INT_MODT_BMSK 0xffff
#define HWIO_EE_n_EV_CH_k_CNTXT_8_INT_MODT_SHFT 0x0
#define HWIO_EE_n_EV_CH_k_CNTXT_9_ADDR(n, k) (GSI_REG_BASE + 0x00010024 + \
					      0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_9_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					      0x00010024 + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_9_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					      0x00010024 + 0x4000 * (n) + \
					      0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_9_RMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_9_MAXn 2
#define HWIO_EE_n_EV_CH_k_CNTXT_9_MAXk 19
#define HWIO_EE_n_EV_CH_k_CNTXT_9_ATTR 0x3
#define HWIO_EE_n_EV_CH_k_CNTXT_9_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_9_ADDR(n, k), \
		HWIO_EE_n_EV_CH_k_CNTXT_9_RMSK)
#define HWIO_EE_n_EV_CH_k_CNTXT_9_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_9_ADDR(n, k), \
		mask)
#define HWIO_EE_n_EV_CH_k_CNTXT_9_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_EV_CH_k_CNTXT_9_ADDR(n, k), \
		val)
#define HWIO_EE_n_EV_CH_k_CNTXT_9_OUTMI2(n, k, mask, \
					 val) out_dword_masked_ns( \
		HWIO_EE_n_EV_CH_k_CNTXT_9_ADDR(n, \
					       k), \
		mask, \
		val, \
		HWIO_EE_n_EV_CH_k_CNTXT_9_INI2(n, k))
#define HWIO_EE_n_EV_CH_k_CNTXT_9_INTVEC_BMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_9_INTVEC_SHFT 0x0
#define HWIO_EE_n_EV_CH_k_CNTXT_10_ADDR(n, k) (GSI_REG_BASE + 0x00010028 + \
					       0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_10_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					       0x00010028 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_10_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					       0x00010028 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_10_RMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_10_MAXn 2
#define HWIO_EE_n_EV_CH_k_CNTXT_10_MAXk 19
#define HWIO_EE_n_EV_CH_k_CNTXT_10_ATTR 0x3
#define HWIO_EE_n_EV_CH_k_CNTXT_10_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_10_ADDR(n, k), \
		HWIO_EE_n_EV_CH_k_CNTXT_10_RMSK)
#define HWIO_EE_n_EV_CH_k_CNTXT_10_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_10_ADDR(n, k), \
		mask)
#define HWIO_EE_n_EV_CH_k_CNTXT_10_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_EV_CH_k_CNTXT_10_ADDR(n, k), \
		val)
#define HWIO_EE_n_EV_CH_k_CNTXT_10_OUTMI2(n, k, mask, \
					  val) out_dword_masked_ns( \
		HWIO_EE_n_EV_CH_k_CNTXT_10_ADDR(n, \
						k), \
		mask, \
		val, \
		HWIO_EE_n_EV_CH_k_CNTXT_10_INI2(n, k))
#define HWIO_EE_n_EV_CH_k_CNTXT_10_MSI_ADDR_LSB_BMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_10_MSI_ADDR_LSB_SHFT 0x0
#define HWIO_EE_n_EV_CH_k_CNTXT_11_ADDR(n, k) (GSI_REG_BASE + 0x0001002c + \
					       0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_11_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					       0x0001002c + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_11_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					       0x0001002c + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_11_RMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_11_MAXn 2
#define HWIO_EE_n_EV_CH_k_CNTXT_11_MAXk 19
#define HWIO_EE_n_EV_CH_k_CNTXT_11_ATTR 0x3
#define HWIO_EE_n_EV_CH_k_CNTXT_11_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_11_ADDR(n, k), \
		HWIO_EE_n_EV_CH_k_CNTXT_11_RMSK)
#define HWIO_EE_n_EV_CH_k_CNTXT_11_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_11_ADDR(n, k), \
		mask)
#define HWIO_EE_n_EV_CH_k_CNTXT_11_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_EV_CH_k_CNTXT_11_ADDR(n, k), \
		val)
#define HWIO_EE_n_EV_CH_k_CNTXT_11_OUTMI2(n, k, mask, \
					  val) out_dword_masked_ns( \
		HWIO_EE_n_EV_CH_k_CNTXT_11_ADDR(n, \
						k), \
		mask, \
		val, \
		HWIO_EE_n_EV_CH_k_CNTXT_11_INI2(n, k))
#define HWIO_EE_n_EV_CH_k_CNTXT_11_MSI_ADDR_MSB_BMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_11_MSI_ADDR_MSB_SHFT 0x0
#define HWIO_EE_n_EV_CH_k_CNTXT_12_ADDR(n, k) (GSI_REG_BASE + 0x00010030 + \
					       0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_12_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					       0x00010030 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_12_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					       0x00010030 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_12_RMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_12_MAXn 2
#define HWIO_EE_n_EV_CH_k_CNTXT_12_MAXk 19
#define HWIO_EE_n_EV_CH_k_CNTXT_12_ATTR 0x3
#define HWIO_EE_n_EV_CH_k_CNTXT_12_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_12_ADDR(n, k), \
		HWIO_EE_n_EV_CH_k_CNTXT_12_RMSK)
#define HWIO_EE_n_EV_CH_k_CNTXT_12_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_12_ADDR(n, k), \
		mask)
#define HWIO_EE_n_EV_CH_k_CNTXT_12_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_EV_CH_k_CNTXT_12_ADDR(n, k), \
		val)
#define HWIO_EE_n_EV_CH_k_CNTXT_12_OUTMI2(n, k, mask, \
					  val) out_dword_masked_ns( \
		HWIO_EE_n_EV_CH_k_CNTXT_12_ADDR(n, \
						k), \
		mask, \
		val, \
		HWIO_EE_n_EV_CH_k_CNTXT_12_INI2(n, k))
#define HWIO_EE_n_EV_CH_k_CNTXT_12_RP_UPDATE_ADDR_LSB_BMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_12_RP_UPDATE_ADDR_LSB_SHFT 0x0
#define HWIO_EE_n_EV_CH_k_CNTXT_13_ADDR(n, k) (GSI_REG_BASE + 0x00010034 + \
					       0x4000 * (n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_13_PHYS(n, k) (GSI_REG_BASE_PHYS + \
					       0x00010034 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_13_OFFS(n, k) (GSI_REG_BASE_OFFS + \
					       0x00010034 + 0x4000 * (n) + \
					       0x80 * (k))
#define HWIO_EE_n_EV_CH_k_CNTXT_13_RMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_13_MAXn 2
#define HWIO_EE_n_EV_CH_k_CNTXT_13_MAXk 19
#define HWIO_EE_n_EV_CH_k_CNTXT_13_ATTR 0x3
#define HWIO_EE_n_EV_CH_k_CNTXT_13_INI2(n, k) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_13_ADDR(n, k), \
		HWIO_EE_n_EV_CH_k_CNTXT_13_RMSK)
#define HWIO_EE_n_EV_CH_k_CNTXT_13_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_CNTXT_13_ADDR(n, k), \
		mask)
#define HWIO_EE_n_EV_CH_k_CNTXT_13_OUTI2(n, k, val) out_dword( \
		HWIO_EE_n_EV_CH_k_CNTXT_13_ADDR(n, k), \
		val)
#define HWIO_EE_n_EV_CH_k_CNTXT_13_OUTMI2(n, k, mask, \
					  val) out_dword_masked_ns( \
		HWIO_EE_n_EV_CH_k_CNTXT_13_ADDR(n, \
						k), \
		mask, \
		val, \
		HWIO_EE_n_EV_CH_k_CNTXT_13_INI2(n, k))
#define HWIO_EE_n_EV_CH_k_CNTXT_13_RP_UPDATE_ADDR_MSB_BMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_CNTXT_13_RP_UPDATE_ADDR_MSB_SHFT 0x0
#define HWIO_EE_n_EV_CH_k_SCRATCH_0_ADDR(n, k) (GSI_REG_BASE + \
						0x00010048 + 0x4000 * \
						(n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_SCRATCH_0_PHYS(n, k) (GSI_REG_BASE_PHYS + \
						0x00010048 + 0x4000 * \
						(n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_SCRATCH_0_OFFS(n, k) (GSI_REG_BASE_OFFS + \
						0x00010048 + 0x4000 * \
						(n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_SCRATCH_0_RMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_SCRATCH_0_MAXn 2
#define HWIO_EE_n_EV_CH_k_SCRATCH_0_MAXk 19
#define HWIO_EE_n_EV_CH_k_SCRATCH_0_ATTR 0x3
#define HWIO_EE_n_EV_CH_k_SCRATCH_0_INI2(n, k) in_dword_masked(	\
		HWIO_EE_n_EV_CH_k_SCRATCH_0_ADDR(n, k),	\
		HWIO_EE_n_EV_CH_k_SCRATCH_0_RMSK)
#define HWIO_EE_n_EV_CH_k_SCRATCH_0_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_SCRATCH_0_ADDR(n, k),	\
		mask)
#define HWIO_EE_n_EV_CH_k_SCRATCH_0_OUTI2(n, k, val) out_dword(	\
		HWIO_EE_n_EV_CH_k_SCRATCH_0_ADDR(n, k),	\
		val)
#define HWIO_EE_n_EV_CH_k_SCRATCH_0_OUTMI2(n, k, mask, \
					   val) out_dword_masked_ns( \
		HWIO_EE_n_EV_CH_k_SCRATCH_0_ADDR(n, \
						 k), \
		mask, \
		val, \
		HWIO_EE_n_EV_CH_k_SCRATCH_0_INI2(n, k))
#define HWIO_EE_n_EV_CH_k_SCRATCH_0_SCRATCH_BMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_SCRATCH_0_SCRATCH_SHFT 0x0
#define HWIO_EE_n_EV_CH_k_SCRATCH_1_ADDR(n, k) (GSI_REG_BASE + \
						0x0001004c + 0x4000 * \
						(n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_SCRATCH_1_PHYS(n, k) (GSI_REG_BASE_PHYS + \
						0x0001004c + 0x4000 * \
						(n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_SCRATCH_1_OFFS(n, k) (GSI_REG_BASE_OFFS + \
						0x0001004c + 0x4000 * \
						(n) + 0x80 * (k))
#define HWIO_EE_n_EV_CH_k_SCRATCH_1_RMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_SCRATCH_1_MAXn 2
#define HWIO_EE_n_EV_CH_k_SCRATCH_1_MAXk 19
#define HWIO_EE_n_EV_CH_k_SCRATCH_1_ATTR 0x3
#define HWIO_EE_n_EV_CH_k_SCRATCH_1_INI2(n, k) in_dword_masked(	\
		HWIO_EE_n_EV_CH_k_SCRATCH_1_ADDR(n, k),	\
		HWIO_EE_n_EV_CH_k_SCRATCH_1_RMSK)
#define HWIO_EE_n_EV_CH_k_SCRATCH_1_INMI2(n, k, mask) in_dword_masked( \
		HWIO_EE_n_EV_CH_k_SCRATCH_1_ADDR(n, k),	\
		mask)
#define HWIO_EE_n_EV_CH_k_SCRATCH_1_OUTI2(n, k, val) out_dword(	\
		HWIO_EE_n_EV_CH_k_SCRATCH_1_ADDR(n, k),	\
		val)
#define HWIO_EE_n_EV_CH_k_SCRATCH_1_OUTMI2(n, k, mask, \
					   val) out_dword_masked_ns( \
		HWIO_EE_n_EV_CH_k_SCRATCH_1_ADDR(n, \
						 k), \
		mask, \
		val, \
		HWIO_EE_n_EV_CH_k_SCRATCH_1_INI2(n, k))
#define HWIO_EE_n_EV_CH_k_SCRATCH_1_SCRATCH_BMSK 0xffffffff
#define HWIO_EE_n_EV_CH_k_SCRATCH_1_SCRATCH_SHFT 0x0
#define HWIO_EE_n_GSI_CH_k_DOORBELL_0_ADDR(n, k) (GSI_REG_BASE + \
						  0x00011000 + 0x4000 *	\
						  (n) + 0x8 * (k))
#define HWIO_EE_n_GSI_CH_k_DOORBELL_0_PHYS(n, k) (GSI_REG_BASE_PHYS + \
						  0x00011000 + 0x4000 *	\
						  (n) + 0x8 * (k))
#define HWIO_EE_n_GSI_CH_k_DOORBELL_0_OFFS(n, k) (GSI_REG_BASE_OFFS + \
						  0x00011000 + 0x4000 *	\
						  (n) + 0x8 * (k))
#define HWIO_EE_n_GSI_CH_k_DOORBELL_1_ADDR(n, k) (GSI_REG_BASE + \
						  0x00011004 + 0x4000 *	\
						  (n) + 0x8 * (k))
#define HWIO_EE_n_GSI_CH_k_DOORBELL_1_PHYS(n, k) (GSI_REG_BASE_PHYS + \
						  0x00011004 + 0x4000 *	\
						  (n) + 0x8 * (k))
#define HWIO_EE_n_GSI_CH_k_DOORBELL_1_OFFS(n, k) (GSI_REG_BASE_OFFS + \
						  0x00011004 + 0x4000 *	\
						  (n) + 0x8 * (k))
#define HWIO_EE_n_EV_CH_k_DOORBELL_0_ADDR(n, k) (GSI_REG_BASE +	\
						 0x00011100 + 0x4000 * \
						 (n) + 0x8 * (k))
#define HWIO_EE_n_EV_CH_k_DOORBELL_0_PHYS(n, k) (GSI_REG_BASE_PHYS + \
						 0x00011100 + 0x4000 * \
						 (n) + 0x8 * (k))
#define HWIO_EE_n_EV_CH_k_DOORBELL_0_OFFS(n, k) (GSI_REG_BASE_OFFS + \
						 0x00011100 + 0x4000 * \
						 (n) + 0x8 * (k))
#define HWIO_EE_n_EV_CH_k_DOORBELL_1_ADDR(n, k) (GSI_REG_BASE +	\
						 0x00011104 + 0x4000 * \
						 (n) + 0x8 * (k))
#define HWIO_EE_n_EV_CH_k_DOORBELL_1_PHYS(n, k) (GSI_REG_BASE_PHYS + \
						 0x00011104 + 0x4000 * \
						 (n) + 0x8 * (k))
#define HWIO_EE_n_EV_CH_k_DOORBELL_1_OFFS(n, k) (GSI_REG_BASE_OFFS + \
						 0x00011104 + 0x4000 * \
						 (n) + 0x8 * (k))
#define HWIO_EE_n_GSI_STATUS_ADDR(n) (GSI_REG_BASE + 0x00012000 + 0x4000 * \
				      (n))
#define HWIO_EE_n_GSI_STATUS_PHYS(n) (GSI_REG_BASE_PHYS + 0x00012000 + \
				      0x4000 * (n))
#define HWIO_EE_n_GSI_STATUS_OFFS(n) (GSI_REG_BASE_OFFS + 0x00012000 + \
				      0x4000 * (n))
#define HWIO_EE_n_GSI_STATUS_RMSK 0x1
#define HWIO_EE_n_GSI_STATUS_MAXn 2
#define HWIO_EE_n_GSI_STATUS_ATTR 0x1
#define HWIO_EE_n_GSI_STATUS_INI(n) in_dword_masked( \
		HWIO_EE_n_GSI_STATUS_ADDR(n), \
		HWIO_EE_n_GSI_STATUS_RMSK)
#define HWIO_EE_n_GSI_STATUS_INMI(n, mask) in_dword_masked( \
		HWIO_EE_n_GSI_STATUS_ADDR(n), \
		mask)
#define HWIO_EE_n_GSI_STATUS_ENABLED_BMSK 0x1
#define HWIO_EE_n_GSI_STATUS_ENABLED_SHFT 0x0
#define HWIO_EE_n_GSI_CH_CMD_ADDR(n) (GSI_REG_BASE + 0x00012008 + 0x4000 * \
				      (n))
#define HWIO_EE_n_GSI_CH_CMD_PHYS(n) (GSI_REG_BASE_PHYS + 0x00012008 + \
				      0x4000 * (n))
#define HWIO_EE_n_GSI_CH_CMD_OFFS(n) (GSI_REG_BASE_OFFS + 0x00012008 + \
				      0x4000 * (n))
#define HWIO_EE_n_EV_CH_CMD_ADDR(n) (GSI_REG_BASE + 0x00012010 + 0x4000 * \
				     (n))
#define HWIO_EE_n_EV_CH_CMD_PHYS(n) (GSI_REG_BASE_PHYS + 0x00012010 + \
				     0x4000 * (n))
#define HWIO_EE_n_EV_CH_CMD_OFFS(n) (GSI_REG_BASE_OFFS + 0x00012010 + \
				     0x4000 * (n))
#define HWIO_EE_n_GSI_EE_GENERIC_CMD_ADDR(n) (GSI_REG_BASE + 0x00012018 + \
					      0x4000 * (n))
#define HWIO_EE_n_GSI_EE_GENERIC_CMD_PHYS(n) (GSI_REG_BASE_PHYS + \
					      0x00012018 + 0x4000 * (n))
#define HWIO_EE_n_GSI_EE_GENERIC_CMD_OFFS(n) (GSI_REG_BASE_OFFS + \
					      0x00012018 + 0x4000 * (n))
#define HWIO_EE_n_GSI_HW_PARAM_0_ADDR(n) (GSI_REG_BASE + 0x00012038 + \
					  0x4000 * (n))
#define HWIO_EE_n_GSI_HW_PARAM_0_PHYS(n) (GSI_REG_BASE_PHYS + 0x00012038 + \
					  0x4000 * (n))
#define HWIO_EE_n_GSI_HW_PARAM_0_OFFS(n) (GSI_REG_BASE_OFFS + 0x00012038 + \
					  0x4000 * (n))
#define HWIO_EE_n_GSI_HW_PARAM_1_ADDR(n) (GSI_REG_BASE + 0x0001203c + \
					  0x4000 * (n))
#define HWIO_EE_n_GSI_HW_PARAM_1_PHYS(n) (GSI_REG_BASE_PHYS + 0x0001203c + \
					  0x4000 * (n))
#define HWIO_EE_n_GSI_HW_PARAM_1_OFFS(n) (GSI_REG_BASE_OFFS + 0x0001203c + \
					  0x4000 * (n))
#define HWIO_EE_n_GSI_HW_PARAM_2_ADDR(n) (GSI_REG_BASE + 0x00012040 + \
					  0x4000 * (n))
#define HWIO_EE_n_GSI_HW_PARAM_2_PHYS(n) (GSI_REG_BASE_PHYS + 0x00012040 + \
					  0x4000 * (n))
#define HWIO_EE_n_GSI_HW_PARAM_2_OFFS(n) (GSI_REG_BASE_OFFS + 0x00012040 + \
					  0x4000 * (n))
#define HWIO_EE_n_GSI_SW_VERSION_ADDR(n) (GSI_REG_BASE + 0x00012044 + \
					  0x4000 * (n))
#define HWIO_EE_n_GSI_SW_VERSION_PHYS(n) (GSI_REG_BASE_PHYS + 0x00012044 + \
					  0x4000 * (n))
#define HWIO_EE_n_GSI_SW_VERSION_OFFS(n) (GSI_REG_BASE_OFFS + 0x00012044 + \
					  0x4000 * (n))
#define HWIO_EE_n_GSI_MCS_CODE_VER_ADDR(n) (GSI_REG_BASE + 0x00012048 +	\
					    0x4000 * (n))
#define HWIO_EE_n_GSI_MCS_CODE_VER_PHYS(n) (GSI_REG_BASE_PHYS +	\
					    0x00012048 + 0x4000 * (n))
#define HWIO_EE_n_GSI_MCS_CODE_VER_OFFS(n) (GSI_REG_BASE_OFFS +	\
					    0x00012048 + 0x4000 * (n))
#define HWIO_EE_n_GSI_HW_PARAM_3_ADDR(n) (GSI_REG_BASE + 0x0001204c + \
					  0x4000 * (n))
#define HWIO_EE_n_GSI_HW_PARAM_3_PHYS(n) (GSI_REG_BASE_PHYS + 0x0001204c + \
					  0x4000 * (n))
#define HWIO_EE_n_GSI_HW_PARAM_3_OFFS(n) (GSI_REG_BASE_OFFS + 0x0001204c + \
					  0x4000 * (n))
#define HWIO_EE_n_CNTXT_TYPE_IRQ_ADDR(n) (GSI_REG_BASE + 0x00012080 + \
					  0x4000 * (n))
#define HWIO_EE_n_CNTXT_TYPE_IRQ_PHYS(n) (GSI_REG_BASE_PHYS + 0x00012080 + \
					  0x4000 * (n))
#define HWIO_EE_n_CNTXT_TYPE_IRQ_OFFS(n) (GSI_REG_BASE_OFFS + 0x00012080 + \
					  0x4000 * (n))
#define HWIO_EE_n_CNTXT_TYPE_IRQ_RMSK 0x7f
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MAXn 2
#define HWIO_EE_n_CNTXT_TYPE_IRQ_ATTR 0x1
#define HWIO_EE_n_CNTXT_TYPE_IRQ_INI(n) in_dword_masked( \
		HWIO_EE_n_CNTXT_TYPE_IRQ_ADDR(n), \
		HWIO_EE_n_CNTXT_TYPE_IRQ_RMSK)
#define HWIO_EE_n_CNTXT_TYPE_IRQ_INMI(n, mask) in_dword_masked(	\
		HWIO_EE_n_CNTXT_TYPE_IRQ_ADDR(n), \
		mask)
#define HWIO_EE_n_CNTXT_TYPE_IRQ_GENERAL_BMSK 0x40
#define HWIO_EE_n_CNTXT_TYPE_IRQ_GENERAL_SHFT 0x6
#define HWIO_EE_n_CNTXT_TYPE_IRQ_INTER_EE_EV_CTRL_BMSK 0x20
#define HWIO_EE_n_CNTXT_TYPE_IRQ_INTER_EE_EV_CTRL_SHFT 0x5
#define HWIO_EE_n_CNTXT_TYPE_IRQ_INTER_EE_CH_CTRL_BMSK 0x10
#define HWIO_EE_n_CNTXT_TYPE_IRQ_INTER_EE_CH_CTRL_SHFT 0x4
#define HWIO_EE_n_CNTXT_TYPE_IRQ_IEOB_BMSK 0x8
#define HWIO_EE_n_CNTXT_TYPE_IRQ_IEOB_SHFT 0x3
#define HWIO_EE_n_CNTXT_TYPE_IRQ_GLOB_EE_BMSK 0x4
#define HWIO_EE_n_CNTXT_TYPE_IRQ_GLOB_EE_SHFT 0x2
#define HWIO_EE_n_CNTXT_TYPE_IRQ_EV_CTRL_BMSK 0x2
#define HWIO_EE_n_CNTXT_TYPE_IRQ_EV_CTRL_SHFT 0x1
#define HWIO_EE_n_CNTXT_TYPE_IRQ_CH_CTRL_BMSK 0x1
#define HWIO_EE_n_CNTXT_TYPE_IRQ_CH_CTRL_SHFT 0x0
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_ADDR(n) (GSI_REG_BASE + 0x00012088 + \
					      0x4000 * (n))
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_PHYS(n) (GSI_REG_BASE_PHYS + \
					      0x00012088 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_OFFS(n) (GSI_REG_BASE_OFFS + \
					      0x00012088 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_RMSK 0x7f
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_MAXn 2
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_ATTR 0x3
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_INI(n) in_dword_masked( \
		HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_ADDR(n), \
		HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_RMSK)
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_INMI(n, mask) in_dword_masked( \
		HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_ADDR(n), \
		mask)
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_OUTI(n, val) out_dword( \
		HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_ADDR(n), \
		val)
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_OUTMI(n, mask, \
					   val) out_dword_masked_ns( \
		HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_ADDR( \
			n), \
		mask, \
		val, \
		HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_INI(n))
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_GENERAL_BMSK 0x40
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_GENERAL_SHFT 0x6
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_INTER_EE_EV_CTRL_BMSK 0x20
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_INTER_EE_EV_CTRL_SHFT 0x5
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_INTER_EE_CH_CTRL_BMSK 0x10
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_INTER_EE_CH_CTRL_SHFT 0x4
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_IEOB_BMSK 0x8
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_IEOB_SHFT 0x3
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_GLOB_EE_BMSK 0x4
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_GLOB_EE_SHFT 0x2
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_EV_CTRL_BMSK 0x2
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_EV_CTRL_SHFT 0x1
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_CH_CTRL_BMSK 0x1
#define HWIO_EE_n_CNTXT_TYPE_IRQ_MSK_CH_CTRL_SHFT 0x0
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_ADDR(n) (GSI_REG_BASE + \
						0x00012090 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_PHYS(n) (GSI_REG_BASE_PHYS + \
						0x00012090 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_OFFS(n) (GSI_REG_BASE_OFFS + \
						0x00012090 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_RMSK 0xffffffff
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MAXn 2
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_ATTR 0x1
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_INI(n) in_dword_masked( \
		HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_ADDR(n),	\
		HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_RMSK)
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_INMI(n, mask) in_dword_masked( \
		HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_ADDR(n),	\
		mask)
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_GSI_CH_BIT_MAP_BMSK 0xffffffff
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_GSI_CH_BIT_MAP_SHFT 0x0
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_ADDR(n) (GSI_REG_BASE + 0x00012094 + \
					       0x4000 * (n))
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_PHYS(n) (GSI_REG_BASE_PHYS + \
					       0x00012094 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_OFFS(n) (GSI_REG_BASE_OFFS + \
					       0x00012094 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_RMSK 0xffffffff
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MAXn 2
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_ATTR 0x1
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_INI(n) in_dword_masked( \
		HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_ADDR(n), \
		HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_RMSK)
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_INMI(n, mask) in_dword_masked( \
		HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_ADDR(n), \
		mask)
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_EV_CH_BIT_MAP_BMSK 0xffffffff
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_EV_CH_BIT_MAP_SHFT 0x0
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_ADDR(n) (GSI_REG_BASE + \
						    0x00012098 + 0x4000 * \
						    (n))
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_PHYS(n) (GSI_REG_BASE_PHYS +	\
						    0x00012098 + 0x4000 * \
						    (n))
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_OFFS(n) (GSI_REG_BASE_OFFS +	\
						    0x00012098 + 0x4000 * \
						    (n))
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_RMSK 0x7fffff
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_MAXn 2
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_ATTR 0x3
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_INI(n) in_dword_masked( \
		HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_ADDR(n), \
		HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_RMSK)
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_INMI(n, mask) in_dword_masked( \
		HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_ADDR(n), \
		mask)
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_OUTI(n, val) out_dword( \
		HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_ADDR(n), \
		val)
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_OUTMI(n, mask, \
						 val) out_dword_masked_ns( \
		HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_ADDR( \
			n), \
		mask, \
		val, \
		HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_INI(n))
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_GSI_CH_BIT_MAP_MSK_BMSK \
	0x7fffff
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_MSK_GSI_CH_BIT_MAP_MSK_SHFT 0x0
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_ADDR(n) (GSI_REG_BASE + \
						   0x0001209c + 0x4000 * \
						   (n))
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_PHYS(n) (GSI_REG_BASE_PHYS + \
						   0x0001209c + 0x4000 * \
						   (n))
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_OFFS(n) (GSI_REG_BASE_OFFS + \
						   0x0001209c + 0x4000 * \
						   (n))
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_RMSK 0xfffff
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_MAXn 2
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_ATTR 0x3
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_INI(n) in_dword_masked( \
		HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_ADDR(n), \
		HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_RMSK)
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_INMI(n, mask) in_dword_masked( \
		HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_ADDR(n), \
		mask)
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_OUTI(n, val) out_dword( \
		HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_ADDR(n), \
		val)
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_OUTMI(n, mask, \
						val) out_dword_masked_ns( \
		HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_ADDR(	\
			n), \
		mask, \
		val, \
		HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_INI(n))
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_EV_CH_BIT_MAP_MSK_BMSK 0xfffff
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_MSK_EV_CH_BIT_MAP_MSK_SHFT 0x0
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_ADDR(n) (GSI_REG_BASE + \
						    0x000120a0 + 0x4000 * \
						    (n))
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_PHYS(n) (GSI_REG_BASE_PHYS +	\
						    0x000120a0 + 0x4000 * \
						    (n))
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_OFFS(n) (GSI_REG_BASE_OFFS +	\
						    0x000120a0 + 0x4000 * \
						    (n))
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_RMSK 0xffffffff
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_MAXn 2
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_ATTR 0x2
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_OUTI(n, val) out_dword( \
		HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_ADDR(n), \
		val)
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_GSI_CH_BIT_MAP_BMSK 0xffffffff
#define HWIO_EE_n_CNTXT_SRC_GSI_CH_IRQ_CLR_GSI_CH_BIT_MAP_SHFT 0x0
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_ADDR(n) (GSI_REG_BASE + \
						   0x000120a4 + 0x4000 * \
						   (n))
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_PHYS(n) (GSI_REG_BASE_PHYS + \
						   0x000120a4 + 0x4000 * \
						   (n))
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_OFFS(n) (GSI_REG_BASE_OFFS + \
						   0x000120a4 + 0x4000 * \
						   (n))
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_RMSK 0xffffffff
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_MAXn 2
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_ATTR 0x2
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_OUTI(n, val) out_dword( \
		HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_ADDR(n), \
		val)
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_EV_CH_BIT_MAP_BMSK 0xffffffff
#define HWIO_EE_n_CNTXT_SRC_EV_CH_IRQ_CLR_EV_CH_BIT_MAP_SHFT 0x0
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_ADDR(n) (GSI_REG_BASE + 0x000120b0 + \
					      0x4000 * (n))
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_PHYS(n) (GSI_REG_BASE_PHYS + \
					      0x000120b0 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_OFFS(n) (GSI_REG_BASE_OFFS + \
					      0x000120b0 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_RMSK 0xffffffff
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MAXn 2
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_ATTR 0x1
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_INI(n) in_dword_masked( \
		HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_ADDR(n), \
		HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_RMSK)
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_INMI(n, mask) in_dword_masked( \
		HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_ADDR(n), \
		mask)
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_EV_CH_BIT_MAP_BMSK 0xffffffff
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_EV_CH_BIT_MAP_SHFT 0x0
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_ADDR(n) (GSI_REG_BASE + \
						  0x000120b8 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_PHYS(n) (GSI_REG_BASE_PHYS + \
						  0x000120b8 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_OFFS(n) (GSI_REG_BASE_OFFS + \
						  0x000120b8 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_RMSK 0xfffff
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_MAXn 2
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_ATTR 0x3
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_INI(n) in_dword_masked( \
		HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_ADDR(n), \
		HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_RMSK)
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_INMI(n, mask) in_dword_masked(	\
		HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_ADDR(n), \
		mask)
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_OUTI(n, val) out_dword( \
		HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_ADDR(n), \
		val)
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_OUTMI(n, mask,	\
					       val) out_dword_masked_ns( \
		HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_ADDR( \
			n), \
		mask, \
		val, \
		HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_INI(n))
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_EV_CH_BIT_MAP_MSK_BMSK 0xfffff
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_MSK_EV_CH_BIT_MAP_MSK_SHFT 0x0
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_ADDR(n) (GSI_REG_BASE + \
						  0x000120c0 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_PHYS(n) (GSI_REG_BASE_PHYS + \
						  0x000120c0 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_OFFS(n) (GSI_REG_BASE_OFFS + \
						  0x000120c0 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_RMSK 0xffffffff
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_MAXn 2
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_ATTR 0x2
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_OUTI(n, val) out_dword( \
		HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_ADDR(n), \
		val)
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_EV_CH_BIT_MAP_BMSK 0xffffffff
#define HWIO_EE_n_CNTXT_SRC_IEOB_IRQ_CLR_EV_CH_BIT_MAP_SHFT 0x0
#define HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_ADDR(n) (GSI_REG_BASE + 0x00012100 + \
					       0x4000 * (n))
#define HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_PHYS(n) (GSI_REG_BASE_PHYS + \
					       0x00012100 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_OFFS(n) (GSI_REG_BASE_OFFS + \
					       0x00012100 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_RMSK 0xf
#define HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_MAXn 2
#define HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_ATTR 0x1
#define HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_INI(n) in_dword_masked( \
		HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_ADDR(n), \
		HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_RMSK)
#define HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_INMI(n, mask) in_dword_masked( \
		HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_ADDR(n), \
		mask)
#define HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT3_BMSK 0x8
#define HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT3_SHFT 0x3
#define HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT2_BMSK 0x4
#define HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT2_SHFT 0x2
#define HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT1_BMSK 0x2
#define HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_GP_INT1_SHFT 0x1
#define HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_ERROR_INT_BMSK 0x1
#define HWIO_EE_n_CNTXT_GLOB_IRQ_STTS_ERROR_INT_SHFT 0x0
#define HWIO_EE_n_CNTXT_GLOB_IRQ_EN_ADDR(n) (GSI_REG_BASE + 0x00012108 + \
					     0x4000 * (n))
#define HWIO_EE_n_CNTXT_GLOB_IRQ_EN_PHYS(n) (GSI_REG_BASE_PHYS + \
					     0x00012108 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_GLOB_IRQ_EN_OFFS(n) (GSI_REG_BASE_OFFS + \
					     0x00012108 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_GLOB_IRQ_CLR_ADDR(n) (GSI_REG_BASE + 0x00012110 + \
					      0x4000 * (n))
#define HWIO_EE_n_CNTXT_GLOB_IRQ_CLR_PHYS(n) (GSI_REG_BASE_PHYS + \
					      0x00012110 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_GLOB_IRQ_CLR_OFFS(n) (GSI_REG_BASE_OFFS + \
					      0x00012110 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_GSI_IRQ_STTS_ADDR(n) (GSI_REG_BASE + 0x00012118 + \
					      0x4000 * (n))
#define HWIO_EE_n_CNTXT_GSI_IRQ_STTS_PHYS(n) (GSI_REG_BASE_PHYS + \
					      0x00012118 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_GSI_IRQ_STTS_OFFS(n) (GSI_REG_BASE_OFFS + \
					      0x00012118 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_GSI_IRQ_STTS_RMSK 0xf
#define HWIO_EE_n_CNTXT_GSI_IRQ_STTS_MAXn 2
#define HWIO_EE_n_CNTXT_GSI_IRQ_STTS_ATTR 0x1
#define HWIO_EE_n_CNTXT_GSI_IRQ_STTS_INI(n) in_dword_masked( \
		HWIO_EE_n_CNTXT_GSI_IRQ_STTS_ADDR(n), \
		HWIO_EE_n_CNTXT_GSI_IRQ_STTS_RMSK)
#define HWIO_EE_n_CNTXT_GSI_IRQ_STTS_INMI(n, mask) in_dword_masked( \
		HWIO_EE_n_CNTXT_GSI_IRQ_STTS_ADDR(n), \
		mask)
#define HWIO_EE_n_CNTXT_GSI_IRQ_STTS_GSI_MCS_STACK_OVRFLOW_BMSK 0x8
#define HWIO_EE_n_CNTXT_GSI_IRQ_STTS_GSI_MCS_STACK_OVRFLOW_SHFT 0x3
#define HWIO_EE_n_CNTXT_GSI_IRQ_STTS_GSI_CMD_FIFO_OVRFLOW_BMSK 0x4
#define HWIO_EE_n_CNTXT_GSI_IRQ_STTS_GSI_CMD_FIFO_OVRFLOW_SHFT 0x2
#define HWIO_EE_n_CNTXT_GSI_IRQ_STTS_GSI_BUS_ERROR_BMSK 0x2
#define HWIO_EE_n_CNTXT_GSI_IRQ_STTS_GSI_BUS_ERROR_SHFT 0x1
#define HWIO_EE_n_CNTXT_GSI_IRQ_STTS_GSI_BREAK_POINT_BMSK 0x1
#define HWIO_EE_n_CNTXT_GSI_IRQ_STTS_GSI_BREAK_POINT_SHFT 0x0
#define HWIO_EE_n_CNTXT_GSI_IRQ_EN_ADDR(n) (GSI_REG_BASE + 0x00012120 +	\
					    0x4000 * (n))
#define HWIO_EE_n_CNTXT_GSI_IRQ_EN_PHYS(n) (GSI_REG_BASE_PHYS +	\
					    0x00012120 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_GSI_IRQ_EN_OFFS(n) (GSI_REG_BASE_OFFS +	\
					    0x00012120 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_GSI_IRQ_CLR_ADDR(n) (GSI_REG_BASE + 0x00012128 + \
					     0x4000 * (n))
#define HWIO_EE_n_CNTXT_GSI_IRQ_CLR_PHYS(n) (GSI_REG_BASE_PHYS + \
					     0x00012128 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_GSI_IRQ_CLR_OFFS(n) (GSI_REG_BASE_OFFS + \
					     0x00012128 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_INTSET_ADDR(n) (GSI_REG_BASE + 0x00012180 + \
					0x4000 * (n))
#define HWIO_EE_n_CNTXT_INTSET_PHYS(n) (GSI_REG_BASE_PHYS + 0x00012180 + \
					0x4000 * (n))
#define HWIO_EE_n_CNTXT_INTSET_OFFS(n) (GSI_REG_BASE_OFFS + 0x00012180 + \
					0x4000 * (n))
#define HWIO_EE_n_CNTXT_INTSET_RMSK 0x1
#define HWIO_EE_n_CNTXT_INTSET_MAXn 2
#define HWIO_EE_n_CNTXT_INTSET_ATTR 0x3
#define HWIO_EE_n_CNTXT_INTSET_INI(n) in_dword_masked( \
		HWIO_EE_n_CNTXT_INTSET_ADDR(n),	\
		HWIO_EE_n_CNTXT_INTSET_RMSK)
#define HWIO_EE_n_CNTXT_INTSET_INMI(n, mask) in_dword_masked( \
		HWIO_EE_n_CNTXT_INTSET_ADDR(n),	\
		mask)
#define HWIO_EE_n_CNTXT_INTSET_OUTI(n, val) out_dword( \
		HWIO_EE_n_CNTXT_INTSET_ADDR(n),	\
		val)
#define HWIO_EE_n_CNTXT_INTSET_OUTMI(n, mask, val) out_dword_masked_ns(	\
		HWIO_EE_n_CNTXT_INTSET_ADDR(n),	\
		mask, \
		val, \
		HWIO_EE_n_CNTXT_INTSET_INI(n))
#define HWIO_EE_n_CNTXT_INTSET_INTYPE_BMSK 0x1
#define HWIO_EE_n_CNTXT_INTSET_INTYPE_SHFT 0x0
#define HWIO_EE_n_CNTXT_INTSET_INTYPE_MSI_FVAL 0x0
#define HWIO_EE_n_CNTXT_INTSET_INTYPE_IRQ_FVAL 0x1
#define HWIO_EE_n_CNTXT_MSI_BASE_LSB_ADDR(n) (GSI_REG_BASE + 0x00012188 + \
					      0x4000 * (n))
#define HWIO_EE_n_CNTXT_MSI_BASE_LSB_PHYS(n) (GSI_REG_BASE_PHYS + \
					      0x00012188 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_MSI_BASE_LSB_OFFS(n) (GSI_REG_BASE_OFFS + \
					      0x00012188 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_MSI_BASE_LSB_RMSK 0xffffffff
#define HWIO_EE_n_CNTXT_MSI_BASE_LSB_MAXn 2
#define HWIO_EE_n_CNTXT_MSI_BASE_LSB_ATTR 0x3
#define HWIO_EE_n_CNTXT_MSI_BASE_LSB_INI(n) in_dword_masked( \
		HWIO_EE_n_CNTXT_MSI_BASE_LSB_ADDR(n), \
		HWIO_EE_n_CNTXT_MSI_BASE_LSB_RMSK)
#define HWIO_EE_n_CNTXT_MSI_BASE_LSB_INMI(n, mask) in_dword_masked( \
		HWIO_EE_n_CNTXT_MSI_BASE_LSB_ADDR(n), \
		mask)
#define HWIO_EE_n_CNTXT_MSI_BASE_LSB_OUTI(n, val) out_dword( \
		HWIO_EE_n_CNTXT_MSI_BASE_LSB_ADDR(n), \
		val)
#define HWIO_EE_n_CNTXT_MSI_BASE_LSB_OUTMI(n, mask, \
					   val) out_dword_masked_ns( \
		HWIO_EE_n_CNTXT_MSI_BASE_LSB_ADDR( \
			n), \
		mask, \
		val, \
		HWIO_EE_n_CNTXT_MSI_BASE_LSB_INI(n))
#define HWIO_EE_n_CNTXT_MSI_BASE_LSB_MSI_ADDR_LSB_BMSK 0xffffffff
#define HWIO_EE_n_CNTXT_MSI_BASE_LSB_MSI_ADDR_LSB_SHFT 0x0
#define HWIO_EE_n_CNTXT_MSI_BASE_MSB_ADDR(n) (GSI_REG_BASE + 0x0001218c + \
					      0x4000 * (n))
#define HWIO_EE_n_CNTXT_MSI_BASE_MSB_PHYS(n) (GSI_REG_BASE_PHYS + \
					      0x0001218c + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_MSI_BASE_MSB_OFFS(n) (GSI_REG_BASE_OFFS + \
					      0x0001218c + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_MSI_BASE_MSB_RMSK 0xffffffff
#define HWIO_EE_n_CNTXT_MSI_BASE_MSB_MAXn 2
#define HWIO_EE_n_CNTXT_MSI_BASE_MSB_ATTR 0x3
#define HWIO_EE_n_CNTXT_MSI_BASE_MSB_INI(n) in_dword_masked( \
		HWIO_EE_n_CNTXT_MSI_BASE_MSB_ADDR(n), \
		HWIO_EE_n_CNTXT_MSI_BASE_MSB_RMSK)
#define HWIO_EE_n_CNTXT_MSI_BASE_MSB_INMI(n, mask) in_dword_masked( \
		HWIO_EE_n_CNTXT_MSI_BASE_MSB_ADDR(n), \
		mask)
#define HWIO_EE_n_CNTXT_MSI_BASE_MSB_OUTI(n, val) out_dword( \
		HWIO_EE_n_CNTXT_MSI_BASE_MSB_ADDR(n), \
		val)
#define HWIO_EE_n_CNTXT_MSI_BASE_MSB_OUTMI(n, mask, \
					   val) out_dword_masked_ns( \
		HWIO_EE_n_CNTXT_MSI_BASE_MSB_ADDR( \
			n), \
		mask, \
		val, \
		HWIO_EE_n_CNTXT_MSI_BASE_MSB_INI(n))
#define HWIO_EE_n_CNTXT_MSI_BASE_MSB_MSI_ADDR_MSB_BMSK 0xffffffff
#define HWIO_EE_n_CNTXT_MSI_BASE_MSB_MSI_ADDR_MSB_SHFT 0x0
#define HWIO_EE_n_CNTXT_INT_VEC_ADDR(n) (GSI_REG_BASE + 0x00012190 + \
					 0x4000 * (n))
#define HWIO_EE_n_CNTXT_INT_VEC_PHYS(n) (GSI_REG_BASE_PHYS + 0x00012190 + \
					 0x4000 * (n))
#define HWIO_EE_n_CNTXT_INT_VEC_OFFS(n) (GSI_REG_BASE_OFFS + 0x00012190 + \
					 0x4000 * (n))
#define HWIO_EE_n_ERROR_LOG_ADDR(n) (GSI_REG_BASE + 0x00012200 + 0x4000 * \
				     (n))
#define HWIO_EE_n_ERROR_LOG_PHYS(n) (GSI_REG_BASE_PHYS + 0x00012200 + \
				     0x4000 * (n))
#define HWIO_EE_n_ERROR_LOG_OFFS(n) (GSI_REG_BASE_OFFS + 0x00012200 + \
				     0x4000 * (n))
#define HWIO_EE_n_ERROR_LOG_RMSK 0xffffffff
#define HWIO_EE_n_ERROR_LOG_MAXn 2
#define HWIO_EE_n_ERROR_LOG_ATTR 0x3
#define HWIO_EE_n_ERROR_LOG_INI(n) in_dword_masked( \
		HWIO_EE_n_ERROR_LOG_ADDR(n), \
		HWIO_EE_n_ERROR_LOG_RMSK)
#define HWIO_EE_n_ERROR_LOG_INMI(n, mask) in_dword_masked( \
		HWIO_EE_n_ERROR_LOG_ADDR(n), \
		mask)
#define HWIO_EE_n_ERROR_LOG_OUTI(n, val) out_dword( \
		HWIO_EE_n_ERROR_LOG_ADDR(n), \
		val)
#define HWIO_EE_n_ERROR_LOG_OUTMI(n, mask, val) out_dword_masked_ns( \
		HWIO_EE_n_ERROR_LOG_ADDR(n), \
		mask, \
		val, \
		HWIO_EE_n_ERROR_LOG_INI(n))
#define HWIO_EE_n_ERROR_LOG_ERROR_LOG_BMSK 0xffffffff
#define HWIO_EE_n_ERROR_LOG_ERROR_LOG_SHFT 0x0
#define HWIO_EE_n_ERROR_LOG_CLR_ADDR(n) (GSI_REG_BASE + 0x00012210 + \
					 0x4000 * (n))
#define HWIO_EE_n_ERROR_LOG_CLR_PHYS(n) (GSI_REG_BASE_PHYS + 0x00012210 + \
					 0x4000 * (n))
#define HWIO_EE_n_ERROR_LOG_CLR_OFFS(n) (GSI_REG_BASE_OFFS + 0x00012210 + \
					 0x4000 * (n))
#define HWIO_EE_n_ERROR_LOG_CLR_RMSK 0xffffffff
#define HWIO_EE_n_ERROR_LOG_CLR_MAXn 2
#define HWIO_EE_n_ERROR_LOG_CLR_ATTR 0x2
#define HWIO_EE_n_ERROR_LOG_CLR_OUTI(n, val) out_dword(	\
		HWIO_EE_n_ERROR_LOG_CLR_ADDR(n), \
		val)
#define HWIO_EE_n_ERROR_LOG_CLR_ERROR_LOG_CLR_BMSK 0xffffffff
#define HWIO_EE_n_ERROR_LOG_CLR_ERROR_LOG_CLR_SHFT 0x0
#define HWIO_EE_n_CNTXT_SCRATCH_0_ADDR(n) (GSI_REG_BASE + 0x00012400 + \
					   0x4000 * (n))
#define HWIO_EE_n_CNTXT_SCRATCH_0_PHYS(n) (GSI_REG_BASE_PHYS + \
					   0x00012400 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_SCRATCH_0_OFFS(n) (GSI_REG_BASE_OFFS + \
					   0x00012400 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_SCRATCH_0_RMSK 0xffffffff
#define HWIO_EE_n_CNTXT_SCRATCH_0_MAXn 2
#define HWIO_EE_n_CNTXT_SCRATCH_0_ATTR 0x3
#define HWIO_EE_n_CNTXT_SCRATCH_0_INI(n) in_dword_masked( \
		HWIO_EE_n_CNTXT_SCRATCH_0_ADDR(n), \
		HWIO_EE_n_CNTXT_SCRATCH_0_RMSK)
#define HWIO_EE_n_CNTXT_SCRATCH_0_INMI(n, mask) in_dword_masked( \
		HWIO_EE_n_CNTXT_SCRATCH_0_ADDR(n), \
		mask)
#define HWIO_EE_n_CNTXT_SCRATCH_0_OUTI(n, val) out_dword( \
		HWIO_EE_n_CNTXT_SCRATCH_0_ADDR(n), \
		val)
#define HWIO_EE_n_CNTXT_SCRATCH_0_OUTMI(n, mask, val) out_dword_masked_ns( \
		HWIO_EE_n_CNTXT_SCRATCH_0_ADDR(n), \
		mask, \
		val, \
		HWIO_EE_n_CNTXT_SCRATCH_0_INI(n))
#define HWIO_EE_n_CNTXT_SCRATCH_0_SCRATCH_BMSK 0xffffffff
#define HWIO_EE_n_CNTXT_SCRATCH_0_SCRATCH_SHFT 0x0
#define HWIO_EE_n_CNTXT_SCRATCH_1_ADDR(n) (GSI_REG_BASE + 0x00012404 + \
					   0x4000 * (n))
#define HWIO_EE_n_CNTXT_SCRATCH_1_PHYS(n) (GSI_REG_BASE_PHYS + \
					   0x00012404 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_SCRATCH_1_OFFS(n) (GSI_REG_BASE_OFFS + \
					   0x00012404 + 0x4000 * (n))
#define HWIO_EE_n_CNTXT_SCRATCH_1_RMSK 0xffffffff
#define HWIO_EE_n_CNTXT_SCRATCH_1_MAXn 2
#define HWIO_EE_n_CNTXT_SCRATCH_1_ATTR 0x3
#define HWIO_EE_n_CNTXT_SCRATCH_1_INI(n) in_dword_masked( \
		HWIO_EE_n_CNTXT_SCRATCH_1_ADDR(n), \
		HWIO_EE_n_CNTXT_SCRATCH_1_RMSK)
#define HWIO_EE_n_CNTXT_SCRATCH_1_INMI(n, mask) in_dword_masked( \
		HWIO_EE_n_CNTXT_SCRATCH_1_ADDR(n), \
		mask)
#define HWIO_EE_n_CNTXT_SCRATCH_1_OUTI(n, val) out_dword( \
		HWIO_EE_n_CNTXT_SCRATCH_1_ADDR(n), \
		val)
#define HWIO_EE_n_CNTXT_SCRATCH_1_OUTMI(n, mask, val) out_dword_masked_ns( \
		HWIO_EE_n_CNTXT_SCRATCH_1_ADDR(n), \
		mask, \
		val, \
		HWIO_EE_n_CNTXT_SCRATCH_1_INI(n))
#define HWIO_EE_n_CNTXT_SCRATCH_1_SCRATCH_BMSK 0xffffffff
#define HWIO_EE_n_CNTXT_SCRATCH_1_SCRATCH_SHFT 0x0
#define HWIO_GSI_MCS_CFG_ADDR (GSI_REG_BASE + 0x0000b000)
#define HWIO_GSI_MCS_CFG_PHYS (GSI_REG_BASE_PHYS + 0x0000b000)
#define HWIO_GSI_MCS_CFG_OFFS (GSI_REG_BASE_OFFS + 0x0000b000)
#define HWIO_GSI_TZ_FW_AUTH_LOCK_ADDR (GSI_REG_BASE + 0x0000b008)
#define HWIO_GSI_TZ_FW_AUTH_LOCK_PHYS (GSI_REG_BASE_PHYS + 0x0000b008)
#define HWIO_GSI_TZ_FW_AUTH_LOCK_OFFS (GSI_REG_BASE_OFFS + 0x0000b008)
#define HWIO_GSI_MSA_FW_AUTH_LOCK_ADDR (GSI_REG_BASE + 0x0000b010)
#define HWIO_GSI_MSA_FW_AUTH_LOCK_PHYS (GSI_REG_BASE_PHYS + 0x0000b010)
#define HWIO_GSI_MSA_FW_AUTH_LOCK_OFFS (GSI_REG_BASE_OFFS + 0x0000b010)
#define HWIO_GSI_SP_FW_AUTH_LOCK_ADDR (GSI_REG_BASE + 0x0000b018)
#define HWIO_GSI_SP_FW_AUTH_LOCK_PHYS (GSI_REG_BASE_PHYS + 0x0000b018)
#define HWIO_GSI_SP_FW_AUTH_LOCK_OFFS (GSI_REG_BASE_OFFS + 0x0000b018)
#define HWIO_INTER_EE_n_ORIGINATOR_EE_ADDR(n) (GSI_REG_BASE + 0x0000c000 + \
					       0x1000 * (n))
#define HWIO_INTER_EE_n_ORIGINATOR_EE_PHYS(n) (GSI_REG_BASE_PHYS + \
					       0x0000c000 + 0x1000 * (n))
#define HWIO_INTER_EE_n_ORIGINATOR_EE_OFFS(n) (GSI_REG_BASE_OFFS + \
					       0x0000c000 + 0x1000 * (n))
#define HWIO_INTER_EE_n_GSI_CH_CMD_ADDR(n) (GSI_REG_BASE + 0x0000c008 +	\
					    0x1000 * (n))
#define HWIO_INTER_EE_n_GSI_CH_CMD_PHYS(n) (GSI_REG_BASE_PHYS +	\
					    0x0000c008 + 0x1000 * (n))
#define HWIO_INTER_EE_n_GSI_CH_CMD_OFFS(n) (GSI_REG_BASE_OFFS +	\
					    0x0000c008 + 0x1000 * (n))
#define HWIO_INTER_EE_n_EV_CH_CMD_ADDR(n) (GSI_REG_BASE + 0x0000c010 + \
					   0x1000 * (n))
#define HWIO_INTER_EE_n_EV_CH_CMD_PHYS(n) (GSI_REG_BASE_PHYS + \
					   0x0000c010 + 0x1000 * (n))
#define HWIO_INTER_EE_n_EV_CH_CMD_OFFS(n) (GSI_REG_BASE_OFFS + \
					   0x0000c010 + 0x1000 * (n))
#define HWIO_INTER_EE_n_SRC_GSI_CH_IRQ_ADDR(n) (GSI_REG_BASE + \
						0x0000c018 + 0x1000 * (n))
#define HWIO_INTER_EE_n_SRC_GSI_CH_IRQ_PHYS(n) (GSI_REG_BASE_PHYS + \
						0x0000c018 + 0x1000 * (n))
#define HWIO_INTER_EE_n_SRC_GSI_CH_IRQ_OFFS(n) (GSI_REG_BASE_OFFS + \
						0x0000c018 + 0x1000 * (n))
#define HWIO_INTER_EE_n_SRC_EV_CH_IRQ_ADDR(n) (GSI_REG_BASE + 0x0000c01c + \
					       0x1000 * (n))
#define HWIO_INTER_EE_n_SRC_EV_CH_IRQ_PHYS(n) (GSI_REG_BASE_PHYS + \
					       0x0000c01c + 0x1000 * (n))
#define HWIO_INTER_EE_n_SRC_EV_CH_IRQ_OFFS(n) (GSI_REG_BASE_OFFS + \
					       0x0000c01c + 0x1000 * (n))
#define HWIO_INTER_EE_n_SRC_GSI_CH_IRQ_MSK_ADDR(n) (GSI_REG_BASE + \
						    0x0000c020 + 0x1000 * \
						    (n))
#define HWIO_INTER_EE_n_SRC_GSI_CH_IRQ_MSK_PHYS(n) (GSI_REG_BASE_PHYS +	\
						    0x0000c020 + 0x1000 * \
						    (n))
#define HWIO_INTER_EE_n_SRC_GSI_CH_IRQ_MSK_OFFS(n) (GSI_REG_BASE_OFFS +	\
						    0x0000c020 + 0x1000 * \
						    (n))
#define HWIO_INTER_EE_n_SRC_EV_CH_IRQ_MSK_ADDR(n) (GSI_REG_BASE + \
						   0x0000c024 + 0x1000 * \
						   (n))
#define HWIO_INTER_EE_n_SRC_EV_CH_IRQ_MSK_PHYS(n) (GSI_REG_BASE_PHYS + \
						   0x0000c024 + 0x1000 * \
						   (n))
#define HWIO_INTER_EE_n_SRC_EV_CH_IRQ_MSK_OFFS(n) (GSI_REG_BASE_OFFS + \
						   0x0000c024 + 0x1000 * \
						   (n))
#define HWIO_INTER_EE_n_SRC_GSI_CH_IRQ_CLR_ADDR(n) (GSI_REG_BASE + \
						    0x0000c028 + 0x1000 * \
						    (n))
#define HWIO_INTER_EE_n_SRC_GSI_CH_IRQ_CLR_PHYS(n) (GSI_REG_BASE_PHYS +	\
						    0x0000c028 + 0x1000 * \
						    (n))
#define HWIO_INTER_EE_n_SRC_GSI_CH_IRQ_CLR_OFFS(n) (GSI_REG_BASE_OFFS +	\
						    0x0000c028 + 0x1000 * \
						    (n))
#define HWIO_INTER_EE_n_SRC_EV_CH_IRQ_CLR_ADDR(n) (GSI_REG_BASE + \
						   0x0000c02c + 0x1000 * \
						   (n))
#define HWIO_INTER_EE_n_SRC_EV_CH_IRQ_CLR_PHYS(n) (GSI_REG_BASE_PHYS + \
						   0x0000c02c + 0x1000 * \
						   (n))
#define HWIO_INTER_EE_n_SRC_EV_CH_IRQ_CLR_OFFS(n) (GSI_REG_BASE_OFFS + \
						   0x0000c02c + 0x1000 * \
						   (n))
#endif
