/*
 * (C) 2021 FCNT LIMITED
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __CUSTOM_DET_DRIVER_H__
#define __CUSTOM_DET_DRIVER_H__

//==============================================================================
// include file
//==============================================================================
#include <linux/device.h>
#include <linux/power_supply.h>
#include <linux/custom_det.h> 

#include "smb5-lib.h"
#include "smb5-reg.h"

//==============================================================================
// feature
//==============================================================================
#define FEATURE_OEM_CHARGE
#define FEATURE_CUSTOM_DET_DRIVER

#ifdef FEATURE_CUSTOM_DET_DRIVER

//==============================================================================
// define & enum
//==============================================================================
#define CUSTOM_DET_RECLOG(fmt, ...)		printk("REC@REC@0 [CUSTOM DET]" fmt, ##__VA_ARGS__)
#define CUSTOM_DET_LOG(fmt, ...)		printk("[custom_det]" fmt, ##__VA_ARGS__)
#define CUSTOM_DET_LOG_D(fmt, ...)		pr_debug("[custom_det]" fmt, ##__VA_ARGS__)

typedef enum {
	CUSTOM_DET_CHARGE_APSD = 0,
} CUSTOM_DET_CHARGE_TYPE;

//==============================================================================
// functions
//==============================================================================
void custom_det_dcin_ov_handler(void);
void custom_det_usbin_ov_handler(void);

bool custom_det_otg_disable(void);
void custom_det_otg_en_set(bool);

void custom_det_typec_change_notification(void); 
void custom_det_charge_req(CUSTOM_DET_CHARGE_TYPE type, bool enable);

int custom_det_request_usb_safety_irqs(struct device *dev);

int custom_det_determine_initial_status(void);
int custom_det_init(struct smb_charger *chg);
void custom_det_probe_end_notification(int vbus_status); 
void custom_det_shutdown(void);
int custom_det_remove(struct smb_charger *chg);

#endif /* FEATURE_CUSTOM_DET_DRIVER */

#endif /* __CUSTOM_DET_DRIVER_H__ */
