/*----------------------------------------------------------------------------*/
// (C) 2021 FCNT LIMITED
/*----------------------------------------------------------------------------*/
/* SPDX-License-Identifier: GPL-2.0+ */

#ifndef __OEM_CHARGER_LOCAL_H
#define __OEM_CHARGER_LOCAL_H

/* CHARGER_CONFIG */
//#define CHG_DRV_CONFIG_HOLDER_ENABLE
#undef CHG_DRV_CONFIG_HOLDER_ENABLE

//#define CHG_DRV_CONFIG_USE_APNV_VMAX
#undef CHG_DRV_CONFIG_USE_APNV_VMAX

//#define CHG_DRV_CONFIG_PD_ENABLE
#undef CHG_DRV_CONFIG_PD_ENABLE

/* CHARGER_WA */
//#define CHG_DRV_WA_USBIN_ADC
#undef CHG_DRV_WA_USBIN_ADC

//#define CHG_DRV_WA_DETECT_ADP_REMOVAL
#undef CHG_DRV_WA_DETECT_ADP_REMOVAL


#define APNV_CHARGE_FG_FUNC_LIMITS_I		(41053)
#define APNV_CHARGE_FG_RCOMP0_I				(47140)
#define APNV_CHARGE_FG_TEMPCO_I				(47141)
#define APNV_CHARGE_FG_FULLCAP_I			(47142)
#define APNV_CHARGE_FG_CYCLES_I 			(47143)
#define APNV_CHARGE_FG_FULLCAPNOM_I 		(47144)
#define APNV_CHARGE_FG_IAVG_EMPTY_I 		(47145)
#define APNV_CHARGE_FG_QRTABLE00_I			(47146)
#define APNV_CHARGE_FG_QRTABLE10_I			(47147)
#define APNV_CHARGE_FG_QRTABLE20_I			(47148)
#define APNV_CHARGE_FG_QRTABLE30_I			(47149)
#define APNV_CHARGE_FG_AGE_RES_I			(47150)
#define APNV_CHARGE_FG_VF_COUNT_I			(49003)
#define APNV_CHARGE_FG_AGE_I				(49004)
#define APNV_CHARGE_DEMO_I					(49283)
#define APNV_ITEM_LONGEVITYCHARGE			(49395)
#define APNV_CHARGING_DATA					(49291)
#define APNV_CHARGING_SETTING				(49296)

/* Power Supply name */
#define QPNP_BMS_PSY_NAME					"bms"
#define QPNP_USB_PSY_NAME					"usb"
#define QPNP_DC_PSY_NAME					"dc"
#define QPNP_BATTERY_PSY_NAME				"battery"

#define OEM_CHG_USB_PSY_NAME				"chg-usb"
#define OEM_CHG_AC_PSY_NAME					"chg-ac"
#define OEM_CHG_HOLDER_PSY_NAME				"chg-holder"

#define OEM_CHARGER_PSY_NAME				"oem-chg"
#define OEM_BATTERY_PSY_NAME				"oem-batt"

#define CHG_DRV_NONE_LONGEVITY				0x00
#define CHG_DRV_1ST_LONGEVITY				0x01
#define CHG_DRV_2ND_LONGEVITY				0x02

enum {
	CHG_DRV_SET_LOW = 0,
	CHG_DRV_SET_HIGH,
};

enum {
	OEM_CHG_SOURCE_HOLDER = 0,		/* for Cradle      */
	OEM_CHG_SOURCE_USB,				/* for USB         */
	OEM_CHG_SOURCE_AC,				/* for AC adaptor  */
	OEM_CHG_SOURCE_APSD,			/* for APSD result */
	OEM_CHG_SOURCE_NUM
};

enum {
	CHG_DRV_CMD_SCHG_CHGR_BATTERY_CHARGER_STATUS_1_REG = 0,		/* 0x00001006 */
	CHG_DRV_CMD_SCHG_CHGR_CHGR_CFG2_REG,						/* 0x00001051 */
	CHG_DRV_CMD_SCHG_CHGR_JEITA_EN_CFG_REG,						/* 0x00001090 */
	CHG_DRV_CMD_SCHG_CHGR_SAFETY_TIMER_ENABLE_CFG_REG,			/* 0x000010A0 */
	CHG_DRV_CMD_SCHG_DCDC_AICL_ICL_STATUS,						/* 0x00001108 */
	CHG_DRV_CMD_SCHG_DCDC_AICL_STATUS,							/* 0x0000110A */
	CHG_DRV_CMD_SCHG_USB_APSD_RESULT_STATUS_REG,				/* 0x00001308 */
	CHG_DRV_CMD_SCHG_USB_INT_RT_STS_REG,						/* 0x00001310 */
	CHG_DRV_CMD_SCHG_USB_CMD_ICL_OVERRIDE_REG,					/* 0x00001342 */
	CHG_DRV_CMD_SCHG_USB_USBIN_ADAPTER_ALLOW_CFG_REG,			/* 0x00001360 */
	CHG_DRV_CMD_SCHG_USB_USBIN_OPTIONS_1_CFG_REG,				/* 0x00001362 */
	CHG_DRV_CMD_SCHG_USB_USBIN_ICL_OPTIONS_REG,					/* 0x00001366 */
	CHG_DRV_CMD_SCHG_USB_USBIN_CURRENT_LIMIT_CFG_REG,			/* 0x00001370 */
	CHG_DRV_CMD_SCHG_USB_USBIN_AICL_OPTIONS_CFG_REG,			/* 0x00001380 */
	CHG_DRV_CMD_SCHG_USB_USBIN_5V_AICL_THRESHOLD_CFG_REG,		/* 0x00001381 */
	CHG_DRV_CMD_SCHG_USB_USBIN_CONT_AICL_THRESHOLD_CFG_REG,		/* 0x00001384 */
	CHG_DRV_CMD_SCHG_TYPEC_TYPE_C_SNK_STATUS_REG,				/* 0x00001506 */
	CHG_DRV_CMD_SCHG_TYPEC_TYPE_C_STATE_MACHINE_STATUS_REG,		/* 0x00001509 */
	CHG_DRV_CMD_SCHG_MISC_INT_RT_STS_REG,						/* 0x00001610 */
	CHG_DRV_CMD_SCHG_MISC_BARK_BITE_WDOG_PET_REG,				/* 0x00001643 */
	CHG_DRV_CMD_SCHG_MISC_AICL_CMD_REG,							/* 0x00001644 */
	CHG_DRV_CMD_SCHG_MISC_WD_CFG_REG,							/* 0x00001651 */
	CHG_DRV_CMD_SCHG_MISC_SNARL_BARK_BITE_WD_CFG_REG,			/* 0x00001653 */
	CHG_DRV_CMD_SCHG_MISC_AICL_RERUN_TIME_CFG_REG,				/* 0x00001661 */
	CHG_DRV_CMD_SCHG_MISC_THERMREG_SRC_CFG_REG,					/* 0x00001670 */

	CHG_DRV_CMD_NUM,
};

typedef enum {
	CHG_CYCLE_LEVEL_NONE = 0,
	CHG_CYCLE_LEVEL_01,
	CHG_CYCLE_LEVEL_02,
	CHG_CYCLE_LEVEL_NUM,
} chg_cycle_level;

extern int charging_mode;
extern int custom_boot_mode;

#endif /* __OEM_CHARGER_LOCAL_H */
