/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2019, The Linux Foundation. All rights reserved.
 */

#ifndef _DT_BINDINGS_PHY_QCOM_LITO_QMP_USB_H
#define _DT_BINDINGS_PHY_QCOM_LITO_QMP_USB_H

/* USB3-DP Combo PHY register offsets */

#define USB3_DP_COM_PHY_MODE_CTRL				0x0000
#define USB3_DP_COM_SW_RESET					0x0004
#define USB3_DP_COM_POWER_DOWN_CTRL				0x0008
#define USB3_DP_COM_SWI_CTRL					0x000c
#define USB3_DP_COM_TYPEC_CTRL					0x0010
#define USB3_DP_COM_TYPEC_PWRDN_CTRL				0x0014
#define USB3_DP_COM_DP_BIST_CFG_0				0x0018
#define USB3_DP_COM_RESET_OVRD_CTRL				0x001c
#define USB3_DP_COM_DBG_CLK_MUX_CTRL				0x0020
#define USB3_DP_COM_TYPEC_STATUS				0x0024
#define USB3_DP_COM_PLACEHOLDER_STATUS				0x0028
#define USB3_DP_COM_REVISION_ID0				0x002c
#define USB3_DP_COM_REVISION_ID1				0x0030
#define USB3_DP_COM_REVISION_ID2				0x0034
#define USB3_DP_COM_REVISION_ID3				0x0038
#define USB3_DP_QSERDES_COM_ATB_SEL1				0x1000
#define USB3_DP_QSERDES_COM_ATB_SEL2				0x1004
#define USB3_DP_QSERDES_COM_FREQ_UPDATE				0x1008
#define USB3_DP_QSERDES_COM_BG_TIMER				0x100c
#define USB3_DP_QSERDES_COM_SSC_EN_CENTER			0x1010
#define USB3_DP_QSERDES_COM_SSC_ADJ_PER1			0x1014
#define USB3_DP_QSERDES_COM_SSC_ADJ_PER2			0x1018
#define USB3_DP_QSERDES_COM_SSC_PER1				0x101c
#define USB3_DP_QSERDES_COM_SSC_PER2				0x1020
#define USB3_DP_QSERDES_COM_SSC_STEP_SIZE1_MODE0		0x1024
#define USB3_DP_QSERDES_COM_SSC_STEP_SIZE2_MODE0		0x1028
#define USB3_DP_QSERDES_COM_SSC_STEP_SIZE3_MODE0		0x102c
#define USB3_DP_QSERDES_COM_SSC_STEP_SIZE1_MODE1		0x1030
#define USB3_DP_QSERDES_COM_SSC_STEP_SIZE2_MODE1		0x1034
#define USB3_DP_QSERDES_COM_SSC_STEP_SIZE3_MODE1		0x1038
#define USB3_DP_QSERDES_COM_POST_DIV				0x103c
#define USB3_DP_QSERDES_COM_POST_DIV_MUX			0x1040
#define USB3_DP_QSERDES_COM_BIAS_EN_CLKBUFLR_EN			0x1044
#define USB3_DP_QSERDES_COM_CLK_ENABLE1				0x1048
#define USB3_DP_QSERDES_COM_SYS_CLK_CTRL			0x104c
#define USB3_DP_QSERDES_COM_SYSCLK_BUF_ENABLE			0x1050
#define USB3_DP_QSERDES_COM_PLL_EN				0x1054
#define USB3_DP_QSERDES_COM_PLL_IVCO				0x1058
#define USB3_DP_QSERDES_COM_CMN_IETRIM				0x105c
#define USB3_DP_QSERDES_COM_CMN_IPTRIM				0x1060
#define USB3_DP_QSERDES_COM_EP_CLOCK_DETECT_CTRL		0x1064
#define USB3_DP_QSERDES_COM_SYSCLK_DET_COMP_STATUS		0x1068
#define USB3_DP_QSERDES_COM_CLK_EP_DIV_MODE0			0x106c
#define USB3_DP_QSERDES_COM_CLK_EP_DIV_MODE1			0x1070
#define USB3_DP_QSERDES_COM_CP_CTRL_MODE0			0x1074
#define USB3_DP_QSERDES_COM_CP_CTRL_MODE1			0x1078
#define USB3_DP_QSERDES_COM_PLL_RCTRL_MODE0			0x107c
#define USB3_DP_QSERDES_COM_PLL_RCTRL_MODE1			0x1080
#define USB3_DP_QSERDES_COM_PLL_CCTRL_MODE0			0x1084
#define USB3_DP_QSERDES_COM_PLL_CCTRL_MODE1			0x1088
#define USB3_DP_QSERDES_COM_PLL_CNTRL				0x108c
#define USB3_DP_QSERDES_COM_BIAS_EN_CTRL_BY_PSM			0x1090
#define USB3_DP_QSERDES_COM_SYSCLK_EN_SEL			0x1094
#define USB3_DP_QSERDES_COM_CML_SYSCLK_SEL			0x1098
#define USB3_DP_QSERDES_COM_RESETSM_CNTRL			0x109c
#define USB3_DP_QSERDES_COM_RESETSM_CNTRL2			0x10a0
#define USB3_DP_QSERDES_COM_LOCK_CMP_EN				0x10a4
#define USB3_DP_QSERDES_COM_LOCK_CMP_CFG			0x10a8
#define USB3_DP_QSERDES_COM_LOCK_CMP1_MODE0			0x10ac
#define USB3_DP_QSERDES_COM_LOCK_CMP2_MODE0			0x10b0
#define USB3_DP_QSERDES_COM_LOCK_CMP1_MODE1			0x10b4
#define USB3_DP_QSERDES_COM_LOCK_CMP2_MODE1			0x10b8
#define USB3_DP_QSERDES_COM_DEC_START_MODE0			0x10bc
#define USB3_DP_QSERDES_COM_DEC_START_MSB_MODE0			0x10c0
#define USB3_DP_QSERDES_COM_DEC_START_MODE1			0x10c4
#define USB3_DP_QSERDES_COM_DEC_START_MSB_MODE1			0x10c8
#define USB3_DP_QSERDES_COM_DIV_FRAC_START1_MODE0		0x10cc
#define USB3_DP_QSERDES_COM_DIV_FRAC_START2_MODE0		0x10d0
#define USB3_DP_QSERDES_COM_DIV_FRAC_START3_MODE0		0x10d4
#define USB3_DP_QSERDES_COM_DIV_FRAC_START1_MODE1		0x10d8
#define USB3_DP_QSERDES_COM_DIV_FRAC_START2_MODE1		0x10dc
#define USB3_DP_QSERDES_COM_DIV_FRAC_START3_MODE1		0x10e0
#define USB3_DP_QSERDES_COM_INTEGLOOP_INITVAL			0x10e4
#define USB3_DP_QSERDES_COM_INTEGLOOP_EN			0x10e8
#define USB3_DP_QSERDES_COM_INTEGLOOP_GAIN0_MODE0		0x10ec
#define USB3_DP_QSERDES_COM_INTEGLOOP_GAIN1_MODE0		0x10f0
#define USB3_DP_QSERDES_COM_INTEGLOOP_GAIN0_MODE1		0x10f4
#define USB3_DP_QSERDES_COM_INTEGLOOP_GAIN1_MODE1		0x10f8
#define USB3_DP_QSERDES_COM_INTEGLOOP_P_PATH_GAIN0		0x10fc
#define USB3_DP_QSERDES_COM_INTEGLOOP_P_PATH_GAIN1		0x1100
#define USB3_DP_QSERDES_COM_VCOCAL_DEADMAN_CTRL			0x1104
#define USB3_DP_QSERDES_COM_VCO_TUNE_CTRL			0x1108
#define USB3_DP_QSERDES_COM_VCO_TUNE_MAP			0x110c
#define USB3_DP_QSERDES_COM_VCO_TUNE1_MODE0			0x1110
#define USB3_DP_QSERDES_COM_VCO_TUNE2_MODE0			0x1114
#define USB3_DP_QSERDES_COM_VCO_TUNE1_MODE1			0x1118
#define USB3_DP_QSERDES_COM_VCO_TUNE2_MODE1			0x111c
#define USB3_DP_QSERDES_COM_VCO_TUNE_INITVAL1			0x1120
#define USB3_DP_QSERDES_COM_VCO_TUNE_INITVAL2			0x1124
#define USB3_DP_QSERDES_COM_VCO_TUNE_MINVAL1			0x1128
#define USB3_DP_QSERDES_COM_VCO_TUNE_MINVAL2			0x112c
#define USB3_DP_QSERDES_COM_VCO_TUNE_MAXVAL1			0x1130
#define USB3_DP_QSERDES_COM_VCO_TUNE_MAXVAL2			0x1134
#define USB3_DP_QSERDES_COM_VCO_TUNE_TIMER1			0x1138
#define USB3_DP_QSERDES_COM_VCO_TUNE_TIMER2			0x113c
#define USB3_DP_QSERDES_COM_CMN_STATUS				0x1140
#define USB3_DP_QSERDES_COM_RESET_SM_STATUS			0x1144
#define USB3_DP_QSERDES_COM_RESTRIM_CODE_STATUS			0x1148
#define USB3_DP_QSERDES_COM_PLLCAL_CODE1_STATUS			0x114c
#define USB3_DP_QSERDES_COM_PLLCAL_CODE2_STATUS			0x1150
#define USB3_DP_QSERDES_COM_CLK_SELECT				0x1154
#define USB3_DP_QSERDES_COM_HSCLK_SEL				0x1158
#define USB3_DP_QSERDES_COM_HSCLK_HS_SWITCH_SEL			0x115c
#define USB3_DP_QSERDES_COM_INTEGLOOP_BINCODE_STATUS		0x1160
#define USB3_DP_QSERDES_COM_PLL_ANALOG				0x1164
#define USB3_DP_QSERDES_COM_CORECLK_DIV_MODE0			0x1168
#define USB3_DP_QSERDES_COM_CORECLK_DIV_MODE1			0x116c
#define USB3_DP_QSERDES_COM_SW_RESET				0x1170
#define USB3_DP_QSERDES_COM_CORE_CLK_EN				0x1174
#define USB3_DP_QSERDES_COM_C_READY_STATUS			0x1178
#define USB3_DP_QSERDES_COM_CMN_CONFIG				0x117c
#define USB3_DP_QSERDES_COM_CMN_RATE_OVERRIDE			0x1180
#define USB3_DP_QSERDES_COM_SVS_MODE_CLK_SEL			0x1184
#define USB3_DP_QSERDES_COM_DEBUG_BUS0				0x1188
#define USB3_DP_QSERDES_COM_DEBUG_BUS1				0x118c
#define USB3_DP_QSERDES_COM_DEBUG_BUS2				0x1190
#define USB3_DP_QSERDES_COM_DEBUG_BUS3				0x1194
#define USB3_DP_QSERDES_COM_DEBUG_BUS_SEL			0x1198
#define USB3_DP_QSERDES_COM_CMN_MISC1				0x119c
#define USB3_DP_QSERDES_COM_CMN_MODE				0x11a0
#define USB3_DP_QSERDES_COM_CMN_MODE_CONTD			0x11a4
#define USB3_DP_QSERDES_COM_VCO_DC_LEVEL_CTRL			0x11a8
#define USB3_DP_QSERDES_COM_BIN_VCOCAL_CMP_CODE1_MODE0		0x11ac
#define USB3_DP_QSERDES_COM_BIN_VCOCAL_CMP_CODE2_MODE0		0x11b0
#define USB3_DP_QSERDES_COM_BIN_VCOCAL_CMP_CODE1_MODE1		0x11b4
#define USB3_DP_QSERDES_COM_BIN_VCOCAL_CMP_CODE2_MODE1		0x11b8
#define USB3_DP_QSERDES_COM_BIN_VCOCAL_HSCLK_SEL		0x11bc
#define USB3_DP_QSERDES_COM_RESERVED_1				0x11c0
#define USB3_DP_QSERDES_TXA_BIST_MODE_LANENO			0x1200
#define USB3_DP_QSERDES_TXA_BIST_INVERT				0x1204
#define USB3_DP_QSERDES_TXA_CLKBUF_ENABLE			0x1208
#define USB3_DP_QSERDES_TXA_TX_EMP_POST1_LVL			0x120c
#define USB3_DP_QSERDES_TXA_TX_IDLE_LVL_LARGE_AMP		0x1210
#define USB3_DP_QSERDES_TXA_TX_DRV_LVL				0x1214
#define USB3_DP_QSERDES_TXA_TX_DRV_LVL_OFFSET			0x1218
#define USB3_DP_QSERDES_TXA_RESET_TSYNC_EN			0x121c
#define USB3_DP_QSERDES_TXA_PRE_STALL_LDO_BOOST_EN		0x1220
#define USB3_DP_QSERDES_TXA_TX_BAND				0x1224
#define USB3_DP_QSERDES_TXA_SLEW_CNTL				0x1228
#define USB3_DP_QSERDES_TXA_INTERFACE_SELECT			0x122c
#define USB3_DP_QSERDES_TXA_LPB_EN				0x1230
#define USB3_DP_QSERDES_TXA_RES_CODE_LANE_TX			0x1234
#define USB3_DP_QSERDES_TXA_RES_CODE_LANE_RX			0x1238
#define USB3_DP_QSERDES_TXA_RES_CODE_LANE_OFFSET_TX		0x123c
#define USB3_DP_QSERDES_TXA_RES_CODE_LANE_OFFSET_RX		0x1240
#define USB3_DP_QSERDES_TXA_PERL_LENGTH1			0x1244
#define USB3_DP_QSERDES_TXA_PERL_LENGTH2			0x1248
#define USB3_DP_QSERDES_TXA_SERDES_BYP_EN_OUT			0x124c
#define USB3_DP_QSERDES_TXA_DEBUG_BUS_SEL			0x1250
#define USB3_DP_QSERDES_TXA_TRANSCEIVER_BIAS_EN			0x1254
#define USB3_DP_QSERDES_TXA_HIGHZ_DRVR_EN			0x1258
#define USB3_DP_QSERDES_TXA_TX_POL_INV				0x125c
#define USB3_DP_QSERDES_TXA_PARRATE_REC_DETECT_IDLE_EN		0x1260
#define USB3_DP_QSERDES_TXA_BIST_PATTERN1			0x1264
#define USB3_DP_QSERDES_TXA_BIST_PATTERN2			0x1268
#define USB3_DP_QSERDES_TXA_BIST_PATTERN3			0x126c
#define USB3_DP_QSERDES_TXA_BIST_PATTERN4			0x1270
#define USB3_DP_QSERDES_TXA_BIST_PATTERN5			0x1274
#define USB3_DP_QSERDES_TXA_BIST_PATTERN6			0x1278
#define USB3_DP_QSERDES_TXA_BIST_PATTERN7			0x127c
#define USB3_DP_QSERDES_TXA_BIST_PATTERN8			0x1280
#define USB3_DP_QSERDES_TXA_LANE_MODE_1				0x1284
#define USB3_DP_QSERDES_TXA_LANE_MODE_2				0x1288
#define USB3_DP_QSERDES_TXA_LANE_MODE_3				0x128c
#define USB3_DP_QSERDES_TXA_LANE_MODE_4				0x1290
#define USB3_DP_QSERDES_TXA_LANE_MODE_5				0x1294
#define USB3_DP_QSERDES_TXA_ATB_SEL1				0x1298
#define USB3_DP_QSERDES_TXA_ATB_SEL2				0x129c
#define USB3_DP_QSERDES_TXA_RCV_DETECT_LVL			0x12a0
#define USB3_DP_QSERDES_TXA_RCV_DETECT_LVL_2			0x12a4
#define USB3_DP_QSERDES_TXA_PRBS_SEED1				0x12a8
#define USB3_DP_QSERDES_TXA_PRBS_SEED2				0x12ac
#define USB3_DP_QSERDES_TXA_PRBS_SEED3				0x12b0
#define USB3_DP_QSERDES_TXA_PRBS_SEED4				0x12b4
#define USB3_DP_QSERDES_TXA_RESET_GEN				0x12b8
#define USB3_DP_QSERDES_TXA_RESET_GEN_MUXES			0x12bc
#define USB3_DP_QSERDES_TXA_TRAN_DRVR_EMP_EN			0x12c0
#define USB3_DP_QSERDES_TXA_TX_INTERFACE_MODE			0x12c4
#define USB3_DP_QSERDES_TXA_VMODE_CTRL1				0x12c8
#define USB3_DP_QSERDES_TXA_ALOG_OBSV_BUS_CTRL_1		0x12cc
#define USB3_DP_QSERDES_TXA_BIST_STATUS				0x12d0
#define USB3_DP_QSERDES_TXA_BIST_ERROR_COUNT1			0x12d4
#define USB3_DP_QSERDES_TXA_BIST_ERROR_COUNT2			0x12d8
#define USB3_DP_QSERDES_TXA_ALOG_OBSV_BUS_STATUS_1		0x12dc
#define USB3_DP_QSERDES_TXA_LANE_DIG_CONFIG			0x12e0
#define USB3_DP_QSERDES_TXA_PI_QEC_CTRL				0x12e4
#define USB3_DP_QSERDES_TXA_PRE_EMPH				0x12e8
#define USB3_DP_QSERDES_TXA_SW_RESET				0x12ec
#define USB3_DP_QSERDES_TXA_DCC_OFFSET				0x12f0
#define USB3_DP_QSERDES_TXA_DIG_BKUP_CTRL			0x12f4
#define USB3_DP_QSERDES_TXA_DEBUG_BUS0				0x12f8
#define USB3_DP_QSERDES_TXA_DEBUG_BUS1				0x12fc
#define USB3_DP_QSERDES_TXA_DEBUG_BUS2				0x1300
#define USB3_DP_QSERDES_TXA_DEBUG_BUS3				0x1304
#define USB3_DP_QSERDES_TXA_READ_EQCODE				0x1308
#define USB3_DP_QSERDES_TXA_READ_OFFSETCODE			0x130c
#define USB3_DP_QSERDES_TXA_IA_ERROR_COUNTER_LOW		0x1310
#define USB3_DP_QSERDES_TXA_IA_ERROR_COUNTER_HIGH		0x1314
#define USB3_DP_QSERDES_TXA_VGA_READ_CODE			0x1318
#define USB3_DP_QSERDES_TXA_VTH_READ_CODE			0x131c
#define USB3_DP_QSERDES_TXA_DFE_TAP1_READ_CODE			0x1320
#define USB3_DP_QSERDES_TXA_DFE_TAP2_READ_CODE			0x1324
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_I			0x1328
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_IBAR			0x132c
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_Q			0x1330
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_QBAR			0x1334
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_A			0x1338
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_ABAR			0x133c
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_SM_ON			0x1340
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_CAL_DONE		0x1344
#define USB3_DP_QSERDES_TXA_IDAC_STATUS_SIGNERROR		0x1348
#define USB3_DP_QSERDES_TXA_DCC_CAL_STATUS			0x134c
#define USB3_DP_QSERDES_RXA_UCDR_FO_GAIN_HALF			0x1400
#define USB3_DP_QSERDES_RXA_UCDR_FO_GAIN_QUARTER		0x1404
#define USB3_DP_QSERDES_RXA_UCDR_FO_GAIN			0x1408
#define USB3_DP_QSERDES_RXA_UCDR_SO_GAIN_HALF			0x140c
#define USB3_DP_QSERDES_RXA_UCDR_SO_GAIN_QUARTER		0x1410
#define USB3_DP_QSERDES_RXA_UCDR_SO_GAIN			0x1414
#define USB3_DP_QSERDES_RXA_UCDR_SVS_FO_GAIN_HALF		0x1418
#define USB3_DP_QSERDES_RXA_UCDR_SVS_FO_GAIN_QUARTER		0x141c
#define USB3_DP_QSERDES_RXA_UCDR_SVS_FO_GAIN			0x1420
#define USB3_DP_QSERDES_RXA_UCDR_SVS_SO_GAIN_HALF		0x1424
#define USB3_DP_QSERDES_RXA_UCDR_SVS_SO_GAIN_QUARTER		0x1428
#define USB3_DP_QSERDES_RXA_UCDR_SVS_SO_GAIN			0x142c
#define USB3_DP_QSERDES_RXA_UCDR_FASTLOCK_FO_GAIN		0x1430
#define USB3_DP_QSERDES_RXA_UCDR_SO_SATURATION_AND_ENABLE	0x1434
#define USB3_DP_QSERDES_RXA_UCDR_FO_TO_SO_DELAY			0x1438
#define USB3_DP_QSERDES_RXA_UCDR_FASTLOCK_COUNT_LOW		0x143c
#define USB3_DP_QSERDES_RXA_UCDR_FASTLOCK_COUNT_HIGH		0x1440
#define USB3_DP_QSERDES_RXA_UCDR_PI_CONTROLS			0x1444
#define USB3_DP_QSERDES_RXA_UCDR_PI_CTRL2			0x1448
#define USB3_DP_QSERDES_RXA_UCDR_SB2_THRESH1			0x144c
#define USB3_DP_QSERDES_RXA_UCDR_SB2_THRESH2			0x1450
#define USB3_DP_QSERDES_RXA_UCDR_SB2_GAIN1			0x1454
#define USB3_DP_QSERDES_RXA_UCDR_SB2_GAIN2			0x1458
#define USB3_DP_QSERDES_RXA_AUX_CONTROL				0x145c
#define USB3_DP_QSERDES_RXA_AUX_DATA_TCOARSE_TFINE		0x1460
#define USB3_DP_QSERDES_RXA_RCLK_AUXDATA_SEL			0x1464
#define USB3_DP_QSERDES_RXA_AC_JTAG_ENABLE			0x1468
#define USB3_DP_QSERDES_RXA_AC_JTAG_INITP			0x146c
#define USB3_DP_QSERDES_RXA_AC_JTAG_INITN			0x1470
#define USB3_DP_QSERDES_RXA_AC_JTAG_LVL				0x1474
#define USB3_DP_QSERDES_RXA_AC_JTAG_MODE			0x1478
#define USB3_DP_QSERDES_RXA_AC_JTAG_RESET			0x147c
#define USB3_DP_QSERDES_RXA_RX_TERM_BW				0x1480
#define USB3_DP_QSERDES_RXA_RX_RCVR_IQ_EN			0x1484
#define USB3_DP_QSERDES_RXA_RX_IDAC_I_DC_OFFSETS		0x1488
#define USB3_DP_QSERDES_RXA_RX_IDAC_IBAR_DC_OFFSETS		0x148c
#define USB3_DP_QSERDES_RXA_RX_IDAC_Q_DC_OFFSETS		0x1490
#define USB3_DP_QSERDES_RXA_RX_IDAC_QBAR_DC_OFFSETS		0x1494
#define USB3_DP_QSERDES_RXA_RX_IDAC_A_DC_OFFSETS		0x1498
#define USB3_DP_QSERDES_RXA_RX_IDAC_ABAR_DC_OFFSETS		0x149c
#define USB3_DP_QSERDES_RXA_RX_IDAC_EN				0x14a0
#define USB3_DP_QSERDES_RXA_RX_IDAC_ENABLES			0x14a4
#define USB3_DP_QSERDES_RXA_RX_IDAC_SIGN			0x14a8
#define USB3_DP_QSERDES_RXA_RX_HIGHZ_HIGHRATE			0x14ac
#define USB3_DP_QSERDES_RXA_RX_TERM_AC_BYPASS_DC_COUPLE_OFFSET	0x14b0
#define USB3_DP_QSERDES_RXA_DFE_1				0x14b4
#define USB3_DP_QSERDES_RXA_DFE_2				0x14b8
#define USB3_DP_QSERDES_RXA_DFE_3				0x14bc
#define USB3_DP_QSERDES_RXA_DFE_4				0x14c0
#define USB3_DP_QSERDES_RXA_TX_ADAPT_PRE_THRESH1		0x14c4
#define USB3_DP_QSERDES_RXA_TX_ADAPT_PRE_THRESH2		0x14c8
#define USB3_DP_QSERDES_RXA_TX_ADAPT_POST_THRESH		0x14cc
#define USB3_DP_QSERDES_RXA_TX_ADAPT_MAIN_THRESH		0x14d0
#define USB3_DP_QSERDES_RXA_VGA_CAL_CNTRL1			0x14d4
#define USB3_DP_QSERDES_RXA_VGA_CAL_CNTRL2			0x14d8
#define USB3_DP_QSERDES_RXA_GM_CAL				0x14dc
#define USB3_DP_QSERDES_RXA_RX_VGA_GAIN2_LSB			0x14e0
#define USB3_DP_QSERDES_RXA_RX_VGA_GAIN2_MSB			0x14e4
#define USB3_DP_QSERDES_RXA_RX_EQU_ADAPTOR_CNTRL1		0x14e8
#define USB3_DP_QSERDES_RXA_RX_EQU_ADAPTOR_CNTRL2		0x14ec
#define USB3_DP_QSERDES_RXA_RX_EQU_ADAPTOR_CNTRL3		0x14f0
#define USB3_DP_QSERDES_RXA_RX_EQU_ADAPTOR_CNTRL4		0x14f4
#define USB3_DP_QSERDES_RXA_RX_IDAC_TSETTLE_LOW			0x14f8
#define USB3_DP_QSERDES_RXA_RX_IDAC_TSETTLE_HIGH		0x14fc
#define USB3_DP_QSERDES_RXA_RX_IDAC_MEASURE_TIME		0x1500
#define USB3_DP_QSERDES_RXA_RX_IDAC_ACCUMULATOR			0x1504
#define USB3_DP_QSERDES_RXA_RX_EQ_OFFSET_LSB			0x1508
#define USB3_DP_QSERDES_RXA_RX_EQ_OFFSET_MSB			0x150c
#define USB3_DP_QSERDES_RXA_RX_EQ_OFFSET_ADAPTOR_CNTRL1		0x1510
#define USB3_DP_QSERDES_RXA_RX_OFFSET_ADAPTOR_CNTRL2		0x1514
#define USB3_DP_QSERDES_RXA_SIGDET_ENABLES			0x1518
#define USB3_DP_QSERDES_RXA_SIGDET_CNTRL			0x151c
#define USB3_DP_QSERDES_RXA_SIGDET_LVL				0x1520
#define USB3_DP_QSERDES_RXA_SIGDET_DEGLITCH_CNTRL		0x1524
#define USB3_DP_QSERDES_RXA_RX_BAND				0x1528
#define USB3_DP_QSERDES_RXA_CDR_FREEZE_UP_DN			0x152c
#define USB3_DP_QSERDES_RXA_CDR_RESET_OVERRIDE			0x1530
#define USB3_DP_QSERDES_RXA_RX_INTERFACE_MODE			0x1534
#define USB3_DP_QSERDES_RXA_JITTER_GEN_MODE			0x1538
#define USB3_DP_QSERDES_RXA_SJ_AMP1				0x153c
#define USB3_DP_QSERDES_RXA_SJ_AMP2				0x1540
#define USB3_DP_QSERDES_RXA_SJ_PER1				0x1544
#define USB3_DP_QSERDES_RXA_SJ_PER2				0x1548
#define USB3_DP_QSERDES_RXA_PPM_OFFSET1				0x154c
#define USB3_DP_QSERDES_RXA_PPM_OFFSET2				0x1550
#define USB3_DP_QSERDES_RXA_SIGN_PPM_PERIOD1			0x1554
#define USB3_DP_QSERDES_RXA_SIGN_PPM_PERIOD2			0x1558
#define USB3_DP_QSERDES_RXA_RX_MODE_00_LOW			0x155c
#define USB3_DP_QSERDES_RXA_RX_MODE_00_HIGH			0x1560
#define USB3_DP_QSERDES_RXA_RX_MODE_00_HIGH2			0x1564
#define USB3_DP_QSERDES_RXA_RX_MODE_00_HIGH3			0x1568
#define USB3_DP_QSERDES_RXA_RX_MODE_00_HIGH4			0x156c
#define USB3_DP_QSERDES_RXA_RX_MODE_01_LOW			0x1570
#define USB3_DP_QSERDES_RXA_RX_MODE_01_HIGH			0x1574
#define USB3_DP_QSERDES_RXA_RX_MODE_01_HIGH2			0x1578
#define USB3_DP_QSERDES_RXA_RX_MODE_01_HIGH3			0x157c
#define USB3_DP_QSERDES_RXA_RX_MODE_01_HIGH4			0x1580
#define USB3_DP_QSERDES_RXA_RX_MODE_10_LOW			0x1584
#define USB3_DP_QSERDES_RXA_RX_MODE_10_HIGH			0x1588
#define USB3_DP_QSERDES_RXA_RX_MODE_10_HIGH2			0x158c
#define USB3_DP_QSERDES_RXA_RX_MODE_10_HIGH3			0x1590
#define USB3_DP_QSERDES_RXA_RX_MODE_10_HIGH4			0x1594
#define USB3_DP_QSERDES_RXA_PHPRE_CTRL				0x1598
#define USB3_DP_QSERDES_RXA_PHPRE_INITVAL			0x159c
#define USB3_DP_QSERDES_RXA_DFE_EN_TIMER			0x15a0
#define USB3_DP_QSERDES_RXA_DFE_CTLE_POST_CAL_OFFSET		0x15a4
#define USB3_DP_QSERDES_RXA_DCC_CTRL1				0x15a8
#define USB3_DP_QSERDES_RXA_DCC_CTRL2				0x15ac
#define USB3_DP_QSERDES_RXA_VTH_CODE				0x15b0
#define USB3_DP_QSERDES_RXA_VTH_MIN_THRESH			0x15b4
#define USB3_DP_QSERDES_RXA_VTH_MAX_THRESH			0x15b8
#define USB3_DP_QSERDES_RXA_ALOG_OBSV_BUS_CTRL_1		0x15bc
#define USB3_DP_QSERDES_RXA_PI_CTRL1				0x15c0
#define USB3_DP_QSERDES_RXA_PI_CTRL2				0x15c4
#define USB3_DP_QSERDES_RXA_PI_QUAD				0x15c8
#define USB3_DP_QSERDES_RXA_IDATA1				0x15cc
#define USB3_DP_QSERDES_RXA_IDATA2				0x15d0
#define USB3_DP_QSERDES_RXA_AUX_DATA1				0x15d4
#define USB3_DP_QSERDES_RXA_AUX_DATA2				0x15d8
#define USB3_DP_QSERDES_RXA_AC_JTAG_OUTP			0x15dc
#define USB3_DP_QSERDES_RXA_AC_JTAG_OUTN			0x15e0
#define USB3_DP_QSERDES_RXA_RX_SIGDET				0x15e4
#define USB3_DP_QSERDES_RXA_ALOG_OBSV_BUS_STATUS_1		0x15e8
#define USB3_DP_QSERDES_TXB_BIST_MODE_LANENO			0x1600
#define USB3_DP_QSERDES_TXB_BIST_INVERT				0x1604
#define USB3_DP_QSERDES_TXB_CLKBUF_ENABLE			0x1608
#define USB3_DP_QSERDES_TXB_TX_EMP_POST1_LVL			0x160c
#define USB3_DP_QSERDES_TXB_TX_IDLE_LVL_LARGE_AMP		0x1610
#define USB3_DP_QSERDES_TXB_TX_DRV_LVL				0x1614
#define USB3_DP_QSERDES_TXB_TX_DRV_LVL_OFFSET			0x1618
#define USB3_DP_QSERDES_TXB_RESET_TSYNC_EN			0x161c
#define USB3_DP_QSERDES_TXB_PRE_STALL_LDO_BOOST_EN		0x1620
#define USB3_DP_QSERDES_TXB_TX_BAND				0x1624
#define USB3_DP_QSERDES_TXB_SLEW_CNTL				0x1628
#define USB3_DP_QSERDES_TXB_INTERFACE_SELECT			0x162c
#define USB3_DP_QSERDES_TXB_LPB_EN				0x1630
#define USB3_DP_QSERDES_TXB_RES_CODE_LANE_TX			0x1634
#define USB3_DP_QSERDES_TXB_RES_CODE_LANE_RX			0x1638
#define USB3_DP_QSERDES_TXB_RES_CODE_LANE_OFFSET_TX		0x163c
#define USB3_DP_QSERDES_TXB_RES_CODE_LANE_OFFSET_RX		0x1640
#define USB3_DP_QSERDES_TXB_PERL_LENGTH1			0x1644
#define USB3_DP_QSERDES_TXB_PERL_LENGTH2			0x1648
#define USB3_DP_QSERDES_TXB_SERDES_BYP_EN_OUT			0x164c
#define USB3_DP_QSERDES_TXB_DEBUG_BUS_SEL			0x1650
#define USB3_DP_QSERDES_TXB_TRANSCEIVER_BIAS_EN			0x1654
#define USB3_DP_QSERDES_TXB_HIGHZ_DRVR_EN			0x1658
#define USB3_DP_QSERDES_TXB_TX_POL_INV				0x165c
#define USB3_DP_QSERDES_TXB_PARRATE_REC_DETECT_IDLE_EN		0x1660
#define USB3_DP_QSERDES_TXB_BIST_PATTERN1			0x1664
#define USB3_DP_QSERDES_TXB_BIST_PATTERN2			0x1668
#define USB3_DP_QSERDES_TXB_BIST_PATTERN3			0x166c
#define USB3_DP_QSERDES_TXB_BIST_PATTERN4			0x1670
#define USB3_DP_QSERDES_TXB_BIST_PATTERN5			0x1674
#define USB3_DP_QSERDES_TXB_BIST_PATTERN6			0x1678
#define USB3_DP_QSERDES_TXB_BIST_PATTERN7			0x167c
#define USB3_DP_QSERDES_TXB_BIST_PATTERN8			0x1680
#define USB3_DP_QSERDES_TXB_LANE_MODE_1				0x1684
#define USB3_DP_QSERDES_TXB_LANE_MODE_2				0x1688
#define USB3_DP_QSERDES_TXB_LANE_MODE_3				0x168c
#define USB3_DP_QSERDES_TXB_LANE_MODE_4				0x1690
#define USB3_DP_QSERDES_TXB_LANE_MODE_5				0x1694
#define USB3_DP_QSERDES_TXB_ATB_SEL1				0x1698
#define USB3_DP_QSERDES_TXB_ATB_SEL2				0x169c
#define USB3_DP_QSERDES_TXB_RCV_DETECT_LVL			0x16a0
#define USB3_DP_QSERDES_TXB_RCV_DETECT_LVL_2			0x16a4
#define USB3_DP_QSERDES_TXB_PRBS_SEED1				0x16a8
#define USB3_DP_QSERDES_TXB_PRBS_SEED2				0x16ac
#define USB3_DP_QSERDES_TXB_PRBS_SEED3				0x16b0
#define USB3_DP_QSERDES_TXB_PRBS_SEED4				0x16b4
#define USB3_DP_QSERDES_TXB_RESET_GEN				0x16b8
#define USB3_DP_QSERDES_TXB_RESET_GEN_MUXES			0x16bc
#define USB3_DP_QSERDES_TXB_TRAN_DRVR_EMP_EN			0x16c0
#define USB3_DP_QSERDES_TXB_TX_INTERFACE_MODE			0x16c4
#define USB3_DP_QSERDES_TXB_VMODE_CTRL1				0x16c8
#define USB3_DP_QSERDES_TXB_ALOG_OBSV_BUS_CTRL_1		0x16cc
#define USB3_DP_QSERDES_TXB_BIST_STATUS				0x16d0
#define USB3_DP_QSERDES_TXB_BIST_ERROR_COUNT1			0x16d4
#define USB3_DP_QSERDES_TXB_BIST_ERROR_COUNT2			0x16d8
#define USB3_DP_QSERDES_TXB_ALOG_OBSV_BUS_STATUS_1		0x16dc
#define USB3_DP_QSERDES_TXB_LANE_DIG_CONFIG			0x16e0
#define USB3_DP_QSERDES_TXB_PI_QEC_CTRL				0x16e4
#define USB3_DP_QSERDES_TXB_PRE_EMPH				0x16e8
#define USB3_DP_QSERDES_TXB_SW_RESET				0x16ec
#define USB3_DP_QSERDES_TXB_DCC_OFFSET				0x16f0
#define USB3_DP_QSERDES_TXB_DIG_BKUP_CTRL			0x16f4
#define USB3_DP_QSERDES_TXB_DEBUG_BUS0				0x16f8
#define USB3_DP_QSERDES_TXB_DEBUG_BUS1				0x16fc
#define USB3_DP_QSERDES_TXB_DEBUG_BUS2				0x1700
#define USB3_DP_QSERDES_TXB_DEBUG_BUS3				0x1704
#define USB3_DP_QSERDES_TXB_READ_EQCODE				0x1708
#define USB3_DP_QSERDES_TXB_READ_OFFSETCODE			0x170c
#define USB3_DP_QSERDES_TXB_IA_ERROR_COUNTER_LOW		0x1710
#define USB3_DP_QSERDES_TXB_IA_ERROR_COUNTER_HIGH		0x1714
#define USB3_DP_QSERDES_TXB_VGA_READ_CODE			0x1718
#define USB3_DP_QSERDES_TXB_VTH_READ_CODE			0x171c
#define USB3_DP_QSERDES_TXB_DFE_TAP1_READ_CODE			0x1720
#define USB3_DP_QSERDES_TXB_DFE_TAP2_READ_CODE			0x1724
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_I			0x1728
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_IBAR			0x172c
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_Q			0x1730
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_QBAR			0x1734
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_A			0x1738
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_ABAR			0x173c
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_SM_ON			0x1740
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_CAL_DONE		0x1744
#define USB3_DP_QSERDES_TXB_IDAC_STATUS_SIGNERROR		0x1748
#define USB3_DP_QSERDES_TXB_DCC_CAL_STATUS			0x174c
#define USB3_DP_QSERDES_RXB_UCDR_FO_GAIN_HALF			0x1800
#define USB3_DP_QSERDES_RXB_UCDR_FO_GAIN_QUARTER		0x1804
#define USB3_DP_QSERDES_RXB_UCDR_FO_GAIN			0x1808
#define USB3_DP_QSERDES_RXB_UCDR_SO_GAIN_HALF			0x180c
#define USB3_DP_QSERDES_RXB_UCDR_SO_GAIN_QUARTER		0x1810
#define USB3_DP_QSERDES_RXB_UCDR_SO_GAIN			0x1814
#define USB3_DP_QSERDES_RXB_UCDR_SVS_FO_GAIN_HALF		0x1818
#define USB3_DP_QSERDES_RXB_UCDR_SVS_FO_GAIN_QUARTER		0x181c
#define USB3_DP_QSERDES_RXB_UCDR_SVS_FO_GAIN			0x1820
#define USB3_DP_QSERDES_RXB_UCDR_SVS_SO_GAIN_HALF		0x1824
#define USB3_DP_QSERDES_RXB_UCDR_SVS_SO_GAIN_QUARTER		0x1828
#define USB3_DP_QSERDES_RXB_UCDR_SVS_SO_GAIN			0x182c
#define USB3_DP_QSERDES_RXB_UCDR_FASTLOCK_FO_GAIN		0x1830
#define USB3_DP_QSERDES_RXB_UCDR_SO_SATURATION_AND_ENABLE	0x1834
#define USB3_DP_QSERDES_RXB_UCDR_FO_TO_SO_DELAY			0x1838
#define USB3_DP_QSERDES_RXB_UCDR_FASTLOCK_COUNT_LOW		0x183c
#define USB3_DP_QSERDES_RXB_UCDR_FASTLOCK_COUNT_HIGH		0x1840
#define USB3_DP_QSERDES_RXB_UCDR_PI_CONTROLS			0x1844
#define USB3_DP_QSERDES_RXB_UCDR_PI_CTRL2			0x1848
#define USB3_DP_QSERDES_RXB_UCDR_SB2_THRESH1			0x184c
#define USB3_DP_QSERDES_RXB_UCDR_SB2_THRESH2			0x1850
#define USB3_DP_QSERDES_RXB_UCDR_SB2_GAIN1			0x1854
#define USB3_DP_QSERDES_RXB_UCDR_SB2_GAIN2			0x1858
#define USB3_DP_QSERDES_RXB_AUX_CONTROL				0x185c
#define USB3_DP_QSERDES_RXB_AUX_DATA_TCOARSE_TFINE		0x1860
#define USB3_DP_QSERDES_RXB_RCLK_AUXDATA_SEL			0x1864
#define USB3_DP_QSERDES_RXB_AC_JTAG_ENABLE			0x1868
#define USB3_DP_QSERDES_RXB_AC_JTAG_INITP			0x186c
#define USB3_DP_QSERDES_RXB_AC_JTAG_INITN			0x1870
#define USB3_DP_QSERDES_RXB_AC_JTAG_LVL				0x1874
#define USB3_DP_QSERDES_RXB_AC_JTAG_MODE			0x1878
#define USB3_DP_QSERDES_RXB_AC_JTAG_RESET			0x187c
#define USB3_DP_QSERDES_RXB_RX_TERM_BW				0x1880
#define USB3_DP_QSERDES_RXB_RX_RCVR_IQ_EN			0x1884
#define USB3_DP_QSERDES_RXB_RX_IDAC_I_DC_OFFSETS		0x1888
#define USB3_DP_QSERDES_RXB_RX_IDAC_IBAR_DC_OFFSETS		0x188c
#define USB3_DP_QSERDES_RXB_RX_IDAC_Q_DC_OFFSETS		0x1890
#define USB3_DP_QSERDES_RXB_RX_IDAC_QBAR_DC_OFFSETS		0x1894
#define USB3_DP_QSERDES_RXB_RX_IDAC_A_DC_OFFSETS		0x1898
#define USB3_DP_QSERDES_RXB_RX_IDAC_ABAR_DC_OFFSETS		0x189c
#define USB3_DP_QSERDES_RXB_RX_IDAC_EN				0x18a0
#define USB3_DP_QSERDES_RXB_RX_IDAC_ENABLES			0x18a4
#define USB3_DP_QSERDES_RXB_RX_IDAC_SIGN			0x18a8
#define USB3_DP_QSERDES_RXB_RX_HIGHZ_HIGHRATE			0x18ac
#define USB3_DP_QSERDES_RXB_RX_TERM_AC_BYPASS_DC_COUPLE_OFFSET	0x18b0
#define USB3_DP_QSERDES_RXB_DFE_1				0x18b4
#define USB3_DP_QSERDES_RXB_DFE_2				0x18b8
#define USB3_DP_QSERDES_RXB_DFE_3				0x18bc
#define USB3_DP_QSERDES_RXB_DFE_4				0x18c0
#define USB3_DP_QSERDES_RXB_TX_ADAPT_PRE_THRESH1		0x18c4
#define USB3_DP_QSERDES_RXB_TX_ADAPT_PRE_THRESH2		0x18c8
#define USB3_DP_QSERDES_RXB_TX_ADAPT_POST_THRESH		0x18cc
#define USB3_DP_QSERDES_RXB_TX_ADAPT_MAIN_THRESH		0x18d0
#define USB3_DP_QSERDES_RXB_VGA_CAL_CNTRL1			0x18d4
#define USB3_DP_QSERDES_RXB_VGA_CAL_CNTRL2			0x18d8
#define USB3_DP_QSERDES_RXB_GM_CAL				0x18dc
#define USB3_DP_QSERDES_RXB_RX_VGA_GAIN2_LSB			0x18e0
#define USB3_DP_QSERDES_RXB_RX_VGA_GAIN2_MSB			0x18e4
#define USB3_DP_QSERDES_RXB_RX_EQU_ADAPTOR_CNTRL1		0x18e8
#define USB3_DP_QSERDES_RXB_RX_EQU_ADAPTOR_CNTRL2		0x18ec
#define USB3_DP_QSERDES_RXB_RX_EQU_ADAPTOR_CNTRL3		0x18f0
#define USB3_DP_QSERDES_RXB_RX_EQU_ADAPTOR_CNTRL4		0x18f4
#define USB3_DP_QSERDES_RXB_RX_IDAC_TSETTLE_LOW			0x18f8
#define USB3_DP_QSERDES_RXB_RX_IDAC_TSETTLE_HIGH		0x18fc
#define USB3_DP_QSERDES_RXB_RX_IDAC_MEASURE_TIME		0x1900
#define USB3_DP_QSERDES_RXB_RX_IDAC_ACCUMULATOR			0x1904
#define USB3_DP_QSERDES_RXB_RX_EQ_OFFSET_LSB			0x1908
#define USB3_DP_QSERDES_RXB_RX_EQ_OFFSET_MSB			0x190c
#define USB3_DP_QSERDES_RXB_RX_EQ_OFFSET_ADAPTOR_CNTRL1		0x1910
#define USB3_DP_QSERDES_RXB_RX_OFFSET_ADAPTOR_CNTRL2		0x1914
#define USB3_DP_QSERDES_RXB_SIGDET_ENABLES			0x1918
#define USB3_DP_QSERDES_RXB_SIGDET_CNTRL			0x191c
#define USB3_DP_QSERDES_RXB_SIGDET_LVL				0x1920
#define USB3_DP_QSERDES_RXB_SIGDET_DEGLITCH_CNTRL		0x1924
#define USB3_DP_QSERDES_RXB_RX_BAND				0x1928
#define USB3_DP_QSERDES_RXB_CDR_FREEZE_UP_DN			0x192c
#define USB3_DP_QSERDES_RXB_CDR_RESET_OVERRIDE			0x1930
#define USB3_DP_QSERDES_RXB_RX_INTERFACE_MODE			0x1934
#define USB3_DP_QSERDES_RXB_JITTER_GEN_MODE			0x1938
#define USB3_DP_QSERDES_RXB_SJ_AMP1				0x193c
#define USB3_DP_QSERDES_RXB_SJ_AMP2				0x1940
#define USB3_DP_QSERDES_RXB_SJ_PER1				0x1944
#define USB3_DP_QSERDES_RXB_SJ_PER2				0x1948
#define USB3_DP_QSERDES_RXB_PPM_OFFSET1				0x194c
#define USB3_DP_QSERDES_RXB_PPM_OFFSET2				0x1950
#define USB3_DP_QSERDES_RXB_SIGN_PPM_PERIOD1			0x1954
#define USB3_DP_QSERDES_RXB_SIGN_PPM_PERIOD2			0x1958
#define USB3_DP_QSERDES_RXB_RX_MODE_00_LOW			0x195c
#define USB3_DP_QSERDES_RXB_RX_MODE_00_HIGH			0x1960
#define USB3_DP_QSERDES_RXB_RX_MODE_00_HIGH2			0x1964
#define USB3_DP_QSERDES_RXB_RX_MODE_00_HIGH3			0x1968
#define USB3_DP_QSERDES_RXB_RX_MODE_00_HIGH4			0x196c
#define USB3_DP_QSERDES_RXB_RX_MODE_01_LOW			0x1970
#define USB3_DP_QSERDES_RXB_RX_MODE_01_HIGH			0x1974
#define USB3_DP_QSERDES_RXB_RX_MODE_01_HIGH2			0x1978
#define USB3_DP_QSERDES_RXB_RX_MODE_01_HIGH3			0x197c
#define USB3_DP_QSERDES_RXB_RX_MODE_01_HIGH4			0x1980
#define USB3_DP_QSERDES_RXB_RX_MODE_10_LOW			0x1984
#define USB3_DP_QSERDES_RXB_RX_MODE_10_HIGH			0x1988
#define USB3_DP_QSERDES_RXB_RX_MODE_10_HIGH2			0x198c
#define USB3_DP_QSERDES_RXB_RX_MODE_10_HIGH3			0x1990
#define USB3_DP_QSERDES_RXB_RX_MODE_10_HIGH4			0x1994
#define USB3_DP_QSERDES_RXB_PHPRE_CTRL				0x1998
#define USB3_DP_QSERDES_RXB_PHPRE_INITVAL			0x199c
#define USB3_DP_QSERDES_RXB_DFE_EN_TIMER			0x19a0
#define USB3_DP_QSERDES_RXB_DFE_CTLE_POST_CAL_OFFSET		0x19a4
#define USB3_DP_QSERDES_RXB_DCC_CTRL1				0x19a8
#define USB3_DP_QSERDES_RXB_DCC_CTRL2				0x19ac
#define USB3_DP_QSERDES_RXB_VTH_CODE				0x19b0
#define USB3_DP_QSERDES_RXB_VTH_MIN_THRESH			0x19b4
#define USB3_DP_QSERDES_RXB_VTH_MAX_THRESH			0x19b8
#define USB3_DP_QSERDES_RXB_ALOG_OBSV_BUS_CTRL_1		0x19bc
#define USB3_DP_QSERDES_RXB_PI_CTRL1				0x19c0
#define USB3_DP_QSERDES_RXB_PI_CTRL2				0x19c4
#define USB3_DP_QSERDES_RXB_PI_QUAD				0x19c8
#define USB3_DP_QSERDES_RXB_IDATA1				0x19cc
#define USB3_DP_QSERDES_RXB_IDATA2				0x19d0
#define USB3_DP_QSERDES_RXB_AUX_DATA1				0x19d4
#define USB3_DP_QSERDES_RXB_AUX_DATA2				0x19d8
#define USB3_DP_QSERDES_RXB_AC_JTAG_OUTP			0x19dc
#define USB3_DP_QSERDES_RXB_AC_JTAG_OUTN			0x19e0
#define USB3_DP_QSERDES_RXB_RX_SIGDET				0x19e4
#define USB3_DP_QSERDES_RXB_ALOG_OBSV_BUS_STATUS_1		0x19e8
#define USB3_DP_PCS_MISC_TYPEC_CTRL				0x1a00
#define USB3_DP_PCS_MISC_TYPEC_PWRDN_CTRL			0x1a04
#define USB3_DP_PCS_MISC_PCS_MISC_CONFIG1			0x1a08
#define USB3_DP_PCS_MISC_CLAMP_ENABLE				0x1a0c
#define USB3_DP_PCS_MISC_TYPEC_STATUS				0x1a10
#define USB3_DP_PCS_MISC_PLACEHOLDER_STATUS			0x1a14
#define USB3_DP_PCS_LN_PCS_STATUS1				0x1b00
#define USB3_DP_PCS_LN_PCS_STATUS2				0x1b04
#define USB3_DP_PCS_LN_PCS_STATUS2_CLEAR			0x1b08
#define USB3_DP_PCS_LN_PCS_STATUS3				0x1b0c
#define USB3_DP_PCS_LN_BIST_CHK_ERR_CNT_L_STATUS		0x1b10
#define USB3_DP_PCS_LN_BIST_CHK_ERR_CNT_H_STATUS		0x1b14
#define USB3_DP_PCS_LN_BIST_CHK_STATUS				0x1b18
#define USB3_DP_PCS_LN_INSIG_SW_CTRL1				0x1b1c
#define USB3_DP_PCS_LN_INSIG_MX_CTRL1				0x1b20
#define USB3_DP_PCS_LN_OUTSIG_SW_CTRL1				0x1b24
#define USB3_DP_PCS_LN_OUTSIG_MX_CTRL1				0x1b28
#define USB3_DP_PCS_LN_TEST_CONTROL1				0x1b2c
#define USB3_DP_PCS_LN_BIST_CTRL				0x1b30
#define USB3_DP_PCS_LN_PRBS_SEED0				0x1b34
#define USB3_DP_PCS_LN_PRBS_SEED1				0x1b38
#define USB3_DP_PCS_LN_FIXED_PAT_CTRL				0x1b3c
#define USB3_DP_PCS_LN_EQ_CONFIG				0x1b40
#define USB3_DP_PCS_LN_TEST_CONTROL2				0x1b44
#define USB3_DP_PCS_LN_TEST_CONTROL3				0x1b48
#define USB3_DP_PCS_SW_RESET					0x1c00
#define USB3_DP_PCS_REVISION_ID0				0x1c04
#define USB3_DP_PCS_REVISION_ID1				0x1c08
#define USB3_DP_PCS_REVISION_ID2				0x1c0c
#define USB3_DP_PCS_REVISION_ID3				0x1c10
#define USB3_DP_PCS_PCS_STATUS1					0x1c14
#define USB3_DP_PCS_PCS_STATUS2					0x1c18
#define USB3_DP_PCS_PCS_STATUS3					0x1c1c
#define USB3_DP_PCS_PCS_STATUS4					0x1c20
#define USB3_DP_PCS_PCS_STATUS5					0x1c24
#define USB3_DP_PCS_PCS_STATUS6					0x1c28
#define USB3_DP_PCS_PCS_STATUS7					0x1c2c
#define USB3_DP_PCS_DEBUG_BUS_0_STATUS				0x1c30
#define USB3_DP_PCS_DEBUG_BUS_1_STATUS				0x1c34
#define USB3_DP_PCS_DEBUG_BUS_2_STATUS				0x1c38
#define USB3_DP_PCS_DEBUG_BUS_3_STATUS				0x1c3c
#define USB3_DP_PCS_POWER_DOWN_CONTROL				0x1c40
#define USB3_DP_PCS_START_CONTROL				0x1c44
#define USB3_DP_PCS_INSIG_SW_CTRL1				0x1c48
#define USB3_DP_PCS_INSIG_SW_CTRL2				0x1c4c
#define USB3_DP_PCS_INSIG_SW_CTRL3				0x1c50
#define USB3_DP_PCS_INSIG_SW_CTRL4				0x1c54
#define USB3_DP_PCS_INSIG_SW_CTRL5				0x1c58
#define USB3_DP_PCS_INSIG_SW_CTRL6				0x1c5c
#define USB3_DP_PCS_INSIG_SW_CTRL7				0x1c60
#define USB3_DP_PCS_INSIG_SW_CTRL8				0x1c64
#define USB3_DP_PCS_INSIG_MX_CTRL1				0x1c68
#define USB3_DP_PCS_INSIG_MX_CTRL2				0x1c6c
#define USB3_DP_PCS_INSIG_MX_CTRL3				0x1c70
#define USB3_DP_PCS_INSIG_MX_CTRL4				0x1c74
#define USB3_DP_PCS_INSIG_MX_CTRL5				0x1c78
#define USB3_DP_PCS_INSIG_MX_CTRL7				0x1c7c
#define USB3_DP_PCS_INSIG_MX_CTRL8				0x1c80
#define USB3_DP_PCS_OUTSIG_SW_CTRL1				0x1c84
#define USB3_DP_PCS_OUTSIG_MX_CTRL1				0x1c88
#define USB3_DP_PCS_CLAMP_ENABLE				0x1c8c
#define USB3_DP_PCS_POWER_STATE_CONFIG1				0x1c90
#define USB3_DP_PCS_POWER_STATE_CONFIG2				0x1c94
#define USB3_DP_PCS_FLL_CNTRL1					0x1c98
#define USB3_DP_PCS_FLL_CNTRL2					0x1c9c
#define USB3_DP_PCS_FLL_CNT_VAL_L				0x1ca0
#define USB3_DP_PCS_FLL_CNT_VAL_H_TOL				0x1ca4
#define USB3_DP_PCS_FLL_MAN_CODE				0x1ca8
#define USB3_DP_PCS_TEST_CONTROL1				0x1cac
#define USB3_DP_PCS_TEST_CONTROL2				0x1cb0
#define USB3_DP_PCS_TEST_CONTROL3				0x1cb4
#define USB3_DP_PCS_TEST_CONTROL4				0x1cb8
#define USB3_DP_PCS_TEST_CONTROL5				0x1cbc
#define USB3_DP_PCS_TEST_CONTROL6				0x1cc0
#define USB3_DP_PCS_LOCK_DETECT_CONFIG1				0x1cc4
#define USB3_DP_PCS_LOCK_DETECT_CONFIG2				0x1cc8
#define USB3_DP_PCS_LOCK_DETECT_CONFIG3				0x1ccc
#define USB3_DP_PCS_LOCK_DETECT_CONFIG4				0x1cd0
#define USB3_DP_PCS_LOCK_DETECT_CONFIG5				0x1cd4
#define USB3_DP_PCS_LOCK_DETECT_CONFIG6				0x1cd8
#define USB3_DP_PCS_REFGEN_REQ_CONFIG1				0x1cdc
#define USB3_DP_PCS_REFGEN_REQ_CONFIG2				0x1ce0
#define USB3_DP_PCS_REFGEN_REQ_CONFIG3				0x1ce4
#define USB3_DP_PCS_BIST_CTRL					0x1ce8
#define USB3_DP_PCS_PRBS_POLY0					0x1cec
#define USB3_DP_PCS_PRBS_POLY1					0x1cf0
#define USB3_DP_PCS_FIXED_PAT0					0x1cf4
#define USB3_DP_PCS_FIXED_PAT1					0x1cf8
#define USB3_DP_PCS_FIXED_PAT2					0x1cfc
#define USB3_DP_PCS_FIXED_PAT3					0x1d00
#define USB3_DP_PCS_FIXED_PAT4					0x1d04
#define USB3_DP_PCS_FIXED_PAT5					0x1d08
#define USB3_DP_PCS_FIXED_PAT6					0x1d0c
#define USB3_DP_PCS_FIXED_PAT7					0x1d10
#define USB3_DP_PCS_FIXED_PAT8					0x1d14
#define USB3_DP_PCS_FIXED_PAT9					0x1d18
#define USB3_DP_PCS_FIXED_PAT10					0x1d1c
#define USB3_DP_PCS_FIXED_PAT11					0x1d20
#define USB3_DP_PCS_FIXED_PAT12					0x1d24
#define USB3_DP_PCS_FIXED_PAT13					0x1d28
#define USB3_DP_PCS_FIXED_PAT14					0x1d2c
#define USB3_DP_PCS_FIXED_PAT15					0x1d30
#define USB3_DP_PCS_TXMGN_CONFIG				0x1d34
#define USB3_DP_PCS_G12S1_TXMGN_V0				0x1d38
#define USB3_DP_PCS_G12S1_TXMGN_V1				0x1d3c
#define USB3_DP_PCS_G12S1_TXMGN_V2				0x1d40
#define USB3_DP_PCS_G12S1_TXMGN_V3				0x1d44
#define USB3_DP_PCS_G12S1_TXMGN_V4				0x1d48
#define USB3_DP_PCS_G12S1_TXMGN_V0_RS				0x1d4c
#define USB3_DP_PCS_G12S1_TXMGN_V1_RS				0x1d50
#define USB3_DP_PCS_G12S1_TXMGN_V2_RS				0x1d54
#define USB3_DP_PCS_G12S1_TXMGN_V3_RS				0x1d58
#define USB3_DP_PCS_G12S1_TXMGN_V4_RS				0x1d5c
#define USB3_DP_PCS_G3S2_TXMGN_MAIN				0x1d60
#define USB3_DP_PCS_G3S2_TXMGN_MAIN_RS				0x1d64
#define USB3_DP_PCS_G12S1_TXDEEMPH_M6DB				0x1d68
#define USB3_DP_PCS_G12S1_TXDEEMPH_M3P5DB			0x1d6c
#define USB3_DP_PCS_G3S2_PRE_GAIN				0x1d70
#define USB3_DP_PCS_G3S2_POST_GAIN				0x1d74
#define USB3_DP_PCS_G3S2_PRE_POST_OFFSET			0x1d78
#define USB3_DP_PCS_G3S2_PRE_GAIN_RS				0x1d7c
#define USB3_DP_PCS_G3S2_POST_GAIN_RS				0x1d80
#define USB3_DP_PCS_G3S2_PRE_POST_OFFSET_RS			0x1d84
#define USB3_DP_PCS_RX_SIGDET_LVL				0x1d88
#define USB3_DP_PCS_RX_SIGDET_DTCT_CNTRL			0x1d8c
#define USB3_DP_PCS_RCVR_DTCT_DLY_P1U2_L			0x1d90
#define USB3_DP_PCS_RCVR_DTCT_DLY_P1U2_H			0x1d94
#define USB3_DP_PCS_RATE_SLEW_CNTRL1				0x1d98
#define USB3_DP_PCS_RATE_SLEW_CNTRL2				0x1d9c
#define USB3_DP_PCS_PWRUP_RESET_DLY_TIME_AUXCLK			0x1da0
#define USB3_DP_PCS_P2U3_WAKEUP_DLY_TIME_AUXCLK_L		0x1da4
#define USB3_DP_PCS_P2U3_WAKEUP_DLY_TIME_AUXCLK_H		0x1da8
#define USB3_DP_PCS_TSYNC_RSYNC_TIME				0x1dac
#define USB3_DP_PCS_CDR_RESET_TIME				0x1db0
#define USB3_DP_PCS_TSYNC_DLY_TIME				0x1db4
#define USB3_DP_PCS_ELECIDLE_DLY_SEL				0x1db8
#define USB3_DP_PCS_CMN_ACK_OUT_SEL				0x1dbc
#define USB3_DP_PCS_ALIGN_DETECT_CONFIG1			0x1dc0
#define USB3_DP_PCS_ALIGN_DETECT_CONFIG2			0x1dc4
#define USB3_DP_PCS_ALIGN_DETECT_CONFIG3			0x1dc8
#define USB3_DP_PCS_ALIGN_DETECT_CONFIG4			0x1dcc
#define USB3_DP_PCS_PCS_TX_RX_CONFIG				0x1dd0
#define USB3_DP_PCS_RX_IDLE_DTCT_CNTRL				0x1dd4
#define USB3_DP_PCS_RX_DCC_CAL_CONFIG				0x1dd8
#define USB3_DP_PCS_EQ_CONFIG1					0x1ddc
#define USB3_DP_PCS_EQ_CONFIG2					0x1de0
#define USB3_DP_PCS_EQ_CONFIG3					0x1de4
#define USB3_DP_PCS_EQ_CONFIG4					0x1de8
#define USB3_DP_PCS_EQ_CONFIG5					0x1dec
#define USB3_DP_PCS_USB3_POWER_STATE_CONFIG1			0x1f00
#define USB3_DP_PCS_USB3_AUTONOMOUS_MODE_STATUS			0x1f04
#define USB3_DP_PCS_USB3_AUTONOMOUS_MODE_CTRL			0x1f08
#define USB3_DP_PCS_USB3_AUTONOMOUS_MODE_CTRL2			0x1f0c
#define USB3_DP_PCS_USB3_LFPS_RXTERM_IRQ_SOURCE_STATUS		0x1f10
#define USB3_DP_PCS_USB3_LFPS_RXTERM_IRQ_CLEAR			0x1f14
#define USB3_DP_PCS_USB3_LFPS_DET_HIGH_COUNT_VAL		0x1f18
#define USB3_DP_PCS_USB3_LFPS_TX_ECSTART			0x1f1c
#define USB3_DP_PCS_USB3_LFPS_PER_TIMER_VAL			0x1f20
#define USB3_DP_PCS_USB3_LFPS_TX_END_CNT_U3_START		0x1f24
#define USB3_DP_PCS_USB3_RXEQTRAINING_LOCK_TIME			0x1f28
#define USB3_DP_PCS_USB3_RXEQTRAINING_WAIT_TIME			0x1f2c
#define USB3_DP_PCS_USB3_RXEQTRAINING_CTLE_TIME			0x1f30
#define USB3_DP_PCS_USB3_RXEQTRAINING_WAIT_TIME_S2		0x1f34
#define USB3_DP_PCS_USB3_RXEQTRAINING_DFE_TIME_S2		0x1f38
#define USB3_DP_PCS_USB3_RCVR_DTCT_DLY_U3_L			0x1f3c
#define USB3_DP_PCS_USB3_RCVR_DTCT_DLY_U3_H			0x1f40
#define USB3_DP_PCS_USB3_ARCVR_DTCT_EN_PERIOD			0x1f44
#define USB3_DP_PCS_USB3_ARCVR_DTCT_CM_DLY			0x1f48
#define USB3_DP_PCS_USB3_TXONESZEROS_RUN_LENGTH			0x1f4c
#define USB3_DP_PCS_USB3_ALFPS_DEGLITCH_VAL			0x1f50
#define USB3_DP_PCS_USB3_SIGDET_STARTUP_TIMER_VAL		0x1f54
#define USB3_DP_PCS_USB3_TEST_CONTROL				0x1f58
#define USB3_DP_PCS_USB3_RXTERMINATION_DLY_SEL			0x1f5c

#endif /* _DT_BINDINGS_PHY_QCOM_LITO_QMP_USB_H */
