/*
  * This program is free software; you can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; version 2
  * of the License.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  * GNU General Public License for more details.
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
// (C) 2021 FCNT LIMITED

#ifndef __EARPHONE_H__
#define __EARPHONE_H__
#include <linux/ioctl.h>

#define EARPHONE_VOICE_CALL_START             _IOW('w', 0x0A, int)
#define EARPHONE_VOICE_CALL_STOP              _IOW('w', 0x0B, int)

#define EARPHONE_DET_OUTPUT                   _IOW('w', 0x0E, int)
#define EARPHONE_STATUS_GET                   _IOW('w', 0x0F, int)

struct earphone_status {
	char plug_status;      /* 0x00: No detect, 0x01: detect, 0xFF: error */
	char sw_status;        /* 0x00: Switch Key Down, 0x01: Release, 0xFF: error */
	char pierce_status;
	char plug_vol[2];      /* Earphone Det Voltage. 0xFFFF: error */
	char sw_vol[2];        /* Switch Key Voltage. 0xFFFF: error */
	char pierce_vol[2];    /* Earphone Pierce Voltage. 0xFFFF: error */
	char dummy;
};

void earphone_micbias_ctrl_register(void* func);
void earphone_micbias_ctrl_unregister(void);

void earphone_micbias_wakeup_register(void* func);
void earphone_micbias_wakeup_unregister(void);

void earphone_mic_mute_register(void* func);
void earphone_mic_mute_unregister(void);
#endif // __EARPHONE_H__
