/*----------------------------------------------------------------------------*/
// (C) 2021 FCNT LIMITED
/*----------------------------------------------------------------------------*/
// SPDX-License-Identifier: GPL-2.0

#ifndef _MMCDL_COMMON_H
#define _MMCDL_COMMON_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <linux/ioctl.h>

/*------------------------------------------------------------------*/
// IOCTL
/*------------------------------------------------------------------*/
typedef struct mmcdl_data {
	uint32_t        iSector;
	uint8_t*        iBuff;
	loff_t          iSize;
} mmcdl_data_t;

#define IOC_MAGIC_MMCDL 'w'

#define IOCTL_MMCDLWRITE	_IOW(IOC_MAGIC_MMCDL, 1, mmcdl_data_t)
#define IOCTL_MMCDLREAD		_IOR(IOC_MAGIC_MMCDL, 2, mmcdl_data_t)
#define IOCTL_MMCDLGETSIZE	_IOW(IOC_MAGIC_MMCDL, 3, unsigned long *)
#define IOCTL_MMCDLFORMAT	_IOW(IOC_MAGIC_MMCDL, 4, mmcdl_data_t)

#ifdef CONFIG_COMPAT
typedef struct compat_mmcdl_data {
	uint32_t            iSector;
	compat_uptr_t       iBuff;
	loff_t              iSize;
} compat_mmcdl_data_t;

#define COMPAT_IOCTL_MMCDLWRITE		_IOW(IOC_MAGIC_MMCDL, 1, compat_mmcdl_data_t)
#define COMPAT_IOCTL_MMCDLREAD		_IOR(IOC_MAGIC_MMCDL, 2, compat_mmcdl_data_t)
#define COMPAT_IOCTL_MMCDLGETSIZE	_IOW(IOC_MAGIC_MMCDL, 3, compat_uptr_t)
#define COMPAT_IOCTL_MMCDLFORMAT	_IOW(IOC_MAGIC_MMCDL, 4, compat_mmcdl_data_t)
#endif /* CONFIG_COMPAT */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _MMCDL_COMMON_H */

