#!/bin/sh
#-------------------------------------------------------------------------------
# (C) 2021 FCNT LIMITED
#-------------------------------------------------------------------------------
#  merge_config.sh - Takes a list of config fragment values, and merges
#  them one by one. Provides warnings on overridden values, and specified
#  values that did not make it to the resulting .config file (due to missed
#  dependencies or config symbol removal).
#
#  Portions reused from kconf_check and generate_cfg:
#  http://git.yoctoproject.org/cgit/cgit.cgi/yocto-kernel-tools/tree/tools/kconf_check
#  http://git.yoctoproject.org/cgit/cgit.cgi/yocto-kernel-tools/tree/tools/generate_cfg
#
#  Copyright (c) 2009-2010 Wind River Systems, Inc.
#  Copyright 2011 Linaro
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License version 2 as
#  published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#  See the GNU General Public License for more details.

# temp file delete
temp_file_delete() {
	rm -f $WORK_FILE
}

# set param
OUTPUTFILE=$KERNEL_CFG_MERGE_PARM1
CONFIGPATH=$KERNEL_CFG_MERGE_PARM2
MERGE_SRC_FILE=$CONFIGPATH/$KERNEL_CFG_MERGE_PARM3
MERGE_DEST_FILE=$CONFIGPATH/$KERNEL_CFG_MERGE_PARM4
SED_STR="s/^\(# \)\{0,1\}\(CONFIG_[a-zA-Z0-9_]*\)[= ].*/\2/p"

# disp param
echo "#"
echo "# merge defconfig start"
echo "#"
echo "Param1:$KERNEL_CFG_MERGE_PARM1"
echo "Param2:$KERNEL_CFG_MERGE_PARM2"
echo "Param3:$KERNEL_CFG_MERGE_PARM3"
echo "Param4:$KERNEL_CFG_MERGE_PARM4"
echo "Outpath file:$CONFIGPATH"
echo "Output file:$OUTPUTFILE"
echo "src file:$MERGE_SRC_FILE"
echo "dest file:$MERGE_DEST_FILE"

# defconfig update check
if [ -e $CONFIGPATH/$OUTPUTFILE ]; then
	if [ $CONFIGPATH/$OUTPUTFILE -ot $MERGE_SRC_FILE ]; then
		echo "detect src file update"
	else
		if [ $CONFIGPATH/$OUTPUTFILE -ot $MERGE_DEST_FILE ]; then
			echo "detect dest file update"
		else
			echo "src/dest file not update"
			echo "#"
			echo "# merge defconfig end"
			echo "#"
			exit
		fi
	fi
else
	echo "output file not exist"
fi

# defconfig merge proc
WORK_FILE=$(mktemp ./defconfig_merge_work.XXXXXXXXXX)
echo "#----------------------------------------------------------------------------" > $WORK_FILE
echo "# Do not edit this file. -- YOUR CHANGES WILL BE ERASED!" >> $WORK_FILE
echo "# This file is automatically generated by fj_config_merge.sh." >> $WORK_FILE
echo "#----------------------------------------------------------------------------" >> $WORK_FILE
cat $MERGE_SRC_FILE >> $WORK_FILE
MERGE_FILE=$MERGE_DEST_FILE
echo "Merging $MERGE_FILE"
CFG_LIST=$(sed -n "$SED_STR" $MERGE_FILE)

for CFG in $CFG_LIST ; do
	grep -q -w $CFG $WORK_FILE
	if [ $? -eq 0 ] ; then
		PREV_VAL=$(grep -w $CFG $WORK_FILE)
		NEW_VAL=$(grep -w $CFG $MERGE_FILE)
		if [ "x$PREV_VAL" != "x$NEW_VAL" ] ; then
			echo old Val:$PREV_VAL
			echo new Val:$NEW_VAL
		fi
		sed -i "/$CFG[ =]/d" $WORK_FILE
	fi
done
cat $MERGE_FILE >> $WORK_FILE

rm -f $CONFIGPATH/$OUTPUTFILE
cp $WORK_FILE $CONFIGPATH/$OUTPUTFILE
temp_file_delete

echo "#"
echo "# merge defconfig end"
echo "#"
exit
