/*----------------------------------------------------------------------------*/
// (C) 2021 FCNT LIMITED
/*----------------------------------------------------------------------------*/
/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <linux/ptrace.h>
#include <crypto/sha.h>
//#include "../../fjfeat/FjFeatMac.h"
#include <linux/kdev_t.h>
#include <linux/spinlock.h>
#include <linux/bootmem.h>

#include <linux/msm_ion.h>

//#define DEBUG_COPY_GUARD
//#define DEBUG_ACCESS_CONTROL
//#define DEBUG_KITTING_ACCESS_CONTROL
//#define DEBUG_SETID_ACCESS_CONTROL

#define CURRENT_UID  (current->cred->uid.val % 100000)// for Multi User
#define AID_ROOT              0  /* traditional unix root user */
#define AID_SYSTEM         1000  /* system server */
#define AID_RADIO          1001  /* telephony subsystem, RIL */
#define AID_BLUETOOTH      1002  /* bluetooth subsystem */
#define AID_GRAPHICS       1003  /* graphics */
#define AID_AUDIO          1005  /* audio devices */
#define AID_CAMERA         1006
#define AID_WIFI           1010  /* wifi subsystem */
#define AID_MEDIA          1013
#define AID_VPN            1016  /* vpn system */
#define AID_KEYSTORE       1017  /* keystore */
#define AID_DRM            1019  /* drm server */
#define AID_GPS 1021             /* GPS daemon */
#define AID_MEDIA_RW 1023        /* internal media storage write access */
#define AID_NFC            1027  /* nfc subsystem */
#define AID_AUDIOSERVER   1041  /* audioserver process */
#define AID_DEBUGGERD     1045  /* debuggerd unprivileged user */
#define AID_MEDIA_CODEC   1046  /* mediacodec process */
#define AID_CAMERASERVER  1047  /* cameraserver process */
#define AID_SHELL         2000  /* adb and debug shell user */
#define AID_NET_ADMIN      3005
#define AID_CASDRM        4005
#define AID_LIFELOG       5050
#define AID_PREINST_FELC  5003
#define AID_GROUP_FELC    5003
#define AID_MMP           5034   /* fj mmp */
#define AID_LEGIBLE_FONT  5035
#define AID_CAMERA_APP    5021
#define AID_NOBODY         9999
#define PRNAME_NO_CHECK 0
#define UID_NO_CHECK -1
#define SUPL_NO_CHECK -1
#define SUPL_NO_HASHCHECK -2
#define SUPL_CHK_ALT_ADDR_IONDMA  -10000

#define NO_CHECK_STR "no_check"
#define ISEMPTY "isEmpty"

#define JAVA_APP_PROCESS_PATH32 "/system/bin/app_process32"
#define JAVA_APP_PROCESS_PATH64 "/system/bin/app_process64"
#define CHECK_COMMON		"*"
#define SYSTEM_PROCESS_PATH "/system/bin/"
#define VENDOR_PROCESS_PATH "/vendor/bin/"
#define HCE_PROCESS_PATH "/sbin/healthd"


#define SECURITY_FJSEC_RECOVERY_PROCESS_NAME "recovery"
#define SECURITY_FJSEC_RECOVERY_PROCESS_PATH "/sbin/recovery"

#define S2B(x) ((loff_t)x * SECTOR_SIZE)
#define ADDR2PFN(x) (x >> PAGE_SHIFT)

#define INIT_PROCESS_NAME "init"
#define INIT_PROCESS_PATH "/system/bin/init"

#define BOOT_ARGS_MODE_FOTA "fotamode"
#define BOOT_ARGS_MODE_MAKERCMD "makermode"
#define BOOT_ARGS_MODE_OSUPDATE "osupdatemode"
#define BOOT_ARGS_MODE_RECOVERYMENU "recoverymenu"
#define BOOT_ARGS_MODE_KERNEL "kernelmode"
#define BOOT_ARGS_MODE_MASTERCLEAR "masterclear"
#define BOOT_ARGS_MODE_CHARGER "charger"
#define BOOT_ARGS_MODE_SDDOWNLOADER "sddownloadermode"

#define OFFSET_BYTE_LIMIT LLONG_MAX

#ifdef DEBUG_ACCESS_CONTROL
#define TEST_PTN_PATH "/dev/block/mmcblk0p22"
#define TEST_MOUNT_POINT "/fota2/"
#define TEST_DIRS_PATH TEST_MOUNT_POINT "*"
#endif /* DEBUG_ACCESS_CONTROL */

#define SIGNAL_CATCHER_PROCESS_NAME "Signal Catcher"
#define CTS_BIONIC_PROCESS_NAME "CtsBionicTestCa"

/* for CTS */
#define CTS_TEST
/* for VTS */
#define VTS_TEST

enum boot_mode_type {
	BOOT_MODE_NONE = 0,
	BOOT_MODE_FOTA = 1,
	BOOT_MODE_SDDOWNLOADER = 2,
//	BOOT_MODE_RECOVERY = 3,
	BOOT_MODE_MASTERCLEAR = 3,
//	BOOT_MODE_MAKERCMD = 4,
	BOOT_MODE_OSUPDATE = 5,
	BOOT_MODE_CHARGER = 6,
};

#define ROOT_DIR "/"

enum result_mount_point {
	MATCH_SYSTEM_MOUNT_POINT,
	MATCH_VENDOR_MOUNT_POINT,
#ifdef CONFIG_SECURITY_FJSEC_AC_SECURE_STORAGE
	MATCH_SECURE_STORAGE_MOUNT_POINT,
#endif /* CONFIG_SECURITY_FJSEC_AC_SECURE_STORAGE */
#ifdef CONFIG_SECURITY_FJSEC_AC_KITTING
	MATCH_KITTING_MOUNT_POINT,
#endif /* CONFIG_SECURITY_FJSEC_AC_KITTING */
	MATCH_MOUNT_POINT,
	MATCH_ROOT_MOUNT_POINT,
	MISMATCH_MOUNT_POINT,
	UNRELATED_MOUNT_POINT,
};

//#define LSM_FLG_OFF
//#define LSM_PAGEACL_AUTOREGIST
#define LSM_PAGEACL_DUMPSTACK
//#define LSM_PAGEACL_PERFDBG
//#define LSM_PAGEACL_SSRDBG



#define BOOT_ARGS_FJLSM_ENFORCING   "enforcing"
#define BOOT_ARGS_FJLSM_PERMISSIVE  "permissive"
#define BOOT_ARGS_FJLSM_OFF         "off"

#define APNV_SECURITY_LSM_FLAG_I	49000 
#define FJSEC_LSM_DISABLED			0x00	// LSMS@\
#define FJSEC_LSM_ENABLED			0x01	// LSM{@\L
#define FJSEC_LSM_PERMISSIVE		0x07	// 0x07  LSM ON(Permissive)

#define FJSEC_LSM_NV_BEFORE			0x00	// LSMs擾O
#define FJSEC_LSM_NV_AFTER			0x01	// LSMs擾


#define INIT_PID 1
#define SYSROOT_DEV_PATH "/dev/root"

/**
 * Limitation of device file.
 */
struct fs_path_config {
	mode_t		mode;
	uid_t		uid;
	gid_t		gid;
	dev_t		rdev;
	const char	*prefix;
	// *NEW* add the mount point info to check the path
	const char *mnt_pnt;
};
static struct fs_path_config devs[] = {
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 0), "/dev/block/mmcblk0", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 1), "/dev/block/mmcblk0p1", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 2), "/dev/block/mmcblk0p2", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 3), "/dev/block/mmcblk0p3", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 4), "/dev/block/mmcblk0p4", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 5), "/dev/block/mmcblk0p5", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 6), "/dev/block/mmcblk0p6", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 7), "/dev/block/mmcblk0p7", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 8), "/dev/block/mmcblk0p8", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 9), "/dev/block/mmcblk0p9", "/mnt/vendor/persist" },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 10), "/dev/block/mmcblk0p10", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 11), "/dev/block/mmcblk0p11", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 12), "/dev/block/mmcblk0p12", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 13), "/dev/block/mmcblk0p13", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 14), "/dev/block/mmcblk0p14", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 15), "/dev/block/mmcblk0p15", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 16), "/dev/block/mmcblk0p16", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 17), "/dev/block/mmcblk0p17", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 18), "/dev/block/mmcblk0p18", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 19), "/dev/block/mmcblk0p19", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 20), "/dev/block/mmcblk0p20", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 21), "/dev/block/mmcblk0p21", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 22), "/dev/block/mmcblk0p22", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 23), "/dev/block/mmcblk0p23", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 24), "/dev/block/mmcblk0p24", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 25), "/dev/block/mmcblk0p25", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 26), "/dev/block/mmcblk0p26", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 27), "/dev/block/mmcblk0p27", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 28), "/dev/block/mmcblk0p28", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 29), "/dev/block/mmcblk0p29", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 30), "/dev/block/mmcblk0p30", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(179, 31), "/dev/block/mmcblk0p31", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 0), "/dev/block/mmcblk0p32", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 1), "/dev/block/mmcblk0p33", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 2), "/dev/block/mmcblk0p34", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 3), "/dev/block/mmcblk0p35", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 4), "/dev/block/mmcblk0p36", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 5), "/dev/block/mmcblk0p37", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 6), "/dev/block/mmcblk0p38", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 7), "/dev/block/mmcblk0p39", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 8), "/dev/block/mmcblk0p40", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 9), "/dev/block/mmcblk0p41", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 10), "/dev/block/mmcblk0p42", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 11), "/dev/block/mmcblk0p43", "/vendor/firmware_mnt" },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 12), "/dev/block/mmcblk0p44", "/vendor/firmware_mnt" },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 13), "/dev/block/mmcblk0p45", "/vendor/dsp" },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 14), "/dev/block/mmcblk0p46", "/vendor/dsp" },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 15), "/dev/block/mmcblk0p47", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 16), "/dev/block/mmcblk0p48", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 17), "/dev/block/mmcblk0p49", "/vendor/bt_firmware" },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 18), "/dev/block/mmcblk0p50", "/vendor/bt_firmware" },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 19), "/dev/block/mmcblk0p51", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 20), "/dev/block/mmcblk0p52", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 21), "/dev/block/mmcblk0p53", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 22), "/dev/block/mmcblk0p54", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 23), "/dev/block/mmcblk0p55", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 24), "/dev/block/mmcblk0p56", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 25), "/dev/block/mmcblk0p57", "/metadata" },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 26), "/dev/block/mmcblk0p58", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 27), "/dev/block/mmcblk0p59", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 28), "/dev/block/mmcblk0p60", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 29), "/dev/block/mmcblk0p61", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 30), "/dev/block/mmcblk0p62", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 31), "/dev/block/mmcblk0p63", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 32), "/dev/block/mmcblk0p64", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 33), "/dev/block/mmcblk0p65", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_SYSTEM, AID_SYSTEM, MKDEV(259, 34), "/dev/block/mmcblk0p66", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 35), "/dev/block/mmcblk0p67", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 36), "/dev/block/mmcblk0p68", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 37), "/dev/block/mmcblk0p69", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 38), "/dev/block/mmcblk0p70", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 39), "/dev/block/mmcblk0p71", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 40), "/dev/block/mmcblk0p72", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 41), "/dev/block/mmcblk0p73", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 42), "/dev/block/mmcblk0p74", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 43), "/dev/block/mmcblk0p75", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 44), "/dev/block/mmcblk0p76", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 45), "/dev/block/mmcblk0p77", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 46), "/dev/block/mmcblk0p78", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 47), "/dev/block/mmcblk0p79", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 48), "/dev/block/mmcblk0p80", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 49), "/dev/block/mmcblk0p81", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 50), "/dev/block/mmcblk0p82", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 51), "/dev/block/mmcblk0p83", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 52), "/dev/block/mmcblk0p84", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 53), "/dev/block/mmcblk0p85", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 54), "/dev/block/mmcblk0p86", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 55), "/dev/block/mmcblk0p87", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 56), "/dev/block/mmcblk0p88", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 57), "/dev/block/mmcblk0p89", "/mnt/makerlog" },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 58), "/dev/block/mmcblk0p90", "/mnt/persist2" },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 59), "/dev/block/mmcblk0p91", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 60), "/dev/block/mmcblk0p92", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 61), "/dev/block/mmcblk0p93", NULL },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 62), "/dev/block/mmcblk0p94", "/mnt/kitting" },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 63), "/dev/block/mmcblk0p95", "/data" },
    { (S_IRUSR | S_IWUSR | S_IFBLK), AID_ROOT, AID_ROOT, MKDEV(259, 64), "/dev/block/mmcblk0p96", NULL },
    { (S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IFCHR), AID_NFC, AID_NFC, MKDEV(205, 254), "/dev/nq-nci", NULL },
    { 0, 0, 0, 0, 0, 0 },
};


struct read_write_access_control_process {
	char *process_name;
	char *process_path;
	uid_t uid;
};

static struct read_write_access_control_process vdsp_process_list[] = {
	{ "wild", "/system/bin/wild", UID_NO_CHECK },
	{ "ueventd", INIT_PROCESS_NAME, UID_NO_CHECK },
	{ 0, 0, 0 },
};

static struct read_write_access_control_process geomag_process_list_bin[] = {
    { "sensors_server", "/system/bin/sensors_server", AID_ROOT },
    { 0, 0, 0 },
};

static struct read_write_access_control_process adsp_process_list_bin[] = {
	{ "init", "/init", AID_ROOT },
	{ "ueventd", "/init", AID_ROOT },
	{ 0, 0, 0 },
};

static struct read_write_access_control_process preinrestore_process_list_bin[] = {
    { "init_preinresto", "/vendor/bin/init_preinrestore.sh", AID_ROOT },
    { "init_preinresto", "/vendor/bin/init_preinrestoreOSV.sh", AID_SHELL },
    { "init_preinresto", "/system/bin/init_preinrestore.sh", AID_ROOT },
    { "init_preinresto", "/system/bin/init_preinrestoreOSV.sh", AID_SHELL },
    { "init_preinresto", "/product/bin/init_preinrestore.sh", AID_ROOT },
    { "init_preinresto", "/product/bin/init_preinrestoreOSV.sh", AID_ROOT },
    { "init_preinresto", "/system/bin/sh", AID_ROOT },
    { "init_preinresto", "/system/bin/sh", AID_SHELL },
    { "main", JAVA_APP_PROCESS_PATH32, AID_SHELL },
    { "main", JAVA_APP_PROCESS_PATH64, AID_SHELL },
    { "main", JAVA_APP_PROCESS_PATH32, AID_ROOT },
    { "main", JAVA_APP_PROCESS_PATH64, AID_ROOT },
    { INIT_PROCESS_NAME, INIT_PROCESS_PATH, AID_ROOT },
    { "touch", "/system/bin/toybox", AID_ROOT },
    { "touch", "/system/bin/toybox", AID_SHELL },
    { 0, 0, 0 },
};

static struct read_write_access_control_process nfc_process_list_lib[] = {
    { 0, 0, 0 },
};

static struct read_write_access_control_process hdcp2_process_list[] = {
    { "qc_prov_hdcp2", "/vendor/bin/qc_prov_hdcp2", AID_SYSTEM },
    { 0, 0, 0 },
};

static struct read_write_access_control_process felica_sec_process_list[] = {
    { "sec_service_tz", "/vendor/bin/sec_service_tz", AID_RADIO },
    { 0, 0, 0 },
};

static struct read_write_access_control_process dspg_process_list[] = {
    { "ueventd", "/init", AID_ROOT },
    { 0, 0, 0 },
};

static struct read_write_access_control_process sec_service_process_list[] = {
    { "sec_service", "/vendor/bin/sec_service", AID_RADIO },
    { 0, 0, 0 },
};

static struct read_write_access_control_process hdcp_sec_process_list[] = {
    { "hdcp_provd", "/vendor/bin/hdcp_provd", AID_SYSTEM },
    { 0, 0, 0 },
};

static struct read_write_access_control_process key_sec_process_list[] = {
    { "Keymasterkey_provd", "/system/bin/Keymasterkey_provd", AID_ROOT },
    { 0, 0, 0 },
};

static struct read_write_access_control_process mms_sec_process_list[] = {
    { "com.android.phone", JAVA_APP_PROCESS_PATH32, AID_RADIO },
    { "com.android.phone", JAVA_APP_PROCESS_PATH64, AID_RADIO },
    { "com.android.mms", JAVA_APP_PROCESS_PATH32, UID_NO_CHECK },
    { "com.android.mms", JAVA_APP_PROCESS_PATH64, UID_NO_CHECK },
    { ".clmail_dl", JAVA_APP_PROCESS_PATH32, UID_NO_CHECK },
    { ".clmail_dl", JAVA_APP_PROCESS_PATH64, UID_NO_CHECK },
    { "jp.co.nttdocomo.carriermail", JAVA_APP_PROCESS_PATH32, UID_NO_CHECK },
    { "jp.co.nttdocomo.carriermail", JAVA_APP_PROCESS_PATH64, UID_NO_CHECK },
    { "system_server", JAVA_APP_PROCESS_PATH32, AID_SYSTEM },
    { "system_server", JAVA_APP_PROCESS_PATH64, AID_SYSTEM },
    { "dex2oat", "/system/bin/dex2oat", UID_NO_CHECK },
	{ 0, 0, 0 },
};

static struct read_write_access_control_process frauddetect_process_list[] = {
    { "com.fujitsu.mobile_phone.fjfrauddetectservice", JAVA_APP_PROCESS_PATH32, UID_NO_CHECK },
    { "com.fujitsu.mobile_phone.fjfrauddetectservice", JAVA_APP_PROCESS_PATH64, UID_NO_CHECK },
    { 0, 0, 0 },
};

static struct read_write_access_control_process wv_process_list[] = {
    { INIT_PROCESS_NAME, INIT_PROCESS_PATH, AID_ROOT },
    { INIT_PROCESS_NAME, INIT_PROCESS_PATH, AID_SYSTEM },
	{ "sh", "/system/bin/sh", AID_ROOT },
    { 0, 0, 0 },
};

static struct read_write_access_control_process pwd_process_list[] = {
    { "com.fujitsu.mobile_phone.passwordmanager", JAVA_APP_PROCESS_PATH32, UID_NO_CHECK },
    { "com.fujitsu.mobile_phone.passwordmanager", JAVA_APP_PROCESS_PATH64, UID_NO_CHECK },
    { "com.fujitsu.mobile_phone.passwordmanagerwrapper", JAVA_APP_PROCESS_PATH32, UID_NO_CHECK },
    { "com.fujitsu.mobile_phone.passwordmanagerwrapper", JAVA_APP_PROCESS_PATH64, UID_NO_CHECK },
    { 0, 0, 0 },
};

#define NO_STRICT	-1
#define CHK_STRICT	1
struct read_write_access_control {
	char *prefix;
	struct read_write_access_control_process *process_list;
	int f_strict;
};

static struct read_write_access_control rw_access_control_list[] = {
	{ "/system/etc/firmware/vw.bin", vdsp_process_list,NO_STRICT },
	{ "/system/etc/firmware/vw_th.bin", vdsp_process_list,NO_STRICT },
	{ "/system/etc/firmware/vp_vw.bin", vdsp_process_list,NO_STRICT },
	{ "/system/etc/firmware/vp_vw_th.bin", vdsp_process_list,NO_STRICT },
	{ "/system/etc/firmware/2b.bin", vdsp_process_list,NO_STRICT },
	{ "/system/lib64/libnfc-nci-mc.so", nfc_process_list_lib,NO_STRICT },
	{ "/system/lib/libnfc-nci-mc.so", nfc_process_list_lib,NO_STRICT },
	{ "/system/lib64/nfc_nci.cxd22xx-mc.default", nfc_process_list_lib,NO_STRICT },
	{ "/system/lib/nfc_nci.cxd22xx-mc.default", nfc_process_list_lib,NO_STRICT },
	{ "/system/lib64/libgeomag.so", geomag_process_list_bin, NO_STRICT },
	{ "/data/master/*", preinrestore_process_list_bin, CHK_STRICT },
	{ "/vendor/firmware_mnt/image/adsp.b*", adsp_process_list_bin, NO_STRICT },
	{ "/vendor/firmware_mnt/image/adsp.mdt", adsp_process_list_bin, NO_STRICT },
	{ "/vendor/lib64/libqc_prov_hdcp2_impl.so", hdcp2_process_list, CHK_STRICT },
	{ "/vendor/lib/libssrvtest_tz.so", felica_sec_process_list, CHK_STRICT },
	{ "/vendor/lib/libHdcpProvisioning.so", hdcp_sec_process_list, CHK_STRICT },
	{ "/system/lib64/libkeymasterkey_provd.so", key_sec_process_list, CHK_STRICT },
	{ "/system/framework/com.fujitsu.mobile_phone.spamjudge.jar", mms_sec_process_list, CHK_STRICT },
	{ "/vendor/lib64/libssrvtest.so", sec_service_process_list, CHK_STRICT },
	{ "/system/lib64/libxcwrapper_android_license.so", frauddetect_process_list, CHK_STRICT },
	{ "/vendor/firmware/asrp_params_aecnr.bin", dspg_process_list, CHK_STRICT },
	{ "/vendor/firmware/asrp_params_nr.bin", dspg_process_list, CHK_STRICT },
	{ "/vendor/firmware/asrp_params_voice_call.bin", dspg_process_list, CHK_STRICT },
	{ "/vendor/firmware/dbmd2_va_ve_fw.bin", dspg_process_list, CHK_STRICT },
	{ "/vendor/bin/wv_service", wv_process_list, CHK_STRICT },
	{ "/system_ext/lib/libpwdwrap.so", pwd_process_list, CHK_STRICT },
	{ "/system_ext/lib64/libpwdwrap.so", pwd_process_list, CHK_STRICT },
	{ 0, 0, 0 },
};

struct ac_config {
	char *prefix;
	enum boot_mode_type boot_mode;
	char *process_name;
	char *process_path;
};


#ifdef CONFIG_SECURITY_FJSEC_AC_KITTING
struct kitting_directory_access_process {
	char *process_name;
	char *process_path;
	uid_t uid;
};

static struct kitting_directory_access_process kitting_directory_access_process_list[] = {
	{ "com.android.settings", JAVA_APP_PROCESS_PATH32, AID_SYSTEM },
	{ "com.android.settings", JAVA_APP_PROCESS_PATH64, AID_SYSTEM },
	{ "com.android.defcontainer", JAVA_APP_PROCESS_PATH32, UID_NO_CHECK },
	{ "com.android.defcontainer", JAVA_APP_PROCESS_PATH64, UID_NO_CHECK },
	{ "com.fujitsu.mobile_phone.home", JAVA_APP_PROCESS_PATH32, AID_SYSTEM },
	{ "com.fujitsu.mobile_phone.home", JAVA_APP_PROCESS_PATH64, AID_SYSTEM },
    { "system_server", JAVA_APP_PROCESS_PATH32, AID_SYSTEM },
    { "system_server", JAVA_APP_PROCESS_PATH64, AID_SYSTEM },
    { "com.fujitsu.mobile_phone.kitting", JAVA_APP_PROCESS_PATH32, AID_SYSTEM },
    { "com.fujitsu.mobile_phone.kitting", JAVA_APP_PROCESS_PATH64, AID_SYSTEM },
    { "bootanimation", "/system/bin/bootanimation", AID_GRAPHICS },
    { "com.fujitsu.mobile_phone.kitting", "/system/bin/busybox", AID_SYSTEM },
    { "main", JAVA_APP_PROCESS_PATH32, AID_ROOT },
    { "main", JAVA_APP_PROCESS_PATH64, AID_ROOT },
#ifdef CTS_TEST
	{ "ernalstorageapp", JAVA_APP_PROCESS_PATH32, UID_NO_CHECK  },
	{ "ernalstorageapp", JAVA_APP_PROCESS_PATH64, UID_NO_CHECK  },
#endif  /* CTS_TEST */
#ifdef DEBUG_KITTING_ACCESS_CONTROL
	{ "com.android.settings", "/system/bin/busybox", AID_SYSTEM },
#endif  /* DEBUG_KITTING_ACCESS_CONTROL */
	{ 0, 0, 0 },
};
#endif /* CONFIG_SECURITY_FJSEC_AC_KITTING */

struct ac_config_setid{
	char *process_name;
	char *process_path;
};

static struct ac_config_setid setid_acl[] = {
	{ "init", "/init"},
	{ "ueventd", "/init"},
	{ "adbd", "/sbin/adbd"},
	{ "adbd", "/apex/com.android.adbd/bin/adbd"},
#ifdef DEBUG_SETID_ACCESS_CONTROL
	{ "setuid_test", "/data/lsm-test/setuid_test"},
	{ "setuid_test_NG", "/data/lsm-test-bin/setuid_test_NG"},
#endif /* DEBUG_SETID_ACCESS_CONTROL */
#ifdef DEBUG_KITTING_ACCESS_CONTROL
	{ "busybox", "/data/busybox/busybox"},
	{ "ndroid.settings", "/data/busybox/busybox"},
#endif /* DEBUG_KITTING_ACCESS_CONTROL */
    { "rmt_storage", "/vendor/bin/rmt_storage"},
    { "tftp_server", "/vendor/bin/tftp_server"},
    { "qseecomd", "/vendor/bin/qseecomd"},
    { "time_daemon", "/vendor/bin/time_daemon"},
    { "loc_launcher", "/vendor/bin/loc_launcher"},
    { "netmgrd", "/vendor/bin/netmgrd"},
    { "sensors.qcom", "/vendor/bin/sensors.qcom"},
#ifdef CTS_TEST
    { "CtsBionicTestCa", "/data/local/tmp/CtsBionicTestCases"},
#endif  /* CTS_TEST */
    { "fjdumpstate", "/product/bin/fjdumpstate"},
    { "fjdumpstate", "/system/bin/fjdumpstate"},
    { "dpmd", "/product/bin/dpmd"},
    { "dpmd", "/system_ext/bin/dpmd"},
    { "diag_mdlog_syst", "/system_ext/bin/diag_mdlog_system"},
	{ 0, 0 },
};

#define FJSEC_ACP_NAME_MAX 64
#define FJSEC_ACP_PATH_MAX 128
#define PG_ACL_CON	0xFF
#define PG_ACL_NCON	0x00
#define PG_ACL_ONE	0x01
#define PG_ACL_NCONS	0x02


struct ac_config_page_ext{
	char process_name[FJSEC_ACP_NAME_MAX];
	char process_path[FJSEC_ACP_PATH_MAX];
	char process_hash[SHA256_DIGEST_SIZE];
	uid_t uid;
	long supl1;
	long supl2;
};


#ifdef CTS_TEST
static struct ac_config_page_ext page_parent_acl_ext[] = {
    { "android.jni.cts", JAVA_APP_PROCESS_PATH32, "", UID_NO_CHECK, SUPL_NO_HASHCHECK, SUPL_NO_CHECK},
    { "android.jni.cts", JAVA_APP_PROCESS_PATH64, "", UID_NO_CHECK, SUPL_NO_HASHCHECK, SUPL_NO_CHECK},
    { "android.os.cts", JAVA_APP_PROCESS_PATH32, "", UID_NO_CHECK, SUPL_NO_HASHCHECK, SUPL_NO_CHECK},
    { "android.os.cts", JAVA_APP_PROCESS_PATH64, "", UID_NO_CHECK, SUPL_NO_HASHCHECK, SUPL_NO_CHECK},
    { "mmon.deviceinfo", JAVA_APP_PROCESS_PATH32, "", UID_NO_CHECK, SUPL_NO_HASHCHECK, SUPL_NO_CHECK},
    { "mmon.deviceinfo", JAVA_APP_PROCESS_PATH64, "", UID_NO_CHECK, SUPL_NO_HASHCHECK, SUPL_NO_CHECK},
    {"0", "0", {0} },
};
#endif