/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2019-2020, The Linux Foundation. All rights reserved.
 */


#ifndef _CAM_VFE480_H_
#define _CAM_VFE480_H_
#include "cam_vfe_camif_ver3.h"
#include "cam_vfe_top_ver3.h"
#include "cam_vfe_core.h"
#include "cam_vfe_bus_ver3.h"
#include "cam_irq_controller.h"

static struct cam_irq_register_set vfe480_top_irq_reg_set[3] = {
	{
		.mask_reg_offset   = 0x0000003C,
		.clear_reg_offset  = 0x00000048,
		.status_reg_offset = 0x00000054,
	},
	{
		.mask_reg_offset   = 0x00000040,
		.clear_reg_offset  = 0x0000004C,
		.status_reg_offset = 0x00000058,
	},
		{
		.mask_reg_offset   = 0x00000044,
		.clear_reg_offset  = 0x00000050,
		.status_reg_offset = 0x0000005C,
	},
};

static struct cam_irq_controller_reg_info vfe480_top_irq_reg_info = {
	.num_registers = 3,
	.irq_reg_set = vfe480_top_irq_reg_set,
	.global_clear_offset  = 0x00000038,
	.global_clear_bitmask = 0x00000001,
};

static struct cam_vfe_camif_ver3_pp_clc_reg vfe480_camif_reg = {
	.hw_version                  = 0x00002600,
	.hw_status                   = 0x00002604,
	.module_cfg                  = 0x00002660,
	.pdaf_raw_crop_width_cfg     = 0x00002668,
	.pdaf_raw_crop_height_cfg    = 0x0000266C,
	.line_skip_pattern           = 0x00002670,
	.pixel_skip_pattern          = 0x00002674,
	.period_cfg                  = 0x00002678,
	.irq_subsample_pattern       = 0x0000267C,
	.epoch_irq_cfg               = 0x00002680,
	.debug_1                     = 0x000027F0,
	.debug_0                     = 0x000027F4,
	.test_bus_ctrl               = 0x000027F8,
	.spare                       = 0x000027FC,
	.reg_update_cmd              = 0x00000034,
};

static struct cam_vfe_camif_ver3_reg_data vfe_480_camif_reg_data = {
	.pp_extern_reg_update_shift      = 4,
	.dual_pd_extern_reg_update_shift = 17,
	.extern_reg_update_mask          = 1,
	.dual_ife_pix_en_shift           = 3,
	.operating_mode_shift            = 11,
	.input_mux_sel_shift             = 5,
	.pixel_pattern_shift             = 24,
	.pixel_pattern_mask              = 0x7,
	.dsp_mode_shift                  = 24,
	.dsp_mode_mask                   = 0x1,
	.dsp_en_shift                    = 23,
	.dsp_en_mask                     = 0x1,
	.reg_update_cmd_data             = 0x41,
	.epoch_line_cfg                  = 0x00000014,
	.sof_irq_mask                    = 0x00000001,
	.epoch0_irq_mask                 = 0x00000004,
	.epoch1_irq_mask                 = 0x00000008,
	.eof_irq_mask                    = 0x00000002,
	.error_irq_mask0                 = 0x82000200,
	.error_irq_mask2                 = 0x30301F80,
	.subscribe_irq_mask1             = 0x00000007,
	.frame_id_irq_mask               = 0x400,
	.enable_diagnostic_hw            = 0x1,
	.pp_camif_cfg_en_shift           = 0,
	.pp_camif_cfg_ife_out_en_shift   = 8,
	.top_debug_cfg_en                = 1,
};

static struct cam_vfe_top_ver3_reg_offset_common vfe480_top_common_reg = {
	.hw_version               = 0x00000000,
	.titan_version            = 0x00000004,
	.hw_capability            = 0x00000008,
	.lens_feature             = 0x0000000C,
	.stats_feature            = 0x00000010,
	.color_feature            = 0x00000014,
	.zoom_feature             = 0x00000018,
	.global_reset_cmd         = 0x0000001C,
	.core_cfg_0               = 0x0000002C,
	.core_cfg_1               = 0x00000030,
	.reg_update_cmd           = 0x00000034,
	.violation_status         = 0x00000074,
	.core_cgc_ovd_0           = 0x00000020,
	.core_cgc_ovd_1           = 0x00000094,
	.ahb_cgc_ovd              = 0x00000024,
	.noc_cgc_ovd              = 0x00000028,
	.trigger_cdm_events       = 0x00000090,
	.custom_frame_idx         = 0x00000110,
	.dsp_status               = 0x0000007C,
	.diag_config              = 0x00000064,
	.diag_sensor_status_0     = 0x00000068,
	.diag_sensor_status_1     = 0x00000098,
	.bus_overflow_status      = 0x0000AA68,
	.top_debug_cfg            = 0x000000DC,
	.top_debug_0              = 0x00000080,
	.top_debug_1              = 0x00000084,
	.top_debug_2              = 0x00000088,
	.top_debug_3              = 0x0000008C,
	.top_debug_4              = 0x0000009C,
	.top_debug_5              = 0x000000A0,
	.top_debug_6              = 0x000000A4,
	.top_debug_7              = 0x000000A8,
	.top_debug_8              = 0x000000AC,
	.top_debug_9              = 0x000000B0,
	.top_debug_10             = 0x000000B4,
	.top_debug_11             = 0x000000B8,
	.top_debug_12             = 0x000000BC,
	.top_debug_13             = 0x000000C0,
};

static struct cam_vfe_camif_lite_ver3_reg vfe480_camif_rdi[3] = {
	{
		.lite_hw_version            = 0x9A00,
		.lite_hw_status             = 0x9A04,
		.lite_module_config         = 0x9A60,
		.lite_skip_period           = 0x9A68,
		.lite_irq_subsample_pattern = 0x9A6C,
		.lite_epoch_irq             = 0x9A70,
		.lite_debug_1               = 0x9BF0,
		.lite_debug_0               = 0x9BF4,
		.lite_test_bus_ctrl         = 0x9BF8,
		.camif_lite_spare           = 0x9BFC,
		.reg_update_cmd             = 0x34,
	},
	{
		.lite_hw_version            = 0x9C00,
		.lite_hw_status             = 0x9C04,
		.lite_module_config         = 0x9C60,
		.lite_skip_period           = 0x9C68,
		.lite_irq_subsample_pattern = 0x9C6C,
		.lite_epoch_irq             = 0x9C70,
		.lite_debug_1               = 0x9DF0,
		.lite_debug_0               = 0x9DF4,
		.lite_test_bus_ctrl         = 0x9DF8,
		.camif_lite_spare           = 0x9DFC,
		.reg_update_cmd             = 0x34,
	},
	{
		.lite_hw_version            = 0x9E00,
		.lite_hw_status             = 0x9E04,
		.lite_module_config         = 0x9E60,
		.lite_skip_period           = 0x9E68,
		.lite_irq_subsample_pattern = 0x9E6C,
		.lite_epoch_irq             = 0x9E70,
		.lite_debug_1               = 0x9FF0,
		.lite_debug_0               = 0x9FF4,
		.lite_test_bus_ctrl         = 0x9FF8,
		.camif_lite_spare           = 0x9FFC,
		.reg_update_cmd             = 0x34,
	},
};

static struct cam_vfe_camif_lite_ver3_reg_data vfe480_camif_rdi_reg_data[3] = {
	{
		.extern_reg_update_shift         = 0,
		.reg_update_cmd_data             = 0x2,
		.epoch_line_cfg                  = 0x0,
		.sof_irq_mask                    = 0x10,
		.epoch0_irq_mask                 = 0x40,
		.epoch1_irq_mask                 = 0x80,
		.eof_irq_mask                    = 0x20,
		.error_irq_mask0                 = 0x20000000,
		.error_irq_mask2                 = 0x20000,
		.subscribe_irq_mask1             = 0x30,
		.enable_diagnostic_hw            = 0x1,
	},
	{
		.extern_reg_update_shift         = 0,
		.reg_update_cmd_data             = 0x4,
		.epoch_line_cfg                  = 0x0,
		.sof_irq_mask                    = 0x100,
		.epoch0_irq_mask                 = 0x400,
		.epoch1_irq_mask                 = 0x800,
		.eof_irq_mask                    = 0x200,
		.error_irq_mask0                 = 0x10000000,
		.error_irq_mask2                 = 0x40000,
		.subscribe_irq_mask1             = 0x300,
		.enable_diagnostic_hw            = 0x1,
	},
	{
		.extern_reg_update_shift         = 0,
		.reg_update_cmd_data             = 0x8,
		.epoch_line_cfg                  = 0x0,
		.sof_irq_mask                    = 0x1000,
		.epoch0_irq_mask                 = 0x4000,
		.epoch1_irq_mask                 = 0x8000,
		.eof_irq_mask                    = 0x2000,
		.error_irq_mask0                 = 0x8000000,
		.error_irq_mask2                 = 0x80000,
		.subscribe_irq_mask1             = 0x3000,
		.enable_diagnostic_hw            = 0x1,
	},
};

static struct cam_vfe_camif_lite_ver3_reg vfe480_camif_lcr = {
	.lite_hw_version            = 0xA000,
	.lite_hw_status             = 0xA004,
	.lite_module_config         = 0xA060,
	.lite_skip_period           = 0xA068,
	.lite_irq_subsample_pattern = 0xA06C,
	.lite_epoch_irq             = 0xA070,
	.lite_debug_1               = 0xA1F0,
	.lite_debug_0               = 0xA1F4,
	.lite_test_bus_ctrl         = 0xA1F8,
	.camif_lite_spare           = 0xA1FC,
	.reg_update_cmd             = 0x0034,
};

static struct cam_vfe_camif_lite_ver3_reg_data vfe480_camif_lcr_reg_data = {
	.extern_reg_update_shift    = 16,
	.reg_update_cmd_data        = 0x40,
	.epoch_line_cfg             = 0x00140014,
	.sof_irq_mask               = 0x100000,
	.epoch0_irq_mask            = 0x400000,
	.epoch1_irq_mask            = 0x800000,
	.eof_irq_mask               = 0x200000,
	.error_irq_mask0            = 0x0,
	.error_irq_mask2            = 0x18000,
	.subscribe_irq_mask1        = 0x300000,
	.enable_diagnostic_hw       = 0x1,
};

static struct cam_vfe_camif_lite_ver3_reg vfe480_camif_pd = {
	.lite_hw_version            = 0xA400,
	.lite_hw_status             = 0xA404,
	.lite_module_config         = 0xA460,
	.lite_skip_period           = 0xA468,
	.lite_irq_subsample_pattern = 0xA46C,
	.lite_epoch_irq             = 0xA470,
	.lite_debug_1               = 0xA5F0,
	.lite_debug_0               = 0xA5F4,
	.lite_test_bus_ctrl         = 0xA5F8,
	.camif_lite_spare           = 0xA5FC,
	.reg_update_cmd             = 0x0034,
};

static struct cam_vfe_camif_lite_ver3_reg_data vfe480_camif_pd_reg_data = {
	.extern_reg_update_shift    = 17,
	.operating_mode_shift       = 13,
	.input_mux_sel_shift        = 31,
	.reg_update_cmd_data        = 0x20,
	.epoch_line_cfg             = 0x00140014,
	.sof_irq_mask               = 0x10000,
	.epoch0_irq_mask            = 0x40000,
	.epoch1_irq_mask            = 0x80000,
	.eof_irq_mask               = 0x20000,
	.error_irq_mask0            = 0x40000000,
	.error_irq_mask2            = 0x6000,
	.subscribe_irq_mask1        = 0x30000,
	.enable_diagnostic_hw       = 0x1,
};

struct cam_vfe_camif_lite_ver3_hw_info rdi_hw_info_arr[CAM_VFE_RDI_VER2_MAX] = {
	{
		.common_reg     = &vfe480_top_common_reg,
		.camif_lite_reg = &vfe480_camif_rdi[0],
		.reg_data       = &vfe480_camif_rdi_reg_data[0],
	},
	{
		.common_reg     = &vfe480_top_common_reg,
		.camif_lite_reg = &vfe480_camif_rdi[1],
		.reg_data       = &vfe480_camif_rdi_reg_data[1],
	},
	{
		.common_reg     = &vfe480_top_common_reg,
		.camif_lite_reg = &vfe480_camif_rdi[2],
		.reg_data       = &vfe480_camif_rdi_reg_data[2],
	},
};

static struct cam_vfe_top_ver3_hw_info vfe480_top_hw_info = {
	.common_reg = &vfe480_top_common_reg,
	.camif_hw_info = {
		.common_reg     = &vfe480_top_common_reg,
		.camif_reg      = &vfe480_camif_reg,
		.reg_data       = &vfe_480_camif_reg_data,
		},
	.pdlib_hw_info = {
		.common_reg     = &vfe480_top_common_reg,
		.camif_lite_reg = &vfe480_camif_pd,
		.reg_data       = &vfe480_camif_pd_reg_data,
		},
	.rdi_hw_info[0] = &rdi_hw_info_arr[0],
	.rdi_hw_info[1] = &rdi_hw_info_arr[1],
	.rdi_hw_info[2] = &rdi_hw_info_arr[2],
	.lcr_hw_info = {
		.common_reg     = &vfe480_top_common_reg,
		.camif_lite_reg = &vfe480_camif_lcr,
		.reg_data       = &vfe480_camif_lcr_reg_data,
		},
	.num_mux = 6,
	.mux_type = {
		CAM_VFE_CAMIF_VER_3_0,
		CAM_VFE_RDI_VER_1_0,
		CAM_VFE_RDI_VER_1_0,
		CAM_VFE_RDI_VER_1_0,
		CAM_VFE_PDLIB_VER_1_0,
		CAM_VFE_LCR_VER_1_0,
	},
};

static struct cam_irq_register_set vfe480_bus_irq_reg[2] = {
		{
			.mask_reg_offset   = 0x0000AA18,
			.clear_reg_offset  = 0x0000AA20,
			.status_reg_offset = 0x0000AA28,
		},
		{
			.mask_reg_offset   = 0x0000AA1C,
			.clear_reg_offset  = 0x0000AA24,
			.status_reg_offset = 0x0000AA2C,
		},
};

static struct cam_vfe_bus_ver3_reg_offset_ubwc_client
	vfe480_ubwc_regs_client_0 = {
	.meta_addr        = 0x0000AC40,
	.meta_cfg         = 0x0000AC44,
	.mode_cfg         = 0x0000AC48,
	.stats_ctrl       = 0x0000AC4C,
	.ctrl_2           = 0x0000AC50,
	.lossy_thresh0    = 0x0000AC54,
	.lossy_thresh1    = 0x0000AC58,
	.off_lossy_var    = 0x0000AC5C,
	.bw_limit         = 0x0000AC1C,
};

static struct cam_vfe_bus_ver3_reg_offset_ubwc_client
	vfe480_ubwc_regs_client_1 = {
	.meta_addr        = 0x0000AD40,
	.meta_cfg         = 0x0000AD44,
	.mode_cfg         = 0x0000AD48,
	.stats_ctrl       = 0x0000AD4C,
	.ctrl_2           = 0x0000AD50,
	.lossy_thresh0    = 0x0000AD54,
	.lossy_thresh1    = 0x0000AD58,
	.off_lossy_var    = 0x0000AD5C,
	.bw_limit         = 0x0000AD1C,
};

static struct cam_vfe_bus_ver3_reg_offset_ubwc_client
	vfe480_ubwc_regs_client_4 = {
	.meta_addr        = 0x0000B040,
	.meta_cfg         = 0x0000B044,
	.mode_cfg         = 0x0000B048,
	.stats_ctrl       = 0x0000B04C,
	.ctrl_2           = 0x0000B050,
	.lossy_thresh0    = 0x0000B054,
	.lossy_thresh1    = 0x0000B058,
	.off_lossy_var    = 0x0000B05C,
	.bw_limit         = 0x0000B01C,
};

static struct cam_vfe_bus_ver3_reg_offset_ubwc_client
	vfe480_ubwc_regs_client_5 = {
	.meta_addr        = 0x0000B140,
	.meta_cfg         = 0x0000B144,
	.mode_cfg         = 0x0000B148,
	.stats_ctrl       = 0x0000B14C,
	.ctrl_2           = 0x0000B150,
	.lossy_thresh0    = 0x0000B154,
	.lossy_thresh1    = 0x0000B158,
	.off_lossy_var    = 0x0000B15C,
	.bw_limit         = 0x0000B11C,
};

static struct cam_vfe_bus_ver3_hw_info vfe480_bus_hw_info = {
	.common_reg = {
		.hw_version                       = 0x0000AA00,
		.cgc_ovd                          = 0x0000AA08,
		.comp_cfg_0                       = 0x0000AA0C,
		.comp_cfg_1                       = 0x0000AA10,
		.if_frameheader_cfg               = {
			0x0000AA34,
			0x0000AA38,
			0x0000AA3C,
			0x0000AA40,
			0x0000AA44,
			0x0000AA48,
		},
		.ubwc_static_ctrl                 = 0x0000AA58,
		.pwr_iso_cfg                      = 0x0000AA5C,
		.overflow_status_clear            = 0x0000AA60,
		.ccif_violation_status            = 0x0000AA64,
		.overflow_status                  = 0x0000AA68,
		.image_size_violation_status      = 0x0000AA70,
		.debug_status_top_cfg             = 0x0000AAD4,
		.debug_status_top                 = 0x0000AAD8,
		.test_bus_ctrl                    = 0x0000AADC,
		.irq_reg_info = {
			.num_registers            = 2,
			.irq_reg_set              = vfe480_bus_irq_reg,
			.global_clear_offset      = 0x0000AA30,
			.global_clear_bitmask     = 0x00000001,
		},
	},
	.num_client = CAM_VFE_BUS_VER3_MAX_CLIENTS,
	.bus_client_reg = {
		/* BUS Client 0 FULL Y */
		{
			.cfg                      = 0x0000AC00,
			.image_addr               = 0x0000AC04,
			.frame_incr               = 0x0000AC08,
			.image_cfg_0              = 0x0000AC0C,
			.image_cfg_1              = 0x0000AC10,
			.image_cfg_2              = 0x0000AC14,
			.packer_cfg               = 0x0000AC18,
			.frame_header_addr        = 0x0000AC20,
			.frame_header_incr        = 0x0000AC24,
			.frame_header_cfg         = 0x0000AC28,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000AC30,
			.irq_subsample_pattern    = 0x0000AC34,
			.framedrop_period         = 0x0000AC38,
			.framedrop_pattern        = 0x0000AC3C,
			.system_cache_cfg         = 0x0000AC60,
			.burst_limit              = 0x0000AC64,
			.addr_status_0            = 0x0000AC68,
			.addr_status_1            = 0x0000AC6C,
			.addr_status_2            = 0x0000AC70,
			.addr_status_3            = 0x0000AC74,
			.debug_status_cfg         = 0x0000AC78,
			.debug_status_0           = 0x0000AC7C,
			.debug_status_1           = 0x0000AC80,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_0,
			.ubwc_regs                = &vfe480_ubwc_regs_client_0,
		},
		/* BUS Client 1 FULL C */
		{
			.cfg                      = 0x0000AD00,
			.image_addr               = 0x0000AD04,
			.frame_incr               = 0x0000AD08,
			.image_cfg_0              = 0x0000AD0C,
			.image_cfg_1              = 0x0000AD10,
			.image_cfg_2              = 0x0000AD14,
			.packer_cfg               = 0x0000AD18,
			.frame_header_addr        = 0x0000AD20,
			.frame_header_incr        = 0x0000AD24,
			.frame_header_cfg         = 0x0000AD28,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000AD30,
			.irq_subsample_pattern    = 0x0000AD34,
			.framedrop_period         = 0x0000AD38,
			.framedrop_pattern        = 0x0000AD3C,
			.system_cache_cfg         = 0x0000AD60,
			.burst_limit              = 0x0000AD64,
			.addr_status_0            = 0x0000AD68,
			.addr_status_1            = 0x0000AD6C,
			.addr_status_2            = 0x0000AD70,
			.addr_status_3            = 0x0000AD74,
			.debug_status_cfg         = 0x0000AD78,
			.debug_status_0           = 0x0000AD7C,
			.debug_status_1           = 0x0000AD80,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_0,
			.ubwc_regs                = &vfe480_ubwc_regs_client_1,
		},
		/* BUS Client 2 DS4 */
		{
			.cfg                      = 0x0000AE00,
			.image_addr               = 0x0000AE04,
			.frame_incr               = 0x0000AE08,
			.image_cfg_0              = 0x0000AE0C,
			.image_cfg_1              = 0x0000AE10,
			.image_cfg_2              = 0x0000AE14,
			.packer_cfg               = 0x0000AE18,
			.frame_header_addr        = 0x0000AE20,
			.frame_header_incr        = 0x0000AE24,
			.frame_header_cfg         = 0x0000AE28,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000AE30,
			.irq_subsample_pattern    = 0x0000AE34,
			.framedrop_period         = 0x0000AE38,
			.framedrop_pattern        = 0x0000AE3C,
			.system_cache_cfg         = 0x0000AE60,
			.burst_limit              = 0x0000AE64,
			.addr_status_0            = 0x0000AE68,
			.addr_status_1            = 0x0000AE6C,
			.addr_status_2            = 0x0000AE70,
			.addr_status_3            = 0x0000AE74,
			.debug_status_cfg         = 0x0000AE78,
			.debug_status_0           = 0x0000AE7C,
			.debug_status_1           = 0x0000AE80,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_0,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 3 DS16 */
		{
			.cfg                      = 0x0000AF00,
			.image_addr               = 0x0000AF04,
			.frame_incr               = 0x0000AF08,
			.image_cfg_0              = 0x0000AF0C,
			.image_cfg_1              = 0x0000AF10,
			.image_cfg_2              = 0x0000AF14,
			.packer_cfg               = 0x0000AF18,
			.frame_header_addr        = 0x0000AF20,
			.frame_header_incr        = 0x0000AF24,
			.frame_header_cfg         = 0x0000AF28,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000AF30,
			.irq_subsample_pattern    = 0x0000AF34,
			.framedrop_period         = 0x0000AF38,
			.framedrop_pattern        = 0x0000AF3C,
			.system_cache_cfg         = 0x0000AF60,
			.burst_limit              = 0x0000AF64,
			.addr_status_0            = 0x0000AF68,
			.addr_status_1            = 0x0000AF6C,
			.addr_status_2            = 0x0000AF70,
			.addr_status_3            = 0x0000AF74,
			.debug_status_cfg         = 0x0000AF78,
			.debug_status_0           = 0x0000AF7C,
			.debug_status_1           = 0x0000AF80,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_0,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 4 DISP Y */
		{
			.cfg                      = 0x0000B000,
			.image_addr               = 0x0000B004,
			.frame_incr               = 0x0000B008,
			.image_cfg_0              = 0x0000B00C,
			.image_cfg_1              = 0x0000B010,
			.image_cfg_2              = 0x0000B014,
			.packer_cfg               = 0x0000B018,
			.frame_header_addr        = 0x0000B020,
			.frame_header_incr        = 0x0000B024,
			.frame_header_cfg         = 0x0000B028,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000B030,
			.irq_subsample_pattern    = 0x0000B034,
			.framedrop_period         = 0x0000B038,
			.framedrop_pattern        = 0x0000B03C,
			.system_cache_cfg         = 0x0000B060,
			.burst_limit              = 0x0000B064,
			.addr_status_0            = 0x0000B068,
			.addr_status_1            = 0x0000B06C,
			.addr_status_2            = 0x0000B070,
			.addr_status_3            = 0x0000B074,
			.debug_status_cfg         = 0x0000B078,
			.debug_status_0           = 0x0000B07C,
			.debug_status_1           = 0x0000B080,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_1,
			.ubwc_regs                = &vfe480_ubwc_regs_client_4,
		},
		/* BUS Client 5 DISP C */
		{
			.cfg                      = 0x0000B100,
			.image_addr               = 0x0000B104,
			.frame_incr               = 0x0000B108,
			.image_cfg_0              = 0x0000B10C,
			.image_cfg_1              = 0x0000B110,
			.image_cfg_2              = 0x0000B114,
			.packer_cfg               = 0x0000B118,
			.frame_header_addr        = 0x0000B120,
			.frame_header_incr        = 0x0000B124,
			.frame_header_cfg         = 0x0000B128,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000B130,
			.irq_subsample_pattern    = 0x0000B134,
			.framedrop_period         = 0x0000B138,
			.framedrop_pattern        = 0x0000B13C,
			.system_cache_cfg         = 0x0000B160,
			.burst_limit              = 0x0000B164,
			.addr_status_0            = 0x0000B168,
			.addr_status_1            = 0x0000B16C,
			.addr_status_2            = 0x0000B170,
			.addr_status_3            = 0x0000B174,
			.debug_status_cfg         = 0x0000B178,
			.debug_status_0           = 0x0000B17C,
			.debug_status_1           = 0x0000B180,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_1,
			.ubwc_regs                = &vfe480_ubwc_regs_client_5,
		},
		/* BUS Client 6 DISP DS4 */
		{
			.cfg                      = 0x0000B200,
			.image_addr               = 0x0000B204,
			.frame_incr               = 0x0000B208,
			.image_cfg_0              = 0x0000B20C,
			.image_cfg_1              = 0x0000B210,
			.image_cfg_2              = 0x0000B214,
			.packer_cfg               = 0x0000B218,
			.frame_header_addr        = 0x0000B220,
			.frame_header_incr        = 0x0000B224,
			.frame_header_cfg         = 0x0000B228,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000B230,
			.irq_subsample_pattern    = 0x0000B234,
			.framedrop_period         = 0x0000B238,
			.framedrop_pattern        = 0x0000B23C,
			.system_cache_cfg         = 0x0000B260,
			.burst_limit              = 0x0000B264,
			.addr_status_0            = 0x0000B268,
			.addr_status_1            = 0x0000B26C,
			.addr_status_2            = 0x0000B270,
			.addr_status_3            = 0x0000B274,
			.debug_status_cfg         = 0x0000B278,
			.debug_status_0           = 0x0000B27C,
			.debug_status_1           = 0x0000B280,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_1,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 7 DISP DS16 */
		{
			.cfg                      = 0x0000B300,
			.image_addr               = 0x0000B304,
			.frame_incr               = 0x0000B308,
			.image_cfg_0              = 0x0000B30C,
			.image_cfg_1              = 0x0000B310,
			.image_cfg_2              = 0x0000B314,
			.packer_cfg               = 0x0000B318,
			.frame_header_addr        = 0x0000B320,
			.frame_header_incr        = 0x0000B324,
			.frame_header_cfg         = 0x0000B328,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000B330,
			.irq_subsample_pattern    = 0x0000B334,
			.framedrop_period         = 0x0000B338,
			.framedrop_pattern        = 0x0000B33C,
			.system_cache_cfg         = 0x0000B360,
			.burst_limit              = 0x0000B364,
			.addr_status_0            = 0x0000B368,
			.addr_status_1            = 0x0000B36C,
			.addr_status_2            = 0x0000B370,
			.addr_status_3            = 0x0000B374,
			.debug_status_cfg         = 0x0000B378,
			.debug_status_0           = 0x0000B37C,
			.debug_status_1           = 0x0000B380,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_1,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 8 FD Y */
		{
			.cfg                      = 0x0000B400,
			.image_addr               = 0x0000B404,
			.frame_incr               = 0x0000B408,
			.image_cfg_0              = 0x0000B40C,
			.image_cfg_1              = 0x0000B410,
			.image_cfg_2              = 0x0000B414,
			.packer_cfg               = 0x0000B418,
			.frame_header_addr        = 0x0000B420,
			.frame_header_incr        = 0x0000B424,
			.frame_header_cfg         = 0x0000B428,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000B430,
			.irq_subsample_pattern    = 0x0000B434,
			.framedrop_period         = 0x0000B438,
			.framedrop_pattern        = 0x0000B43C,
			.system_cache_cfg         = 0x0000B460,
			.burst_limit              = 0x0000B464,
			.addr_status_0            = 0x0000B468,
			.addr_status_1            = 0x0000B46C,
			.addr_status_2            = 0x0000B470,
			.addr_status_3            = 0x0000B474,
			.debug_status_cfg         = 0x0000B478,
			.debug_status_0           = 0x0000B47C,
			.debug_status_1           = 0x0000B480,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_2,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 9 FD C */
		{
			.cfg                      = 0x0000B500,
			.image_addr               = 0x0000B504,
			.frame_incr               = 0x0000B508,
			.image_cfg_0              = 0x0000B50C,
			.image_cfg_1              = 0x0000B510,
			.image_cfg_2              = 0x0000B514,
			.packer_cfg               = 0x0000B518,
			.frame_header_addr        = 0x0000B520,
			.frame_header_incr        = 0x0000B524,
			.frame_header_cfg         = 0x0000B528,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000B530,
			.irq_subsample_pattern    = 0x0000B534,
			.framedrop_period         = 0x0000B538,
			.framedrop_pattern        = 0x0000B53C,
			.system_cache_cfg         = 0x0000B560,
			.burst_limit              = 0x0000B564,
			.addr_status_0            = 0x0000B568,
			.addr_status_1            = 0x0000B56C,
			.addr_status_2            = 0x0000B570,
			.addr_status_3            = 0x0000B574,
			.debug_status_cfg         = 0x0000B578,
			.debug_status_0           = 0x0000B57C,
			.debug_status_1           = 0x0000B580,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_2,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 10 PIXEL RAW */
		{
			.cfg                      = 0x0000B600,
			.image_addr               = 0x0000B604,
			.frame_incr               = 0x0000B608,
			.image_cfg_0              = 0x0000B60C,
			.image_cfg_1              = 0x0000B610,
			.image_cfg_2              = 0x0000B614,
			.packer_cfg               = 0x0000B618,
			.frame_header_addr        = 0x0000B620,
			.frame_header_incr        = 0x0000B624,
			.frame_header_cfg         = 0x0000B628,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000B630,
			.irq_subsample_pattern    = 0x0000B634,
			.framedrop_period         = 0x0000B638,
			.framedrop_pattern        = 0x0000B63C,
			.system_cache_cfg         = 0x0000B660,
			.burst_limit              = 0x0000B664,
			.addr_status_0            = 0x0000B668,
			.addr_status_1            = 0x0000B66C,
			.addr_status_2            = 0x0000B670,
			.addr_status_3            = 0x0000B674,
			.debug_status_cfg         = 0x0000B678,
			.debug_status_0           = 0x0000B67C,
			.debug_status_1           = 0x0000B680,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_3,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 11 CAMIF PD */
		{
			.cfg                      = 0x0000B700,
			.image_addr               = 0x0000B704,
			.frame_incr               = 0x0000B708,
			.image_cfg_0              = 0x0000B70C,
			.image_cfg_1              = 0x0000B710,
			.image_cfg_2              = 0x0000B714,
			.packer_cfg               = 0x0000B718,
			.frame_header_addr        = 0x0000B720,
			.frame_header_incr        = 0x0000B724,
			.frame_header_cfg         = 0x0000B728,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000B730,
			.irq_subsample_pattern    = 0x0000B734,
			.framedrop_period         = 0x0000B738,
			.framedrop_pattern        = 0x0000B73C,
			.system_cache_cfg         = 0x0000B760,
			.burst_limit              = 0x0000B764,
			.addr_status_0            = 0x0000B768,
			.addr_status_1            = 0x0000B76C,
			.addr_status_2            = 0x0000B770,
			.addr_status_3            = 0x0000B774,
			.debug_status_cfg         = 0x0000B778,
			.debug_status_0           = 0x0000B77C,
			.debug_status_1           = 0x0000B780,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_4,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 12 STATS HDR BE */
		{
			.cfg                      = 0x0000B800,
			.image_addr               = 0x0000B804,
			.frame_incr               = 0x0000B808,
			.image_cfg_0              = 0x0000B80C,
			.image_cfg_1              = 0x0000B810,
			.image_cfg_2              = 0x0000B814,
			.packer_cfg               = 0x0000B818,
			.frame_header_addr        = 0x0000B820,
			.frame_header_incr        = 0x0000B824,
			.frame_header_cfg         = 0x0000B828,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000B830,
			.irq_subsample_pattern    = 0x0000B834,
			.framedrop_period         = 0x0000B838,
			.framedrop_pattern        = 0x0000B83C,
			.system_cache_cfg         = 0x0000B860,
			.burst_limit              = 0x0000B864,
			.addr_status_0            = 0x0000B868,
			.addr_status_1            = 0x0000B86C,
			.addr_status_2            = 0x0000B870,
			.addr_status_3            = 0x0000B874,
			.debug_status_cfg         = 0x0000B878,
			.debug_status_0           = 0x0000B87C,
			.debug_status_1           = 0x0000B880,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_5,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 13 STATS HDR BHIST */
		{
			.cfg                      = 0x0000B900,
			.image_addr               = 0x0000B904,
			.frame_incr               = 0x0000B908,
			.image_cfg_0              = 0x0000B90C,
			.image_cfg_1              = 0x0000B910,
			.image_cfg_2              = 0x0000B914,
			.packer_cfg               = 0x0000B918,
			.frame_header_addr        = 0x0000B920,
			.frame_header_incr        = 0x0000B924,
			.frame_header_cfg         = 0x0000B928,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000B930,
			.irq_subsample_pattern    = 0x0000B934,
			.framedrop_period         = 0x0000B938,
			.framedrop_pattern        = 0x0000B93C,
			.system_cache_cfg         = 0x0000B960,
			.burst_limit              = 0x0000B964,
			.addr_status_0            = 0x0000B968,
			.addr_status_1            = 0x0000B96C,
			.addr_status_2            = 0x0000B970,
			.addr_status_3            = 0x0000B974,
			.debug_status_cfg         = 0x0000B978,
			.debug_status_0           = 0x0000B97C,
			.debug_status_1           = 0x0000B980,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_5,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 14 STATS TINTLESS BG */
		{
			.cfg                      = 0x0000BA00,
			.image_addr               = 0x0000BA04,
			.frame_incr               = 0x0000BA08,
			.image_cfg_0              = 0x0000BA0C,
			.image_cfg_1              = 0x0000BA10,
			.image_cfg_2              = 0x0000BA14,
			.packer_cfg               = 0x0000BA18,
			.frame_header_addr        = 0x0000BA20,
			.frame_header_incr        = 0x0000BA24,
			.frame_header_cfg         = 0x0000BA28,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000BA30,
			.irq_subsample_pattern    = 0x0000BA34,
			.framedrop_period         = 0x0000BA38,
			.framedrop_pattern        = 0x0000BA3C,
			.system_cache_cfg         = 0x0000BA60,
			.burst_limit              = 0x0000BA64,
			.addr_status_0            = 0x0000BA68,
			.addr_status_1            = 0x0000BA6C,
			.addr_status_2            = 0x0000BA70,
			.addr_status_3            = 0x0000BA74,
			.debug_status_cfg         = 0x0000BA78,
			.debug_status_0           = 0x0000BA7C,
			.debug_status_1           = 0x0000BA80,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_6,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 15 STATS AWB BG */
		{
			.cfg                      = 0x0000BB00,
			.image_addr               = 0x0000BB04,
			.frame_incr               = 0x0000BB08,
			.image_cfg_0              = 0x0000BB0C,
			.image_cfg_1              = 0x0000BB10,
			.image_cfg_2              = 0x0000BB14,
			.packer_cfg               = 0x0000BB18,
			.frame_header_addr        = 0x0000BB20,
			.frame_header_incr        = 0x0000BB24,
			.frame_header_cfg         = 0x0000BB28,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000BB30,
			.irq_subsample_pattern    = 0x0000BB34,
			.framedrop_period         = 0x0000BB38,
			.framedrop_pattern        = 0x0000BB3C,
			.system_cache_cfg         = 0x0000BB60,
			.burst_limit              = 0x0000BB64,
			.addr_status_0            = 0x0000BB68,
			.addr_status_1            = 0x0000BB6C,
			.addr_status_2            = 0x0000BB70,
			.addr_status_3            = 0x0000BB74,
			.debug_status_cfg         = 0x0000BB78,
			.debug_status_0           = 0x0000BB7C,
			.debug_status_1           = 0x0000BB80,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_6,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 16 STATS BHIST */
		{
			.cfg                      = 0x0000BC00,
			.image_addr               = 0x0000BC04,
			.frame_incr               = 0x0000BC08,
			.image_cfg_0              = 0x0000BC0C,
			.image_cfg_1              = 0x0000BC10,
			.image_cfg_2              = 0x0000BC14,
			.packer_cfg               = 0x0000BC18,
			.frame_header_addr        = 0x0000BC20,
			.frame_header_incr        = 0x0000BC24,
			.frame_header_cfg         = 0x0000BC28,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000BC30,
			.irq_subsample_pattern    = 0x0000BC34,
			.framedrop_period         = 0x0000BC38,
			.framedrop_pattern        = 0x0000BC3C,
			.system_cache_cfg         = 0x0000BC60,
			.burst_limit              = 0x0000BC64,
			.addr_status_0            = 0x0000BC68,
			.addr_status_1            = 0x0000BC6C,
			.addr_status_2            = 0x0000BC70,
			.addr_status_3            = 0x0000BC74,
			.debug_status_cfg         = 0x0000BC78,
			.debug_status_0           = 0x0000BC7C,
			.debug_status_1           = 0x0000BC80,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_7,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 17 STATS RS */
		{
			.cfg                      = 0x0000BD00,
			.image_addr               = 0x0000BD04,
			.frame_incr               = 0x0000BD08,
			.image_cfg_0              = 0x0000BD0C,
			.image_cfg_1              = 0x0000BD10,
			.image_cfg_2              = 0x0000BD14,
			.packer_cfg               = 0x0000BD18,
			.frame_header_addr        = 0x0000BD20,
			.frame_header_incr        = 0x0000BD24,
			.frame_header_cfg         = 0x0000BD28,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000BD30,
			.irq_subsample_pattern    = 0x0000BD34,
			.framedrop_period         = 0x0000BD38,
			.framedrop_pattern        = 0x0000BD3C,
			.system_cache_cfg         = 0x0000BD60,
			.burst_limit              = 0x0000BD64,
			.addr_status_0            = 0x0000BD68,
			.addr_status_1            = 0x0000BD6C,
			.addr_status_2            = 0x0000BD70,
			.addr_status_3            = 0x0000BD74,
			.debug_status_cfg         = 0x0000BD78,
			.debug_status_0           = 0x0000BD7C,
			.debug_status_1           = 0x0000BD80,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_7,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 18 STATS CS */
		{
			.cfg                      = 0x0000BE00,
			.image_addr               = 0x0000BE04,
			.frame_incr               = 0x0000BE08,
			.image_cfg_0              = 0x0000BE0C,
			.image_cfg_1              = 0x0000BE10,
			.image_cfg_2              = 0x0000BE14,
			.packer_cfg               = 0x0000BE18,
			.frame_header_addr        = 0x0000BE20,
			.frame_header_incr        = 0x0000BE24,
			.frame_header_cfg         = 0x0000BE28,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000BE30,
			.irq_subsample_pattern    = 0x0000BE34,
			.framedrop_period         = 0x0000BE38,
			.framedrop_pattern        = 0x0000BE3C,
			.system_cache_cfg         = 0x0000BE60,
			.burst_limit              = 0x0000BE64,
			.addr_status_0            = 0x0000BE68,
			.addr_status_1            = 0x0000BE6C,
			.addr_status_2            = 0x0000BE70,
			.addr_status_3            = 0x0000BE74,
			.debug_status_cfg         = 0x0000BE78,
			.debug_status_0           = 0x0000BE7C,
			.debug_status_1           = 0x0000BE80,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_7,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 19 STATS IHIST */
		{
			.cfg                      = 0x0000BF00,
			.image_addr               = 0x0000BF04,
			.frame_incr               = 0x0000BF08,
			.image_cfg_0              = 0x0000BF0C,
			.image_cfg_1              = 0x0000BF10,
			.image_cfg_2              = 0x0000BF14,
			.packer_cfg               = 0x0000BF18,
			.frame_header_addr        = 0x0000BF20,
			.frame_header_incr        = 0x0000BF24,
			.frame_header_cfg         = 0x0000BF28,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000BF30,
			.irq_subsample_pattern    = 0x0000BF34,
			.framedrop_period         = 0x0000BF38,
			.framedrop_pattern        = 0x0000BF3C,
			.system_cache_cfg         = 0x0000BF60,
			.burst_limit              = 0x0000BF64,
			.addr_status_0            = 0x0000BF68,
			.addr_status_1            = 0x0000BF6C,
			.addr_status_2            = 0x0000BF70,
			.addr_status_3            = 0x0000BF74,
			.debug_status_cfg         = 0x0000BF78,
			.debug_status_0           = 0x0000BF7C,
			.debug_status_1           = 0x0000BF80,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_7,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 20 STATS BF */
		{
			.cfg                      = 0x0000C000,
			.image_addr               = 0x0000C004,
			.frame_incr               = 0x0000C008,
			.image_cfg_0              = 0x0000C00C,
			.image_cfg_1              = 0x0000C010,
			.image_cfg_2              = 0x0000C014,
			.packer_cfg               = 0x0000C018,
			.frame_header_addr        = 0x0000C020,
			.frame_header_incr        = 0x0000C024,
			.frame_header_cfg         = 0x0000C028,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000C030,
			.irq_subsample_pattern    = 0x0000C034,
			.framedrop_period         = 0x0000C038,
			.framedrop_pattern        = 0x0000C03C,
			.system_cache_cfg         = 0x0000C060,
			.burst_limit              = 0x0000C064,
			.addr_status_0            = 0x0000C068,
			.addr_status_1            = 0x0000C06C,
			.addr_status_2            = 0x0000C070,
			.addr_status_3            = 0x0000C074,
			.debug_status_cfg         = 0x0000C078,
			.debug_status_0           = 0x0000C07C,
			.debug_status_1           = 0x0000C080,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_8,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 21 PDAF V2.0 */
		{
			.cfg                      = 0x0000C100,
			.image_addr               = 0x0000C104,
			.frame_incr               = 0x0000C108,
			.image_cfg_0              = 0x0000C10C,
			.image_cfg_1              = 0x0000C110,
			.image_cfg_2              = 0x0000C114,
			.packer_cfg               = 0x0000C118,
			.frame_header_addr        = 0x0000C120,
			.frame_header_incr        = 0x0000C124,
			.frame_header_cfg         = 0x0000C128,
			.line_done_cfg            = 0x0000C12C,
			.irq_subsample_period     = 0x0000C130,
			.irq_subsample_pattern    = 0x0000C134,
			.framedrop_period         = 0x0000C138,
			.framedrop_pattern        = 0x0000C13C,
			.system_cache_cfg         = 0x0000C160,
			.burst_limit              = 0x0000C164,
			.addr_status_0            = 0x0000C168,
			.addr_status_1            = 0x0000C16C,
			.addr_status_2            = 0x0000C170,
			.addr_status_3            = 0x0000C174,
			.debug_status_cfg         = 0x0000C178,
			.debug_status_0           = 0x0000C17C,
			.debug_status_1           = 0x0000C180,
			.comp_group               = CAM_VFE_BUS_VER3_COMP_GRP_9,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 22 LCR */
		{
			.cfg                      = 0x0000C200,
			.image_addr               = 0x0000C204,
			.frame_incr               = 0x0000C208,
			.image_cfg_0              = 0x0000C20C,
			.image_cfg_1              = 0x0000C210,
			.image_cfg_2              = 0x0000C214,
			.packer_cfg               = 0x0000C218,
			.frame_header_addr        = 0x0000C220,
			.frame_header_incr        = 0x0000C224,
			.frame_header_cfg         = 0x0000C228,
			.line_done_cfg            = 0,
			.irq_subsample_period     = 0x0000C230,
			.irq_subsample_pattern    = 0x0000C234,
			.framedrop_period         = 0x0000C238,
			.framedrop_pattern        = 0x0000C23C,
			.system_cache_cfg         = 0x0000C260,
			.burst_limit              = 0x0000C264,
			.addr_status_0            = 0x0000C268,
			.addr_status_1            = 0x0000C26C,
			.addr_status_2            = 0x0000C270,
			.addr_status_3            = 0x0000C274,
			.debug_status_cfg         = 0x0000C278,
			.debug_status_0           = 0x0000C27C,
			.debug_status_1           = 0x0000C280,
			.comp_group              = CAM_VFE_BUS_VER3_COMP_GRP_10,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 23 RDI0 */
		{
			.cfg                      = 0x0000C300,
			.image_addr               = 0x0000C304,
			.frame_incr               = 0x0000C308,
			.image_cfg_0              = 0x0000C30C,
			.image_cfg_1              = 0x0000C310,
			.image_cfg_2              = 0x0000C314,
			.packer_cfg               = 0x0000C318,
			.frame_header_addr        = 0x0000C320,
			.frame_header_incr        = 0x0000C324,
			.frame_header_cfg         = 0x0000C328,
			.line_done_cfg            = 0x0000C32C,
			.irq_subsample_period     = 0x0000C330,
			.irq_subsample_pattern    = 0x0000C334,
			.framedrop_period         = 0x0000C338,
			.framedrop_pattern        = 0x0000C33C,
			.system_cache_cfg         = 0x0000C360,
			.burst_limit              = 0x0000C364,
			.addr_status_0            = 0x0000C368,
			.addr_status_1            = 0x0000C36C,
			.addr_status_2            = 0x0000C370,
			.addr_status_3            = 0x0000C374,
			.debug_status_cfg         = 0x0000C378,
			.debug_status_0           = 0x0000C37C,
			.debug_status_1           = 0x0000C380,
			.comp_group              = CAM_VFE_BUS_VER3_COMP_GRP_11,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 24 RDI1 */
		{
			.cfg                      = 0x0000C400,
			.image_addr               = 0x0000C404,
			.frame_incr               = 0x0000C408,
			.image_cfg_0              = 0x0000C40C,
			.image_cfg_1              = 0x0000C410,
			.image_cfg_2              = 0x0000C414,
			.packer_cfg               = 0x0000C418,
			.frame_header_addr        = 0x0000C420,
			.frame_header_incr        = 0x0000C424,
			.frame_header_cfg         = 0x0000C428,
			.line_done_cfg            = 0x0000C42C,
			.irq_subsample_period     = 0x0000C430,
			.irq_subsample_pattern    = 0x0000C434,
			.framedrop_period         = 0x0000C438,
			.framedrop_pattern        = 0x0000C43C,
			.system_cache_cfg         = 0x0000C460,
			.burst_limit              = 0x0000C464,
			.addr_status_0            = 0x0000C468,
			.addr_status_1            = 0x0000C46C,
			.addr_status_2            = 0x0000C470,
			.addr_status_3            = 0x0000C474,
			.debug_status_cfg         = 0x0000C478,
			.debug_status_0           = 0x0000C47C,
			.debug_status_1           = 0x0000C480,
			.comp_group              = CAM_VFE_BUS_VER3_COMP_GRP_12,
			.ubwc_regs                = NULL,
		},
		/* BUS Client 25 RDI2 */
		{
			.cfg                      = 0x0000C500,
			.image_addr               = 0x0000C504,
			.frame_incr               = 0x0000C508,
			.image_cfg_0              = 0x0000C50C,
			.image_cfg_1              = 0x0000C510,
			.image_cfg_2              = 0x0000C514,
			.packer_cfg               = 0x0000C518,
			.frame_header_addr        = 0x0000C520,
			.frame_header_incr        = 0x0000C524,
			.frame_header_cfg         = 0x0000C528,
			.line_done_cfg            = 0x0000C52C,
			.irq_subsample_period     = 0x0000C530,
			.irq_subsample_pattern    = 0x0000C534,
			.framedrop_period         = 0x0000C538,
			.framedrop_pattern        = 0x0000C53C,
			.system_cache_cfg         = 0x0000C560,
			.burst_limit              = 0x0000C564,
			.addr_status_0            = 0x0000C568,
			.addr_status_1            = 0x0000C56C,
			.addr_status_2            = 0x0000C570,
			.addr_status_3            = 0x0000C574,
			.debug_status_cfg         = 0x0000C578,
			.debug_status_0           = 0x0000C57C,
			.debug_status_1           = 0x0000C580,
			.comp_group              = CAM_VFE_BUS_VER3_COMP_GRP_13,
			.ubwc_regs                = NULL,
		},
	},
	.num_out = 23,
	.vfe_out_hw_info = {
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_RDI0,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_3,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_RDI1,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_4,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_RDI2,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_5,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_FULL,
			.max_width     = 4096,
			.max_height    = 4096,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_DS4,
			.max_width     = 1920,
			.max_height    = 1080,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_DS16,
			.max_width     = 1920,
			.max_height    = 1080,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_RAW_DUMP,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_FD,
			.max_width     = 1920,
			.max_height    = 1080,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_PDAF,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_STATS_HDR_BE,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  =
				CAM_VFE_BUS_VER3_VFE_OUT_STATS_HDR_BHIST,
			.max_width     = 1920,
			.max_height    = 1080,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  =
				CAM_VFE_BUS_VER3_VFE_OUT_STATS_TL_BG,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_STATS_BF,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_STATS_AWB_BG,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_STATS_BHIST,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_STATS_RS,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_STATS_CS,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_STATS_IHIST,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_FULL_DISP,
			.max_width     = 4096,
			.max_height    = 4096,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_DS4_DISP,
			.max_width     = 1920,
			.max_height    = 1080,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_DS16_DISP,
			.max_width     = 1920,
			.max_height    = 1080,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_0,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_2PD,
			.max_width     = 1920,
			.max_height    = 1080,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_1,
		},
		{
			.vfe_out_type  = CAM_VFE_BUS_VER3_VFE_OUT_LCR,
			.max_width     = -1,
			.max_height    = -1,
			.source_group  = CAM_VFE_BUS_VER3_SRC_GRP_2,
		},
	},
	.comp_done_shift = 6,
	.top_irq_shift   = 7,
};

static struct cam_irq_register_set vfe480_bus_rd_irq_reg[1] = {
	{
		.mask_reg_offset   = 0x0000A810,
		.clear_reg_offset  = 0x0000A814,
		.status_reg_offset = 0x0000A81C,
	},
};

static struct cam_vfe_bus_rd_ver1_hw_info vfe480_bus_rd_hw_info = {
	.common_reg = {
		.hw_version                   = 0x0000A800,
		.hw_capability                = 0x0000A804,
		.sw_reset                     = 0x0000A808,
		.cgc_ovd                      = 0x0000A80C,
		.pwr_iso_cfg                  = 0x0000A834,
		.input_if_cmd                 = 0x0000A820,
		.test_bus_ctrl                = 0x0000A848,
		.irq_reg_info = {
			.num_registers        = 1,
			.irq_reg_set          = vfe480_bus_rd_irq_reg,
			.global_clear_offset  = 0x0000A818,
			.global_clear_bitmask = 0x00000001,
		},
	},
	.num_client = 1,
	.bus_client_reg = {
		/* BUS Client 0 */
		{
			.cfg                      = 0x0000A850,
			.image_addr               = 0x0000A858,
			.buf_size                 = 0x0000A85C,
			.stride                   = 0x0000A860,
			.unpacker_cfg             = 0x0000A864,
			.latency_buf_allocation   = 0x0000A878,
			.burst_limit              = 0x0000A880,
		},
	},
	.num_bus_rd_resc = 1,
	.vfe_bus_rd_hw_info = {
		{
			.vfe_bus_rd_type = CAM_VFE_BUS_RD_VER1_VFE_BUSRD_RDI0,
			.max_width     = -1,
			.max_height    = -1,
		},
	},
};

struct cam_vfe_hw_info cam_vfe480_hw_info = {
	.irq_reg_info                  = &vfe480_top_irq_reg_info,

	.bus_version                   = CAM_VFE_BUS_VER_3_0,
	.bus_hw_info                   = &vfe480_bus_hw_info,

	.bus_rd_version                = CAM_VFE_BUS_RD_VER_1_0,
	.bus_rd_hw_info                = &vfe480_bus_rd_hw_info,

	.top_version                   = CAM_VFE_TOP_VER_3_0,
	.top_hw_info                   = &vfe480_top_hw_info,
};

#endif /* _CAM_VFE480_H_ */
